# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from ...token_base.types.token_id import TokenId
import typing
from ...common.types.id import Id
import pydantic
from ...token_base.types.token_owner_type import TokenOwnerType
import datetime as dt
from ...token_base.types.token_pair import TokenPair
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RefreshToken(Base):
    id: TokenId
    member_id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    Member Id
    """

    owner_id: Id = pydantic.Field()
    """
    ID of the entity that owns this token
    """

    owner_type: TokenOwnerType = pydantic.Field()
    """
    Type of the entity that owns this token
    """

    expires: dt.datetime = pydantic.Field()
    """
    Time when this token expires and can no longer be used again.
    """

    token_ttl: str = pydantic.Field()
    """
    Token time-to-live
    """

    primary: TokenPair = pydantic.Field()
    """
    Primary running access and refresh tokens
    """

    secondary: typing.Optional[TokenPair] = pydantic.Field(default=None)
    """
    Temporary secondary TokenPair created after a RefreshToken operation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
