# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConsumerGroupsGroupResult',
    'GetHistoryDeliveryJobsJobResult',
    'GetHistoryDeliveryJobsJobJobStatusResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceAllowedListResult',
    'GetInstancesInstanceAllowedListInternetListResult',
    'GetInstancesInstanceAllowedListVpcListResult',
    'GetInstancesInstanceUpgradeServiceDetailInfoResult',
    'GetSaslAclsAclResult',
    'GetSaslUsersUserResult',
    'GetTopicsTopicResult',
    'GetTrailsActiontrailResult',
    'GetTrailsDeprecatedActiontrailResult',
    'GetTrailsDeprecatedTrailResult',
    'GetTrailsTrailResult',
]

@pulumi.output_type
class GetConsumerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 consumer_id: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 remark: _builtins.str,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str consumer_id: The name of the consumer group.
        :param _builtins.str id: The ID of the consumer group, It is formatted to `<instance_id>:<consumer_id>`.
        :param _builtins.str instance_id: ID of the ALIKAFKA Instance that owns the consumer groups.
        :param _builtins.str remark: The remark of the consumer group.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the consumer group.
        """
        pulumi.set(__self__, "consumer_id", consumer_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "remark", remark)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> _builtins.str:
        """
        The name of the consumer group.
        """
        return pulumi.get(self, "consumer_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the consumer group, It is formatted to `<instance_id>:<consumer_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the ALIKAFKA Instance that owns the consumer groups.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        The remark of the consumer group.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the consumer group.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetHistoryDeliveryJobsJobResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 end_time: _builtins.str,
                 history_delivery_job_id: _builtins.str,
                 home_region: _builtins.str,
                 id: _builtins.str,
                 job_statuses: Sequence['outputs.GetHistoryDeliveryJobsJobJobStatusResult'],
                 start_time: _builtins.str,
                 status: _builtins.int,
                 trail_name: _builtins.str,
                 updated_time: _builtins.str):
        """
        :param _builtins.str create_time: The time when the task was created.
        :param _builtins.str end_time: The time when the task ended.
        :param _builtins.str home_region: The home region of the trail.
        :param _builtins.str id: The ID of the History Delivery Job.
        :param Sequence['GetHistoryDeliveryJobsJobJobStatusArgs'] job_statuses: Detail status of delivery job.
        :param _builtins.str start_time: The time when the task started.
        :param _builtins.int status: The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
        :param _builtins.str trail_name: The name of the trail.
        :param _builtins.str updated_time: The time when the task was updated.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "history_delivery_job_id", history_delivery_job_id)
        pulumi.set(__self__, "home_region", home_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_statuses", job_statuses)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trail_name", trail_name)
        pulumi.set(__self__, "updated_time", updated_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the task was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The time when the task ended.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="historyDeliveryJobId")
    def history_delivery_job_id(self) -> _builtins.str:
        return pulumi.get(self, "history_delivery_job_id")

    @_builtins.property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> _builtins.str:
        """
        The home region of the trail.
        """
        return pulumi.get(self, "home_region")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the History Delivery Job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobStatuses")
    def job_statuses(self) -> Sequence['outputs.GetHistoryDeliveryJobsJobJobStatusResult']:
        """
        Detail status of delivery job.
        """
        return pulumi.get(self, "job_statuses")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The time when the task started.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> _builtins.str:
        """
        The name of the trail.
        """
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The time when the task was updated.
        """
        return pulumi.get(self, "updated_time")


@pulumi.output_type
class GetHistoryDeliveryJobsJobJobStatusResult(dict):
    def __init__(__self__, *,
                 region: _builtins.str,
                 status: _builtins.int):
        """
        :param _builtins.str region: The region of the delivery job.
        :param _builtins.int status: The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the delivery job.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 allowed_lists: Sequence['outputs.GetInstancesInstanceAllowedListResult'],
                 config: _builtins.str,
                 create_time: _builtins.str,
                 deploy_type: _builtins.int,
                 disk_size: _builtins.int,
                 disk_type: _builtins.int,
                 domain_endpoint: _builtins.str,
                 eip_max: _builtins.int,
                 end_point: _builtins.str,
                 expired_time: _builtins.int,
                 id: _builtins.str,
                 io_max: _builtins.int,
                 msg_retain: _builtins.int,
                 name: _builtins.str,
                 paid_type: _builtins.str,
                 partition_num: _builtins.int,
                 sasl_domain_endpoint: _builtins.str,
                 security_group: _builtins.str,
                 service_status: _builtins.int,
                 service_version: _builtins.str,
                 spec_type: _builtins.str,
                 ssl_domain_endpoint: _builtins.str,
                 ssl_end_point: _builtins.str,
                 topic_quota: _builtins.int,
                 upgrade_service_detail_infos: Sequence['outputs.GetInstancesInstanceUpgradeServiceDetailInfoResult'],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence['GetInstancesInstanceAllowedListArgs'] allowed_lists: The allowed list of the instance.
        :param _builtins.str config: The config the instance.
        :param _builtins.str create_time: The create time of the instance.
        :param _builtins.int deploy_type: The deployed type of the instance.
        :param _builtins.int disk_size: The disk size of the instance.
        :param _builtins.int disk_type: The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        :param _builtins.str domain_endpoint: The domain point of the instance.
        :param _builtins.int eip_max: The peak bandwidth of the instance.
        :param _builtins.str end_point: The endPoint to access the instance.
        :param _builtins.int expired_time: The expired time  of the instance.
        :param _builtins.str id: ID of the instance.
        :param _builtins.int io_max: The peak value of io of the instance.
        :param _builtins.int msg_retain: The msg retain of the instance.
        :param _builtins.str name: Name of the instance.
        :param _builtins.str paid_type: The paid type of the instance.
        :param _builtins.int partition_num: (Available in 1.194.0+) The number of partitions.
        :param _builtins.str sasl_domain_endpoint: The SASL domain point of the instance.
        :param _builtins.str security_group: The security group of the instance.
        :param _builtins.int service_status: The current status of the instance. -1: unknown status, 0: wait deploy, 1: initializing, 2: preparing, 3 starting, 5: in service, 7: wait upgrade, 8: upgrading, 10: released, 15: freeze, 101: deploy error, 102: upgrade error.
        :param _builtins.str service_version: The kafka openSource version of the instance.
        :param _builtins.str spec_type: The spec type of the instance.
        :param _builtins.str ssl_domain_endpoint: The SSL domain point of the instance.
        :param _builtins.str ssl_end_point: The SSL end point of the instance.
        :param _builtins.int topic_quota: The max num of topic can be create of the instance.
        :param Sequence['GetInstancesInstanceUpgradeServiceDetailInfoArgs'] upgrade_service_detail_infos: The UpgradeServiceDetailInfo List.
        :param _builtins.str vpc_id: The ID of attaching VPC to instance.
        :param _builtins.str vswitch_id: The ID of attaching vswitch to instance.
        :param _builtins.str zone_id: The ID of attaching zone to instance.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the instance.
        """
        pulumi.set(__self__, "allowed_lists", allowed_lists)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deploy_type", deploy_type)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "domain_endpoint", domain_endpoint)
        pulumi.set(__self__, "eip_max", eip_max)
        pulumi.set(__self__, "end_point", end_point)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "io_max", io_max)
        pulumi.set(__self__, "msg_retain", msg_retain)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "paid_type", paid_type)
        pulumi.set(__self__, "partition_num", partition_num)
        pulumi.set(__self__, "sasl_domain_endpoint", sasl_domain_endpoint)
        pulumi.set(__self__, "security_group", security_group)
        pulumi.set(__self__, "service_status", service_status)
        pulumi.set(__self__, "service_version", service_version)
        pulumi.set(__self__, "spec_type", spec_type)
        pulumi.set(__self__, "ssl_domain_endpoint", ssl_domain_endpoint)
        pulumi.set(__self__, "ssl_end_point", ssl_end_point)
        pulumi.set(__self__, "topic_quota", topic_quota)
        pulumi.set(__self__, "upgrade_service_detail_infos", upgrade_service_detail_infos)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="allowedLists")
    def allowed_lists(self) -> Sequence['outputs.GetInstancesInstanceAllowedListResult']:
        """
        The allowed list of the instance.
        """
        return pulumi.get(self, "allowed_lists")

    @_builtins.property
    @pulumi.getter
    def config(self) -> _builtins.str:
        """
        The config the instance.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> _builtins.int:
        """
        The deployed type of the instance.
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        The disk size of the instance.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.int:
        """
        The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="domainEndpoint")
    def domain_endpoint(self) -> _builtins.str:
        """
        The domain point of the instance.
        """
        return pulumi.get(self, "domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> _builtins.int:
        """
        The peak bandwidth of the instance.
        """
        return pulumi.get(self, "eip_max")

    @_builtins.property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> _builtins.str:
        """
        The endPoint to access the instance.
        """
        return pulumi.get(self, "end_point")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.int:
        """
        The expired time  of the instance.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> _builtins.int:
        """
        The peak value of io of the instance.
        """
        return pulumi.get(self, "io_max")

    @_builtins.property
    @pulumi.getter(name="msgRetain")
    def msg_retain(self) -> _builtins.int:
        """
        The msg retain of the instance.
        """
        return pulumi.get(self, "msg_retain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> _builtins.str:
        """
        The paid type of the instance.
        """
        return pulumi.get(self, "paid_type")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> _builtins.int:
        """
        (Available in 1.194.0+) The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter(name="saslDomainEndpoint")
    def sasl_domain_endpoint(self) -> _builtins.str:
        """
        The SASL domain point of the instance.
        """
        return pulumi.get(self, "sasl_domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> _builtins.str:
        """
        The security group of the instance.
        """
        return pulumi.get(self, "security_group")

    @_builtins.property
    @pulumi.getter(name="serviceStatus")
    def service_status(self) -> _builtins.int:
        """
        The current status of the instance. -1: unknown status, 0: wait deploy, 1: initializing, 2: preparing, 3 starting, 5: in service, 7: wait upgrade, 8: upgrading, 10: released, 15: freeze, 101: deploy error, 102: upgrade error.
        """
        return pulumi.get(self, "service_status")

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> _builtins.str:
        """
        The kafka openSource version of the instance.
        """
        return pulumi.get(self, "service_version")

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> _builtins.str:
        """
        The spec type of the instance.
        """
        return pulumi.get(self, "spec_type")

    @_builtins.property
    @pulumi.getter(name="sslDomainEndpoint")
    def ssl_domain_endpoint(self) -> _builtins.str:
        """
        The SSL domain point of the instance.
        """
        return pulumi.get(self, "ssl_domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="sslEndPoint")
    def ssl_end_point(self) -> _builtins.str:
        """
        The SSL end point of the instance.
        """
        return pulumi.get(self, "ssl_end_point")

    @_builtins.property
    @pulumi.getter(name="topicQuota")
    def topic_quota(self) -> _builtins.int:
        """
        The max num of topic can be create of the instance.
        """
        return pulumi.get(self, "topic_quota")

    @_builtins.property
    @pulumi.getter(name="upgradeServiceDetailInfos")
    def upgrade_service_detail_infos(self) -> Sequence['outputs.GetInstancesInstanceUpgradeServiceDetailInfoResult']:
        """
        The UpgradeServiceDetailInfo List.
        """
        return pulumi.get(self, "upgrade_service_detail_infos")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of attaching zone to instance.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the instance.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInstancesInstanceAllowedListResult(dict):
    def __init__(__self__, *,
                 deploy_type: _builtins.str,
                 internet_lists: Sequence['outputs.GetInstancesInstanceAllowedListInternetListResult'],
                 vpc_lists: Sequence['outputs.GetInstancesInstanceAllowedListVpcListResult']):
        """
        :param _builtins.str deploy_type: The deployed type of the instance.
        :param Sequence['GetInstancesInstanceAllowedListInternetListArgs'] internet_lists: The internet list of the instance.
        :param Sequence['GetInstancesInstanceAllowedListVpcListArgs'] vpc_lists: The vpc list of the instance.
        """
        pulumi.set(__self__, "deploy_type", deploy_type)
        pulumi.set(__self__, "internet_lists", internet_lists)
        pulumi.set(__self__, "vpc_lists", vpc_lists)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> _builtins.str:
        """
        The deployed type of the instance.
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter(name="internetLists")
    def internet_lists(self) -> Sequence['outputs.GetInstancesInstanceAllowedListInternetListResult']:
        """
        The internet list of the instance.
        """
        return pulumi.get(self, "internet_lists")

    @_builtins.property
    @pulumi.getter(name="vpcLists")
    def vpc_lists(self) -> Sequence['outputs.GetInstancesInstanceAllowedListVpcListResult']:
        """
        The vpc list of the instance.
        """
        return pulumi.get(self, "vpc_lists")


@pulumi.output_type
class GetInstancesInstanceAllowedListInternetListResult(dict):
    def __init__(__self__, *,
                 allowed_ip_lists: Sequence[_builtins.str],
                 port_range: _builtins.str):
        """
        :param Sequence[_builtins.str] allowed_ip_lists: The allowed ip list of the internet_list.
        :param _builtins.str port_range: The port range of the internet_list.
        """
        pulumi.set(__self__, "allowed_ip_lists", allowed_ip_lists)
        pulumi.set(__self__, "port_range", port_range)

    @_builtins.property
    @pulumi.getter(name="allowedIpLists")
    def allowed_ip_lists(self) -> Sequence[_builtins.str]:
        """
        The allowed ip list of the internet_list.
        """
        return pulumi.get(self, "allowed_ip_lists")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range of the internet_list.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class GetInstancesInstanceAllowedListVpcListResult(dict):
    def __init__(__self__, *,
                 allowed_ip_lists: Sequence[_builtins.str],
                 port_range: _builtins.str):
        """
        :param Sequence[_builtins.str] allowed_ip_lists: The allowed ip list of the internet_list.
        :param _builtins.str port_range: The port range of the internet_list.
        """
        pulumi.set(__self__, "allowed_ip_lists", allowed_ip_lists)
        pulumi.set(__self__, "port_range", port_range)

    @_builtins.property
    @pulumi.getter(name="allowedIpLists")
    def allowed_ip_lists(self) -> Sequence[_builtins.str]:
        """
        The allowed ip list of the internet_list.
        """
        return pulumi.get(self, "allowed_ip_lists")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range of the internet_list.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class GetInstancesInstanceUpgradeServiceDetailInfoResult(dict):
    def __init__(__self__, *,
                 current2_open_source_version: _builtins.str):
        """
        :param _builtins.str current2_open_source_version: The Current2OpenSourceVersion of the instance.
        """
        pulumi.set(__self__, "current2_open_source_version", current2_open_source_version)

    @_builtins.property
    @pulumi.getter(name="current2OpenSourceVersion")
    def current2_open_source_version(self) -> _builtins.str:
        """
        The Current2OpenSourceVersion of the instance.
        """
        return pulumi.get(self, "current2_open_source_version")


@pulumi.output_type
class GetSaslAclsAclResult(dict):
    def __init__(__self__, *,
                 acl_operation_type: _builtins.str,
                 acl_resource_name: _builtins.str,
                 acl_resource_pattern_type: _builtins.str,
                 acl_resource_type: _builtins.str,
                 host: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str acl_operation_type: The operation type of the sasl acl.
        :param _builtins.str acl_resource_name: Get results for the specified resource name.
        :param _builtins.str acl_resource_pattern_type: The resource pattern type of the sasl acl.
        :param _builtins.str acl_resource_type: Get results for the specified resource type.
        :param _builtins.str host: The host of the sasl acl.
        :param _builtins.str username: Get results for the specified username.
        """
        pulumi.set(__self__, "acl_operation_type", acl_operation_type)
        pulumi.set(__self__, "acl_resource_name", acl_resource_name)
        pulumi.set(__self__, "acl_resource_pattern_type", acl_resource_pattern_type)
        pulumi.set(__self__, "acl_resource_type", acl_resource_type)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="aclOperationType")
    def acl_operation_type(self) -> _builtins.str:
        """
        The operation type of the sasl acl.
        """
        return pulumi.get(self, "acl_operation_type")

    @_builtins.property
    @pulumi.getter(name="aclResourceName")
    def acl_resource_name(self) -> _builtins.str:
        """
        Get results for the specified resource name.
        """
        return pulumi.get(self, "acl_resource_name")

    @_builtins.property
    @pulumi.getter(name="aclResourcePatternType")
    def acl_resource_pattern_type(self) -> _builtins.str:
        """
        The resource pattern type of the sasl acl.
        """
        return pulumi.get(self, "acl_resource_pattern_type")

    @_builtins.property
    @pulumi.getter(name="aclResourceType")
    def acl_resource_type(self) -> _builtins.str:
        """
        Get results for the specified resource type.
        """
        return pulumi.get(self, "acl_resource_type")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The host of the sasl acl.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Get results for the specified username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSaslUsersUserResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 password: _builtins.str,
                 type: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password: The password of the user.
        :param _builtins.str type: (Available since v1.260.0) The type of the user.
        :param _builtins.str username: The username of the user.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (Available since v1.260.0) The type of the user.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetTopicsTopicResult(dict):
    def __init__(__self__, *,
                 compact_topic: _builtins.bool,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 local_topic: _builtins.bool,
                 partition_num: _builtins.int,
                 remark: _builtins.str,
                 status: _builtins.int,
                 status_name: _builtins.str,
                 topic: _builtins.str,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool compact_topic: whether the current topic is kafka compact topic or not.
        :param _builtins.str create_time: Time of creation.
        :param _builtins.str id: The ID of the topic, It is formatted to `<instance_id>:<topic>`.
        :param _builtins.str instance_id: ID of the instance.
        :param _builtins.bool local_topic: whether the current topic is kafka local topic or not.
        :param _builtins.int partition_num: Partition number of the topic.
        :param _builtins.str remark: Remark of the topic.
        :param _builtins.int status: The current status code of the topic. There are three values to describe the topic status: 0 stands for the topic is in service, 1 stands for freezing and 2 stands for pause.
        :param _builtins.str status_name: The status_name of the topic.
        :param _builtins.str topic: A topic to filter results by the topic name.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the topic.
        """
        pulumi.set(__self__, "compact_topic", compact_topic)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "local_topic", local_topic)
        pulumi.set(__self__, "partition_num", partition_num)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_name", status_name)
        pulumi.set(__self__, "topic", topic)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="compactTopic")
    def compact_topic(self) -> _builtins.bool:
        """
        whether the current topic is kafka compact topic or not.
        """
        return pulumi.get(self, "compact_topic")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Time of creation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the topic, It is formatted to `<instance_id>:<topic>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="localTopic")
    def local_topic(self) -> _builtins.bool:
        """
        whether the current topic is kafka local topic or not.
        """
        return pulumi.get(self, "local_topic")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> _builtins.int:
        """
        Partition number of the topic.
        """
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        Remark of the topic.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The current status code of the topic. There are three values to describe the topic status: 0 stands for the topic is in service, 1 stands for freezing and 2 stands for pause.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusName")
    def status_name(self) -> _builtins.str:
        """
        The status_name of the topic.
        """
        return pulumi.get(self, "status_name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        A topic to filter results by the topic name.
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the topic.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetTrailsActiontrailResult(dict):
    def __init__(__self__, *,
                 event_rw: _builtins.str,
                 id: _builtins.str,
                 is_organization_trail: _builtins.bool,
                 oss_bucket_name: _builtins.str,
                 oss_key_prefix: _builtins.str,
                 oss_write_role_arn: _builtins.str,
                 sls_project_arn: _builtins.str,
                 sls_write_role_arn: _builtins.str,
                 status: _builtins.str,
                 trail_name: _builtins.str,
                 trail_region: _builtins.str):
        """
        :param _builtins.str event_rw: Indicates whether the event is a read or a write event.
        :param _builtins.str id: The id of the ActionTrail Trail. It is the same as trail name.
        :param _builtins.str oss_bucket_name: The name of the specified OSS bucket.
        :param _builtins.str oss_key_prefix: The prefix of the specified OSS bucket name.
        :param _builtins.str sls_project_arn: The unique ARN of the Log Service project.
        :param _builtins.str sls_write_role_arn: The unique ARN of the Log Service role.
        :param _builtins.str status: Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
        :param _builtins.str trail_name: The name of the ActionTrail Trail.
        :param _builtins.str trail_region: The regions to which the trail is applied.
        """
        pulumi.set(__self__, "event_rw", event_rw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trail_name", trail_name)
        pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> _builtins.str:
        """
        Indicates whether the event is a read or a write event.
        """
        return pulumi.get(self, "event_rw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the ActionTrail Trail. It is the same as trail name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> _builtins.bool:
        return pulumi.get(self, "is_organization_trail")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the specified OSS bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> _builtins.str:
        """
        The prefix of the specified OSS bucket name.
        """
        return pulumi.get(self, "oss_key_prefix")

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "oss_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service project.
        """
        return pulumi.get(self, "sls_project_arn")

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service role.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> _builtins.str:
        """
        The name of the ActionTrail Trail.
        """
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> _builtins.str:
        """
        The regions to which the trail is applied.
        """
        return pulumi.get(self, "trail_region")


@pulumi.output_type
class GetTrailsDeprecatedActiontrailResult(dict):
    def __init__(__self__, *,
                 event_rw: _builtins.str,
                 id: _builtins.str,
                 is_organization_trail: _builtins.bool,
                 oss_bucket_name: _builtins.str,
                 oss_key_prefix: _builtins.str,
                 oss_write_role_arn: _builtins.str,
                 sls_project_arn: _builtins.str,
                 sls_write_role_arn: _builtins.str,
                 status: _builtins.str,
                 trail_name: _builtins.str,
                 trail_region: _builtins.str):
        """
        :param _builtins.str event_rw: Indicates whether the event is a read or a write event.
        :param _builtins.str oss_bucket_name: The name of the specified OSS bucket.
        :param _builtins.str oss_key_prefix: The prefix of the specified OSS bucket name.
        :param _builtins.str sls_project_arn: The unique ARN of the Log Service project.
        :param _builtins.str sls_write_role_arn: The unique ARN of the Log Service role.
        """
        pulumi.set(__self__, "event_rw", event_rw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trail_name", trail_name)
        pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> _builtins.str:
        """
        Indicates whether the event is a read or a write event.
        """
        return pulumi.get(self, "event_rw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> _builtins.bool:
        return pulumi.get(self, "is_organization_trail")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the specified OSS bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> _builtins.str:
        """
        The prefix of the specified OSS bucket name.
        """
        return pulumi.get(self, "oss_key_prefix")

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "oss_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service project.
        """
        return pulumi.get(self, "sls_project_arn")

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service role.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> _builtins.str:
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> _builtins.str:
        return pulumi.get(self, "trail_region")


@pulumi.output_type
class GetTrailsDeprecatedTrailResult(dict):
    def __init__(__self__, *,
                 event_rw: _builtins.str,
                 id: _builtins.str,
                 is_organization_trail: _builtins.bool,
                 oss_bucket_name: _builtins.str,
                 oss_key_prefix: _builtins.str,
                 oss_write_role_arn: _builtins.str,
                 sls_project_arn: _builtins.str,
                 sls_write_role_arn: _builtins.str,
                 status: _builtins.str,
                 trail_name: _builtins.str,
                 trail_region: _builtins.str):
        """
        :param _builtins.str event_rw: Indicates whether the event is a read or a write event.
        :param _builtins.str oss_bucket_name: The name of the specified OSS bucket.
        :param _builtins.str oss_key_prefix: The prefix of the specified OSS bucket name.
        :param _builtins.str sls_project_arn: The unique ARN of the Log Service project.
        :param _builtins.str sls_write_role_arn: The unique ARN of the Log Service role.
        """
        pulumi.set(__self__, "event_rw", event_rw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trail_name", trail_name)
        pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> _builtins.str:
        """
        Indicates whether the event is a read or a write event.
        """
        return pulumi.get(self, "event_rw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> _builtins.bool:
        return pulumi.get(self, "is_organization_trail")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the specified OSS bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> _builtins.str:
        """
        The prefix of the specified OSS bucket name.
        """
        return pulumi.get(self, "oss_key_prefix")

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "oss_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service project.
        """
        return pulumi.get(self, "sls_project_arn")

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service role.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> _builtins.str:
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> _builtins.str:
        return pulumi.get(self, "trail_region")


@pulumi.output_type
class GetTrailsTrailResult(dict):
    def __init__(__self__, *,
                 event_rw: _builtins.str,
                 id: _builtins.str,
                 is_organization_trail: _builtins.bool,
                 oss_bucket_name: _builtins.str,
                 oss_key_prefix: _builtins.str,
                 oss_write_role_arn: _builtins.str,
                 sls_project_arn: _builtins.str,
                 sls_write_role_arn: _builtins.str,
                 status: _builtins.str,
                 trail_name: _builtins.str,
                 trail_region: _builtins.str):
        """
        :param _builtins.str event_rw: Indicates whether the event is a read or a write event.
        :param _builtins.str id: The id of the ActionTrail Trail. It is the same as trail name.
        :param _builtins.str oss_bucket_name: The name of the specified OSS bucket.
        :param _builtins.str oss_key_prefix: The prefix of the specified OSS bucket name.
        :param _builtins.str sls_project_arn: The unique ARN of the Log Service project.
        :param _builtins.str sls_write_role_arn: The unique ARN of the Log Service role.
        :param _builtins.str status: Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
        :param _builtins.str trail_name: The name of the ActionTrail Trail.
        :param _builtins.str trail_region: The regions to which the trail is applied.
        """
        pulumi.set(__self__, "event_rw", event_rw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trail_name", trail_name)
        pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> _builtins.str:
        """
        Indicates whether the event is a read or a write event.
        """
        return pulumi.get(self, "event_rw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the ActionTrail Trail. It is the same as trail name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> _builtins.bool:
        return pulumi.get(self, "is_organization_trail")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> _builtins.str:
        """
        The name of the specified OSS bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> _builtins.str:
        """
        The prefix of the specified OSS bucket name.
        """
        return pulumi.get(self, "oss_key_prefix")

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> _builtins.str:
        return pulumi.get(self, "oss_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service project.
        """
        return pulumi.get(self, "sls_project_arn")

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> _builtins.str:
        """
        The unique ARN of the Log Service role.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> _builtins.str:
        """
        The name of the ActionTrail Trail.
        """
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> _builtins.str:
        """
        The regions to which the trail is applied.
        """
        return pulumi.get(self, "trail_region")


