# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrailArgs', 'Trail']

@pulumi.input_type
class TrailArgs:
    def __init__(__self__, *,
                 event_rw: Optional[pulumi.Input[_builtins.str]] = None,
                 is_organization_trail: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_compute_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_compute_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_key_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Trail resource.
        :param pulumi.Input[_builtins.str] event_rw: The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        :param pulumi.Input[_builtins.bool] is_organization_trail: Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] max_compute_project_arn: The ARN of the MaxCompute project to which you want to deliver events.
        :param pulumi.Input[_builtins.str] max_compute_write_role_arn: The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        :param pulumi.Input[_builtins.str] mns_topic_arn: Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_key_prefix: The prefix of the file name in the OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_write_role_arn: The name of the RAM role that the user allows ActionTrail to access OSS service.
        :param pulumi.Input[_builtins.str] role_name: Field `role_name` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] sls_project_arn: The ARN of the Simple Log Service project to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] sls_write_role_arn: The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        :param pulumi.Input[_builtins.str] status: The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] trail_name: The name of the trail to be created.
        :param pulumi.Input[_builtins.str] trail_region: The region of the trail.
        """
        if event_rw is not None:
            pulumi.set(__self__, "event_rw", event_rw)
        if is_organization_trail is not None:
            pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        if max_compute_project_arn is not None:
            pulumi.set(__self__, "max_compute_project_arn", max_compute_project_arn)
        if max_compute_write_role_arn is not None:
            pulumi.set(__self__, "max_compute_write_role_arn", max_compute_write_role_arn)
        if mns_topic_arn is not None:
            warnings.warn("""Field `mns_topic_arn` has been deprecated from version 1.118.0""", DeprecationWarning)
            pulumi.log.warn("""mns_topic_arn is deprecated: Field `mns_topic_arn` has been deprecated from version 1.118.0""")
        if mns_topic_arn is not None:
            pulumi.set(__self__, "mns_topic_arn", mns_topic_arn)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if oss_key_prefix is not None:
            pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        if oss_write_role_arn is not None:
            pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        if role_name is not None:
            warnings.warn("""Field `role_name` has been deprecated from version 1.118.0""", DeprecationWarning)
            pulumi.log.warn("""role_name is deprecated: Field `role_name` has been deprecated from version 1.118.0""")
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if sls_project_arn is not None:
            pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        if sls_write_role_arn is not None:
            pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trail_name is not None:
            pulumi.set(__self__, "trail_name", trail_name)
        if trail_region is not None:
            pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        """
        return pulumi.get(self, "event_rw")

    @event_rw.setter
    def event_rw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_rw", value)

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "is_organization_trail")

    @is_organization_trail.setter
    def is_organization_trail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_organization_trail", value)

    @_builtins.property
    @pulumi.getter(name="maxComputeProjectArn")
    def max_compute_project_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the MaxCompute project to which you want to deliver events.
        """
        return pulumi.get(self, "max_compute_project_arn")

    @max_compute_project_arn.setter
    def max_compute_project_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_compute_project_arn", value)

    @_builtins.property
    @pulumi.getter(name="maxComputeWriteRoleArn")
    def max_compute_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        """
        return pulumi.get(self, "max_compute_write_role_arn")

    @max_compute_write_role_arn.setter
    def max_compute_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_compute_write_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="mnsTopicArn")
    @_utilities.deprecated("""Field `mns_topic_arn` has been deprecated from version 1.118.0""")
    def mns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "mns_topic_arn")

    @mns_topic_arn.setter
    def mns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mns_topic_arn", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the file name in the OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_key_prefix")

    @oss_key_prefix.setter
    def oss_key_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_key_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that the user allows ActionTrail to access OSS service.
        """
        return pulumi.get(self, "oss_write_role_arn")

    @oss_write_role_arn.setter
    def oss_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_write_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    @_utilities.deprecated("""Field `role_name` has been deprecated from version 1.118.0""")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `role_name` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the Simple Log Service project to which the trail delivers logs.
        """
        return pulumi.get(self, "sls_project_arn")

    @sls_project_arn.setter
    def sls_project_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_project_arn", value)

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @sls_write_role_arn.setter
    def sls_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_write_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the trail to be created.
        """
        return pulumi.get(self, "trail_name")

    @trail_name.setter
    def trail_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_name", value)

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the trail.
        """
        return pulumi.get(self, "trail_region")

    @trail_region.setter
    def trail_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_region", value)


@pulumi.input_type
class _TrailState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 event_rw: Optional[pulumi.Input[_builtins.str]] = None,
                 is_organization_trail: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_compute_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_compute_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_key_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Trail resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.256.0) The time when the trail was created.
        :param pulumi.Input[_builtins.str] event_rw: The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        :param pulumi.Input[_builtins.bool] is_organization_trail: Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] max_compute_project_arn: The ARN of the MaxCompute project to which you want to deliver events.
        :param pulumi.Input[_builtins.str] max_compute_write_role_arn: The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        :param pulumi.Input[_builtins.str] mns_topic_arn: Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_key_prefix: The prefix of the file name in the OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_write_role_arn: The name of the RAM role that the user allows ActionTrail to access OSS service.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.256.0) The home region of the trail.
        :param pulumi.Input[_builtins.str] role_name: Field `role_name` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] sls_project_arn: The ARN of the Simple Log Service project to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] sls_write_role_arn: The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        :param pulumi.Input[_builtins.str] status: The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] trail_name: The name of the trail to be created.
        :param pulumi.Input[_builtins.str] trail_region: The region of the trail.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if event_rw is not None:
            pulumi.set(__self__, "event_rw", event_rw)
        if is_organization_trail is not None:
            pulumi.set(__self__, "is_organization_trail", is_organization_trail)
        if max_compute_project_arn is not None:
            pulumi.set(__self__, "max_compute_project_arn", max_compute_project_arn)
        if max_compute_write_role_arn is not None:
            pulumi.set(__self__, "max_compute_write_role_arn", max_compute_write_role_arn)
        if mns_topic_arn is not None:
            warnings.warn("""Field `mns_topic_arn` has been deprecated from version 1.118.0""", DeprecationWarning)
            pulumi.log.warn("""mns_topic_arn is deprecated: Field `mns_topic_arn` has been deprecated from version 1.118.0""")
        if mns_topic_arn is not None:
            pulumi.set(__self__, "mns_topic_arn", mns_topic_arn)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if oss_key_prefix is not None:
            pulumi.set(__self__, "oss_key_prefix", oss_key_prefix)
        if oss_write_role_arn is not None:
            pulumi.set(__self__, "oss_write_role_arn", oss_write_role_arn)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if role_name is not None:
            warnings.warn("""Field `role_name` has been deprecated from version 1.118.0""", DeprecationWarning)
            pulumi.log.warn("""role_name is deprecated: Field `role_name` has been deprecated from version 1.118.0""")
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if sls_project_arn is not None:
            pulumi.set(__self__, "sls_project_arn", sls_project_arn)
        if sls_write_role_arn is not None:
            pulumi.set(__self__, "sls_write_role_arn", sls_write_role_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trail_name is not None:
            pulumi.set(__self__, "trail_name", trail_name)
        if trail_region is not None:
            pulumi.set(__self__, "trail_region", trail_region)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.256.0) The time when the trail was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        """
        return pulumi.get(self, "event_rw")

    @event_rw.setter
    def event_rw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_rw", value)

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "is_organization_trail")

    @is_organization_trail.setter
    def is_organization_trail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_organization_trail", value)

    @_builtins.property
    @pulumi.getter(name="maxComputeProjectArn")
    def max_compute_project_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the MaxCompute project to which you want to deliver events.
        """
        return pulumi.get(self, "max_compute_project_arn")

    @max_compute_project_arn.setter
    def max_compute_project_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_compute_project_arn", value)

    @_builtins.property
    @pulumi.getter(name="maxComputeWriteRoleArn")
    def max_compute_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        """
        return pulumi.get(self, "max_compute_write_role_arn")

    @max_compute_write_role_arn.setter
    def max_compute_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_compute_write_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="mnsTopicArn")
    @_utilities.deprecated("""Field `mns_topic_arn` has been deprecated from version 1.118.0""")
    def mns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "mns_topic_arn")

    @mns_topic_arn.setter
    def mns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mns_topic_arn", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the file name in the OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_key_prefix")

    @oss_key_prefix.setter
    def oss_key_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_key_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that the user allows ActionTrail to access OSS service.
        """
        return pulumi.get(self, "oss_write_role_arn")

    @oss_write_role_arn.setter
    def oss_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_write_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.256.0) The home region of the trail.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    @_utilities.deprecated("""Field `role_name` has been deprecated from version 1.118.0""")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `role_name` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the Simple Log Service project to which the trail delivers logs.
        """
        return pulumi.get(self, "sls_project_arn")

    @sls_project_arn.setter
    def sls_project_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_project_arn", value)

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @sls_write_role_arn.setter
    def sls_write_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_write_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the trail to be created.
        """
        return pulumi.get(self, "trail_name")

    @trail_name.setter
    def trail_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_name", value)

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the trail.
        """
        return pulumi.get(self, "trail_region")

    @trail_region.setter
    def trail_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_region", value)


@pulumi.type_token("alicloud:actiontrail/trail:Trail")
class Trail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_rw: Optional[pulumi.Input[_builtins.str]] = None,
                 is_organization_trail: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_compute_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_compute_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_key_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Actiontrail Trail resource.

        Trail of ActionTrail. After creating a trail, you need to enable the trail through StartLogging.

        For information about Actiontrail Trail and how to use it, see [What is Trail](https://www.alibabacloud.com/help/en/actiontrail/latest/api-actiontrail-2020-07-06-createtrail).

        > **NOTE:** Available since v1.95.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_get_account = alicloud.get_account()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_project = alicloud.log.Project("default",
            project_name=f"{name}-{default_integer['result']}",
            description="tf actiontrail example")
        default_get_roles = alicloud.ram.get_roles(name_regex="AliyunServiceRoleForActionTrail")
        default_trail = alicloud.actiontrail.Trail("default",
            trail_name=name,
            sls_write_role_arn=default_get_roles.roles[0].arn,
            sls_project_arn=default_project.project_name.apply(lambda project_name: f"acs:log:{default.regions[0].id}:{default_get_account.id}:project/{project_name}"))
        ```

        ## Import

        Actiontrail Trail can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:actiontrail/trail:Trail example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] event_rw: The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        :param pulumi.Input[_builtins.bool] is_organization_trail: Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] max_compute_project_arn: The ARN of the MaxCompute project to which you want to deliver events.
        :param pulumi.Input[_builtins.str] max_compute_write_role_arn: The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        :param pulumi.Input[_builtins.str] mns_topic_arn: Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_key_prefix: The prefix of the file name in the OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_write_role_arn: The name of the RAM role that the user allows ActionTrail to access OSS service.
        :param pulumi.Input[_builtins.str] role_name: Field `role_name` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] sls_project_arn: The ARN of the Simple Log Service project to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] sls_write_role_arn: The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        :param pulumi.Input[_builtins.str] status: The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] trail_name: The name of the trail to be created.
        :param pulumi.Input[_builtins.str] trail_region: The region of the trail.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TrailArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Actiontrail Trail resource.

        Trail of ActionTrail. After creating a trail, you need to enable the trail through StartLogging.

        For information about Actiontrail Trail and how to use it, see [What is Trail](https://www.alibabacloud.com/help/en/actiontrail/latest/api-actiontrail-2020-07-06-createtrail).

        > **NOTE:** Available since v1.95.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_get_account = alicloud.get_account()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_project = alicloud.log.Project("default",
            project_name=f"{name}-{default_integer['result']}",
            description="tf actiontrail example")
        default_get_roles = alicloud.ram.get_roles(name_regex="AliyunServiceRoleForActionTrail")
        default_trail = alicloud.actiontrail.Trail("default",
            trail_name=name,
            sls_write_role_arn=default_get_roles.roles[0].arn,
            sls_project_arn=default_project.project_name.apply(lambda project_name: f"acs:log:{default.regions[0].id}:{default_get_account.id}:project/{project_name}"))
        ```

        ## Import

        Actiontrail Trail can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:actiontrail/trail:Trail example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_rw: Optional[pulumi.Input[_builtins.str]] = None,
                 is_organization_trail: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_compute_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_compute_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_key_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrailArgs.__new__(TrailArgs)

            __props__.__dict__["event_rw"] = event_rw
            __props__.__dict__["is_organization_trail"] = is_organization_trail
            __props__.__dict__["max_compute_project_arn"] = max_compute_project_arn
            __props__.__dict__["max_compute_write_role_arn"] = max_compute_write_role_arn
            __props__.__dict__["mns_topic_arn"] = mns_topic_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["oss_bucket_name"] = oss_bucket_name
            __props__.__dict__["oss_key_prefix"] = oss_key_prefix
            __props__.__dict__["oss_write_role_arn"] = oss_write_role_arn
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["sls_project_arn"] = sls_project_arn
            __props__.__dict__["sls_write_role_arn"] = sls_write_role_arn
            __props__.__dict__["status"] = status
            __props__.__dict__["trail_name"] = trail_name
            __props__.__dict__["trail_region"] = trail_region
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(Trail, __self__).__init__(
            'alicloud:actiontrail/trail:Trail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            event_rw: Optional[pulumi.Input[_builtins.str]] = None,
            is_organization_trail: Optional[pulumi.Input[_builtins.bool]] = None,
            max_compute_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
            max_compute_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            mns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            oss_key_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            oss_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            sls_project_arn: Optional[pulumi.Input[_builtins.str]] = None,
            sls_write_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            trail_name: Optional[pulumi.Input[_builtins.str]] = None,
            trail_region: Optional[pulumi.Input[_builtins.str]] = None) -> 'Trail':
        """
        Get an existing Trail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.256.0) The time when the trail was created.
        :param pulumi.Input[_builtins.str] event_rw: The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        :param pulumi.Input[_builtins.bool] is_organization_trail: Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] max_compute_project_arn: The ARN of the MaxCompute project to which you want to deliver events.
        :param pulumi.Input[_builtins.str] max_compute_write_role_arn: The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        :param pulumi.Input[_builtins.str] mns_topic_arn: Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_key_prefix: The prefix of the file name in the OSS bucket to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] oss_write_role_arn: The name of the RAM role that the user allows ActionTrail to access OSS service.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.256.0) The home region of the trail.
        :param pulumi.Input[_builtins.str] role_name: Field `role_name` has been deprecated from provider version 1.118.0.
        :param pulumi.Input[_builtins.str] sls_project_arn: The ARN of the Simple Log Service project to which the trail delivers logs.
        :param pulumi.Input[_builtins.str] sls_write_role_arn: The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        :param pulumi.Input[_builtins.str] status: The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[_builtins.str] trail_name: The name of the trail to be created.
        :param pulumi.Input[_builtins.str] trail_region: The region of the trail.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrailState.__new__(_TrailState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["event_rw"] = event_rw
        __props__.__dict__["is_organization_trail"] = is_organization_trail
        __props__.__dict__["max_compute_project_arn"] = max_compute_project_arn
        __props__.__dict__["max_compute_write_role_arn"] = max_compute_write_role_arn
        __props__.__dict__["mns_topic_arn"] = mns_topic_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["oss_bucket_name"] = oss_bucket_name
        __props__.__dict__["oss_key_prefix"] = oss_key_prefix
        __props__.__dict__["oss_write_role_arn"] = oss_write_role_arn
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["sls_project_arn"] = sls_project_arn
        __props__.__dict__["sls_write_role_arn"] = sls_write_role_arn
        __props__.__dict__["status"] = status
        __props__.__dict__["trail_name"] = trail_name
        __props__.__dict__["trail_region"] = trail_region
        return Trail(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.256.0) The time when the trail was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="eventRw")
    def event_rw(self) -> pulumi.Output[_builtins.str]:
        """
        The read/write type of the events to be delivered. Default value: `All`. Valid values: `Read`, `Write`, `All`.
        """
        return pulumi.get(self, "event_rw")

    @_builtins.property
    @pulumi.getter(name="isOrganizationTrail")
    def is_organization_trail(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to create a multi-account trail. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "is_organization_trail")

    @_builtins.property
    @pulumi.getter(name="maxComputeProjectArn")
    def max_compute_project_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the MaxCompute project to which you want to deliver events.
        """
        return pulumi.get(self, "max_compute_project_arn")

    @_builtins.property
    @pulumi.getter(name="maxComputeWriteRoleArn")
    def max_compute_write_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the role that is assumed by ActionTrail to deliver events to the MaxCompute project.
        """
        return pulumi.get(self, "max_compute_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="mnsTopicArn")
    @_utilities.deprecated("""Field `mns_topic_arn` has been deprecated from version 1.118.0""")
    def mns_topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field `mns_topic_arn` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "mns_topic_arn")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.95.0. New field `trail_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossKeyPrefix")
    def oss_key_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The prefix of the file name in the OSS bucket to which the trail delivers logs.
        """
        return pulumi.get(self, "oss_key_prefix")

    @_builtins.property
    @pulumi.getter(name="ossWriteRoleArn")
    def oss_write_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the RAM role that the user allows ActionTrail to access OSS service.
        """
        return pulumi.get(self, "oss_write_role_arn")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.256.0) The home region of the trail.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    @_utilities.deprecated("""Field `role_name` has been deprecated from version 1.118.0""")
    def role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field `role_name` has been deprecated from provider version 1.118.0.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="slsProjectArn")
    def sls_project_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the Simple Log Service project to which the trail delivers logs.
        """
        return pulumi.get(self, "sls_project_arn")

    @_builtins.property
    @pulumi.getter(name="slsWriteRoleArn")
    def sls_write_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the role that ActionTrail assumes to deliver operation events to the Simple Log Service project.
        """
        return pulumi.get(self, "sls_write_role_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The status of the trail. Default value: `Enable`. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trailName")
    def trail_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the trail to be created.
        """
        return pulumi.get(self, "trail_name")

    @_builtins.property
    @pulumi.getter(name="trailRegion")
    def trail_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the trail.
        """
        return pulumi.get(self, "trail_region")

