# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLoadBalancersResult',
    'AwaitableGetLoadBalancersResult',
    'get_load_balancers',
    'get_load_balancers_output',
]

@pulumi.output_type
class GetLoadBalancersResult:
    """
    A collection of values returned by getLoadBalancers.
    """
    def __init__(__self__, address_type=None, balancers=None, enable_details=None, id=None, ids=None, load_balancer_business_status=None, load_balancer_bussiness_status=None, load_balancer_ids=None, load_balancer_name=None, name_regex=None, names=None, output_file=None, resource_group_id=None, status=None, tags=None, vpc_id=None, vpc_ids=None, zone_id=None):
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if balancers and not isinstance(balancers, list):
            raise TypeError("Expected argument 'balancers' to be a list")
        pulumi.set(__self__, "balancers", balancers)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if load_balancer_business_status and not isinstance(load_balancer_business_status, str):
            raise TypeError("Expected argument 'load_balancer_business_status' to be a str")
        pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        if load_balancer_bussiness_status and not isinstance(load_balancer_bussiness_status, str):
            raise TypeError("Expected argument 'load_balancer_bussiness_status' to be a str")
        pulumi.set(__self__, "load_balancer_bussiness_status", load_balancer_bussiness_status)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_ids and not isinstance(vpc_ids, list):
            raise TypeError("Expected argument 'vpc_ids' to be a list")
        pulumi.set(__self__, "vpc_ids", vpc_ids)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[_builtins.str]:
        """
        The type of IP address that the ALB instance uses to provide services.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def balancers(self) -> Sequence['outputs.GetLoadBalancersBalancerResult']:
        """
        A list of Alb Load Balancers. Each element contains the following attributes:
        """
        return pulumi.get(self, "balancers")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.142.0) Load Balancing of the Service Status.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBussinessStatus")
    @_utilities.deprecated("""Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it will be removed in the future version. Please use the new attribute 'load_balancer_business_status' instead.""")
    def load_balancer_bussiness_status(self) -> Optional[_builtins.str]:
        """
        (Deprecated since v1.142.0) Load Balancing of the Service Status. **NOTE:** Field `load_balancer_bussiness_status` has been deprecated from provider version 1.142.0. New field `load_balancer_business_status` instead.
        """
        return pulumi.get(self, "load_balancer_bussiness_status")

    @_builtins.property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "load_balancer_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Load Balancer names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.250.0) The zone status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "vpc_ids")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The ID of the zone to which the ALB instance belongs.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetLoadBalancersResult(GetLoadBalancersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancersResult(
            address_type=self.address_type,
            balancers=self.balancers,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            load_balancer_business_status=self.load_balancer_business_status,
            load_balancer_bussiness_status=self.load_balancer_bussiness_status,
            load_balancer_ids=self.load_balancer_ids,
            load_balancer_name=self.load_balancer_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id,
            vpc_ids=self.vpc_ids,
            zone_id=self.zone_id)


def get_load_balancers(address_type: Optional[_builtins.str] = None,
                       enable_details: Optional[_builtins.bool] = None,
                       ids: Optional[Sequence[_builtins.str]] = None,
                       load_balancer_business_status: Optional[_builtins.str] = None,
                       load_balancer_bussiness_status: Optional[_builtins.str] = None,
                       load_balancer_ids: Optional[Sequence[_builtins.str]] = None,
                       load_balancer_name: Optional[_builtins.str] = None,
                       name_regex: Optional[_builtins.str] = None,
                       output_file: Optional[_builtins.str] = None,
                       resource_group_id: Optional[_builtins.str] = None,
                       status: Optional[_builtins.str] = None,
                       tags: Optional[Mapping[str, _builtins.str]] = None,
                       vpc_id: Optional[_builtins.str] = None,
                       vpc_ids: Optional[Sequence[_builtins.str]] = None,
                       zone_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancersResult:
    """
    This data source provides the Alb Load Balancers of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.132.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_get_zones = alicloud.alb.get_zones()
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16",
        enable_ipv6=True)
    zone_a = alicloud.ecs.Eip("zone_a",
        bandwidth="10",
        internet_charge_type="PayByTraffic")
    zone_a_switch = alicloud.vpc.Switch("zone_a",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.0.0/18",
        zone_id=default_get_zones.zones[0].id,
        ipv6_cidr_block_mask=6)
    zone_b = alicloud.vpc.Switch("zone_b",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.128.0/18",
        zone_id=default_get_zones.zones[1].id,
        ipv6_cidr_block_mask=8)
    default_ipv6_gateway = alicloud.vpc.Ipv6Gateway("default",
        ipv6_gateway_name=name,
        vpc_id=default_network.id)
    default_common_bandwith_package = alicloud.vpc.CommonBandwithPackage("default",
        bandwidth="1000",
        internet_charge_type="PayByBandwidth")
    default_load_balancer = alicloud.alb.LoadBalancer("default",
        load_balancer_edition="Basic",
        address_type="Internet",
        vpc_id=default_ipv6_gateway.vpc_id,
        address_allocated_mode="Fixed",
        address_ip_version="DualStack",
        ipv6_address_type="Internet",
        bandwidth_package_id=default_common_bandwith_package.id,
        resource_group_id=default.groups[1].id,
        load_balancer_name=name,
        deletion_protection_enabled=False,
        load_balancer_billing_config={
            "pay_type": "PayAsYouGo",
        },
        zone_mappings=[
            {
                "vswitch_id": zone_a_switch.id,
                "zone_id": zone_a_switch.zone_id,
                "eip_type": "Common",
                "allocation_id": zone_a.id,
                "intranet_address": "192.168.10.1",
            },
            {
                "vswitch_id": zone_b.id,
                "zone_id": zone_b.zone_id,
            },
        ],
        tags={
            "Created": "TF",
        })
    ids = alicloud.alb.get_load_balancers_output(ids=[default_load_balancer.id])
    pulumi.export("albLoadBalancersId0", ids.balancers[0].id)
    ```


    :param _builtins.str address_type: The type of IP address that the ALB instance uses to provide services. Valid values: `Intranet`, `Internet`.
    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Load Balancer IDs.
    :param _builtins.str load_balancer_business_status: Load Balancing of the Service Status. Valid Values: `Abnormal`and `Normal`.
    :param _builtins.str load_balancer_bussiness_status: Field `load_balancer_bussiness_status` has been deprecated from provider version 1.142.0. New field `load_balancer_business_status` instead.
    :param Sequence[_builtins.str] load_balancer_ids: The load balancer ids.
    :param _builtins.str load_balancer_name: The name of the resource.
    :param _builtins.str name_regex: A regex string to filter results by Load Balancer name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
    :param Sequence[_builtins.str] vpc_ids: The vpc ids.
    :param _builtins.str zone_id: The zone ID of the resource.
    """
    __args__ = dict()
    __args__['addressType'] = address_type
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['loadBalancerBusinessStatus'] = load_balancer_business_status
    __args__['loadBalancerBussinessStatus'] = load_balancer_bussiness_status
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['loadBalancerName'] = load_balancer_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vpcIds'] = vpc_ids
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getLoadBalancers:getLoadBalancers', __args__, opts=opts, typ=GetLoadBalancersResult).value

    return AwaitableGetLoadBalancersResult(
        address_type=pulumi.get(__ret__, 'address_type'),
        balancers=pulumi.get(__ret__, 'balancers'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        load_balancer_business_status=pulumi.get(__ret__, 'load_balancer_business_status'),
        load_balancer_bussiness_status=pulumi.get(__ret__, 'load_balancer_bussiness_status'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_ids=pulumi.get(__ret__, 'vpc_ids'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_load_balancers_output(address_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              load_balancer_business_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              load_balancer_bussiness_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              load_balancer_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              vpc_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancersResult]:
    """
    This data source provides the Alb Load Balancers of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.132.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_get_zones = alicloud.alb.get_zones()
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16",
        enable_ipv6=True)
    zone_a = alicloud.ecs.Eip("zone_a",
        bandwidth="10",
        internet_charge_type="PayByTraffic")
    zone_a_switch = alicloud.vpc.Switch("zone_a",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.0.0/18",
        zone_id=default_get_zones.zones[0].id,
        ipv6_cidr_block_mask=6)
    zone_b = alicloud.vpc.Switch("zone_b",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.128.0/18",
        zone_id=default_get_zones.zones[1].id,
        ipv6_cidr_block_mask=8)
    default_ipv6_gateway = alicloud.vpc.Ipv6Gateway("default",
        ipv6_gateway_name=name,
        vpc_id=default_network.id)
    default_common_bandwith_package = alicloud.vpc.CommonBandwithPackage("default",
        bandwidth="1000",
        internet_charge_type="PayByBandwidth")
    default_load_balancer = alicloud.alb.LoadBalancer("default",
        load_balancer_edition="Basic",
        address_type="Internet",
        vpc_id=default_ipv6_gateway.vpc_id,
        address_allocated_mode="Fixed",
        address_ip_version="DualStack",
        ipv6_address_type="Internet",
        bandwidth_package_id=default_common_bandwith_package.id,
        resource_group_id=default.groups[1].id,
        load_balancer_name=name,
        deletion_protection_enabled=False,
        load_balancer_billing_config={
            "pay_type": "PayAsYouGo",
        },
        zone_mappings=[
            {
                "vswitch_id": zone_a_switch.id,
                "zone_id": zone_a_switch.zone_id,
                "eip_type": "Common",
                "allocation_id": zone_a.id,
                "intranet_address": "192.168.10.1",
            },
            {
                "vswitch_id": zone_b.id,
                "zone_id": zone_b.zone_id,
            },
        ],
        tags={
            "Created": "TF",
        })
    ids = alicloud.alb.get_load_balancers_output(ids=[default_load_balancer.id])
    pulumi.export("albLoadBalancersId0", ids.balancers[0].id)
    ```


    :param _builtins.str address_type: The type of IP address that the ALB instance uses to provide services. Valid values: `Intranet`, `Internet`.
    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Load Balancer IDs.
    :param _builtins.str load_balancer_business_status: Load Balancing of the Service Status. Valid Values: `Abnormal`and `Normal`.
    :param _builtins.str load_balancer_bussiness_status: Field `load_balancer_bussiness_status` has been deprecated from provider version 1.142.0. New field `load_balancer_business_status` instead.
    :param Sequence[_builtins.str] load_balancer_ids: The load balancer ids.
    :param _builtins.str load_balancer_name: The name of the resource.
    :param _builtins.str name_regex: A regex string to filter results by Load Balancer name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
    :param Sequence[_builtins.str] vpc_ids: The vpc ids.
    :param _builtins.str zone_id: The zone ID of the resource.
    """
    __args__ = dict()
    __args__['addressType'] = address_type
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['loadBalancerBusinessStatus'] = load_balancer_business_status
    __args__['loadBalancerBussinessStatus'] = load_balancer_bussiness_status
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['loadBalancerName'] = load_balancer_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vpcIds'] = vpc_ids
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:alb/getLoadBalancers:getLoadBalancers', __args__, opts=opts, typ=GetLoadBalancersResult)
    return __ret__.apply(lambda __response__: GetLoadBalancersResult(
        address_type=pulumi.get(__response__, 'address_type'),
        balancers=pulumi.get(__response__, 'balancers'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        load_balancer_business_status=pulumi.get(__response__, 'load_balancer_business_status'),
        load_balancer_bussiness_status=pulumi.get(__response__, 'load_balancer_bussiness_status'),
        load_balancer_ids=pulumi.get(__response__, 'load_balancer_ids'),
        load_balancer_name=pulumi.get(__response__, 'load_balancer_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpc_ids=pulumi.get(__response__, 'vpc_ids'),
        zone_id=pulumi.get(__response__, 'zone_id')))
