# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRulesResult',
    'AwaitableGetRulesResult',
    'get_rules',
    'get_rules_output',
]

@pulumi.output_type
class GetRulesResult:
    """
    A collection of values returned by getRules.
    """
    def __init__(__self__, id=None, ids=None, listener_ids=None, load_balancer_ids=None, name_regex=None, names=None, output_file=None, rule_ids=None, rules=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_ids and not isinstance(listener_ids, list):
            raise TypeError("Expected argument 'listener_ids' to be a list")
        pulumi.set(__self__, "listener_ids", listener_ids)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rule_ids and not isinstance(rule_ids, list):
            raise TypeError("Expected argument 'rule_ids' to be a list")
        pulumi.set(__self__, "rule_ids", rule_ids)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="listenerIds")
    def listener_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "listener_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "load_balancer_ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Rule names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "rule_ids")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetRulesRuleResult']:
        """
        A list of Alb Rules. Each element contains the following attributes:
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the forwarding rule.
        """
        return pulumi.get(self, "status")


class AwaitableGetRulesResult(GetRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesResult(
            id=self.id,
            ids=self.ids,
            listener_ids=self.listener_ids,
            load_balancer_ids=self.load_balancer_ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            rule_ids=self.rule_ids,
            rules=self.rules,
            status=self.status)


def get_rules(ids: Optional[Sequence[_builtins.str]] = None,
              listener_ids: Optional[Sequence[_builtins.str]] = None,
              load_balancer_ids: Optional[Sequence[_builtins.str]] = None,
              name_regex: Optional[_builtins.str] = None,
              output_file: Optional[_builtins.str] = None,
              rule_ids: Optional[Sequence[_builtins.str]] = None,
              status: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesResult:
    """
    This data source provides the Alb Rules of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.133.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.alb.get_zones()
    default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = []
    for range in [{"value": i} for i in range(0, 2)]:
        default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
            vpc_id=default_network.id,
            cidr_block=std.format(input="10.4.%d.0/24",
                args=[range["value"] + 1]).result,
            zone_id=default.zones[range["value"]].id,
            vswitch_name=std.format(input=f"{name}_%d",
                args=[range["value"] + 1]).result))
    default_load_balancer = alicloud.alb.LoadBalancer("default",
        vpc_id=default_network.id,
        address_type="Internet",
        address_allocated_mode="Fixed",
        load_balancer_name=name,
        load_balancer_edition="Standard",
        resource_group_id=default_get_resource_groups.groups[0].id,
        load_balancer_billing_config={
            "pay_type": "PayAsYouGo",
        },
        tags={
            "Created": "TF",
        },
        zone_mappings=[
            {
                "vswitch_id": default_switch[0].id,
                "zone_id": default.zones[0].id,
            },
            {
                "vswitch_id": default_switch[1].id,
                "zone_id": default.zones[1].id,
            },
        ])
    default_server_group = alicloud.alb.ServerGroup("default",
        protocol="HTTP",
        vpc_id=default_network.id,
        server_group_name=name,
        resource_group_id=default_get_resource_groups.groups[0].id,
        health_check_config={
            "health_check_enabled": False,
        },
        sticky_session_config={
            "sticky_session_enabled": False,
        },
        tags={
            "Created": "TF",
        })
    default_listener = alicloud.alb.Listener("default",
        load_balancer_id=default_load_balancer.id,
        listener_protocol="HTTP",
        listener_port=80,
        listener_description=name,
        default_actions=[{
            "type": "ForwardGroup",
            "forward_group_config": {
                "server_group_tuples": [{
                    "server_group_id": default_server_group.id,
                }],
            },
        }])
    default_rule = alicloud.alb.Rule("default",
        rule_name=name,
        listener_id=default_listener.id,
        priority=555,
        rule_conditions=[{
            "cookie_config": {
                "values": [{
                    "key": "created",
                    "value": "tf",
                }],
            },
            "type": "Cookie",
        }],
        rule_actions=[{
            "forward_group_config": {
                "server_group_tuples": [{
                    "server_group_id": default_server_group.id,
                }],
            },
            "order": 9,
            "type": "ForwardGroup",
        }])
    ids = alicloud.alb.get_rules_output(ids=[default_rule.id])
    pulumi.export("albRuleId", ids.rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Rule IDs.
    :param Sequence[_builtins.str] listener_ids: The listener ids.
    :param Sequence[_builtins.str] load_balancer_ids: The load balancer ids.
    :param _builtins.str name_regex: A regex string to filter results by Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[_builtins.str] rule_ids: The rule ids.
    :param _builtins.str status: The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerIds'] = listener_ids
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['ruleIds'] = rule_ids
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getRules:getRules', __args__, opts=opts, typ=GetRulesResult).value

    return AwaitableGetRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_ids=pulumi.get(__ret__, 'listener_ids'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rule_ids=pulumi.get(__ret__, 'rule_ids'),
        rules=pulumi.get(__ret__, 'rules'),
        status=pulumi.get(__ret__, 'status'))
def get_rules_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     listener_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     rule_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulesResult]:
    """
    This data source provides the Alb Rules of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.133.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.alb.get_zones()
    default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = []
    for range in [{"value": i} for i in range(0, 2)]:
        default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
            vpc_id=default_network.id,
            cidr_block=std.format(input="10.4.%d.0/24",
                args=[range["value"] + 1]).result,
            zone_id=default.zones[range["value"]].id,
            vswitch_name=std.format(input=f"{name}_%d",
                args=[range["value"] + 1]).result))
    default_load_balancer = alicloud.alb.LoadBalancer("default",
        vpc_id=default_network.id,
        address_type="Internet",
        address_allocated_mode="Fixed",
        load_balancer_name=name,
        load_balancer_edition="Standard",
        resource_group_id=default_get_resource_groups.groups[0].id,
        load_balancer_billing_config={
            "pay_type": "PayAsYouGo",
        },
        tags={
            "Created": "TF",
        },
        zone_mappings=[
            {
                "vswitch_id": default_switch[0].id,
                "zone_id": default.zones[0].id,
            },
            {
                "vswitch_id": default_switch[1].id,
                "zone_id": default.zones[1].id,
            },
        ])
    default_server_group = alicloud.alb.ServerGroup("default",
        protocol="HTTP",
        vpc_id=default_network.id,
        server_group_name=name,
        resource_group_id=default_get_resource_groups.groups[0].id,
        health_check_config={
            "health_check_enabled": False,
        },
        sticky_session_config={
            "sticky_session_enabled": False,
        },
        tags={
            "Created": "TF",
        })
    default_listener = alicloud.alb.Listener("default",
        load_balancer_id=default_load_balancer.id,
        listener_protocol="HTTP",
        listener_port=80,
        listener_description=name,
        default_actions=[{
            "type": "ForwardGroup",
            "forward_group_config": {
                "server_group_tuples": [{
                    "server_group_id": default_server_group.id,
                }],
            },
        }])
    default_rule = alicloud.alb.Rule("default",
        rule_name=name,
        listener_id=default_listener.id,
        priority=555,
        rule_conditions=[{
            "cookie_config": {
                "values": [{
                    "key": "created",
                    "value": "tf",
                }],
            },
            "type": "Cookie",
        }],
        rule_actions=[{
            "forward_group_config": {
                "server_group_tuples": [{
                    "server_group_id": default_server_group.id,
                }],
            },
            "order": 9,
            "type": "ForwardGroup",
        }])
    ids = alicloud.alb.get_rules_output(ids=[default_rule.id])
    pulumi.export("albRuleId", ids.rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Rule IDs.
    :param Sequence[_builtins.str] listener_ids: The listener ids.
    :param Sequence[_builtins.str] load_balancer_ids: The load balancer ids.
    :param _builtins.str name_regex: A regex string to filter results by Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[_builtins.str] rule_ids: The rule ids.
    :param _builtins.str status: The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerIds'] = listener_ids
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['ruleIds'] = rule_ids
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:alb/getRules:getRules', __args__, opts=opts, typ=GetRulesResult)
    return __ret__.apply(lambda __response__: GetRulesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        listener_ids=pulumi.get(__response__, 'listener_ids'),
        load_balancer_ids=pulumi.get(__response__, 'load_balancer_ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        rule_ids=pulumi.get(__response__, 'rule_ids'),
        rules=pulumi.get(__response__, 'rules'),
        status=pulumi.get(__response__, 'status')))
