# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeywordLibArgs', 'KeywordLib']

@pulumi.input_type
class KeywordLibArgs:
    def __init__(__self__, *,
                 keyword_lib_name: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 lib_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeywordLib resource.
        :param pulumi.Input[_builtins.str] keyword_lib_name: The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] resource_type: The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: The business scenario. Example:["bizTypeA","bizTypeB"]
        :param pulumi.Input[_builtins.str] category: The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        :param pulumi.Input[_builtins.str] lang: Language.
        :param pulumi.Input[_builtins.str] language: Language used by the text Library
        :param pulumi.Input[_builtins.str] lib_type: The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        :param pulumi.Input[_builtins.str] match_mode: The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        """
        pulumi.set(__self__, "keyword_lib_name", keyword_lib_name)
        pulumi.set(__self__, "resource_type", resource_type)
        if biz_types is not None:
            pulumi.set(__self__, "biz_types", biz_types)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if lib_type is not None:
            pulumi.set(__self__, "lib_type", lib_type)
        if match_mode is not None:
            pulumi.set(__self__, "match_mode", match_mode)

    @_builtins.property
    @pulumi.getter(name="keywordLibName")
    def keyword_lib_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "keyword_lib_name")

    @keyword_lib_name.setter
    def keyword_lib_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "keyword_lib_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The business scenario. Example:["bizTypeA","bizTypeB"]
        """
        return pulumi.get(self, "biz_types")

    @biz_types.setter
    def biz_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "biz_types", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language used by the text Library
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="libType")
    def lib_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        """
        return pulumi.get(self, "lib_type")

    @lib_type.setter
    def lib_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lib_type", value)

    @_builtins.property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        """
        return pulumi.get(self, "match_mode")

    @match_mode.setter
    def match_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_mode", value)


@pulumi.input_type
class _KeywordLibState:
    def __init__(__self__, *,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyword_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 lib_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeywordLib resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: The business scenario. Example:["bizTypeA","bizTypeB"]
        :param pulumi.Input[_builtins.str] category: The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        :param pulumi.Input[_builtins.str] keyword_lib_name: The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] lang: Language.
        :param pulumi.Input[_builtins.str] language: Language used by the text Library
        :param pulumi.Input[_builtins.str] lib_type: The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        :param pulumi.Input[_builtins.str] match_mode: The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        :param pulumi.Input[_builtins.str] resource_type: The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        if biz_types is not None:
            pulumi.set(__self__, "biz_types", biz_types)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if keyword_lib_name is not None:
            pulumi.set(__self__, "keyword_lib_name", keyword_lib_name)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if lib_type is not None:
            pulumi.set(__self__, "lib_type", lib_type)
        if match_mode is not None:
            pulumi.set(__self__, "match_mode", match_mode)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The business scenario. Example:["bizTypeA","bizTypeB"]
        """
        return pulumi.get(self, "biz_types")

    @biz_types.setter
    def biz_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "biz_types", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="keywordLibName")
    def keyword_lib_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "keyword_lib_name")

    @keyword_lib_name.setter
    def keyword_lib_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keyword_lib_name", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language used by the text Library
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="libType")
    def lib_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        """
        return pulumi.get(self, "lib_type")

    @lib_type.setter
    def lib_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lib_type", value)

    @_builtins.property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        """
        return pulumi.get(self, "match_mode")

    @match_mode.setter
    def match_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.type_token("alicloud:aligreen/keywordLib:KeywordLib")
class KeywordLib(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyword_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 lib_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Aligreen Keyword Lib resource.

        Keyword library for text detection.

        For information about Aligreen Keyword Lib and how to use it, see [What is Keyword Lib](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateKeywordLib).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_mn8s_vk = alicloud.aligreen.BizType("defaultMn8sVK",
            biz_type_name=f"{name}{default['result']}",
            cite_template=True,
            industry_info="社交-注册信息-昵称")
        default_keyword_lib = alicloud.aligreen.KeywordLib("default",
            category="BLACK",
            resource_type="TEXT",
            lib_type="textKeyword",
            keyword_lib_name=name,
            match_mode="fuzzy",
            language="cn",
            biz_types=["example_007"],
            lang="cn",
            enable=True)
        ```

        ## Import

        Aligreen Keyword Lib can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/keywordLib:KeywordLib example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: The business scenario. Example:["bizTypeA","bizTypeB"]
        :param pulumi.Input[_builtins.str] category: The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        :param pulumi.Input[_builtins.str] keyword_lib_name: The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] lang: Language.
        :param pulumi.Input[_builtins.str] language: Language used by the text Library
        :param pulumi.Input[_builtins.str] lib_type: The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        :param pulumi.Input[_builtins.str] match_mode: The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        :param pulumi.Input[_builtins.str] resource_type: The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeywordLibArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Aligreen Keyword Lib resource.

        Keyword library for text detection.

        For information about Aligreen Keyword Lib and how to use it, see [What is Keyword Lib](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateKeywordLib).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_mn8s_vk = alicloud.aligreen.BizType("defaultMn8sVK",
            biz_type_name=f"{name}{default['result']}",
            cite_template=True,
            industry_info="社交-注册信息-昵称")
        default_keyword_lib = alicloud.aligreen.KeywordLib("default",
            category="BLACK",
            resource_type="TEXT",
            lib_type="textKeyword",
            keyword_lib_name=name,
            match_mode="fuzzy",
            language="cn",
            biz_types=["example_007"],
            lang="cn",
            enable=True)
        ```

        ## Import

        Aligreen Keyword Lib can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/keywordLib:KeywordLib example <id>
        ```

        :param str resource_name: The name of the resource.
        :param KeywordLibArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeywordLibArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 keyword_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 lib_type: Optional[pulumi.Input[_builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeywordLibArgs.__new__(KeywordLibArgs)

            __props__.__dict__["biz_types"] = biz_types
            __props__.__dict__["category"] = category
            __props__.__dict__["enable"] = enable
            if keyword_lib_name is None and not opts.urn:
                raise TypeError("Missing required property 'keyword_lib_name'")
            __props__.__dict__["keyword_lib_name"] = keyword_lib_name
            __props__.__dict__["lang"] = lang
            __props__.__dict__["language"] = language
            __props__.__dict__["lib_type"] = lib_type
            __props__.__dict__["match_mode"] = match_mode
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
        super(KeywordLib, __self__).__init__(
            'alicloud:aligreen/keywordLib:KeywordLib',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            keyword_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            lib_type: Optional[pulumi.Input[_builtins.str]] = None,
            match_mode: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeywordLib':
        """
        Get an existing KeywordLib resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: The business scenario. Example:["bizTypeA","bizTypeB"]
        :param pulumi.Input[_builtins.str] category: The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        :param pulumi.Input[_builtins.str] keyword_lib_name: The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] lang: Language.
        :param pulumi.Input[_builtins.str] language: Language used by the text Library
        :param pulumi.Input[_builtins.str] lib_type: The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        :param pulumi.Input[_builtins.str] match_mode: The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        :param pulumi.Input[_builtins.str] resource_type: The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeywordLibState.__new__(_KeywordLibState)

        __props__.__dict__["biz_types"] = biz_types
        __props__.__dict__["category"] = category
        __props__.__dict__["enable"] = enable
        __props__.__dict__["keyword_lib_name"] = keyword_lib_name
        __props__.__dict__["lang"] = lang
        __props__.__dict__["language"] = language
        __props__.__dict__["lib_type"] = lib_type
        __props__.__dict__["match_mode"] = match_mode
        __props__.__dict__["resource_type"] = resource_type
        return KeywordLib(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The business scenario. Example:["bizTypeA","bizTypeB"]
        """
        return pulumi.get(self, "biz_types")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the text library. Valid values: BLACK: a blacklist. WHITE: a whitelist. REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable text library.true: Enable the text library. This is the default value.false: Disable the text library.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="keywordLibName")
    def keyword_lib_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the keyword library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "keyword_lib_name")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[_builtins.str]:
        """
        Language used by the text Library
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="libType")
    def lib_type(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the text library in each moderation scenario. Valid values: textKeyword: a text library against which terms in text are matched. similarText: a text library against which text patterns are matched. textKeyword: a text library against which terms extracted from images are matched. voiceText: a text library against which terms converted from audio are matched.
        """
        return pulumi.get(self, "lib_type")

    @_builtins.property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The matching method. Valid values:fuzzy: fuzzy match precise: exact match
        """
        return pulumi.get(self, "match_mode")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The moderation scenario to which the text library applies. Valid values:TEXT: text anti-spam、IMAGE: ad violation detection、VOICE: audio anti-spam
        """
        return pulumi.get(self, "resource_type")

