# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 zone_config: pulumi.Input['GatewayZoneConfigArgs'],
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['GatewayLogConfigArgs']] = None,
                 network_access_config: Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input['GatewayVpcArgs']] = None,
                 vswitch: Optional[pulumi.Input['GatewayVswitchArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input['GatewayZoneConfigArgs'] zone_config: Availability Zone Configuration See `zone_config` below.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the resource
        :param pulumi.Input[_builtins.str] gateway_type: Describes the gateway type, which is categorized into the following two types:
               - API: indicates an API gateway
               - AI: Indicates an AI gateway
        :param pulumi.Input['GatewayLogConfigArgs'] log_config: Log Configuration See `log_config` below.
        :param pulumi.Input['GatewayNetworkAccessConfigArgs'] network_access_config: Network Access Configuration See `network_access_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] spec: Gateway instance specifications
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input['GatewayVpcArgs'] vpc: The VPC associated with the Gateway. See `vpc` below.
        :param pulumi.Input['GatewayVswitchArgs'] vswitch: The virtual switch associated with the Gateway. See `vswitch` below.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]] zones: The List of zones associated with the Gateway. See `zones` below.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "zone_config", zone_config)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if network_access_config is not None:
            pulumi.set(__self__, "network_access_config", network_access_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if vswitch is not None:
            pulumi.set(__self__, "vswitch", vswitch)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="zoneConfig")
    def zone_config(self) -> pulumi.Input['GatewayZoneConfigArgs']:
        """
        Availability Zone Configuration See `zone_config` below.
        """
        return pulumi.get(self, "zone_config")

    @zone_config.setter
    def zone_config(self, value: pulumi.Input['GatewayZoneConfigArgs']):
        pulumi.set(self, "zone_config", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the gateway type, which is categorized into the following two types:
        - API: indicates an API gateway
        - AI: Indicates an AI gateway
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_type", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['GatewayLogConfigArgs']]:
        """
        Log Configuration See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['GatewayLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessConfig")
    def network_access_config(self) -> Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']]:
        """
        Network Access Configuration See `network_access_config` below.
        """
        return pulumi.get(self, "network_access_config")

    @network_access_config.setter
    def network_access_config(self, value: Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']]):
        pulumi.set(self, "network_access_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway instance specifications
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['GatewayVpcArgs']]:
        """
        The VPC associated with the Gateway. See `vpc` below.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['GatewayVpcArgs']]):
        pulumi.set(self, "vpc", value)

    @_builtins.property
    @pulumi.getter
    def vswitch(self) -> Optional[pulumi.Input['GatewayVswitchArgs']]:
        """
        The virtual switch associated with the Gateway. See `vswitch` below.
        """
        return pulumi.get(self, "vswitch")

    @vswitch.setter
    def vswitch(self, value: Optional[pulumi.Input['GatewayVswitchArgs']]):
        pulumi.set(self, "vswitch", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]]:
        """
        The List of zones associated with the Gateway. See `zones` below.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['GatewayLogConfigArgs']] = None,
                 network_access_config: Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input['GatewayVpcArgs']] = None,
                 vswitch: Optional[pulumi.Input['GatewayVswitchArgs']] = None,
                 zone_config: Optional[pulumi.Input['GatewayZoneConfigArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[_builtins.int] create_time: The creation timestamp. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the resource
        :param pulumi.Input[_builtins.str] gateway_type: Describes the gateway type, which is categorized into the following two types:
               - API: indicates an API gateway
               - AI: Indicates an AI gateway
        :param pulumi.Input['GatewayLogConfigArgs'] log_config: Log Configuration See `log_config` below.
        :param pulumi.Input['GatewayNetworkAccessConfigArgs'] network_access_config: Network Access Configuration See `network_access_config` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] spec: Gateway instance specifications
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input['GatewayVpcArgs'] vpc: The VPC associated with the Gateway. See `vpc` below.
        :param pulumi.Input['GatewayVswitchArgs'] vswitch: The virtual switch associated with the Gateway. See `vswitch` below.
        :param pulumi.Input['GatewayZoneConfigArgs'] zone_config: Availability Zone Configuration See `zone_config` below.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]] zones: The List of zones associated with the Gateway. See `zones` below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if network_access_config is not None:
            pulumi.set(__self__, "network_access_config", network_access_config)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if vswitch is not None:
            pulumi.set(__self__, "vswitch", vswitch)
        if zone_config is not None:
            pulumi.set(__self__, "zone_config", zone_config)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The creation timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the gateway type, which is categorized into the following two types:
        - API: indicates an API gateway
        - AI: Indicates an AI gateway
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_type", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['GatewayLogConfigArgs']]:
        """
        Log Configuration See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['GatewayLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessConfig")
    def network_access_config(self) -> Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']]:
        """
        Network Access Configuration See `network_access_config` below.
        """
        return pulumi.get(self, "network_access_config")

    @network_access_config.setter
    def network_access_config(self, value: Optional[pulumi.Input['GatewayNetworkAccessConfigArgs']]):
        pulumi.set(self, "network_access_config", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway instance specifications
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['GatewayVpcArgs']]:
        """
        The VPC associated with the Gateway. See `vpc` below.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['GatewayVpcArgs']]):
        pulumi.set(self, "vpc", value)

    @_builtins.property
    @pulumi.getter
    def vswitch(self) -> Optional[pulumi.Input['GatewayVswitchArgs']]:
        """
        The virtual switch associated with the Gateway. See `vswitch` below.
        """
        return pulumi.get(self, "vswitch")

    @vswitch.setter
    def vswitch(self, value: Optional[pulumi.Input['GatewayVswitchArgs']]):
        pulumi.set(self, "vswitch", value)

    @_builtins.property
    @pulumi.getter(name="zoneConfig")
    def zone_config(self) -> Optional[pulumi.Input['GatewayZoneConfigArgs']]:
        """
        Availability Zone Configuration See `zone_config` below.
        """
        return pulumi.get(self, "zone_config")

    @zone_config.setter
    def zone_config(self, value: Optional[pulumi.Input['GatewayZoneConfigArgs']]):
        pulumi.set(self, "zone_config", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]]:
        """
        The List of zones associated with the Gateway. See `zones` below.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayZoneArgs']]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("alicloud:apig/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['GatewayLogConfigArgs', 'GatewayLogConfigArgsDict']]] = None,
                 network_access_config: Optional[pulumi.Input[Union['GatewayNetworkAccessConfigArgs', 'GatewayNetworkAccessConfigArgsDict']]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input[Union['GatewayVpcArgs', 'GatewayVpcArgsDict']]] = None,
                 vswitch: Optional[pulumi.Input[Union['GatewayVswitchArgs', 'GatewayVswitchArgsDict']]] = None,
                 zone_config: Optional[pulumi.Input[Union['GatewayZoneConfigArgs', 'GatewayZoneConfigArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayZoneArgs', 'GatewayZoneArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        APIG Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apig/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the resource
        :param pulumi.Input[_builtins.str] gateway_type: Describes the gateway type, which is categorized into the following two types:
               - API: indicates an API gateway
               - AI: Indicates an AI gateway
        :param pulumi.Input[Union['GatewayLogConfigArgs', 'GatewayLogConfigArgsDict']] log_config: Log Configuration See `log_config` below.
        :param pulumi.Input[Union['GatewayNetworkAccessConfigArgs', 'GatewayNetworkAccessConfigArgsDict']] network_access_config: Network Access Configuration See `network_access_config` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] spec: Gateway instance specifications
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[Union['GatewayVpcArgs', 'GatewayVpcArgsDict']] vpc: The VPC associated with the Gateway. See `vpc` below.
        :param pulumi.Input[Union['GatewayVswitchArgs', 'GatewayVswitchArgsDict']] vswitch: The virtual switch associated with the Gateway. See `vswitch` below.
        :param pulumi.Input[Union['GatewayZoneConfigArgs', 'GatewayZoneConfigArgsDict']] zone_config: Availability Zone Configuration See `zone_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayZoneArgs', 'GatewayZoneArgsDict']]]] zones: The List of zones associated with the Gateway. See `zones` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        APIG Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apig/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['GatewayLogConfigArgs', 'GatewayLogConfigArgsDict']]] = None,
                 network_access_config: Optional[pulumi.Input[Union['GatewayNetworkAccessConfigArgs', 'GatewayNetworkAccessConfigArgsDict']]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input[Union['GatewayVpcArgs', 'GatewayVpcArgsDict']]] = None,
                 vswitch: Optional[pulumi.Input[Union['GatewayVswitchArgs', 'GatewayVswitchArgsDict']]] = None,
                 zone_config: Optional[pulumi.Input[Union['GatewayZoneConfigArgs', 'GatewayZoneConfigArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayZoneArgs', 'GatewayZoneArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["gateway_name"] = gateway_name
            __props__.__dict__["gateway_type"] = gateway_type
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["network_access_config"] = network_access_config
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["spec"] = spec
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["vswitch"] = vswitch
            if zone_config is None and not opts.urn:
                raise TypeError("Missing required property 'zone_config'")
            __props__.__dict__["zone_config"] = zone_config
            __props__.__dict__["zones"] = zones
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'alicloud:apig/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_type: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['GatewayLogConfigArgs', 'GatewayLogConfigArgsDict']]] = None,
            network_access_config: Optional[pulumi.Input[Union['GatewayNetworkAccessConfigArgs', 'GatewayNetworkAccessConfigArgsDict']]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc: Optional[pulumi.Input[Union['GatewayVpcArgs', 'GatewayVpcArgsDict']]] = None,
            vswitch: Optional[pulumi.Input[Union['GatewayVswitchArgs', 'GatewayVswitchArgsDict']]] = None,
            zone_config: Optional[pulumi.Input[Union['GatewayZoneConfigArgs', 'GatewayZoneConfigArgsDict']]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayZoneArgs', 'GatewayZoneArgsDict']]]]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] create_time: The creation timestamp. Unit: milliseconds.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the resource
        :param pulumi.Input[_builtins.str] gateway_type: Describes the gateway type, which is categorized into the following two types:
               - API: indicates an API gateway
               - AI: Indicates an AI gateway
        :param pulumi.Input[Union['GatewayLogConfigArgs', 'GatewayLogConfigArgsDict']] log_config: Log Configuration See `log_config` below.
        :param pulumi.Input[Union['GatewayNetworkAccessConfigArgs', 'GatewayNetworkAccessConfigArgsDict']] network_access_config: Network Access Configuration See `network_access_config` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] spec: Gateway instance specifications
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[Union['GatewayVpcArgs', 'GatewayVpcArgsDict']] vpc: The VPC associated with the Gateway. See `vpc` below.
        :param pulumi.Input[Union['GatewayVswitchArgs', 'GatewayVswitchArgsDict']] vswitch: The virtual switch associated with the Gateway. See `vswitch` below.
        :param pulumi.Input[Union['GatewayZoneConfigArgs', 'GatewayZoneConfigArgsDict']] zone_config: Availability Zone Configuration See `zone_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayZoneArgs', 'GatewayZoneArgsDict']]]] zones: The List of zones associated with the Gateway. See `zones` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["gateway_type"] = gateway_type
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["network_access_config"] = network_access_config
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc"] = vpc
        __props__.__dict__["vswitch"] = vswitch
        __props__.__dict__["zone_config"] = zone_config
        __props__.__dict__["zones"] = zones
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The creation timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the gateway type, which is categorized into the following two types:
        - API: indicates an API gateway
        - AI: Indicates an AI gateway
        """
        return pulumi.get(self, "gateway_type")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.GatewayLogConfig']]:
        """
        Log Configuration See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="networkAccessConfig")
    def network_access_config(self) -> pulumi.Output[Optional['outputs.GatewayNetworkAccessConfig']]:
        """
        Network Access Configuration See `network_access_config` below.
        """
        return pulumi.get(self, "network_access_config")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Gateway instance specifications
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[Optional['outputs.GatewayVpc']]:
        """
        The VPC associated with the Gateway. See `vpc` below.
        """
        return pulumi.get(self, "vpc")

    @_builtins.property
    @pulumi.getter
    def vswitch(self) -> pulumi.Output[Optional['outputs.GatewayVswitch']]:
        """
        The virtual switch associated with the Gateway. See `vswitch` below.
        """
        return pulumi.get(self, "vswitch")

    @_builtins.property
    @pulumi.getter(name="zoneConfig")
    def zone_config(self) -> pulumi.Output['outputs.GatewayZoneConfig']:
        """
        Availability Zone Configuration See `zone_config` below.
        """
        return pulumi.get(self, "zone_config")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence['outputs.GatewayZone']]:
        """
        The List of zones associated with the Gateway. See `zones` below.
        """
        return pulumi.get(self, "zones")

