# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessControlListArgs', 'AccessControlList']

@pulumi.input_type
class AccessControlListArgs:
    def __init__(__self__, *,
                 access_control_list_name: pulumi.Input[_builtins.str],
                 acl_entrys: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessControlList resource.
        :param pulumi.Input[_builtins.str] access_control_list_name: Access control list name.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]] acl_entrys: Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
               **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: ipv4 and ipv6.
        """
        pulumi.set(__self__, "access_control_list_name", access_control_list_name)
        if acl_entrys is not None:
            warnings.warn("""Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_entrys is deprecated: Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""")
        if acl_entrys is not None:
            pulumi.set(__self__, "acl_entrys", acl_entrys)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)

    @_builtins.property
    @pulumi.getter(name="accessControlListName")
    def access_control_list_name(self) -> pulumi.Input[_builtins.str]:
        """
        Access control list name.
        """
        return pulumi.get(self, "access_control_list_name")

    @access_control_list_name.setter
    def access_control_list_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_control_list_name", value)

    @_builtins.property
    @pulumi.getter(name="aclEntrys")
    @_utilities.deprecated("""Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""")
    def acl_entrys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]]:
        """
        Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
        **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        """
        return pulumi.get(self, "acl_entrys")

    @acl_entrys.setter
    def acl_entrys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]]):
        pulumi.set(self, "acl_entrys", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version. Valid values: ipv4 and ipv6.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)


@pulumi.input_type
class _AccessControlListState:
    def __init__(__self__, *,
                 access_control_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_entrys: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessControlList resources.
        :param pulumi.Input[_builtins.str] access_control_list_name: Access control list name.
        :param pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]] acl_entrys: Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
               **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: ipv4 and ipv6.
        """
        if access_control_list_name is not None:
            pulumi.set(__self__, "access_control_list_name", access_control_list_name)
        if acl_entrys is not None:
            warnings.warn("""Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_entrys is deprecated: Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""")
        if acl_entrys is not None:
            pulumi.set(__self__, "acl_entrys", acl_entrys)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)

    @_builtins.property
    @pulumi.getter(name="accessControlListName")
    def access_control_list_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control list name.
        """
        return pulumi.get(self, "access_control_list_name")

    @access_control_list_name.setter
    def access_control_list_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_control_list_name", value)

    @_builtins.property
    @pulumi.getter(name="aclEntrys")
    @_utilities.deprecated("""Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""")
    def acl_entrys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]]:
        """
        Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
        **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        """
        return pulumi.get(self, "acl_entrys")

    @acl_entrys.setter
    def acl_entrys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessControlListAclEntryArgs']]]]):
        pulumi.set(self, "acl_entrys", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version. Valid values: ipv4 and ipv6.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)


@pulumi.type_token("alicloud:apigateway/accessControlList:AccessControlList")
class AccessControlList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_entrys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlListAclEntryArgs', 'AccessControlListAclEntryArgsDict']]]]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Api Gateway Access Control List resource. Access control list.

        For information about Api Gateway Access Control List and how to use it, see [What is Access Control List](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createaccesscontrollist).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaultxyw_s8c = alicloud.apigateway.Instance("defaultxywS8c",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6",
            payment_type="PayAsYouGo")
        default = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        ```

        ## Import

        Api Gateway Access Control List can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/accessControlList:AccessControlList example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_control_list_name: Access control list name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlListAclEntryArgs', 'AccessControlListAclEntryArgsDict']]]] acl_entrys: Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
               **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: ipv4 and ipv6.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessControlListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Api Gateway Access Control List resource. Access control list.

        For information about Api Gateway Access Control List and how to use it, see [What is Access Control List](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createaccesscontrollist).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaultxyw_s8c = alicloud.apigateway.Instance("defaultxywS8c",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6",
            payment_type="PayAsYouGo")
        default = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        ```

        ## Import

        Api Gateway Access Control List can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/accessControlList:AccessControlList example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessControlListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessControlListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_entrys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlListAclEntryArgs', 'AccessControlListAclEntryArgsDict']]]]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessControlListArgs.__new__(AccessControlListArgs)

            if access_control_list_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_control_list_name'")
            __props__.__dict__["access_control_list_name"] = access_control_list_name
            __props__.__dict__["acl_entrys"] = None if acl_entrys is None else pulumi.Output.secret(acl_entrys)
            __props__.__dict__["address_ip_version"] = address_ip_version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["aclEntrys"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AccessControlList, __self__).__init__(
            'alicloud:apigateway/accessControlList:AccessControlList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_list_name: Optional[pulumi.Input[_builtins.str]] = None,
            acl_entrys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessControlListAclEntryArgs', 'AccessControlListAclEntryArgsDict']]]]] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessControlList':
        """
        Get an existing AccessControlList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_control_list_name: Access control list name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessControlListAclEntryArgs', 'AccessControlListAclEntryArgsDict']]]] acl_entrys: Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
               **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: ipv4 and ipv6.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessControlListState.__new__(_AccessControlListState)

        __props__.__dict__["access_control_list_name"] = access_control_list_name
        __props__.__dict__["acl_entrys"] = acl_entrys
        __props__.__dict__["address_ip_version"] = address_ip_version
        return AccessControlList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControlListName")
    def access_control_list_name(self) -> pulumi.Output[_builtins.str]:
        """
        Access control list name.
        """
        return pulumi.get(self, "access_control_list_name")

    @_builtins.property
    @pulumi.getter(name="aclEntrys")
    @_utilities.deprecated("""Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.""")
    def acl_entrys(self) -> pulumi.Output[Sequence['outputs.AccessControlListAclEntry']]:
        """
        Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
        **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
        """
        return pulumi.get(self, "acl_entrys")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version. Valid values: ipv4 and ipv6.
        """
        return pulumi.get(self, "address_ip_version")

