# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApisResult',
    'AwaitableGetApisResult',
    'get_apis',
    'get_apis_output',
]

@pulumi.output_type
class GetApisResult:
    """
    A collection of values returned by getApis.
    """
    def __init__(__self__, api_id=None, apis=None, group_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if apis and not isinstance(apis, list):
            raise TypeError("Expected argument 'apis' to be a list")
        pulumi.set(__self__, "apis", apis)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[_builtins.str]:
        """
        (Available since v1.224.0) The ID of the API.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter
    def apis(self) -> Sequence['outputs.GetApisApiResult']:
        """
        A list of APIs. Each element contains the following attributes:
        """
        return pulumi.get(self, "apis")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the API group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of API names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetApisResult(GetApisResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApisResult(
            api_id=self.api_id,
            apis=self.apis,
            group_id=self.group_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_apis(api_id: Optional[_builtins.str] = None,
             group_id: Optional[_builtins.str] = None,
             ids: Optional[Sequence[_builtins.str]] = None,
             name_regex: Optional[_builtins.str] = None,
             output_file: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApisResult:
    """
    This data source provides the Api Gateway APIs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.22.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.apigateway.Group("default",
        name=name,
        description=name)
    default_api = alicloud.apigateway.Api("default",
        group_id=default.id,
        name=name,
        description=name,
        auth_type="APP",
        service_type="HTTP",
        request_config={
            "protocol": "HTTP",
            "method": "GET",
            "path": "/test/path",
            "mode": "MAPPING",
        },
        http_service_config={
            "address": "http://apigateway-backend.alicloudapi.com:8080",
            "method": "GET",
            "path": "/web/cloudapi",
            "timeout": 20,
            "aone_name": "cloudapi-openapi",
        },
        request_parameters=[{
            "name": name,
            "type": "STRING",
            "required": "OPTIONAL",
            "in_": "QUERY",
            "in_service": "QUERY",
            "name_service": name,
        }])
    ids = alicloud.apigateway.get_apis_output(ids=[default_api.id])
    pulumi.export("apiGatewayApisId0", ids.apis[0].id)
    ```


    :param _builtins.str api_id: The ID of the API.
    :param _builtins.str group_id: The ID of the API group.
    :param Sequence[_builtins.str] ids: A list of API IDs.
    :param _builtins.str name_regex: A regex string to filter results by API name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['groupId'] = group_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:apigateway/getApis:getApis', __args__, opts=opts, typ=GetApisResult).value

    return AwaitableGetApisResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        apis=pulumi.get(__ret__, 'apis'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_apis_output(api_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApisResult]:
    """
    This data source provides the Api Gateway APIs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.22.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.apigateway.Group("default",
        name=name,
        description=name)
    default_api = alicloud.apigateway.Api("default",
        group_id=default.id,
        name=name,
        description=name,
        auth_type="APP",
        service_type="HTTP",
        request_config={
            "protocol": "HTTP",
            "method": "GET",
            "path": "/test/path",
            "mode": "MAPPING",
        },
        http_service_config={
            "address": "http://apigateway-backend.alicloudapi.com:8080",
            "method": "GET",
            "path": "/web/cloudapi",
            "timeout": 20,
            "aone_name": "cloudapi-openapi",
        },
        request_parameters=[{
            "name": name,
            "type": "STRING",
            "required": "OPTIONAL",
            "in_": "QUERY",
            "in_service": "QUERY",
            "name_service": name,
        }])
    ids = alicloud.apigateway.get_apis_output(ids=[default_api.id])
    pulumi.export("apiGatewayApisId0", ids.apis[0].id)
    ```


    :param _builtins.str api_id: The ID of the API.
    :param _builtins.str group_id: The ID of the API group.
    :param Sequence[_builtins.str] ids: A list of API IDs.
    :param _builtins.str name_regex: A regex string to filter results by API name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['groupId'] = group_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:apigateway/getApis:getApis', __args__, opts=opts, typ=GetApisResult)
    return __ret__.apply(lambda __response__: GetApisResult(
        api_id=pulumi.get(__response__, 'api_id'),
        apis=pulumi.get(__response__, 'apis'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
