# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceAclAttachmentArgs', 'InstanceAclAttachment']

@pulumi.input_type
class InstanceAclAttachmentArgs:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[_builtins.str],
                 acl_type: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a InstanceAclAttachment resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL to attach.
        :param pulumi.Input[_builtins.str] acl_type: The type of the ACL. Valid values: `white`, `black`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the API Gateway instance that the ACL will be attached to.
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "acl_type", acl_type)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ACL to attach.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the ACL. Valid values: `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the API Gateway instance that the ACL will be attached to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _InstanceAclAttachmentState:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceAclAttachment resources.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL to attach.
        :param pulumi.Input[_builtins.str] acl_type: The type of the ACL. Valid values: `white`, `black`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the API Gateway instance that the ACL will be attached to.
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ACL to attach.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ACL. Valid values: `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API Gateway instance that the ACL will be attached to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)


@pulumi.type_token("alicloud:apigateway/instanceAclAttachment:InstanceAclAttachment")
class InstanceAclAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Instance ACL attachment resource for attaching an ACL to a specific API Gateway instance.

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.Instance("default",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6",
            payment_type="PayAsYouGo",
            instance_type="normal")
        default_access_control_list = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        default_acl_entry_attachment = alicloud.apigateway.AclEntryAttachment("default",
            acl_id=default_access_control_list.id,
            entry="128.0.0.1/32",
            comment="test comment")
        default_instance_acl_attachment = alicloud.apigateway.InstanceAclAttachment("default",
            instance_id=default.id,
            acl_id=default_access_control_list.id,
            acl_type="white")
        ```

        ## Import

        Api Gateway Instance Acl Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/instanceAclAttachment:InstanceAclAttachment example <instance_id>:<acl_id>:<acl_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL to attach.
        :param pulumi.Input[_builtins.str] acl_type: The type of the ACL. Valid values: `white`, `black`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the API Gateway instance that the ACL will be attached to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceAclAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Instance ACL attachment resource for attaching an ACL to a specific API Gateway instance.

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.Instance("default",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6",
            payment_type="PayAsYouGo",
            instance_type="normal")
        default_access_control_list = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        default_acl_entry_attachment = alicloud.apigateway.AclEntryAttachment("default",
            acl_id=default_access_control_list.id,
            entry="128.0.0.1/32",
            comment="test comment")
        default_instance_acl_attachment = alicloud.apigateway.InstanceAclAttachment("default",
            instance_id=default.id,
            acl_id=default_access_control_list.id,
            acl_type="white")
        ```

        ## Import

        Api Gateway Instance Acl Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/instanceAclAttachment:InstanceAclAttachment example <instance_id>:<acl_id>:<acl_type>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceAclAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceAclAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceAclAttachmentArgs.__new__(InstanceAclAttachmentArgs)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            if acl_type is None and not opts.urn:
                raise TypeError("Missing required property 'acl_type'")
            __props__.__dict__["acl_type"] = acl_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(InstanceAclAttachment, __self__).__init__(
            'alicloud:apigateway/instanceAclAttachment:InstanceAclAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[_builtins.str]] = None,
            acl_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceAclAttachment':
        """
        Get an existing InstanceAclAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL to attach.
        :param pulumi.Input[_builtins.str] acl_type: The type of the ACL. Valid values: `white`, `black`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the API Gateway instance that the ACL will be attached to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceAclAttachmentState.__new__(_InstanceAclAttachmentState)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["acl_type"] = acl_type
        __props__.__dict__["instance_id"] = instance_id
        return InstanceAclAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ACL to attach.
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the ACL. Valid values: `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the API Gateway instance that the ACL will be attached to.
        """
        return pulumi.get(self, "instance_id")

