# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AddonReleaseArgs', 'AddonRelease']

@pulumi.input_type
class AddonReleaseArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[_builtins.str],
                 addon_version: pulumi.Input[_builtins.str],
                 environment_id: pulumi.Input[_builtins.str],
                 addon_release_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AddonRelease resource.
        :param pulumi.Input[_builtins.str] addon_name: Addon Name.
        :param pulumi.Input[_builtins.str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] addon_release_name: The name of the resource.
        :param pulumi.Input[_builtins.str] aliyun_lang: The installed locale.
        :param pulumi.Input[_builtins.str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "addon_version", addon_version)
        pulumi.set(__self__, "environment_id", environment_id)
        if addon_release_name is not None:
            pulumi.set(__self__, "addon_release_name", addon_release_name)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[_builtins.str]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "addon_version", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @addon_release_name.setter
    def addon_release_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_release_name", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _AddonReleaseState:
    def __init__(__self__, *,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_release_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddonRelease resources.
        :param pulumi.Input[_builtins.str] addon_name: Addon Name.
        :param pulumi.Input[_builtins.str] addon_release_name: The name of the resource.
        :param pulumi.Input[_builtins.str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[_builtins.str] aliyun_lang: The installed locale.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        if addon_name is not None:
            pulumi.set(__self__, "addon_name", addon_name)
        if addon_release_name is not None:
            pulumi.set(__self__, "addon_release_name", addon_release_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_name", value)

    @_builtins.property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @addon_release_name.setter
    def addon_release_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_release_name", value)

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "addon_version", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("alicloud:arms/addonRelease:AddonRelease")
class AddonRelease(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_release_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ARMS Addon Release resource. Release package of observability addon.

        For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.sn1ne"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_addon_release = alicloud.arms.AddonRelease("default",
            aliyun_lang="zh",
            addon_name="mysql",
            environment_id=default_environment.id,
            addon_version="0.0.1",
            values=json.dumps({
                "host": "mysql-service.default",
                "password": "roots",
                "port": 3306,
                "username": "root",
            }))
        ```

        ## Import

        ARMS Addon Release can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_name: Addon Name.
        :param pulumi.Input[_builtins.str] addon_release_name: The name of the resource.
        :param pulumi.Input[_builtins.str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[_builtins.str] aliyun_lang: The installed locale.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Addon Release resource. Release package of observability addon.

        For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.sn1ne"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_addon_release = alicloud.arms.AddonRelease("default",
            aliyun_lang="zh",
            addon_name="mysql",
            environment_id=default_environment.id,
            addon_version="0.0.1",
            values=json.dumps({
                "host": "mysql-service.default",
                "password": "roots",
                "port": 3306,
                "username": "root",
            }))
        ```

        ## Import

        ARMS Addon Release can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
        ```

        :param str resource_name: The name of the resource.
        :param AddonReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_release_name: Optional[pulumi.Input[_builtins.str]] = None,
                 addon_version: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonReleaseArgs.__new__(AddonReleaseArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            __props__.__dict__["addon_release_name"] = addon_release_name
            if addon_version is None and not opts.urn:
                raise TypeError("Missing required property 'addon_version'")
            __props__.__dict__["addon_version"] = addon_version
            __props__.__dict__["aliyun_lang"] = aliyun_lang
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["values"] = values
            __props__.__dict__["create_time"] = None
        super(AddonRelease, __self__).__init__(
            'alicloud:arms/addonRelease:AddonRelease',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_name: Optional[pulumi.Input[_builtins.str]] = None,
            addon_release_name: Optional[pulumi.Input[_builtins.str]] = None,
            addon_version: Optional[pulumi.Input[_builtins.str]] = None,
            aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddonRelease':
        """
        Get an existing AddonRelease resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] addon_name: Addon Name.
        :param pulumi.Input[_builtins.str] addon_release_name: The name of the resource.
        :param pulumi.Input[_builtins.str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[_builtins.str] aliyun_lang: The installed locale.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonReleaseState.__new__(_AddonReleaseState)

        __props__.__dict__["addon_name"] = addon_name
        __props__.__dict__["addon_release_name"] = addon_release_name
        __props__.__dict__["addon_version"] = addon_version
        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["values"] = values
        return AddonRelease(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[_builtins.str]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @_builtins.property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @_builtins.property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[_builtins.str]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

