# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvCustomJobArgs', 'EnvCustomJob']

@pulumi.input_type
class EnvCustomJobArgs:
    def __init__(__self__, *,
                 config_yaml: pulumi.Input[_builtins.str],
                 env_custom_job_name: pulumi.Input[_builtins.str],
                 environment_id: pulumi.Input[_builtins.str],
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvCustomJob resource.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_custom_job_name: Custom job name.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] aliyun_lang: The locale. The default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        pulumi.set(__self__, "config_yaml", config_yaml)
        pulumi.set(__self__, "env_custom_job_name", env_custom_job_name)
        pulumi.set(__self__, "environment_id", environment_id)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Input[_builtins.str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_yaml", value)

    @_builtins.property
    @pulumi.getter(name="envCustomJobName")
    def env_custom_job_name(self) -> pulumi.Input[_builtins.str]:
        """
        Custom job name.
        """
        return pulumi.get(self, "env_custom_job_name")

    @env_custom_job_name.setter
    def env_custom_job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_custom_job_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locale. The default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _EnvCustomJobState:
    def __init__(__self__, *,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 env_custom_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvCustomJob resources.
        :param pulumi.Input[_builtins.str] aliyun_lang: The locale. The default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_custom_job_name: Custom job name.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if config_yaml is not None:
            pulumi.set(__self__, "config_yaml", config_yaml)
        if env_custom_job_name is not None:
            pulumi.set(__self__, "env_custom_job_name", env_custom_job_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locale. The default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_yaml", value)

    @_builtins.property
    @pulumi.getter(name="envCustomJobName")
    def env_custom_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom job name.
        """
        return pulumi.get(self, "env_custom_job_name")

    @env_custom_job_name.setter
    def env_custom_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_custom_job_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:arms/envCustomJob:EnvCustomJob")
class EnvCustomJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 env_custom_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ARMS Env Custom Job resource. Custom jobs in the arms environment.

        For information about ARMS Env Custom Job and how to use it, see [What is Env Custom Job](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvcustomjob).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        env_ecs = alicloud.arms.Environment("env-ecs",
            environment_type="ECS",
            environment_name=f"terraform-example-{default['result']}",
            bind_resource_id=vpc.id,
            environment_sub_type="ECS")
        default_env_custom_job = alicloud.arms.EnvCustomJob("default",
            status="run",
            environment_id=env_ecs.id,
            env_custom_job_name=name,
            config_yaml=\"\"\"scrape_configs:
        - job_name: job-demo1
          honor_timestamps: false
          honor_labels: false
          scrape_interval: 30s
          scheme: http
          metrics_path: /metric
          static_configs:
          - targets:
            - 127.0.0.1:9090
        \"\"\",
            aliyun_lang="en")
        ```

        ## Import

        ARMS Env Custom Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envCustomJob:EnvCustomJob example <environment_id>:<env_custom_job_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aliyun_lang: The locale. The default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_custom_job_name: Custom job name.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvCustomJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Env Custom Job resource. Custom jobs in the arms environment.

        For information about ARMS Env Custom Job and how to use it, see [What is Env Custom Job](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvcustomjob).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        env_ecs = alicloud.arms.Environment("env-ecs",
            environment_type="ECS",
            environment_name=f"terraform-example-{default['result']}",
            bind_resource_id=vpc.id,
            environment_sub_type="ECS")
        default_env_custom_job = alicloud.arms.EnvCustomJob("default",
            status="run",
            environment_id=env_ecs.id,
            env_custom_job_name=name,
            config_yaml=\"\"\"scrape_configs:
        - job_name: job-demo1
          honor_timestamps: false
          honor_labels: false
          scrape_interval: 30s
          scheme: http
          metrics_path: /metric
          static_configs:
          - targets:
            - 127.0.0.1:9090
        \"\"\",
            aliyun_lang="en")
        ```

        ## Import

        ARMS Env Custom Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envCustomJob:EnvCustomJob example <environment_id>:<env_custom_job_name>
        ```

        :param str resource_name: The name of the resource.
        :param EnvCustomJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvCustomJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 env_custom_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvCustomJobArgs.__new__(EnvCustomJobArgs)

            __props__.__dict__["aliyun_lang"] = aliyun_lang
            if config_yaml is None and not opts.urn:
                raise TypeError("Missing required property 'config_yaml'")
            __props__.__dict__["config_yaml"] = config_yaml
            if env_custom_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'env_custom_job_name'")
            __props__.__dict__["env_custom_job_name"] = env_custom_job_name
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["status"] = status
        super(EnvCustomJob, __self__).__init__(
            'alicloud:arms/envCustomJob:EnvCustomJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
            config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
            env_custom_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvCustomJob':
        """
        Get an existing EnvCustomJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aliyun_lang: The locale. The default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_custom_job_name: Custom job name.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvCustomJobState.__new__(_EnvCustomJobState)

        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["config_yaml"] = config_yaml
        __props__.__dict__["env_custom_job_name"] = env_custom_job_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["status"] = status
        return EnvCustomJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The locale. The default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Output[_builtins.str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @_builtins.property
    @pulumi.getter(name="envCustomJobName")
    def env_custom_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom job name.
        """
        return pulumi.get(self, "env_custom_job_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

