# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvServiceMonitorArgs', 'EnvServiceMonitor']

@pulumi.input_type
class EnvServiceMonitorArgs:
    def __init__(__self__, *,
                 config_yaml: pulumi.Input[_builtins.str],
                 environment_id: pulumi.Input[_builtins.str],
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvServiceMonitor resource.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment, default is Chinese zh | en.
        """
        pulumi.set(__self__, "config_yaml", config_yaml)
        pulumi.set(__self__, "environment_id", environment_id)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Input[_builtins.str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_yaml", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)


@pulumi.input_type
class _EnvServiceMonitorState:
    def __init__(__self__, *,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 env_service_monitor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvServiceMonitor resources.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_service_monitor_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] namespace: The namespace where the resource is located.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if config_yaml is not None:
            pulumi.set(__self__, "config_yaml", config_yaml)
        if env_service_monitor_name is not None:
            pulumi.set(__self__, "env_service_monitor_name", env_service_monitor_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_yaml", value)

    @_builtins.property
    @pulumi.getter(name="envServiceMonitorName")
    def env_service_monitor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_service_monitor_name")

    @env_service_monitor_name.setter
    def env_service_monitor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_service_monitor_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace where the resource is located.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:arms/envServiceMonitor:EnvServiceMonitor")
class EnvServiceMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.

        For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.n1"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_env_service_monitor = alicloud.arms.EnvServiceMonitor("default",
            environment_id=default_environment.id,
            config_yaml=\"\"\"apiVersion: monitoring.coreos.com/v1
        kind: ServiceMonitor
        metadata:
          name: arms-admin1
          namespace: arms-prom
          annotations:
            arms.prometheus.io/discovery: 'true'
            o11y.aliyun.com/addon-name: mysql
            o11y.aliyun.com/addon-version: 1.0.1
            o11y.aliyun.com/release-name: mysql1
        spec:
          endpoints:
          - interval: 30s
            port: operator
            path: /metrics
          - interval: 10s
            port: operator1
            path: /metrics
          namespaceSelector:
            any: true
          selector:
            matchLabels:
             app: arms-prometheus-ack-arms-prometheus
        \"\"\",
            aliyun_lang="zh")
        ```

        ## Import

        ARMS Env Service Monitor can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvServiceMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.

        For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.n1"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_env_service_monitor = alicloud.arms.EnvServiceMonitor("default",
            environment_id=default_environment.id,
            config_yaml=\"\"\"apiVersion: monitoring.coreos.com/v1
        kind: ServiceMonitor
        metadata:
          name: arms-admin1
          namespace: arms-prom
          annotations:
            arms.prometheus.io/discovery: 'true'
            o11y.aliyun.com/addon-name: mysql
            o11y.aliyun.com/addon-version: 1.0.1
            o11y.aliyun.com/release-name: mysql1
        spec:
          endpoints:
          - interval: 30s
            port: operator
            path: /metrics
          - interval: 10s
            port: operator1
            path: /metrics
          namespaceSelector:
            any: true
          selector:
            matchLabels:
             app: arms-prometheus-ack-arms-prometheus
        \"\"\",
            aliyun_lang="zh")
        ```

        ## Import

        ARMS Env Service Monitor can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
        ```

        :param str resource_name: The name of the resource.
        :param EnvServiceMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvServiceMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvServiceMonitorArgs.__new__(EnvServiceMonitorArgs)

            __props__.__dict__["aliyun_lang"] = aliyun_lang
            if config_yaml is None and not opts.urn:
                raise TypeError("Missing required property 'config_yaml'")
            __props__.__dict__["config_yaml"] = config_yaml
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["env_service_monitor_name"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["status"] = None
        super(EnvServiceMonitor, __self__).__init__(
            'alicloud:arms/envServiceMonitor:EnvServiceMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
            config_yaml: Optional[pulumi.Input[_builtins.str]] = None,
            env_service_monitor_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvServiceMonitor':
        """
        Get an existing EnvServiceMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[_builtins.str] config_yaml: Yaml configuration string.
        :param pulumi.Input[_builtins.str] env_service_monitor_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: Environment id.
        :param pulumi.Input[_builtins.str] namespace: The namespace where the resource is located.
        :param pulumi.Input[_builtins.str] status: Status: run, stop.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvServiceMonitorState.__new__(_EnvServiceMonitorState)

        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["config_yaml"] = config_yaml
        __props__.__dict__["env_service_monitor_name"] = env_service_monitor_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["status"] = status
        return EnvServiceMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @_builtins.property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Output[_builtins.str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @_builtins.property
    @pulumi.getter(name="envServiceMonitorName")
    def env_service_monitor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_service_monitor_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace where the resource is located.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

