# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostShareKeyArgs', 'HostShareKey']

@pulumi.input_type
class HostShareKeyArgs:
    def __init__(__self__, *,
                 host_share_key_name: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 pass_phrase: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HostShareKey resource.
        :param pulumi.Input[_builtins.str] host_share_key_name: The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastion instance.
        :param pulumi.Input[_builtins.str] private_key: The private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] pass_phrase: The password of the private key. The value is a Base64-encoded string.
        """
        pulumi.set(__self__, "host_share_key_name", host_share_key_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "private_key", private_key)
        if pass_phrase is not None:
            pulumi.set(__self__, "pass_phrase", pass_phrase)

    @_builtins.property
    @pulumi.getter(name="hostShareKeyName")
    def host_share_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        """
        return pulumi.get(self, "host_share_key_name")

    @host_share_key_name.setter
    def host_share_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_share_key_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Bastion instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="passPhrase")
    def pass_phrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "pass_phrase")

    @pass_phrase.setter
    def pass_phrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pass_phrase", value)


@pulumi.input_type
class _HostShareKeyState:
    def __init__(__self__, *,
                 host_share_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_share_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pass_phrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_finger_print: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostShareKey resources.
        :param pulumi.Input[_builtins.str] host_share_key_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] host_share_key_name: The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastion instance.
        :param pulumi.Input[_builtins.str] pass_phrase: The password of the private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] private_key: The private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] private_key_finger_print: The fingerprint of the private key.
        """
        if host_share_key_id is not None:
            pulumi.set(__self__, "host_share_key_id", host_share_key_id)
        if host_share_key_name is not None:
            pulumi.set(__self__, "host_share_key_name", host_share_key_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if pass_phrase is not None:
            pulumi.set(__self__, "pass_phrase", pass_phrase)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_finger_print is not None:
            pulumi.set(__self__, "private_key_finger_print", private_key_finger_print)

    @_builtins.property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "host_share_key_id")

    @host_share_key_id.setter
    def host_share_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_share_key_id", value)

    @_builtins.property
    @pulumi.getter(name="hostShareKeyName")
    def host_share_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        """
        return pulumi.get(self, "host_share_key_name")

    @host_share_key_name.setter
    def host_share_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_share_key_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Bastion instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="passPhrase")
    def pass_phrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "pass_phrase")

    @pass_phrase.setter
    def pass_phrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pass_phrase", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFingerPrint")
    def private_key_finger_print(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint of the private key.
        """
        return pulumi.get(self, "private_key_finger_print")

    @private_key_finger_print.setter
    def private_key_finger_print(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_finger_print", value)


@pulumi.type_token("alicloud:bastionhost/hostShareKey:HostShareKey")
class HostShareKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_share_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pass_phrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Bastion Host Share Key resource.

        For information about Bastion Host Host Share Key and how to use it, see [What is Host Share Key](https://www.alibabacloud.com/help/en/bastion-host/latest/createhostsharekey).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.bastionhost.get_instances()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
            cidr_block="10.4.0.0/16")
        default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
            vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.zones[0].id)
        default_security_group = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}", vpc_id=default_get_networks.ids[0]))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        default_instance = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_instance.append(alicloud.bastionhost.Instance(f"default-{range['value']}",
                    description=name,
                    license_code="bhah_ent_50_asset",
                    plan_code="cloudbastion",
                    storage="5",
                    bandwidth="5",
                    period=1,
                    vswitch_id=default_get_switches.ids[0],
                    security_group_ids=[default_security_group[0].id.apply(lambda id: id)]))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        instance_id = pulumi.Output.all(
            length=len(default.ids),
            id=default_instance[0].id
        ).apply(lambda resolved_outputs: default.ids[0] if resolved_outputs['length'] > 0 else resolved_outputs['id'])

        private_key = config.get("privateKey")
        if private_key is None:
            private_key = "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"
        default_host_share_key = alicloud.bastionhost.HostShareKey("default",
            host_share_key_name=name,
            instance_id=instance_id,
            private_key=private_key)
        ```

        ## Import

        Bastion Host Share Key can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/hostShareKey:HostShareKey example <instance_id>:<host_share_key_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] host_share_key_name: The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastion instance.
        :param pulumi.Input[_builtins.str] pass_phrase: The password of the private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] private_key: The private key. The value is a Base64-encoded string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostShareKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Bastion Host Share Key resource.

        For information about Bastion Host Host Share Key and how to use it, see [What is Host Share Key](https://www.alibabacloud.com/help/en/bastion-host/latest/createhostsharekey).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.bastionhost.get_instances()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
            cidr_block="10.4.0.0/16")
        default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
            vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.zones[0].id)
        default_security_group = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}", vpc_id=default_get_networks.ids[0]))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        default_instance = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_instance.append(alicloud.bastionhost.Instance(f"default-{range['value']}",
                    description=name,
                    license_code="bhah_ent_50_asset",
                    plan_code="cloudbastion",
                    storage="5",
                    bandwidth="5",
                    period=1,
                    vswitch_id=default_get_switches.ids[0],
                    security_group_ids=[default_security_group[0].id.apply(lambda id: id)]))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        instance_id = pulumi.Output.all(
            length=len(default.ids),
            id=default_instance[0].id
        ).apply(lambda resolved_outputs: default.ids[0] if resolved_outputs['length'] > 0 else resolved_outputs['id'])

        private_key = config.get("privateKey")
        if private_key is None:
            private_key = "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"
        default_host_share_key = alicloud.bastionhost.HostShareKey("default",
            host_share_key_name=name,
            instance_id=instance_id,
            private_key=private_key)
        ```

        ## Import

        Bastion Host Share Key can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/hostShareKey:HostShareKey example <instance_id>:<host_share_key_id>
        ```

        :param str resource_name: The name of the resource.
        :param HostShareKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostShareKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_share_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pass_phrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostShareKeyArgs.__new__(HostShareKeyArgs)

            if host_share_key_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_share_key_name'")
            __props__.__dict__["host_share_key_name"] = host_share_key_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["pass_phrase"] = None if pass_phrase is None else pulumi.Output.secret(pass_phrase)
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["host_share_key_id"] = None
            __props__.__dict__["private_key_finger_print"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passPhrase", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(HostShareKey, __self__).__init__(
            'alicloud:bastionhost/hostShareKey:HostShareKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host_share_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_share_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            pass_phrase: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_finger_print: Optional[pulumi.Input[_builtins.str]] = None) -> 'HostShareKey':
        """
        Get an existing HostShareKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] host_share_key_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] host_share_key_name: The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastion instance.
        :param pulumi.Input[_builtins.str] pass_phrase: The password of the private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] private_key: The private key. The value is a Base64-encoded string.
        :param pulumi.Input[_builtins.str] private_key_finger_print: The fingerprint of the private key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostShareKeyState.__new__(_HostShareKeyState)

        __props__.__dict__["host_share_key_id"] = host_share_key_id
        __props__.__dict__["host_share_key_name"] = host_share_key_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["pass_phrase"] = pass_phrase
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_finger_print"] = private_key_finger_print
        return HostShareKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "host_share_key_id")

    @_builtins.property
    @pulumi.getter(name="hostShareKeyName")
    def host_share_key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the host shared key to be added. The name can be a maximum of 128 characters in length.
        """
        return pulumi.get(self, "host_share_key_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Bastion instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="passPhrase")
    def pass_phrase(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "pass_phrase")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key. The value is a Base64-encoded string.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyFingerPrint")
    def private_key_finger_print(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint of the private key.
        """
        return pulumi.get(self, "private_key_finger_print")

