# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceCertificateArgs', 'ServiceCertificate']

@pulumi.input_type
class ServiceCertificateArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServiceCertificate resource.
        :param pulumi.Input[_builtins.str] cert: The content of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_name: A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        :param pulumi.Input[_builtins.str] encrypt_cert: The content of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] encrypt_private_key: The private key of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] key: The private key of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] lang: Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] sign_cert: The content of an SM signing certificate in PEM format.
        :param pulumi.Input[_builtins.str] sign_private_key: The private key of an SM signing certificate in PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if encrypt_cert is not None:
            pulumi.set(__self__, "encrypt_cert", encrypt_cert)
        if encrypt_private_key is not None:
            pulumi.set(__self__, "encrypt_private_key", encrypt_private_key)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lang is not None:
            warnings.warn("""Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""", DeprecationWarning)
            pulumi.log.warn("""lang is deprecated: Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""")
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sign_cert is not None:
            pulumi.set(__self__, "sign_cert", sign_cert)
        if sign_private_key is not None:
            pulumi.set(__self__, "sign_private_key", sign_private_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptCert")
    def encrypt_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_cert")

    @encrypt_cert.setter
    def encrypt_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_cert", value)

    @_builtins.property
    @pulumi.getter(name="encryptPrivateKey")
    def encrypt_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_private_key")

    @encrypt_private_key.setter
    def encrypt_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_private_key", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""")
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="signCert")
    def sign_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_cert")

    @sign_cert.setter
    def sign_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_cert", value)

    @_builtins.property
    @pulumi.getter(name="signPrivateKey")
    def sign_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_private_key")

    @sign_private_key.setter
    def sign_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_private_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceCertificateState:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ServiceCertificate resources.
        :param pulumi.Input[_builtins.str] cert: The content of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_name: A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        :param pulumi.Input[_builtins.str] encrypt_cert: The content of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] encrypt_private_key: The private key of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] key: The private key of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] lang: Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] sign_cert: The content of an SM signing certificate in PEM format.
        :param pulumi.Input[_builtins.str] sign_private_key: The private key of an SM signing certificate in PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if encrypt_cert is not None:
            pulumi.set(__self__, "encrypt_cert", encrypt_cert)
        if encrypt_private_key is not None:
            pulumi.set(__self__, "encrypt_private_key", encrypt_private_key)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lang is not None:
            warnings.warn("""Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""", DeprecationWarning)
            pulumi.log.warn("""lang is deprecated: Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""")
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sign_cert is not None:
            pulumi.set(__self__, "sign_cert", sign_cert)
        if sign_private_key is not None:
            pulumi.set(__self__, "sign_private_key", sign_private_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptCert")
    def encrypt_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_cert")

    @encrypt_cert.setter
    def encrypt_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_cert", value)

    @_builtins.property
    @pulumi.getter(name="encryptPrivateKey")
    def encrypt_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_private_key")

    @encrypt_private_key.setter
    def encrypt_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_private_key", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""")
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="signCert")
    def sign_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_cert")

    @sign_cert.setter
    def sign_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_cert", value)

    @_builtins.property
    @pulumi.getter(name="signPrivateKey")
    def sign_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_private_key")

    @sign_private_key.setter
    def sign_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_private_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:cas/serviceCertificate:ServiceCertificate")
class ServiceCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a SSL Certificates Certificate resource.

        For information about SSL Certificates Certificate and how to use it, see [What is Certificate](https://www.alibabacloud.com/help/product/28533.html).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_service_certificate = alicloud.cas.ServiceCertificate("default",
            certificate_name=f"terraform-example-{default['result']}",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIID1jCCAr6gAwIBAgIQQ7/8/QOOTbywxdgSX9aMqDANBgkqhkiG9w0BAQsFADBe
        MQswCQYDVQQGEwJDTjEOMAwGA1UEChMFTXlTU0wxKzApBgNVBAsTIk15U1NMIFRl
        c3QgUlNBIC0gRm9yIHRlc3QgdXNlIG9ubHkxEjAQBgNVBAMTCU15U1NMLmNvbTAe
        Fw0yNTA5MjIwNTU3NDVaFw0zMDA5MjEwNTU3NDVaMCAxCzAJBgNVBAYTAkNOMREw
        DwYDVQQDEwgxNjg4LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
        AMEl04gKBqJxV+8KideZb7S4mPysehPzr/cXu4i1RXT7UFtNVZuqc4IdIzOja2SU
        6uNn8mY6Pfc5FNybg98bYx0ADbub55TUaw2Pz1CFEbiMvLpzMkp4EZadvmJWZk8t
        dNb+ClKqdXUWhxApS3Lz+wjCNYQnlODk4KmxmM8/U/CyQS7lgWS/1G72UFB09Skg
        sfvWdoHLrFfIlbVkp9XVELCtOkjj8Nn/rPOhc31NbstrwV4Whl6jngGAkaEtImJ7
        //sL+sPPsutefCgfZPrC+Zwru2En1BuIo5KW02NYLdjXbABH8xjkUobqRoro7eY3
        VySBr7adD6QmNv5hWohOuykCAwEAAaOBzTCByjAOBgNVHQ8BAf8EBAMCBaAwHQYD
        VR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB8GA1UdIwQYMBaAFCiBJgXRNBo/
        wXMPu5PPFRw/A79/MGMGCCsGAQUFBwEBBFcwVTAhBggrBgEFBQcwAYYVaHR0cDov
        L29jc3AubXlzc2wuY29tMDAGCCsGAQUFBzAChiRodHRwOi8vY2EubXlzc2wuY29t
        L215c3NsdGVzdHJzYS5jcnQwEwYDVR0RBAwwCoIIMTY4OC5jb20wDQYJKoZIhvcN
        AQELBQADggEBAHa0ATVeHtPPw1+a6kajlW6OQUjhiJg+Sk9fVA1eJ2Hzl1yDDw3K
        yAyl1gkxGI6BwWdX/C8IE6PuPYcG2CmJGoFoEAAIbAE76AKABvHoA8I6wyDruxFz
        06bNM8104TxAHTxe2zaHgBQnYIRk07uA8gxjZKFp1//eYbxj8HiP0Q9zXqYjF79G
        Le4PDw7Q6U22CP+cT9Sz5ZEoJCzmUtx3uQWhLzNxvyISrXeSqAFJzjtL0KKSR1cr
        8he6FoeU37oKdmrnweLeBe+no3OMChETa2JN4VAzXj/nPpQcyB7nXDfLUHe01+BB
        ZBXKFLD2H38e97mFl/7mgNP5Nc1sycI5Sp4=
        -----END CERTIFICATE-----
        \"\"\",
            key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIEowIBAAKCAQEAwSXTiAoGonFX7wqJ15lvtLiY/Kx6E/Ov9xe7iLVFdPtQW01V
        m6pzgh0jM6NrZJTq42fyZjo99zkU3JuD3xtjHQANu5vnlNRrDY/PUIURuIy8unMy
        SngRlp2+YlZmTy101v4KUqp1dRaHEClLcvP7CMI1hCeU4OTgqbGYzz9T8LJBLuWB
        ZL/UbvZQUHT1KSCx+9Z2gcusV8iVtWSn1dUQsK06SOPw2f+s86FzfU1uy2vBXhaG
        XqOeAYCRoS0iYnv/+wv6w8+y6158KB9k+sL5nCu7YSfUG4ijkpbTY1gt2NdsAEfz
        GORShupGiujt5jdXJIGvtp0PpCY2/mFaiE67KQIDAQABAoIBAAKF9CZTUd8zvDKE
        azo/Ur0Zf5omxgOBC/vzj0DLyXKr89KgMdhHmPG1YBKFIIU0XYCHXkclR05LAcbu
        BdeCJpXS5zBbwDdAB9P/XHXQqeNvfJRc++ZgJ4QAXzkuqBssXK87ALcwFeUShxot
        cphiWpW0inlwVkVn3WLUzfUV0+ARljn8VOf+aAmfCiQMl4gsBpvD3dxF84aihS+1
        blqar5dE1GCJWHW67R1uSaAqHf7nwbBkZY8nTWF8n4+ELAAtlOgQKZlrQ+JxB3Ar
        rWzgMj4M6F1/man1y/XPR56px9Xv3DwBZHuLufsqPr10q/nI9VIIQHe49sFgnN4+
        48Q7wIECgYEAwxlrgBJI8gua4mJZxJRT8gBv2Mb1Kk1k7HVX11I+yF4eXr+cm+24
        Cq7MjqmBXSnqvdQkwGFZ+C3cTKXJBPONWGF8NgiXaHSKjPEoFuHLdKBpgZMAax/L
        aZBQRw6g12nz3XUCK0DE0wGgPkoDxc65s4NEWS+ua43LZ4TUOzWwwWECgYEA/XB1
        ARNHyARy+P3iTeebh3t7qJoNoptLWHMlKjSjIZ1VZ4+9ilKsi5ZKVkPaLIjo8MGv
        Ank3vzSrFSYhId0XfmSqoWySWc0eBkc6NERvopxuIV1WwRKf/18lLhxiEjHIcgds
        G2KmfeiXdCKSgGlWvJmLITY4gJpOYMjpEDxipskCgYAdxnljmGbNmfvPZRcyKzkM
        jAiF2wd7p0gp1lbLo9+1ELgt2ax7F7Ko3riVZUU7BLSwt/nL6o+iks02XW7qdIkz
        3dzpGjKRXIfwrrVhmKBGclzny5mav8V5nO7DiXX+qkrvl3X3R/FCCtN77ivZOo2Y
        2gXKXr6N55wNdnY1eyI4wQKBgQDXjZo2O+vFVuNimqyrjd1eMcxO7hfCwUooBGcL
        qpFEucg1uK+Awig24LCBBly9nARjIJh1Bhw/58/KwQ9U+fJNcdkeSnV/I1HyDQqY
        AczhBSM2BWkP9YNXc9jvivxudSECuwVblV/9nqGSCQWJag53gjAvIyqTVqpq7vYq
        9PEC4QKBgGY2pj0ZNqGkq16jD3iS+DDBpX+TPnoHzu5GZCM/1GLZ6xXbpNWtZQt4
        /m+6koRWeGvNAULnp8RSnhBzm+ZglpbwYcvsqRNDqIPGhJ2JruVA/bY3S0ebkRlD
        xDn0dJVMvNyRR83ZpjTQhxoq5l56TN5xk1vdJ9nZdwJMmXiz2TrA
        -----END PRIVATE KEY-----
        \"\"\")
        ```

        ## Import

        SSL Certificates Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cas/serviceCertificate:ServiceCertificate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: The content of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_name: A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        :param pulumi.Input[_builtins.str] encrypt_cert: The content of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] encrypt_private_key: The private key of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] key: The private key of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] lang: Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] sign_cert: The content of an SM signing certificate in PEM format.
        :param pulumi.Input[_builtins.str] sign_private_key: The private key of an SM signing certificate in PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceCertificateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SSL Certificates Certificate resource.

        For information about SSL Certificates Certificate and how to use it, see [What is Certificate](https://www.alibabacloud.com/help/product/28533.html).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_service_certificate = alicloud.cas.ServiceCertificate("default",
            certificate_name=f"terraform-example-{default['result']}",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIID1jCCAr6gAwIBAgIQQ7/8/QOOTbywxdgSX9aMqDANBgkqhkiG9w0BAQsFADBe
        MQswCQYDVQQGEwJDTjEOMAwGA1UEChMFTXlTU0wxKzApBgNVBAsTIk15U1NMIFRl
        c3QgUlNBIC0gRm9yIHRlc3QgdXNlIG9ubHkxEjAQBgNVBAMTCU15U1NMLmNvbTAe
        Fw0yNTA5MjIwNTU3NDVaFw0zMDA5MjEwNTU3NDVaMCAxCzAJBgNVBAYTAkNOMREw
        DwYDVQQDEwgxNjg4LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
        AMEl04gKBqJxV+8KideZb7S4mPysehPzr/cXu4i1RXT7UFtNVZuqc4IdIzOja2SU
        6uNn8mY6Pfc5FNybg98bYx0ADbub55TUaw2Pz1CFEbiMvLpzMkp4EZadvmJWZk8t
        dNb+ClKqdXUWhxApS3Lz+wjCNYQnlODk4KmxmM8/U/CyQS7lgWS/1G72UFB09Skg
        sfvWdoHLrFfIlbVkp9XVELCtOkjj8Nn/rPOhc31NbstrwV4Whl6jngGAkaEtImJ7
        //sL+sPPsutefCgfZPrC+Zwru2En1BuIo5KW02NYLdjXbABH8xjkUobqRoro7eY3
        VySBr7adD6QmNv5hWohOuykCAwEAAaOBzTCByjAOBgNVHQ8BAf8EBAMCBaAwHQYD
        VR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB8GA1UdIwQYMBaAFCiBJgXRNBo/
        wXMPu5PPFRw/A79/MGMGCCsGAQUFBwEBBFcwVTAhBggrBgEFBQcwAYYVaHR0cDov
        L29jc3AubXlzc2wuY29tMDAGCCsGAQUFBzAChiRodHRwOi8vY2EubXlzc2wuY29t
        L215c3NsdGVzdHJzYS5jcnQwEwYDVR0RBAwwCoIIMTY4OC5jb20wDQYJKoZIhvcN
        AQELBQADggEBAHa0ATVeHtPPw1+a6kajlW6OQUjhiJg+Sk9fVA1eJ2Hzl1yDDw3K
        yAyl1gkxGI6BwWdX/C8IE6PuPYcG2CmJGoFoEAAIbAE76AKABvHoA8I6wyDruxFz
        06bNM8104TxAHTxe2zaHgBQnYIRk07uA8gxjZKFp1//eYbxj8HiP0Q9zXqYjF79G
        Le4PDw7Q6U22CP+cT9Sz5ZEoJCzmUtx3uQWhLzNxvyISrXeSqAFJzjtL0KKSR1cr
        8he6FoeU37oKdmrnweLeBe+no3OMChETa2JN4VAzXj/nPpQcyB7nXDfLUHe01+BB
        ZBXKFLD2H38e97mFl/7mgNP5Nc1sycI5Sp4=
        -----END CERTIFICATE-----
        \"\"\",
            key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIEowIBAAKCAQEAwSXTiAoGonFX7wqJ15lvtLiY/Kx6E/Ov9xe7iLVFdPtQW01V
        m6pzgh0jM6NrZJTq42fyZjo99zkU3JuD3xtjHQANu5vnlNRrDY/PUIURuIy8unMy
        SngRlp2+YlZmTy101v4KUqp1dRaHEClLcvP7CMI1hCeU4OTgqbGYzz9T8LJBLuWB
        ZL/UbvZQUHT1KSCx+9Z2gcusV8iVtWSn1dUQsK06SOPw2f+s86FzfU1uy2vBXhaG
        XqOeAYCRoS0iYnv/+wv6w8+y6158KB9k+sL5nCu7YSfUG4ijkpbTY1gt2NdsAEfz
        GORShupGiujt5jdXJIGvtp0PpCY2/mFaiE67KQIDAQABAoIBAAKF9CZTUd8zvDKE
        azo/Ur0Zf5omxgOBC/vzj0DLyXKr89KgMdhHmPG1YBKFIIU0XYCHXkclR05LAcbu
        BdeCJpXS5zBbwDdAB9P/XHXQqeNvfJRc++ZgJ4QAXzkuqBssXK87ALcwFeUShxot
        cphiWpW0inlwVkVn3WLUzfUV0+ARljn8VOf+aAmfCiQMl4gsBpvD3dxF84aihS+1
        blqar5dE1GCJWHW67R1uSaAqHf7nwbBkZY8nTWF8n4+ELAAtlOgQKZlrQ+JxB3Ar
        rWzgMj4M6F1/man1y/XPR56px9Xv3DwBZHuLufsqPr10q/nI9VIIQHe49sFgnN4+
        48Q7wIECgYEAwxlrgBJI8gua4mJZxJRT8gBv2Mb1Kk1k7HVX11I+yF4eXr+cm+24
        Cq7MjqmBXSnqvdQkwGFZ+C3cTKXJBPONWGF8NgiXaHSKjPEoFuHLdKBpgZMAax/L
        aZBQRw6g12nz3XUCK0DE0wGgPkoDxc65s4NEWS+ua43LZ4TUOzWwwWECgYEA/XB1
        ARNHyARy+P3iTeebh3t7qJoNoptLWHMlKjSjIZ1VZ4+9ilKsi5ZKVkPaLIjo8MGv
        Ank3vzSrFSYhId0XfmSqoWySWc0eBkc6NERvopxuIV1WwRKf/18lLhxiEjHIcgds
        G2KmfeiXdCKSgGlWvJmLITY4gJpOYMjpEDxipskCgYAdxnljmGbNmfvPZRcyKzkM
        jAiF2wd7p0gp1lbLo9+1ELgt2ax7F7Ko3riVZUU7BLSwt/nL6o+iks02XW7qdIkz
        3dzpGjKRXIfwrrVhmKBGclzny5mav8V5nO7DiXX+qkrvl3X3R/FCCtN77ivZOo2Y
        2gXKXr6N55wNdnY1eyI4wQKBgQDXjZo2O+vFVuNimqyrjd1eMcxO7hfCwUooBGcL
        qpFEucg1uK+Awig24LCBBly9nARjIJh1Bhw/58/KwQ9U+fJNcdkeSnV/I1HyDQqY
        AczhBSM2BWkP9YNXc9jvivxudSECuwVblV/9nqGSCQWJag53gjAvIyqTVqpq7vYq
        9PEC4QKBgGY2pj0ZNqGkq16jD3iS+DDBpX+TPnoHzu5GZCM/1GLZ6xXbpNWtZQt4
        /m+6koRWeGvNAULnp8RSnhBzm+ZglpbwYcvsqRNDqIPGhJ2JruVA/bY3S0ebkRlD
        xDn0dJVMvNyRR83ZpjTQhxoq5l56TN5xk1vdJ9nZdwJMmXiz2TrA
        -----END PRIVATE KEY-----
        \"\"\")
        ```

        ## Import

        SSL Certificates Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cas/serviceCertificate:ServiceCertificate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceCertificateArgs.__new__(ServiceCertificateArgs)

            __props__.__dict__["cert"] = cert
            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["encrypt_cert"] = encrypt_cert
            __props__.__dict__["encrypt_private_key"] = None if encrypt_private_key is None else pulumi.Output.secret(encrypt_private_key)
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            __props__.__dict__["lang"] = lang
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["sign_cert"] = sign_cert
            __props__.__dict__["sign_private_key"] = None if sign_private_key is None else pulumi.Output.secret(sign_private_key)
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptPrivateKey", "key", "signPrivateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceCertificate, __self__).__init__(
            'alicloud:cas/serviceCertificate:ServiceCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_cert: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_private_key: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sign_cert: Optional[pulumi.Input[_builtins.str]] = None,
            sign_private_key: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ServiceCertificate':
        """
        Get an existing ServiceCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: The content of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_name: A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        :param pulumi.Input[_builtins.str] encrypt_cert: The content of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] encrypt_private_key: The private key of an SM encryption certificate in PEM format.
        :param pulumi.Input[_builtins.str] key: The private key of a non-SM certificate in PEM format.
        :param pulumi.Input[_builtins.str] lang: Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] sign_cert: The content of an SM signing certificate in PEM format.
        :param pulumi.Input[_builtins.str] sign_private_key: The private key of an SM signing certificate in PEM format.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceCertificateState.__new__(_ServiceCertificateState)

        __props__.__dict__["cert"] = cert
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["encrypt_cert"] = encrypt_cert
        __props__.__dict__["encrypt_private_key"] = encrypt_private_key
        __props__.__dict__["key"] = key
        __props__.__dict__["lang"] = lang
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sign_cert"] = sign_cert
        __props__.__dict__["sign_private_key"] = sign_private_key
        __props__.__dict__["tags"] = tags
        return ServiceCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[_builtins.str]:
        """
        A custom name for the certificate. The name can be up to 64 characters long and can contain any character type, such as letters, numbers, and underscores. **NOTE:** From version 1.260.1, `certificate_name` can be modified.
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="encryptCert")
    def encrypt_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_cert")

    @_builtins.property
    @pulumi.getter(name="encryptPrivateKey")
    def encrypt_private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key of an SM encryption certificate in PEM format.
        """
        return pulumi.get(self, "encrypt_private_key")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key of a non-SM certificate in PEM format.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'lang' has been deprecated from provider version 1.260.1 and it will be removed in the future version.""")
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field `lang` has been deprecated from provider version 1.260.1 and it will be removed in the future version.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute 'certificate_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.129.0 and it will be removed in the future version. Please use the new attribute `certificate_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="signCert")
    def sign_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_cert")

    @_builtins.property
    @pulumi.getter(name="signPrivateKey")
    def sign_private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key of an SM signing certificate in PEM format.
        """
        return pulumi.get(self, "sign_private_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

