# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InterRegionTrafficQosPolicyArgs', 'InterRegionTrafficQosPolicy']

@pulumi.input_type
class InterRegionTrafficQosPolicyArgs:
    def __init__(__self__, *,
                 transit_router_attachment_id: pulumi.Input[_builtins.str],
                 transit_router_id: pulumi.Input[_builtins.str],
                 bandwidth_guarantee_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InterRegionTrafficQosPolicy resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: Peer Attachment ID.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.str] bandwidth_guarantee_mode: Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_name: The name of the traffic scheduling policy.
        """
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if bandwidth_guarantee_mode is not None:
            pulumi.set(__self__, "bandwidth_guarantee_mode", bandwidth_guarantee_mode)
        if inter_region_traffic_qos_policy_description is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_policy_description", inter_region_traffic_qos_policy_description)
        if inter_region_traffic_qos_policy_name is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_policy_name", inter_region_traffic_qos_policy_name)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Peer Attachment ID.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthGuaranteeMode")
    def bandwidth_guarantee_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        """
        return pulumi.get(self, "bandwidth_guarantee_mode")

    @bandwidth_guarantee_mode.setter
    def bandwidth_guarantee_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_guarantee_mode", value)

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyDescription")
    def inter_region_traffic_qos_policy_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_description")

    @inter_region_traffic_qos_policy_description.setter
    def inter_region_traffic_qos_policy_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_region_traffic_qos_policy_description", value)

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyName")
    def inter_region_traffic_qos_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_name")

    @inter_region_traffic_qos_policy_name.setter
    def inter_region_traffic_qos_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_region_traffic_qos_policy_name", value)


@pulumi.input_type
class _InterRegionTrafficQosPolicyState:
    def __init__(__self__, *,
                 bandwidth_guarantee_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InterRegionTrafficQosPolicy resources.
        :param pulumi.Input[_builtins.str] bandwidth_guarantee_mode: Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_name: The name of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] status: The status of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: Peer Attachment ID.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        """
        if bandwidth_guarantee_mode is not None:
            pulumi.set(__self__, "bandwidth_guarantee_mode", bandwidth_guarantee_mode)
        if inter_region_traffic_qos_policy_description is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_policy_description", inter_region_traffic_qos_policy_description)
        if inter_region_traffic_qos_policy_name is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_policy_name", inter_region_traffic_qos_policy_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="bandwidthGuaranteeMode")
    def bandwidth_guarantee_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        """
        return pulumi.get(self, "bandwidth_guarantee_mode")

    @bandwidth_guarantee_mode.setter
    def bandwidth_guarantee_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_guarantee_mode", value)

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyDescription")
    def inter_region_traffic_qos_policy_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_description")

    @inter_region_traffic_qos_policy_description.setter
    def inter_region_traffic_qos_policy_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_region_traffic_qos_policy_description", value)

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyName")
    def inter_region_traffic_qos_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_name")

    @inter_region_traffic_qos_policy_name.setter
    def inter_region_traffic_qos_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inter_region_traffic_qos_policy_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the traffic scheduling policy.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peer Attachment ID.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)


@pulumi.type_token("alicloud:cen/interRegionTrafficQosPolicy:InterRegionTrafficQosPolicy")
class InterRegionTrafficQosPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_guarantee_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy resource.

        For information about Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy and how to use it, see [What is Inter Region Traffic Qos Policy](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateCenInterRegionTrafficQosPolicy).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultp_szb78 = alicloud.cen.Instance("defaultpSZB78")
        default_ummxn_e = alicloud.cen.TransitRouter("defaultUmmxnE", cen_id=defaultp_szb78.id)
        defaultksqg_sa = alicloud.cen.TransitRouter("defaultksqgSa", cen_id=defaultp_szb78.id)
        defaultn_xz83y = alicloud.cen.TransitRouterPeerAttachment("defaultnXZ83y",
            default_link_type="Platinum",
            bandwidth_type="DataTransfer",
            cen_id=defaultp_szb78.id,
            peer_transit_router_region_id="cn-hangzhou",
            transit_router_id=default_ummxn_e.transit_router_id,
            peer_transit_router_id=defaultksqg_sa.transit_router_id,
            bandwidth=10)
        default = alicloud.cen.InterRegionTrafficQosPolicy("default",
            transit_router_attachment_id=defaultn_xz83y.transit_router_attachment_id,
            inter_region_traffic_qos_policy_name="example1",
            inter_region_traffic_qos_policy_description="example1",
            bandwidth_guarantee_mode="byBandwidthPercent",
            transit_router_id=defaultksqg_sa.transit_router_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/interRegionTrafficQosPolicy:InterRegionTrafficQosPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_guarantee_mode: Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_name: The name of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: Peer Attachment ID.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterRegionTrafficQosPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy resource.

        For information about Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy and how to use it, see [What is Inter Region Traffic Qos Policy](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateCenInterRegionTrafficQosPolicy).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultp_szb78 = alicloud.cen.Instance("defaultpSZB78")
        default_ummxn_e = alicloud.cen.TransitRouter("defaultUmmxnE", cen_id=defaultp_szb78.id)
        defaultksqg_sa = alicloud.cen.TransitRouter("defaultksqgSa", cen_id=defaultp_szb78.id)
        defaultn_xz83y = alicloud.cen.TransitRouterPeerAttachment("defaultnXZ83y",
            default_link_type="Platinum",
            bandwidth_type="DataTransfer",
            cen_id=defaultp_szb78.id,
            peer_transit_router_region_id="cn-hangzhou",
            transit_router_id=default_ummxn_e.transit_router_id,
            peer_transit_router_id=defaultksqg_sa.transit_router_id,
            bandwidth=10)
        default = alicloud.cen.InterRegionTrafficQosPolicy("default",
            transit_router_attachment_id=defaultn_xz83y.transit_router_attachment_id,
            inter_region_traffic_qos_policy_name="example1",
            inter_region_traffic_qos_policy_description="example1",
            bandwidth_guarantee_mode="byBandwidthPercent",
            transit_router_id=defaultksqg_sa.transit_router_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/interRegionTrafficQosPolicy:InterRegionTrafficQosPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InterRegionTrafficQosPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterRegionTrafficQosPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_guarantee_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 inter_region_traffic_qos_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterRegionTrafficQosPolicyArgs.__new__(InterRegionTrafficQosPolicyArgs)

            __props__.__dict__["bandwidth_guarantee_mode"] = bandwidth_guarantee_mode
            __props__.__dict__["inter_region_traffic_qos_policy_description"] = inter_region_traffic_qos_policy_description
            __props__.__dict__["inter_region_traffic_qos_policy_name"] = inter_region_traffic_qos_policy_name
            if transit_router_attachment_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_attachment_id'")
            __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["status"] = None
        super(InterRegionTrafficQosPolicy, __self__).__init__(
            'alicloud:cen/interRegionTrafficQosPolicy:InterRegionTrafficQosPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_guarantee_mode: Optional[pulumi.Input[_builtins.str]] = None,
            inter_region_traffic_qos_policy_description: Optional[pulumi.Input[_builtins.str]] = None,
            inter_region_traffic_qos_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'InterRegionTrafficQosPolicy':
        """
        Get an existing InterRegionTrafficQosPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_guarantee_mode: Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] inter_region_traffic_qos_policy_name: The name of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] status: The status of the traffic scheduling policy.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: Peer Attachment ID.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterRegionTrafficQosPolicyState.__new__(_InterRegionTrafficQosPolicyState)

        __props__.__dict__["bandwidth_guarantee_mode"] = bandwidth_guarantee_mode
        __props__.__dict__["inter_region_traffic_qos_policy_description"] = inter_region_traffic_qos_policy_description
        __props__.__dict__["inter_region_traffic_qos_policy_name"] = inter_region_traffic_qos_policy_name
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_id"] = transit_router_id
        return InterRegionTrafficQosPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bandwidthGuaranteeMode")
    def bandwidth_guarantee_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Bandwidth guarantee mode. You can select by bandwidth or by bandwidth percentage. The default is by percentage.
        """
        return pulumi.get(self, "bandwidth_guarantee_mode")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyDescription")
    def inter_region_traffic_qos_policy_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_description")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyName")
    def inter_region_traffic_qos_policy_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the traffic scheduling policy.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Peer Attachment ID.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

