# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitRouterMulticastDomainSourceArgs', 'TransitRouterMulticastDomainSource']

@pulumi.input_type
class TransitRouterMulticastDomainSourceArgs:
    def __init__(__self__, *,
                 group_ip_address: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 transit_router_multicast_domain_id: pulumi.Input[_builtins.str],
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransitRouterMulticastDomainSource resource.
        :param pulumi.Input[_builtins.str] group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID of the multicast source.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        """
        return pulumi.get(self, "group_ip_address")

    @group_ip_address.setter
    def group_ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        ENI ID of the multicast source.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the multicast domain to which the multicast source belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @transit_router_multicast_domain_id.setter
    def transit_router_multicast_domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_multicast_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _TransitRouterMulticastDomainSourceState:
    def __init__(__self__, *,
                 group_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterMulticastDomainSource resources.
        :param pulumi.Input[_builtins.str] group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID of the multicast source.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        if group_ip_address is not None:
            pulumi.set(__self__, "group_ip_address", group_ip_address)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_multicast_domain_id is not None:
            pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        """
        return pulumi.get(self, "group_ip_address")

    @group_ip_address.setter
    def group_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ENI ID of the multicast source.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the multicast domain to which the multicast source belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @transit_router_multicast_domain_id.setter
    def transit_router_multicast_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_multicast_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource")
class TransitRouterMulticastDomainSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cen Transit Router Multicast Domain Source resource.

        For information about Cen Transit Router Multicast Domain Source and how to use it, see [What is Transit Router Multicast Domain Source](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-registertransitroutermulticastgroupsources).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.cen.get_transit_router_available_resources()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_master = alicloud.vpc.Switch("default_master",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.1.0/24",
            zone_id="cn-hangzhou-i")
        default_slave = alicloud.vpc.Switch("default_slave",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.2.0/24",
            zone_id="cn-hangzhou-j")
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default",
            cen_id=default_instance.id,
            support_multicast=True)
        default_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("default",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            vpc_id=default_network.id,
            zone_mappings=[
                {
                    "zone_id": default_master.zone_id,
                    "vswitch_id": default_master.id,
                },
                {
                    "zone_id": default_slave.zone_id,
                    "vswitch_id": default_slave.id,
                },
            ],
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_transit_router_multicast_domain = alicloud.cen.TransitRouterMulticastDomain("default",
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_multicast_domain_name=name,
            transit_router_multicast_domain_description=name)
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            network_interface_name=name,
            vswitch_id=default_master.id,
            security_group_ids=[default_security_group.id],
            description="Basic test",
            primary_ip_address=default_master.cidr_block.apply(lambda cidr_block: std.cidrhost_output(input=cidr_block,
                host=100)).apply(lambda invoke: invoke.result),
            tags={
                "Created": "TF",
                "For": "Test",
            },
            resource_group_id=default_get_resource_groups.ids[0])
        default_transit_router_multicast_domain_association = alicloud.cen.TransitRouterMulticastDomainAssociation("default",
            transit_router_multicast_domain_id=default_transit_router_multicast_domain.id,
            transit_router_attachment_id=default_transit_router_vpc_attachment.transit_router_attachment_id,
            vswitch_id=default_master.id)
        example = alicloud.cen.TransitRouterMulticastDomainSource("example",
            vpc_id=default_network.id,
            transit_router_multicast_domain_id=default_transit_router_multicast_domain_association.transit_router_multicast_domain_id,
            network_interface_id=default_ecs_network_interface.id,
            group_ip_address="239.1.1.1")
        ```

        ## Import

        Cen Transit Router Multicast Domain Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID of the multicast source.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterMulticastDomainSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cen Transit Router Multicast Domain Source resource.

        For information about Cen Transit Router Multicast Domain Source and how to use it, see [What is Transit Router Multicast Domain Source](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-registertransitroutermulticastgroupsources).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.cen.get_transit_router_available_resources()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_master = alicloud.vpc.Switch("default_master",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.1.0/24",
            zone_id="cn-hangzhou-i")
        default_slave = alicloud.vpc.Switch("default_slave",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="192.168.2.0/24",
            zone_id="cn-hangzhou-j")
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default",
            cen_id=default_instance.id,
            support_multicast=True)
        default_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("default",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            vpc_id=default_network.id,
            zone_mappings=[
                {
                    "zone_id": default_master.zone_id,
                    "vswitch_id": default_master.id,
                },
                {
                    "zone_id": default_slave.zone_id,
                    "vswitch_id": default_slave.id,
                },
            ],
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_transit_router_multicast_domain = alicloud.cen.TransitRouterMulticastDomain("default",
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_multicast_domain_name=name,
            transit_router_multicast_domain_description=name)
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            network_interface_name=name,
            vswitch_id=default_master.id,
            security_group_ids=[default_security_group.id],
            description="Basic test",
            primary_ip_address=default_master.cidr_block.apply(lambda cidr_block: std.cidrhost_output(input=cidr_block,
                host=100)).apply(lambda invoke: invoke.result),
            tags={
                "Created": "TF",
                "For": "Test",
            },
            resource_group_id=default_get_resource_groups.ids[0])
        default_transit_router_multicast_domain_association = alicloud.cen.TransitRouterMulticastDomainAssociation("default",
            transit_router_multicast_domain_id=default_transit_router_multicast_domain.id,
            transit_router_attachment_id=default_transit_router_vpc_attachment.transit_router_attachment_id,
            vswitch_id=default_master.id)
        example = alicloud.cen.TransitRouterMulticastDomainSource("example",
            vpc_id=default_network.id,
            transit_router_multicast_domain_id=default_transit_router_multicast_domain_association.transit_router_multicast_domain_id,
            network_interface_id=default_ecs_network_interface.id,
            group_ip_address="239.1.1.1")
        ```

        ## Import

        Cen Transit Router Multicast Domain Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterMulticastDomainSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterMulticastDomainSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterMulticastDomainSourceArgs.__new__(TransitRouterMulticastDomainSourceArgs)

            if group_ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'group_ip_address'")
            __props__.__dict__["group_ip_address"] = group_ip_address
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if transit_router_multicast_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_multicast_domain_id'")
            __props__.__dict__["transit_router_multicast_domain_id"] = transit_router_multicast_domain_id
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["status"] = None
        super(TransitRouterMulticastDomainSource, __self__).__init__(
            'alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouterMulticastDomainSource':
        """
        Get an existing TransitRouterMulticastDomainSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID of the multicast source.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterMulticastDomainSourceState.__new__(_TransitRouterMulticastDomainSourceState)

        __props__.__dict__["group_ip_address"] = group_ip_address
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_multicast_domain_id"] = transit_router_multicast_domain_id
        __props__.__dict__["vpc_id"] = vpc_id
        return TransitRouterMulticastDomainSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        """
        return pulumi.get(self, "group_ip_address")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        ENI ID of the multicast source.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the multicast domain to which the multicast source belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")

