# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountsResult',
    'AwaitableGetAccountsResult',
    'get_accounts',
    'get_accounts_output',
]

@pulumi.output_type
class GetAccountsResult:
    """
    A collection of values returned by getAccounts.
    """
    def __init__(__self__, accounts=None, db_cluster_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if db_cluster_id and not isinstance(db_cluster_id, str):
            raise TypeError("Expected argument 'db_cluster_id' to be a str")
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetAccountsAccountResult']:
        """
        A list of Click House Accounts. Each element contains the following attributes:
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> _builtins.str:
        """
        The DBCluster id.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Account names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


class AwaitableGetAccountsResult(GetAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountsResult(
            accounts=self.accounts,
            db_cluster_id=self.db_cluster_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_accounts(db_cluster_id: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountsResult:
    """
    This data source provides the Click House Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.134.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "oneaccountname"
    pwd = config.get("pwd")
    if pwd is None:
        pwd = "Tf-onepwd"
    type = config.get("type")
    if type is None:
        type = "Normal"
    default = alicloud.clickhouse.get_regions(current=True)
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=default.regions[0].zone_ids[0].zone_id)
    default_db_cluster = alicloud.clickhouse.DbCluster("default",
        db_cluster_version="22.8.5.29",
        category="Basic",
        db_cluster_class="S8",
        db_cluster_network_type="vpc",
        db_cluster_description=name,
        db_node_group_count=1,
        payment_type="PayAsYouGo",
        db_node_storage="500",
        storage_type="cloud_essd",
        vswitch_id=default_switch.id,
        vpc_id=default_network.id)
    default_account = alicloud.clickhouse.Account("default",
        db_cluster_id=default_db_cluster.id,
        account_description="your_description",
        account_name=name,
        account_password=pwd,
        type=type)
    default_get_accounts = alicloud.clickhouse.get_accounts_output(ids=[default_account.id],
        db_cluster_id=default_db_cluster.id)
    pulumi.export("accountId", default_get_accounts.ids[0])
    ```


    :param _builtins.str db_cluster_id: The DBCluster id.
    :param Sequence[_builtins.str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param _builtins.str name_regex: A regex string to filter results by Account name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:clickhouse/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult).value

    return AwaitableGetAccountsResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        db_cluster_id=pulumi.get(__ret__, 'db_cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_accounts_output(db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountsResult]:
    """
    This data source provides the Click House Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.134.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "oneaccountname"
    pwd = config.get("pwd")
    if pwd is None:
        pwd = "Tf-onepwd"
    type = config.get("type")
    if type is None:
        type = "Normal"
    default = alicloud.clickhouse.get_regions(current=True)
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=default.regions[0].zone_ids[0].zone_id)
    default_db_cluster = alicloud.clickhouse.DbCluster("default",
        db_cluster_version="22.8.5.29",
        category="Basic",
        db_cluster_class="S8",
        db_cluster_network_type="vpc",
        db_cluster_description=name,
        db_node_group_count=1,
        payment_type="PayAsYouGo",
        db_node_storage="500",
        storage_type="cloud_essd",
        vswitch_id=default_switch.id,
        vpc_id=default_network.id)
    default_account = alicloud.clickhouse.Account("default",
        db_cluster_id=default_db_cluster.id,
        account_description="your_description",
        account_name=name,
        account_password=pwd,
        type=type)
    default_get_accounts = alicloud.clickhouse.get_accounts_output(ids=[default_account.id],
        db_cluster_id=default_db_cluster.id)
    pulumi.export("accountId", default_get_accounts.ids[0])
    ```


    :param _builtins.str db_cluster_id: The DBCluster id.
    :param Sequence[_builtins.str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param _builtins.str name_regex: A regex string to filter results by Account name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid Status: `Creating`,`Available`,`Deleting`.
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:clickhouse/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult)
    return __ret__.apply(lambda __response__: GetAccountsResult(
        accounts=pulumi.get(__response__, 'accounts'),
        db_cluster_id=pulumi.get(__response__, 'db_cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
