# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNatFirewallsResult',
    'AwaitableGetNatFirewallsResult',
    'get_nat_firewalls',
    'get_nat_firewalls_output',
]

@pulumi.output_type
class GetNatFirewallsResult:
    """
    A collection of values returned by getNatFirewalls.
    """
    def __init__(__self__, firewalls=None, id=None, ids=None, lang=None, member_uid=None, nat_gateway_id=None, output_file=None, page_number=None, page_size=None, proxy_id=None, proxy_name=None, region_no=None, status=None, vpc_id=None):
        if firewalls and not isinstance(firewalls, list):
            raise TypeError("Expected argument 'firewalls' to be a list")
        pulumi.set(__self__, "firewalls", firewalls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if member_uid and not isinstance(member_uid, int):
            raise TypeError("Expected argument 'member_uid' to be a int")
        pulumi.set(__self__, "member_uid", member_uid)
        if nat_gateway_id and not isinstance(nat_gateway_id, str):
            raise TypeError("Expected argument 'nat_gateway_id' to be a str")
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if proxy_id and not isinstance(proxy_id, str):
            raise TypeError("Expected argument 'proxy_id' to be a str")
        pulumi.set(__self__, "proxy_id", proxy_id)
        if proxy_name and not isinstance(proxy_name, str):
            raise TypeError("Expected argument 'proxy_name' to be a str")
        pulumi.set(__self__, "proxy_name", proxy_name)
        if region_no and not isinstance(region_no, str):
            raise TypeError("Expected argument 'region_no' to be a str")
        pulumi.set(__self__, "region_no", region_no)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def firewalls(self) -> Sequence['outputs.GetNatFirewallsFirewallResult']:
        """
        A list of Nat Firewall Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "firewalls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Nat Firewall IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[_builtins.int]:
        """
        Member Account ID
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[_builtins.str]:
        """
        NAT gateway ID
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> Optional[_builtins.str]:
        """
        NAT firewall ID
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="proxyName")
    def proxy_name(self) -> Optional[_builtins.str]:
        """
        NAT firewall name
        """
        return pulumi.get(self, "proxy_name")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetNatFirewallsResult(GetNatFirewallsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNatFirewallsResult(
            firewalls=self.firewalls,
            id=self.id,
            ids=self.ids,
            lang=self.lang,
            member_uid=self.member_uid,
            nat_gateway_id=self.nat_gateway_id,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            proxy_id=self.proxy_id,
            proxy_name=self.proxy_name,
            region_no=self.region_no,
            status=self.status,
            vpc_id=self.vpc_id)


def get_nat_firewalls(ids: Optional[Sequence[_builtins.str]] = None,
                      lang: Optional[_builtins.str] = None,
                      member_uid: Optional[_builtins.int] = None,
                      nat_gateway_id: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      page_number: Optional[_builtins.int] = None,
                      page_size: Optional[_builtins.int] = None,
                      proxy_id: Optional[_builtins.str] = None,
                      proxy_name: Optional[_builtins.str] = None,
                      region_no: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      vpc_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNatFirewallsResult:
    """
    This data source provides Cloud Firewall Nat Firewall available to the user.[What is Nat Firewall](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/CreateSecurityProxy)

    > **NOTE:** Available since v1.243.0.


    :param Sequence[_builtins.str] ids: A list of Nat Firewall IDs.
    :param _builtins.str lang: Lang
    :param _builtins.int member_uid: Member Account ID
    :param _builtins.str nat_gateway_id: NAT gateway ID
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Page No
    :param _builtins.int page_size: Page Size
    :param _builtins.str proxy_id: NAT firewall ID
    :param _builtins.str proxy_name: NAT firewall name
    :param _builtins.str region_no: Region
    :param _builtins.str status: The status of the resource
    :param _builtins.str vpc_id: The ID of the VPC instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['natGatewayId'] = nat_gateway_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['proxyId'] = proxy_id
    __args__['proxyName'] = proxy_name
    __args__['regionNo'] = region_no
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getNatFirewalls:getNatFirewalls', __args__, opts=opts, typ=GetNatFirewallsResult).value

    return AwaitableGetNatFirewallsResult(
        firewalls=pulumi.get(__ret__, 'firewalls'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lang=pulumi.get(__ret__, 'lang'),
        member_uid=pulumi.get(__ret__, 'member_uid'),
        nat_gateway_id=pulumi.get(__ret__, 'nat_gateway_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        proxy_id=pulumi.get(__ret__, 'proxy_id'),
        proxy_name=pulumi.get(__ret__, 'proxy_name'),
        region_no=pulumi.get(__ret__, 'region_no'),
        status=pulumi.get(__ret__, 'status'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_nat_firewalls_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             member_uid: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             nat_gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             proxy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             proxy_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region_no: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNatFirewallsResult]:
    """
    This data source provides Cloud Firewall Nat Firewall available to the user.[What is Nat Firewall](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/CreateSecurityProxy)

    > **NOTE:** Available since v1.243.0.


    :param Sequence[_builtins.str] ids: A list of Nat Firewall IDs.
    :param _builtins.str lang: Lang
    :param _builtins.int member_uid: Member Account ID
    :param _builtins.str nat_gateway_id: NAT gateway ID
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Page No
    :param _builtins.int page_size: Page Size
    :param _builtins.str proxy_id: NAT firewall ID
    :param _builtins.str proxy_name: NAT firewall name
    :param _builtins.str region_no: Region
    :param _builtins.str status: The status of the resource
    :param _builtins.str vpc_id: The ID of the VPC instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['natGatewayId'] = nat_gateway_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['proxyId'] = proxy_id
    __args__['proxyName'] = proxy_name
    __args__['regionNo'] = region_no
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getNatFirewalls:getNatFirewalls', __args__, opts=opts, typ=GetNatFirewallsResult)
    return __ret__.apply(lambda __response__: GetNatFirewallsResult(
        firewalls=pulumi.get(__response__, 'firewalls'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lang=pulumi.get(__response__, 'lang'),
        member_uid=pulumi.get(__response__, 'member_uid'),
        nat_gateway_id=pulumi.get(__response__, 'nat_gateway_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        proxy_id=pulumi.get(__response__, 'proxy_id'),
        proxy_name=pulumi.get(__response__, 'proxy_name'),
        region_no=pulumi.get(__response__, 'region_no'),
        status=pulumi.get(__response__, 'status'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
