# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTlsInspectCaCertificatesResult',
    'AwaitableGetTlsInspectCaCertificatesResult',
    'get_tls_inspect_ca_certificates',
    'get_tls_inspect_ca_certificates_output',
]

@pulumi.output_type
class GetTlsInspectCaCertificatesResult:
    """
    A collection of values returned by getTlsInspectCaCertificates.
    """
    def __init__(__self__, ca_cert_id=None, certificates=None, id=None, ids=None, output_file=None, page_number=None, page_size=None):
        if ca_cert_id and not isinstance(ca_cert_id, str):
            raise TypeError("Expected argument 'ca_cert_id' to be a str")
        pulumi.set(__self__, "ca_cert_id", ca_cert_id)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)

    @_builtins.property
    @pulumi.getter(name="caCertId")
    def ca_cert_id(self) -> Optional[_builtins.str]:
        """
        CA certificate ID
        """
        return pulumi.get(self, "ca_cert_id")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetTlsInspectCaCertificatesCertificateResult']:
        """
        A list of Tls Inspect Ca Certificate Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Tls Inspect Ca Certificate IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")


class AwaitableGetTlsInspectCaCertificatesResult(GetTlsInspectCaCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsInspectCaCertificatesResult(
            ca_cert_id=self.ca_cert_id,
            certificates=self.certificates,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size)


def get_tls_inspect_ca_certificates(ca_cert_id: Optional[_builtins.str] = None,
                                    ids: Optional[Sequence[_builtins.str]] = None,
                                    output_file: Optional[_builtins.str] = None,
                                    page_number: Optional[_builtins.int] = None,
                                    page_size: Optional[_builtins.int] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsInspectCaCertificatesResult:
    """
    This data source provides Cloud Firewall Tls Inspect Ca Certificate available to the user.[What is Tls Inspect Ca Certificate](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/GetTlsInspectCertificateDownloadUrl)

    > **NOTE:** Available since v1.262.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_cloud_firewall_tls_inspect_ca_certificate = alicloud.index.CloudFirewallTlsInspectCaCertificate("default")
    default = alicloud.cloudfirewall.get_tls_inspect_ca_certificates(ids=[default_cloud_firewall_tls_inspect_ca_certificate["id"]])
    pulumi.export("alicloudCloudFirewallTlsInspectCaCertificateExampleId", default.certificates[0].id)
    ```


    :param _builtins.str ca_cert_id: CA certificate ID
    :param Sequence[_builtins.str] ids: A list of Tls Inspect Ca Certificate IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    """
    __args__ = dict()
    __args__['caCertId'] = ca_cert_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getTlsInspectCaCertificates:getTlsInspectCaCertificates', __args__, opts=opts, typ=GetTlsInspectCaCertificatesResult).value

    return AwaitableGetTlsInspectCaCertificatesResult(
        ca_cert_id=pulumi.get(__ret__, 'ca_cert_id'),
        certificates=pulumi.get(__ret__, 'certificates'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'))
def get_tls_inspect_ca_certificates_output(ca_cert_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                           page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTlsInspectCaCertificatesResult]:
    """
    This data source provides Cloud Firewall Tls Inspect Ca Certificate available to the user.[What is Tls Inspect Ca Certificate](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/GetTlsInspectCertificateDownloadUrl)

    > **NOTE:** Available since v1.262.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_cloud_firewall_tls_inspect_ca_certificate = alicloud.index.CloudFirewallTlsInspectCaCertificate("default")
    default = alicloud.cloudfirewall.get_tls_inspect_ca_certificates(ids=[default_cloud_firewall_tls_inspect_ca_certificate["id"]])
    pulumi.export("alicloudCloudFirewallTlsInspectCaCertificateExampleId", default.certificates[0].id)
    ```


    :param _builtins.str ca_cert_id: CA certificate ID
    :param Sequence[_builtins.str] ids: A list of Tls Inspect Ca Certificate IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    """
    __args__ = dict()
    __args__['caCertId'] = ca_cert_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getTlsInspectCaCertificates:getTlsInspectCaCertificates', __args__, opts=opts, typ=GetTlsInspectCaCertificatesResult)
    return __ret__.apply(lambda __response__: GetTlsInspectCaCertificatesResult(
        ca_cert_id=pulumi.get(__response__, 'ca_cert_id'),
        certificates=pulumi.get(__response__, 'certificates'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size')))
