# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NatFirewallControlPolicyArgs', 'NatFirewallControlPolicy']

@pulumi.input_type
class NatFirewallControlPolicyArgs:
    def __init__(__self__, *,
                 acl_action: pulumi.Input[_builtins.str],
                 application_name_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: pulumi.Input[_builtins.str],
                 destination: pulumi.Input[_builtins.str],
                 destination_type: pulumi.Input[_builtins.str],
                 direction: pulumi.Input[_builtins.str],
                 nat_gateway_id: pulumi.Input[_builtins.str],
                 new_order: pulumi.Input[_builtins.str],
                 proto: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NatFirewallControlPolicy resource.
        :param pulumi.Input[_builtins.str] acl_action: The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
               - **accept**: Release
               - **drop**: Refused
               - **log**: Observation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The list of application types supported by the access control policy.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] destination: The destination address segment in the access control policy. Valid values:
               - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
               - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
               - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
               - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        :param pulumi.Input[_builtins.str] destination_type: The destination address type in the access control policy. Valid values:
               - **net**: Destination Network segment (CIDR address)
               - **group**: Destination Address Book
               - **domain**: the destination domain name.
        :param pulumi.Input[_builtins.str] direction: The traffic direction of the access control policy. Valid values:
               - **out**: Internal and external traffic access control.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of the NAT gateway instance.
        :param pulumi.Input[_builtins.str] new_order: The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        :param pulumi.Input[_builtins.str] proto: The security protocol type for traffic access in the access control policy. Valid values:
               - ANY (indicates that all protocol types are queried)
               - TCP
               - UDP
               - ICMP.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy. Valid values:
               - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
               - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        :param pulumi.Input[_builtins.str] source_type: The source address type in the access control policy. Valid values:
               - **net**: the source network segment (CIDR address)
               - **group**: source address book
        :param pulumi.Input[_builtins.str] dest_port: The destination port of traffic access in the access control policy. Value:
               - When the protocol type is set to ICMP, the value of DestPort is null.
               > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
               > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        :param pulumi.Input[_builtins.str] dest_port_group: The address book name of the destination port of the access traffic in the access control policy.
               > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        :param pulumi.Input[_builtins.str] dest_port_type: The destination port type of the access traffic in the security access control policy.
               - **port**: port
               - **group**: Port Address Book.
        :param pulumi.Input[_builtins.int] domain_resolve_type: The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
               - **0**: Based on FQDN
               - **1**: DNS-based dynamic resolution
               - **2**: dynamic resolution based on FQDN and DNS.
        :param pulumi.Input[_builtins.int] end_time: The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
               > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        :param pulumi.Input[_builtins.str] ip_version: Supported IP address version. Value:
               - **4** (default): indicates the IPv4 address.
        :param pulumi.Input[_builtins.str] release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
               - **true**: Enable access control policy
               - **false**: Do not enable access control policies.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: Collection of recurring dates for the policy validity period of the access control policy.
               - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
               - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
               - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        :param pulumi.Input[_builtins.str] repeat_end_time: The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
               > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        :param pulumi.Input[_builtins.str] repeat_start_time: The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
               > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        :param pulumi.Input[_builtins.str] repeat_type: The type of repetition for the policy validity period of the access control policy. Value:
               - **Permit** (default): Always
               - **None**: Specify a single time
               - **Daily**: Daily
               - **Weekly**: Weekly
               - **Monthly**: Monthly.
        :param pulumi.Input[_builtins.int] start_time: The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
               > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "application_name_lists", application_name_lists)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "new_order", new_order)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_type", source_type)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if domain_resolve_type is not None:
            pulumi.set(__self__, "domain_resolve_type", domain_resolve_type)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if repeat_days is not None:
            pulumi.set(__self__, "repeat_days", repeat_days)
        if repeat_end_time is not None:
            pulumi.set(__self__, "repeat_end_time", repeat_end_time)
        if repeat_start_time is not None:
            pulumi.set(__self__, "repeat_start_time", repeat_start_time)
        if repeat_type is not None:
            pulumi.set(__self__, "repeat_type", repeat_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Input[_builtins.str]:
        """
        The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
        - **accept**: Release
        - **drop**: Refused
        - **log**: Observation.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of application types supported by the access control policy.
        """
        return pulumi.get(self, "application_name_lists")

    @application_name_lists.setter
    def application_name_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "application_name_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        The destination address segment in the access control policy. Valid values:
        - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
        - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
        - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
        - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[_builtins.str]:
        """
        The destination address type in the access control policy. Valid values:
        - **net**: Destination Network segment (CIDR address)
        - **group**: Destination Address Book
        - **domain**: the destination domain name.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        The traffic direction of the access control policy. Valid values:
        - **out**: Internal and external traffic access control.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the NAT gateway instance.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="newOrder")
    def new_order(self) -> pulumi.Input[_builtins.str]:
        """
        The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        """
        return pulumi.get(self, "new_order")

    @new_order.setter
    def new_order(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "new_order", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Input[_builtins.str]:
        """
        The security protocol type for traffic access in the access control policy. Valid values:
        - ANY (indicates that all protocol types are queried)
        - TCP
        - UDP
        - ICMP.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        The source address in the access control policy. Valid values:
        - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
        - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The source address type in the access control policy. Valid values:
        - **net**: the source network segment (CIDR address)
        - **group**: source address book
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port of traffic access in the access control policy. Value:
        - When the protocol type is set to ICMP, the value of DestPort is null.
        > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
        > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address book name of the destination port of the access traffic in the access control policy.
        > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port type of the access traffic in the security access control policy.
        - **port**: port
        - **group**: Port Address Book.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
        - **0**: Based on FQDN
        - **1**: DNS-based dynamic resolution
        - **2**: dynamic resolution based on FQDN and DNS.
        """
        return pulumi.get(self, "domain_resolve_type")

    @domain_resolve_type.setter
    def domain_resolve_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "domain_resolve_type", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
        > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported IP address version. Value:
        - **4** (default): indicates the IPv4 address.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
        - **true**: Enable access control policy
        - **false**: Do not enable access control policies.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Collection of recurring dates for the policy validity period of the access control policy.
        - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
        - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
        - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        """
        return pulumi.get(self, "repeat_days")

    @repeat_days.setter
    def repeat_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "repeat_days", value)

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
        > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        """
        return pulumi.get(self, "repeat_end_time")

    @repeat_end_time.setter
    def repeat_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_end_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
        > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        """
        return pulumi.get(self, "repeat_start_time")

    @repeat_start_time.setter
    def repeat_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_start_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of repetition for the policy validity period of the access control policy. Value:
        - **Permit** (default): Always
        - **None**: Specify a single time
        - **Daily**: Daily
        - **Weekly**: Weekly
        - **Monthly**: Monthly.
        """
        return pulumi.get(self, "repeat_type")

    @repeat_type.setter
    def repeat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_type", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
        > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _NatFirewallControlPolicyState:
    def __init__(__self__, *,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_order: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NatFirewallControlPolicy resources.
        :param pulumi.Input[_builtins.str] acl_action: The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
               - **accept**: Release
               - **drop**: Refused
               - **log**: Observation.
        :param pulumi.Input[_builtins.str] acl_uuid: The unique ID of the security access control policy.
               > **NOTE:**  To modify a security access control policy, you need to provide the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy interface to obtain the ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The list of application types supported by the access control policy.
        :param pulumi.Input[_builtins.int] create_time: The time when the policy was created.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port of traffic access in the access control policy. Value:
               - When the protocol type is set to ICMP, the value of DestPort is null.
               > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
               > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        :param pulumi.Input[_builtins.str] dest_port_group: The address book name of the destination port of the access traffic in the access control policy.
               > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        :param pulumi.Input[_builtins.str] dest_port_type: The destination port type of the access traffic in the security access control policy.
               - **port**: port
               - **group**: Port Address Book.
        :param pulumi.Input[_builtins.str] destination: The destination address segment in the access control policy. Valid values:
               - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
               - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
               - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
               - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        :param pulumi.Input[_builtins.str] destination_type: The destination address type in the access control policy. Valid values:
               - **net**: Destination Network segment (CIDR address)
               - **group**: Destination Address Book
               - **domain**: the destination domain name.
        :param pulumi.Input[_builtins.str] direction: The traffic direction of the access control policy. Valid values:
               - **out**: Internal and external traffic access control.
        :param pulumi.Input[_builtins.int] domain_resolve_type: The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
               - **0**: Based on FQDN
               - **1**: DNS-based dynamic resolution
               - **2**: dynamic resolution based on FQDN and DNS.
        :param pulumi.Input[_builtins.int] end_time: The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
               > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        :param pulumi.Input[_builtins.str] ip_version: Supported IP address version. Value:
               - **4** (default): indicates the IPv4 address.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of the NAT gateway instance.
        :param pulumi.Input[_builtins.str] new_order: The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        :param pulumi.Input[_builtins.str] proto: The security protocol type for traffic access in the access control policy. Valid values:
               - ANY (indicates that all protocol types are queried)
               - TCP
               - UDP
               - ICMP.
        :param pulumi.Input[_builtins.str] release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
               - **true**: Enable access control policy
               - **false**: Do not enable access control policies.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: Collection of recurring dates for the policy validity period of the access control policy.
               - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
               - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
               - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        :param pulumi.Input[_builtins.str] repeat_end_time: The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
               > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        :param pulumi.Input[_builtins.str] repeat_start_time: The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
               > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        :param pulumi.Input[_builtins.str] repeat_type: The type of repetition for the policy validity period of the access control policy. Value:
               - **Permit** (default): Always
               - **None**: Specify a single time
               - **Daily**: Daily
               - **Weekly**: Weekly
               - **Monthly**: Monthly.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy. Valid values:
               - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
               - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        :param pulumi.Input[_builtins.str] source_type: The source address type in the access control policy. Valid values:
               - **net**: the source network segment (CIDR address)
               - **group**: source address book
        :param pulumi.Input[_builtins.int] start_time: The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
               > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        if acl_action is not None:
            pulumi.set(__self__, "acl_action", acl_action)
        if acl_uuid is not None:
            pulumi.set(__self__, "acl_uuid", acl_uuid)
        if application_name_lists is not None:
            pulumi.set(__self__, "application_name_lists", application_name_lists)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if domain_resolve_type is not None:
            pulumi.set(__self__, "domain_resolve_type", domain_resolve_type)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_order is not None:
            pulumi.set(__self__, "new_order", new_order)
        if proto is not None:
            pulumi.set(__self__, "proto", proto)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if repeat_days is not None:
            pulumi.set(__self__, "repeat_days", repeat_days)
        if repeat_end_time is not None:
            pulumi.set(__self__, "repeat_end_time", repeat_end_time)
        if repeat_start_time is not None:
            pulumi.set(__self__, "repeat_start_time", repeat_start_time)
        if repeat_type is not None:
            pulumi.set(__self__, "repeat_type", repeat_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
        - **accept**: Release
        - **drop**: Refused
        - **log**: Observation.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the security access control policy.
        > **NOTE:**  To modify a security access control policy, you need to provide the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy interface to obtain the ID.
        """
        return pulumi.get(self, "acl_uuid")

    @acl_uuid.setter
    def acl_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_uuid", value)

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of application types supported by the access control policy.
        """
        return pulumi.get(self, "application_name_lists")

    @application_name_lists.setter
    def application_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_name_lists", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the policy was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port of traffic access in the access control policy. Value:
        - When the protocol type is set to ICMP, the value of DestPort is null.
        > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
        > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address book name of the destination port of the access traffic in the access control policy.
        > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port type of the access traffic in the security access control policy.
        - **port**: port
        - **group**: Port Address Book.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination address segment in the access control policy. Valid values:
        - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
        - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
        - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
        - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination address type in the access control policy. Valid values:
        - **net**: Destination Network segment (CIDR address)
        - **group**: Destination Address Book
        - **domain**: the destination domain name.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic direction of the access control policy. Valid values:
        - **out**: Internal and external traffic access control.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
        - **0**: Based on FQDN
        - **1**: DNS-based dynamic resolution
        - **2**: dynamic resolution based on FQDN and DNS.
        """
        return pulumi.get(self, "domain_resolve_type")

    @domain_resolve_type.setter
    def domain_resolve_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "domain_resolve_type", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
        > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported IP address version. Value:
        - **4** (default): indicates the IPv4 address.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the NAT gateway instance.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="newOrder")
    def new_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        """
        return pulumi.get(self, "new_order")

    @new_order.setter
    def new_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "new_order", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security protocol type for traffic access in the access control policy. Valid values:
        - ANY (indicates that all protocol types are queried)
        - TCP
        - UDP
        - ICMP.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
        - **true**: Enable access control policy
        - **false**: Do not enable access control policies.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Collection of recurring dates for the policy validity period of the access control policy.
        - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
        - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
        - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        """
        return pulumi.get(self, "repeat_days")

    @repeat_days.setter
    def repeat_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "repeat_days", value)

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
        > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        """
        return pulumi.get(self, "repeat_end_time")

    @repeat_end_time.setter
    def repeat_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_end_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
        > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        """
        return pulumi.get(self, "repeat_start_time")

    @repeat_start_time.setter
    def repeat_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_start_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of repetition for the policy validity period of the access control policy. Value:
        - **Permit** (default): Always
        - **None**: Specify a single time
        - **Daily**: Daily
        - **Weekly**: Weekly
        - **Monthly**: Monthly.
        """
        return pulumi.get(self, "repeat_type")

    @repeat_type.setter
    def repeat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_type", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source address in the access control policy. Valid values:
        - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
        - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source address type in the access control policy. Valid values:
        - **net**: the source network segment (CIDR address)
        - **group**: source address book
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
        > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)


@pulumi.type_token("alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy")
class NatFirewallControlPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_order: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Nat Firewall Control Policy resource. Nat firewall access control policy.

        For information about Cloud Firewall Nat Firewall Control Policy and how to use it, see [What is Nat Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createnatfirewallcontrolpolicy).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        direction = config.get("direction")
        if direction is None:
            direction = "out"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_d_ei_wf_m = alicloud.vpc.Network("defaultDEiWfM",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        default_fhdm3_f = alicloud.vpc.Switch("defaultFHDM3F",
            vpc_id=default_d_ei_wf_m.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.2.0/24")
        default_mb_s2_ts = alicloud.vpc.NatGateway("defaultMbS2Ts",
            vpc_id=default_d_ei_wf_m.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_fhdm3_f.id,
            nat_type="Enhanced")
        port = alicloud.cloudfirewall.AddressBook("port",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "port",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "port",
                ]).result,
            group_type="port",
            address_lists=[
                "22/22",
                "23/23",
                "24/24",
            ])
        port_update = alicloud.cloudfirewall.AddressBook("port-update",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "port-update",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "port-update",
                ]).result,
            group_type="port",
            address_lists=[
                "22/22",
                "23/23",
                "24/24",
            ])
        domain = alicloud.cloudfirewall.AddressBook("domain",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "domain",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "domain",
                ]).result,
            group_type="domain",
            address_lists=[
                "alibaba.com",
                "aliyun.com",
                "alicloud.com",
            ])
        ip = alicloud.cloudfirewall.AddressBook("ip",
            description=name,
            group_name=name,
            group_type="ip",
            address_lists=[
                "1.1.1.1/32",
                "2.2.2.2/32",
            ])
        default_nat_firewall_control_policy = alicloud.cloudfirewall.NatFirewallControlPolicy("default",
            application_name_lists=["ANY"],
            description=name,
            release="false",
            ip_version="4",
            repeat_days=[
                1,
                2,
                3,
            ],
            repeat_start_time="21:00",
            acl_action="log",
            dest_port_group=port.group_name,
            repeat_type="Weekly",
            nat_gateway_id=default_mb_s2_ts.id,
            source="1.1.1.1/32",
            direction="out",
            repeat_end_time="21:30",
            start_time=1699156800,
            destination="1.1.1.1/32",
            end_time=1888545600,
            source_type="net",
            proto="TCP",
            new_order="1",
            destination_type="net",
            dest_port_type="group",
            domain_resolve_type=0)
        ```

        ## Import

        Cloud Firewall Nat Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy example <acl_uuid>:<nat_gateway_id>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
               - **accept**: Release
               - **drop**: Refused
               - **log**: Observation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The list of application types supported by the access control policy.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port of traffic access in the access control policy. Value:
               - When the protocol type is set to ICMP, the value of DestPort is null.
               > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
               > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        :param pulumi.Input[_builtins.str] dest_port_group: The address book name of the destination port of the access traffic in the access control policy.
               > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        :param pulumi.Input[_builtins.str] dest_port_type: The destination port type of the access traffic in the security access control policy.
               - **port**: port
               - **group**: Port Address Book.
        :param pulumi.Input[_builtins.str] destination: The destination address segment in the access control policy. Valid values:
               - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
               - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
               - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
               - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        :param pulumi.Input[_builtins.str] destination_type: The destination address type in the access control policy. Valid values:
               - **net**: Destination Network segment (CIDR address)
               - **group**: Destination Address Book
               - **domain**: the destination domain name.
        :param pulumi.Input[_builtins.str] direction: The traffic direction of the access control policy. Valid values:
               - **out**: Internal and external traffic access control.
        :param pulumi.Input[_builtins.int] domain_resolve_type: The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
               - **0**: Based on FQDN
               - **1**: DNS-based dynamic resolution
               - **2**: dynamic resolution based on FQDN and DNS.
        :param pulumi.Input[_builtins.int] end_time: The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
               > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        :param pulumi.Input[_builtins.str] ip_version: Supported IP address version. Value:
               - **4** (default): indicates the IPv4 address.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of the NAT gateway instance.
        :param pulumi.Input[_builtins.str] new_order: The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        :param pulumi.Input[_builtins.str] proto: The security protocol type for traffic access in the access control policy. Valid values:
               - ANY (indicates that all protocol types are queried)
               - TCP
               - UDP
               - ICMP.
        :param pulumi.Input[_builtins.str] release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
               - **true**: Enable access control policy
               - **false**: Do not enable access control policies.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: Collection of recurring dates for the policy validity period of the access control policy.
               - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
               - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
               - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        :param pulumi.Input[_builtins.str] repeat_end_time: The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
               > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        :param pulumi.Input[_builtins.str] repeat_start_time: The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
               > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        :param pulumi.Input[_builtins.str] repeat_type: The type of repetition for the policy validity period of the access control policy. Value:
               - **Permit** (default): Always
               - **None**: Specify a single time
               - **Daily**: Daily
               - **Weekly**: Weekly
               - **Monthly**: Monthly.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy. Valid values:
               - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
               - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        :param pulumi.Input[_builtins.str] source_type: The source address type in the access control policy. Valid values:
               - **net**: the source network segment (CIDR address)
               - **group**: source address book
        :param pulumi.Input[_builtins.int] start_time: The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
               > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatFirewallControlPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Nat Firewall Control Policy resource. Nat firewall access control policy.

        For information about Cloud Firewall Nat Firewall Control Policy and how to use it, see [What is Nat Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/developer-reference/api-cloudfw-2017-12-07-createnatfirewallcontrolpolicy).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        direction = config.get("direction")
        if direction is None:
            direction = "out"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_d_ei_wf_m = alicloud.vpc.Network("defaultDEiWfM",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        default_fhdm3_f = alicloud.vpc.Switch("defaultFHDM3F",
            vpc_id=default_d_ei_wf_m.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.2.0/24")
        default_mb_s2_ts = alicloud.vpc.NatGateway("defaultMbS2Ts",
            vpc_id=default_d_ei_wf_m.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_fhdm3_f.id,
            nat_type="Enhanced")
        port = alicloud.cloudfirewall.AddressBook("port",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "port",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "port",
                ]).result,
            group_type="port",
            address_lists=[
                "22/22",
                "23/23",
                "24/24",
            ])
        port_update = alicloud.cloudfirewall.AddressBook("port-update",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "port-update",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "port-update",
                ]).result,
            group_type="port",
            address_lists=[
                "22/22",
                "23/23",
                "24/24",
            ])
        domain = alicloud.cloudfirewall.AddressBook("domain",
            description=std.format(input="%s%s",
                args=[
                    name,
                    "domain",
                ]).result,
            group_name=std.format(input="%s%s",
                args=[
                    name,
                    "domain",
                ]).result,
            group_type="domain",
            address_lists=[
                "alibaba.com",
                "aliyun.com",
                "alicloud.com",
            ])
        ip = alicloud.cloudfirewall.AddressBook("ip",
            description=name,
            group_name=name,
            group_type="ip",
            address_lists=[
                "1.1.1.1/32",
                "2.2.2.2/32",
            ])
        default_nat_firewall_control_policy = alicloud.cloudfirewall.NatFirewallControlPolicy("default",
            application_name_lists=["ANY"],
            description=name,
            release="false",
            ip_version="4",
            repeat_days=[
                1,
                2,
                3,
            ],
            repeat_start_time="21:00",
            acl_action="log",
            dest_port_group=port.group_name,
            repeat_type="Weekly",
            nat_gateway_id=default_mb_s2_ts.id,
            source="1.1.1.1/32",
            direction="out",
            repeat_end_time="21:30",
            start_time=1699156800,
            destination="1.1.1.1/32",
            end_time=1888545600,
            source_type="net",
            proto="TCP",
            new_order="1",
            destination_type="net",
            dest_port_type="group",
            domain_resolve_type=0)
        ```

        ## Import

        Cloud Firewall Nat Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy example <acl_uuid>:<nat_gateway_id>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param NatFirewallControlPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatFirewallControlPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_order: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatFirewallControlPolicyArgs.__new__(NatFirewallControlPolicyArgs)

            if acl_action is None and not opts.urn:
                raise TypeError("Missing required property 'acl_action'")
            __props__.__dict__["acl_action"] = acl_action
            if application_name_lists is None and not opts.urn:
                raise TypeError("Missing required property 'application_name_lists'")
            __props__.__dict__["application_name_lists"] = application_name_lists
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["dest_port"] = dest_port
            __props__.__dict__["dest_port_group"] = dest_port_group
            __props__.__dict__["dest_port_type"] = dest_port_type
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["domain_resolve_type"] = domain_resolve_type
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["ip_version"] = ip_version
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            if new_order is None and not opts.urn:
                raise TypeError("Missing required property 'new_order'")
            __props__.__dict__["new_order"] = new_order
            if proto is None and not opts.urn:
                raise TypeError("Missing required property 'proto'")
            __props__.__dict__["proto"] = proto
            __props__.__dict__["release"] = release
            __props__.__dict__["repeat_days"] = repeat_days
            __props__.__dict__["repeat_end_time"] = repeat_end_time
            __props__.__dict__["repeat_start_time"] = repeat_start_time
            __props__.__dict__["repeat_type"] = repeat_type
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            if source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_type'")
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["acl_uuid"] = None
            __props__.__dict__["create_time"] = None
        super(NatFirewallControlPolicy, __self__).__init__(
            'alicloud:cloudfirewall/natFirewallControlPolicy:NatFirewallControlPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_action: Optional[pulumi.Input[_builtins.str]] = None,
            acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            domain_resolve_type: Optional[pulumi.Input[_builtins.int]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            new_order: Optional[pulumi.Input[_builtins.str]] = None,
            proto: Optional[pulumi.Input[_builtins.str]] = None,
            release: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'NatFirewallControlPolicy':
        """
        Get an existing NatFirewallControlPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
               - **accept**: Release
               - **drop**: Refused
               - **log**: Observation.
        :param pulumi.Input[_builtins.str] acl_uuid: The unique ID of the security access control policy.
               > **NOTE:**  To modify a security access control policy, you need to provide the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy interface to obtain the ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The list of application types supported by the access control policy.
        :param pulumi.Input[_builtins.int] create_time: The time when the policy was created.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port of traffic access in the access control policy. Value:
               - When the protocol type is set to ICMP, the value of DestPort is null.
               > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
               > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
               - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        :param pulumi.Input[_builtins.str] dest_port_group: The address book name of the destination port of the access traffic in the access control policy.
               > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        :param pulumi.Input[_builtins.str] dest_port_type: The destination port type of the access traffic in the security access control policy.
               - **port**: port
               - **group**: Port Address Book.
        :param pulumi.Input[_builtins.str] destination: The destination address segment in the access control policy. Valid values:
               - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
               - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
               - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
               - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        :param pulumi.Input[_builtins.str] destination_type: The destination address type in the access control policy. Valid values:
               - **net**: Destination Network segment (CIDR address)
               - **group**: Destination Address Book
               - **domain**: the destination domain name.
        :param pulumi.Input[_builtins.str] direction: The traffic direction of the access control policy. Valid values:
               - **out**: Internal and external traffic access control.
        :param pulumi.Input[_builtins.int] domain_resolve_type: The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
               - **0**: Based on FQDN
               - **1**: DNS-based dynamic resolution
               - **2**: dynamic resolution based on FQDN and DNS.
        :param pulumi.Input[_builtins.int] end_time: The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
               > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        :param pulumi.Input[_builtins.str] ip_version: Supported IP address version. Value:
               - **4** (default): indicates the IPv4 address.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of the NAT gateway instance.
        :param pulumi.Input[_builtins.str] new_order: The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        :param pulumi.Input[_builtins.str] proto: The security protocol type for traffic access in the access control policy. Valid values:
               - ANY (indicates that all protocol types are queried)
               - TCP
               - UDP
               - ICMP.
        :param pulumi.Input[_builtins.str] release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
               - **true**: Enable access control policy
               - **false**: Do not enable access control policies.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: Collection of recurring dates for the policy validity period of the access control policy.
               - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
               - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
               - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        :param pulumi.Input[_builtins.str] repeat_end_time: The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
               > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        :param pulumi.Input[_builtins.str] repeat_start_time: The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
               > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        :param pulumi.Input[_builtins.str] repeat_type: The type of repetition for the policy validity period of the access control policy. Value:
               - **Permit** (default): Always
               - **None**: Specify a single time
               - **Daily**: Daily
               - **Weekly**: Weekly
               - **Monthly**: Monthly.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy. Valid values:
               - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
               - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        :param pulumi.Input[_builtins.str] source_type: The source address type in the access control policy. Valid values:
               - **net**: the source network segment (CIDR address)
               - **group**: source address book
        :param pulumi.Input[_builtins.int] start_time: The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
               > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatFirewallControlPolicyState.__new__(_NatFirewallControlPolicyState)

        __props__.__dict__["acl_action"] = acl_action
        __props__.__dict__["acl_uuid"] = acl_uuid
        __props__.__dict__["application_name_lists"] = application_name_lists
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dest_port"] = dest_port
        __props__.__dict__["dest_port_group"] = dest_port_group
        __props__.__dict__["dest_port_type"] = dest_port_type
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["direction"] = direction
        __props__.__dict__["domain_resolve_type"] = domain_resolve_type
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_order"] = new_order
        __props__.__dict__["proto"] = proto
        __props__.__dict__["release"] = release
        __props__.__dict__["repeat_days"] = repeat_days
        __props__.__dict__["repeat_end_time"] = repeat_end_time
        __props__.__dict__["repeat_start_time"] = repeat_start_time
        __props__.__dict__["repeat_type"] = repeat_type
        __props__.__dict__["source"] = source
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["start_time"] = start_time
        return NatFirewallControlPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Output[_builtins.str]:
        """
        The method (action) of access traffic passing through Cloud Firewall in the security access control policy. Valid values:
        - **accept**: Release
        - **drop**: Refused
        - **log**: Observation.
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the security access control policy.
        > **NOTE:**  To modify a security access control policy, you need to provide the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy interface to obtain the ID.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of application types supported by the access control policy.
        """
        return pulumi.get(self, "application_name_lists")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when the policy was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Output[_builtins.str]:
        """
        The destination port of traffic access in the access control policy. Value:
        - When the protocol type is set to ICMP, the value of DestPort is null.
        > **NOTE:**  When the protocol type is ICMP, access control on the destination port is not supported.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) IS group, the value of DestPort is null.
        > **NOTE:**  When you select group (destination port address book) for the destination port type of the access control policy, you do not need to set a specific destination port number. All ports that need to be controlled by this access control policy are included in the destination port address book.
        - When the protocol type is TCP, UDP, or ANY, and the destination port type (DestPortType) is port, the value of DestPort is the destination port number.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The address book name of the destination port of the access traffic in the access control policy.
        > **NOTE:**  When DestPortType is set to group, you need to set the destination port address book name.
        """
        return pulumi.get(self, "dest_port_group")

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> pulumi.Output[_builtins.str]:
        """
        The destination port type of the access traffic in the security access control policy.
        - **port**: port
        - **group**: Port Address Book.
        """
        return pulumi.get(self, "dest_port_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        The destination address segment in the access control policy. Valid values:
        - When DestinationType is net, Destination is the Destination CIDR. For example: 1.2.XX.XX/24
        - When DestinationType IS group, Destination is the name of the Destination address book. For example: db_group
        - When DestinationType is domain, Destination is the Destination domain name. For example: * .aliyuncs.com
        - When DestinationType is location, Destination is the Destination region. For example: \\["BJ11", "ZB"\\].
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        The destination address type in the access control policy. Valid values:
        - **net**: Destination Network segment (CIDR address)
        - **group**: Destination Address Book
        - **domain**: the destination domain name.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.str]:
        """
        The traffic direction of the access control policy. Valid values:
        - **out**: Internal and external traffic access control.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The domain name resolution method of the access control policy. The policy is enabled by default after it is created. Valid values:
        - **0**: Based on FQDN
        - **1**: DNS-based dynamic resolution
        - **2**: dynamic resolution based on FQDN and DNS.
        """
        return pulumi.get(self, "domain_resolve_type")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The end time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. Must be full or half time and at least half an hour greater than the start time.
        > **NOTE:**  When RepeatType is set to permit, EndTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, EndTime must have a value and you need to set the end time.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Supported IP address version. Value:
        - **4** (default): indicates the IPv4 address.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the NAT gateway instance.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="newOrder")
    def new_order(self) -> pulumi.Output[_builtins.str]:
        """
        The priority for the access control policy to take effect. The priority number increases sequentially from 1, and the smaller the priority number, the higher the priority.
        """
        return pulumi.get(self, "new_order")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Output[_builtins.str]:
        """
        The security protocol type for traffic access in the access control policy. Valid values:
        - ANY (indicates that all protocol types are queried)
        - TCP
        - UDP
        - ICMP.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> pulumi.Output[_builtins.str]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
        - **true**: Enable access control policy
        - **false**: Do not enable access control policies.
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Collection of recurring dates for the policy validity period of the access control policy.
        - When RepeatType is 'Permanent', 'None', 'Daily', RepeatDays is an empty collection. For example:[]
        - When RepeatType is Weekly, RepeatDays cannot be empty. For example:["0", "6"]. When the RepeatType is set to Weekly, RepeatDays cannot be repeated.
        - RepeatDays cannot be empty when RepeatType is 'Monthly. For example:[1, 31]. When RepeatType is set to Monthly, RepeatDays cannot be repeated.
        """
        return pulumi.get(self, "repeat_days")

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The recurring end time of the policy validity period of the access control policy. For example: 23:30, it must be the whole point or half point time, and at least half an hour greater than the repeat start time.
        > **NOTE:**  When RepeatType is set to normal or None, RepeatEndTime is null. When the RepeatType is Daily, Weekly, or Monthly, the RepeatEndTime must have a value, and you need to set the repeat end time.
        """
        return pulumi.get(self, "repeat_end_time")

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The recurring start time of the policy validity period of the access control policy. For example: 08:00, it must be the whole point or half point time, and at least half an hour less than the repeat end time.
        > **NOTE:**  When RepeatType is set to permit or None, RepeatStartTime is empty. When the RepeatType is Daily, Weekly, or Monthly, the RepeatStartTime must have a value and you need to set the repeat start time.
        """
        return pulumi.get(self, "repeat_start_time")

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of repetition for the policy validity period of the access control policy. Value:
        - **Permit** (default): Always
        - **None**: Specify a single time
        - **Daily**: Daily
        - **Weekly**: Weekly
        - **Monthly**: Monthly.
        """
        return pulumi.get(self, "repeat_type")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        The source address in the access control policy. Valid values:
        - When **SourceType** is set to 'net', Source is the Source CIDR address. For example: 10.2.4.0/24
        - When **SourceType** is set to 'group', Source is the name of the Source address book. For example: db_group.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The source address type in the access control policy. Valid values:
        - **net**: the source network segment (CIDR address)
        - **group**: source address book
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The start time of the policy validity period of the access control policy. Expresses using the second-level timestamp format. It must be a full or half hour and at least half an hour less than the end time.
        > **NOTE:**  When RepeatType is set to normal, StartTime is null. When the RepeatType is None, Daily, Weekly, or Monthly, StartTime must have a value and you need to set the start time.
        """
        return pulumi.get(self, "start_time")

