# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ThreatIntelligenceSwitchArgs', 'ThreatIntelligenceSwitch']

@pulumi.input_type
class ThreatIntelligenceSwitchArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 category_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ThreatIntelligenceSwitch resource.
        :param pulumi.Input[_builtins.str] action: Rule action. Value:
        :param pulumi.Input[_builtins.str] category_id: The threat intelligence classification ID.
        :param pulumi.Input[_builtins.int] enable_status: Switch status. Value:
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if enable_status is not None:
            pulumi.set(__self__, "enable_status", enable_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule action. Value:
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The threat intelligence classification ID.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category_id", value)

    @_builtins.property
    @pulumi.getter(name="enableStatus")
    def enable_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Switch status. Value:
        """
        return pulumi.get(self, "enable_status")

    @enable_status.setter
    def enable_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_status", value)


@pulumi.input_type
class _ThreatIntelligenceSwitchState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 category_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ThreatIntelligenceSwitch resources.
        :param pulumi.Input[_builtins.str] action: Rule action. Value:
        :param pulumi.Input[_builtins.str] category_id: The threat intelligence classification ID.
        :param pulumi.Input[_builtins.int] enable_status: Switch status. Value:
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if enable_status is not None:
            pulumi.set(__self__, "enable_status", enable_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule action. Value:
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The threat intelligence classification ID.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category_id", value)

    @_builtins.property
    @pulumi.getter(name="enableStatus")
    def enable_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Switch status. Value:
        """
        return pulumi.get(self, "enable_status")

    @enable_status.setter
    def enable_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_status", value)


@pulumi.type_token("alicloud:cloudfirewall/threatIntelligenceSwitch:ThreatIntelligenceSwitch")
class ThreatIntelligenceSwitch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 category_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        Cloud Firewall Threat Intelligence Switch can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/threatIntelligenceSwitch:ThreatIntelligenceSwitch example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Rule action. Value:
        :param pulumi.Input[_builtins.str] category_id: The threat intelligence classification ID.
        :param pulumi.Input[_builtins.int] enable_status: Switch status. Value:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ThreatIntelligenceSwitchArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Cloud Firewall Threat Intelligence Switch can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/threatIntelligenceSwitch:ThreatIntelligenceSwitch example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ThreatIntelligenceSwitchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThreatIntelligenceSwitchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 category_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThreatIntelligenceSwitchArgs.__new__(ThreatIntelligenceSwitchArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["category_id"] = category_id
            __props__.__dict__["enable_status"] = enable_status
        super(ThreatIntelligenceSwitch, __self__).__init__(
            'alicloud:cloudfirewall/threatIntelligenceSwitch:ThreatIntelligenceSwitch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            category_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_status: Optional[pulumi.Input[_builtins.int]] = None) -> 'ThreatIntelligenceSwitch':
        """
        Get an existing ThreatIntelligenceSwitch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Rule action. Value:
        :param pulumi.Input[_builtins.str] category_id: The threat intelligence classification ID.
        :param pulumi.Input[_builtins.int] enable_status: Switch status. Value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThreatIntelligenceSwitchState.__new__(_ThreatIntelligenceSwitchState)

        __props__.__dict__["action"] = action
        __props__.__dict__["category_id"] = category_id
        __props__.__dict__["enable_status"] = enable_status
        return ThreatIntelligenceSwitch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule action. Value:
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> pulumi.Output[_builtins.str]:
        """
        The threat intelligence classification ID.
        """
        return pulumi.get(self, "category_id")

    @_builtins.property
    @pulumi.getter(name="enableStatus")
    def enable_status(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Switch status. Value:
        """
        return pulumi.get(self, "enable_status")

