# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceMetricAlarmRulesResult',
    'AwaitableGetServiceMetricAlarmRulesResult',
    'get_service_metric_alarm_rules',
    'get_service_metric_alarm_rules_output',
]

@pulumi.output_type
class GetServiceMetricAlarmRulesResult:
    """
    A collection of values returned by getServiceMetricAlarmRules.
    """
    def __init__(__self__, dimensions=None, id=None, ids=None, metric_name=None, namespace=None, output_file=None, rule_name=None, rules=None, status=None):
        if dimensions and not isinstance(dimensions, str):
            raise TypeError("Expected argument 'dimensions' to be a str")
        pulumi.set(__self__, "dimensions", dimensions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if metric_name and not isinstance(metric_name, str):
            raise TypeError("Expected argument 'metric_name' to be a str")
        pulumi.set(__self__, "metric_name", metric_name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rule_name and not isinstance(rule_name, str):
            raise TypeError("Expected argument 'rule_name' to be a str")
        pulumi.set(__self__, "rule_name", rule_name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if status and not isinstance(status, bool):
            raise TypeError("Expected argument 'status' to be a bool")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[_builtins.str]:
        """
        The dimensions of the alert rule.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[_builtins.str]:
        """
        The metric that is used to monitor the cloud service.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace of the cloud service.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[_builtins.str]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetServiceMetricAlarmRulesRuleResult']:
        """
        A list of Hybrid Double Writes. Each element contains the following attributes:
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the alert rule is enabled.
        """
        return pulumi.get(self, "status")


class AwaitableGetServiceMetricAlarmRulesResult(GetServiceMetricAlarmRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceMetricAlarmRulesResult(
            dimensions=self.dimensions,
            id=self.id,
            ids=self.ids,
            metric_name=self.metric_name,
            namespace=self.namespace,
            output_file=self.output_file,
            rule_name=self.rule_name,
            rules=self.rules,
            status=self.status)


def get_service_metric_alarm_rules(dimensions: Optional[_builtins.str] = None,
                                   ids: Optional[Sequence[_builtins.str]] = None,
                                   metric_name: Optional[_builtins.str] = None,
                                   namespace: Optional[_builtins.str] = None,
                                   output_file: Optional[_builtins.str] = None,
                                   rule_name: Optional[_builtins.str] = None,
                                   status: Optional[_builtins.bool] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceMetricAlarmRulesResult:
    """
    This data source provides the Cloud Monitor Service Metric Alarm Rules of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.256.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.ecs.get_instances(status="Running")
    default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
    default_alarm = alicloud.cms.Alarm("default",
        name=name,
        project="acs_ecs_dashboard",
        metric="disk_writebytes",
        period=900,
        silence_time=300,
        webhook="https://www.aliyun.com",
        enabled=True,
        contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
        effective_interval="06:00-20:00",
        metric_dimensions=f\"\"\"  [
        {{
          \\"instanceId\\": \\"{default.ids[0]}\\",
          \\"device\\": \\"/dev/vda1\\"
        }}
      ]
    \"\"\",
        escalations_critical={
            "statistics": "Average",
            "comparison_operator": "<=",
            "threshold": "90",
            "times": 1,
        },
        escalations_info={
            "statistics": "Minimum",
            "comparison_operator": "!=",
            "threshold": "20",
            "times": 3,
        },
        escalations_warn={
            "statistics": "Average",
            "comparison_operator": "==",
            "threshold": "30",
            "times": 5,
        })
    ids = alicloud.cloudmonitor.get_service_metric_alarm_rules_output(ids=[default_alarm.id])
    pulumi.export("cloudMonitorServiceMetricAlarmRulesId0", ids.rules[0].id)
    ```


    :param _builtins.str dimensions: The monitoring dimensions of the specified resource.
    :param Sequence[_builtins.str] ids: A list of Metric Alarm Rule IDs.
    :param _builtins.str metric_name: The name of the metric.
    :param _builtins.str namespace: The namespace of the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str rule_name: The name of the alert rule.
    :param _builtins.bool status: Specifies whether to query enabled or disabled alert rules. Valid values: `true`, `false`.
    """
    __args__ = dict()
    __args__['dimensions'] = dimensions
    __args__['ids'] = ids
    __args__['metricName'] = metric_name
    __args__['namespace'] = namespace
    __args__['outputFile'] = output_file
    __args__['ruleName'] = rule_name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudmonitor/getServiceMetricAlarmRules:getServiceMetricAlarmRules', __args__, opts=opts, typ=GetServiceMetricAlarmRulesResult).value

    return AwaitableGetServiceMetricAlarmRulesResult(
        dimensions=pulumi.get(__ret__, 'dimensions'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        metric_name=pulumi.get(__ret__, 'metric_name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rule_name=pulumi.get(__ret__, 'rule_name'),
        rules=pulumi.get(__ret__, 'rules'),
        status=pulumi.get(__ret__, 'status'))
def get_service_metric_alarm_rules_output(dimensions: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          metric_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          rule_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          status: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceMetricAlarmRulesResult]:
    """
    This data source provides the Cloud Monitor Service Metric Alarm Rules of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.256.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.ecs.get_instances(status="Running")
    default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
    default_alarm = alicloud.cms.Alarm("default",
        name=name,
        project="acs_ecs_dashboard",
        metric="disk_writebytes",
        period=900,
        silence_time=300,
        webhook="https://www.aliyun.com",
        enabled=True,
        contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
        effective_interval="06:00-20:00",
        metric_dimensions=f\"\"\"  [
        {{
          \\"instanceId\\": \\"{default.ids[0]}\\",
          \\"device\\": \\"/dev/vda1\\"
        }}
      ]
    \"\"\",
        escalations_critical={
            "statistics": "Average",
            "comparison_operator": "<=",
            "threshold": "90",
            "times": 1,
        },
        escalations_info={
            "statistics": "Minimum",
            "comparison_operator": "!=",
            "threshold": "20",
            "times": 3,
        },
        escalations_warn={
            "statistics": "Average",
            "comparison_operator": "==",
            "threshold": "30",
            "times": 5,
        })
    ids = alicloud.cloudmonitor.get_service_metric_alarm_rules_output(ids=[default_alarm.id])
    pulumi.export("cloudMonitorServiceMetricAlarmRulesId0", ids.rules[0].id)
    ```


    :param _builtins.str dimensions: The monitoring dimensions of the specified resource.
    :param Sequence[_builtins.str] ids: A list of Metric Alarm Rule IDs.
    :param _builtins.str metric_name: The name of the metric.
    :param _builtins.str namespace: The namespace of the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str rule_name: The name of the alert rule.
    :param _builtins.bool status: Specifies whether to query enabled or disabled alert rules. Valid values: `true`, `false`.
    """
    __args__ = dict()
    __args__['dimensions'] = dimensions
    __args__['ids'] = ids
    __args__['metricName'] = metric_name
    __args__['namespace'] = namespace
    __args__['outputFile'] = output_file
    __args__['ruleName'] = rule_name
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudmonitor/getServiceMetricAlarmRules:getServiceMetricAlarmRules', __args__, opts=opts, typ=GetServiceMetricAlarmRulesResult)
    return __ret__.apply(lambda __response__: GetServiceMetricAlarmRulesResult(
        dimensions=pulumi.get(__response__, 'dimensions'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        metric_name=pulumi.get(__response__, 'metric_name'),
        namespace=pulumi.get(__response__, 'namespace'),
        output_file=pulumi.get(__response__, 'output_file'),
        rule_name=pulumi.get(__response__, 'rule_name'),
        rules=pulumi.get(__response__, 'rules'),
        status=pulumi.get(__response__, 'status')))
