# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserProvisioningEventsResult',
    'AwaitableGetUserProvisioningEventsResult',
    'get_user_provisioning_events',
    'get_user_provisioning_events_output',
]

@pulumi.output_type
class GetUserProvisioningEventsResult:
    """
    A collection of values returned by getUserProvisioningEvents.
    """
    def __init__(__self__, directory_id=None, events=None, id=None, ids=None, output_file=None, user_provisioning_id=None):
        if directory_id and not isinstance(directory_id, str):
            raise TypeError("Expected argument 'directory_id' to be a str")
        pulumi.set(__self__, "directory_id", directory_id)
        if events and not isinstance(events, list):
            raise TypeError("Expected argument 'events' to be a list")
        pulumi.set(__self__, "events", events)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if user_provisioning_id and not isinstance(user_provisioning_id, str):
            raise TypeError("Expected argument 'user_provisioning_id' to be a str")
        pulumi.set(__self__, "user_provisioning_id", user_provisioning_id)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        Directory ID
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetUserProvisioningEventsEventResult']:
        """
        A list of User Provisioning Event Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Provisioning Event IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="userProvisioningId")
    def user_provisioning_id(self) -> Optional[_builtins.str]:
        """
        The ID of the User Provisioning.
        """
        return pulumi.get(self, "user_provisioning_id")


class AwaitableGetUserProvisioningEventsResult(GetUserProvisioningEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserProvisioningEventsResult(
            directory_id=self.directory_id,
            events=self.events,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            user_provisioning_id=self.user_provisioning_id)


def get_user_provisioning_events(directory_id: Optional[_builtins.str] = None,
                                 ids: Optional[Sequence[_builtins.str]] = None,
                                 output_file: Optional[_builtins.str] = None,
                                 user_provisioning_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserProvisioningEventsResult:
    """
    This data source provides Cloud Sso User Provisioning Event available to the user.[What is User Provisioning Event](https://next.api.alibabacloud.com/document/cloudsso/2021-05-15/GetUserProvisioningEvent)

    > **NOTE:** Available since v1.261.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_q_sr_gmc = alicloud.cloudsso.Directory("defaultQSrGmc",
        directory_global_access_status="Disabled",
        password_policy={
            "min_password_length": 8,
            "min_password_different_chars": 8,
            "max_password_age": 90,
            "password_reuse_prevention": 1,
            "max_login_attempts": 5,
        },
        mfa_authentication_setting_info={
            "mfa_authentication_advance_settings": "OnlyRiskyLogin",
            "operation_for_risk_login": "EnforceVerify",
        },
        directory_name="tfexample")
    default = alicloud.cloudsso.get_user_provisioning_events_output(directory_id=default_q_sr_gmc.id)
    pulumi.export("alicloudCloudSsoUserProvisioningEventExampleId", default.events[0].id)
    ```


    :param _builtins.str directory_id: Directory ID
    :param Sequence[_builtins.str] ids: A list of User Provisioning Event IDs. The value is formulated as `<directory_id>:<event_id>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str user_provisioning_id: The ID of the User Provisioning.
    """
    __args__ = dict()
    __args__['directoryId'] = directory_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['userProvisioningId'] = user_provisioning_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudsso/getUserProvisioningEvents:getUserProvisioningEvents', __args__, opts=opts, typ=GetUserProvisioningEventsResult).value

    return AwaitableGetUserProvisioningEventsResult(
        directory_id=pulumi.get(__ret__, 'directory_id'),
        events=pulumi.get(__ret__, 'events'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        user_provisioning_id=pulumi.get(__ret__, 'user_provisioning_id'))
def get_user_provisioning_events_output(directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        user_provisioning_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserProvisioningEventsResult]:
    """
    This data source provides Cloud Sso User Provisioning Event available to the user.[What is User Provisioning Event](https://next.api.alibabacloud.com/document/cloudsso/2021-05-15/GetUserProvisioningEvent)

    > **NOTE:** Available since v1.261.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_q_sr_gmc = alicloud.cloudsso.Directory("defaultQSrGmc",
        directory_global_access_status="Disabled",
        password_policy={
            "min_password_length": 8,
            "min_password_different_chars": 8,
            "max_password_age": 90,
            "password_reuse_prevention": 1,
            "max_login_attempts": 5,
        },
        mfa_authentication_setting_info={
            "mfa_authentication_advance_settings": "OnlyRiskyLogin",
            "operation_for_risk_login": "EnforceVerify",
        },
        directory_name="tfexample")
    default = alicloud.cloudsso.get_user_provisioning_events_output(directory_id=default_q_sr_gmc.id)
    pulumi.export("alicloudCloudSsoUserProvisioningEventExampleId", default.events[0].id)
    ```


    :param _builtins.str directory_id: Directory ID
    :param Sequence[_builtins.str] ids: A list of User Provisioning Event IDs. The value is formulated as `<directory_id>:<event_id>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str user_provisioning_id: The ID of the User Provisioning.
    """
    __args__ = dict()
    __args__['directoryId'] = directory_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['userProvisioningId'] = user_provisioning_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudsso/getUserProvisioningEvents:getUserProvisioningEvents', __args__, opts=opts, typ=GetUserProvisioningEventsResult)
    return __ret__.apply(lambda __response__: GetUserProvisioningEventsResult(
        directory_id=pulumi.get(__response__, 'directory_id'),
        events=pulumi.get(__response__, 'events'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        user_provisioning_id=pulumi.get(__response__, 'user_provisioning_id')))
