# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserAttachmentArgs', 'UserAttachment']

@pulumi.input_type
class UserAttachmentArgs:
    def __init__(__self__, *,
                 directory_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UserAttachment resource.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory.
        :param pulumi.Input[_builtins.str] group_id: The ID of the group.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserAttachmentState:
    def __init__(__self__, *,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserAttachment resources.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory.
        :param pulumi.Input[_builtins.str] group_id: The ID of the group.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("alicloud:cloudsso/userAttachment:UserAttachment")
class UserAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud SSO User Attachment resource.

        For information about Cloud SSO User Attachment and how to use it, see [What is User Attachment](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addusertogroup).

        > **NOTE:** Available since v1.141.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_directory = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        directory_id = len(default.ids).apply(lambda length: default.ids[0] if length > 0 else std.concat(input=[
            [__item.id for __item in default_directory],
            [""],
        ]).result[0])
        default_user = alicloud.cloudsso.User("default",
            directory_id=directory_id,
            user_name=f"{name}-{default_integer['result']}")
        default_group = alicloud.cloudsso.Group("default",
            directory_id=directory_id,
            group_name=name,
            description=name)
        default_user_attachment = alicloud.cloudsso.UserAttachment("default",
            directory_id=directory_id,
            user_id=default_user.user_id,
            group_id=default_group.group_id)
        ```

        ## Import

        Cloud SSO User Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/userAttachment:UserAttachment example <directory_id>:<group_id>:<user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory.
        :param pulumi.Input[_builtins.str] group_id: The ID of the group.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud SSO User Attachment resource.

        For information about Cloud SSO User Attachment and how to use it, see [What is User Attachment](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addusertogroup).

        > **NOTE:** Available since v1.141.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_directory = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))

        len(default.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        directory_id = len(default.ids).apply(lambda length: default.ids[0] if length > 0 else std.concat(input=[
            [__item.id for __item in default_directory],
            [""],
        ]).result[0])
        default_user = alicloud.cloudsso.User("default",
            directory_id=directory_id,
            user_name=f"{name}-{default_integer['result']}")
        default_group = alicloud.cloudsso.Group("default",
            directory_id=directory_id,
            group_name=name,
            description=name)
        default_user_attachment = alicloud.cloudsso.UserAttachment("default",
            directory_id=directory_id,
            user_id=default_user.user_id,
            group_id=default_group.group_id)
        ```

        ## Import

        Cloud SSO User Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/userAttachment:UserAttachment example <directory_id>:<group_id>:<user_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAttachmentArgs.__new__(UserAttachmentArgs)

            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserAttachment, __self__).__init__(
            'alicloud:cloudsso/userAttachment:UserAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserAttachment':
        """
        Get an existing UserAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory.
        :param pulumi.Input[_builtins.str] group_id: The ID of the group.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAttachmentState.__new__(_UserAttachmentState)

        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["user_id"] = user_id
        return UserAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

