# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserProvisioningArgs', 'UserProvisioning']

@pulumi.input_type
class UserProvisioningArgs:
    def __init__(__self__, *,
                 deletion_strategy: pulumi.Input[_builtins.str],
                 directory_id: pulumi.Input[_builtins.str],
                 duplication_strategy: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str],
                 target_id: pulumi.Input[_builtins.str],
                 target_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserProvisioning resource.
        :param pulumi.Input[_builtins.str] deletion_strategy: The processing policy for users who have been synchronized when deleting synchronization
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory to which the synchronization belongs
        :param pulumi.Input[_builtins.str] duplication_strategy: Processing Policy for Synchronization Conflicts
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] principal_type: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_id: The ID of the destination associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_type: The target type associated with the synchronization
        :param pulumi.Input[_builtins.str] description: Description of User Synchronization
        """
        pulumi.set(__self__, "deletion_strategy", deletion_strategy)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "duplication_strategy", duplication_strategy)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_type", target_type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="deletionStrategy")
    def deletion_strategy(self) -> pulumi.Input[_builtins.str]:
        """
        The processing policy for users who have been synchronized when deleting synchronization
        """
        return pulumi.get(self, "deletion_strategy")

    @deletion_strategy.setter
    def deletion_strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "deletion_strategy", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the directory to which the synchronization belongs
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="duplicationStrategy")
    def duplication_strategy(self) -> pulumi.Input[_builtins.str]:
        """
        Processing Policy for Synchronization Conflicts
        """
        return pulumi.get(self, "duplication_strategy")

    @duplication_strategy.setter
    def duplication_strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "duplication_strategy", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the destination associated with the synchronization.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[_builtins.str]:
        """
        The target type associated with the synchronization
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of User Synchronization
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _UserProvisioningState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_provisioning_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_provisioning_statistics: Optional[pulumi.Input[Sequence[pulumi.Input['UserProvisioningUserProvisioningStatisticArgs']]]] = None):
        """
        Input properties used for looking up and filtering UserProvisioning resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the synchronization
        :param pulumi.Input[_builtins.str] deletion_strategy: The processing policy for users who have been synchronized when deleting synchronization
        :param pulumi.Input[_builtins.str] description: Description of User Synchronization
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory to which the synchronization belongs
        :param pulumi.Input[_builtins.str] duplication_strategy: Processing Policy for Synchronization Conflicts
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] principal_type: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] target_id: The ID of the destination associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_type: The target type associated with the synchronization
        :param pulumi.Input[_builtins.str] user_provisioning_id: The first ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input['UserProvisioningUserProvisioningStatisticArgs']]] user_provisioning_statistics: User Provisioning statistics
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_strategy is not None:
            pulumi.set(__self__, "deletion_strategy", deletion_strategy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if duplication_strategy is not None:
            pulumi.set(__self__, "duplication_strategy", duplication_strategy)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if user_provisioning_id is not None:
            pulumi.set(__self__, "user_provisioning_id", user_provisioning_id)
        if user_provisioning_statistics is not None:
            pulumi.set(__self__, "user_provisioning_statistics", user_provisioning_statistics)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the synchronization
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionStrategy")
    def deletion_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The processing policy for users who have been synchronized when deleting synchronization
        """
        return pulumi.get(self, "deletion_strategy")

    @deletion_strategy.setter
    def deletion_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_strategy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of User Synchronization
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the directory to which the synchronization belongs
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="duplicationStrategy")
    def duplication_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Processing Policy for Synchronization Conflicts
        """
        return pulumi.get(self, "duplication_strategy")

    @duplication_strategy.setter
    def duplication_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duplication_strategy", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the destination associated with the synchronization.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target type associated with the synchronization
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="userProvisioningId")
    def user_provisioning_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "user_provisioning_id")

    @user_provisioning_id.setter
    def user_provisioning_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_provisioning_id", value)

    @_builtins.property
    @pulumi.getter(name="userProvisioningStatistics")
    def user_provisioning_statistics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserProvisioningUserProvisioningStatisticArgs']]]]:
        """
        User Provisioning statistics
        """
        return pulumi.get(self, "user_provisioning_statistics")

    @user_provisioning_statistics.setter
    def user_provisioning_statistics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserProvisioningUserProvisioningStatisticArgs']]]]):
        pulumi.set(self, "user_provisioning_statistics", value)


@pulumi.type_token("alicloud:cloudsso/userProvisioning:UserProvisioning")
class UserProvisioning(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud SSO User Provisioning resource.

        RAM user synchronization.

        For information about Cloud SSO User Provisioning and how to use it, see [What is User Provisioning](https://next.api.alibabacloud.com/document/cloudsso/2021-05-15/CreateUserProvisioning).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_account()
        default_get_directories = alicloud.cloudsso.get_directories()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_directory = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))

        len(default_get_directories.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        directory_id = len(default_get_directories.ids).apply(lambda length: default_get_directories.ids[0] if length > 0 else std.concat(input=[
            [__item.id for __item in default_directory],
            [""],
        ]).result[0])
        default_user = alicloud.cloudsso.User("default",
            directory_id=directory_id,
            user_name=f"{name}-{default_integer['result']}")
        default_group = alicloud.cloudsso.Group("default",
            directory_id=directory_id,
            group_name=name,
            description=name)
        default_user_provisioning = alicloud.cloudsso.UserProvisioning("default",
            description="description",
            principal_id=default_user.user_id,
            target_type="RD-Account",
            deletion_strategy="Keep",
            duplication_strategy="KeepBoth",
            principal_type="User",
            target_id=default.id,
            directory_id=default_user.directory_id)
        ```

        ## Import

        Cloud SSO User Provisioning can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/userProvisioning:UserProvisioning example <directory_id>:<user_provisioning_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deletion_strategy: The processing policy for users who have been synchronized when deleting synchronization
        :param pulumi.Input[_builtins.str] description: Description of User Synchronization
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory to which the synchronization belongs
        :param pulumi.Input[_builtins.str] duplication_strategy: Processing Policy for Synchronization Conflicts
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] principal_type: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_id: The ID of the destination associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_type: The target type associated with the synchronization
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserProvisioningArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud SSO User Provisioning resource.

        RAM user synchronization.

        For information about Cloud SSO User Provisioning and how to use it, see [What is User Provisioning](https://next.api.alibabacloud.com/document/cloudsso/2021-05-15/CreateUserProvisioning).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_account()
        default_get_directories = alicloud.cloudsso.get_directories()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_directory = []
        def create_default(range_body):
            for range in [{"value": i} for i in range(0, range_body)]:
                default_directory.append(alicloud.cloudsso.Directory(f"default-{range['value']}", directory_name=name))

        len(default_get_directories.ids).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
        directory_id = len(default_get_directories.ids).apply(lambda length: default_get_directories.ids[0] if length > 0 else std.concat(input=[
            [__item.id for __item in default_directory],
            [""],
        ]).result[0])
        default_user = alicloud.cloudsso.User("default",
            directory_id=directory_id,
            user_name=f"{name}-{default_integer['result']}")
        default_group = alicloud.cloudsso.Group("default",
            directory_id=directory_id,
            group_name=name,
            description=name)
        default_user_provisioning = alicloud.cloudsso.UserProvisioning("default",
            description="description",
            principal_id=default_user.user_id,
            target_type="RD-Account",
            deletion_strategy="Keep",
            duplication_strategy="KeepBoth",
            principal_type="User",
            target_id=default.id,
            directory_id=default_user.directory_id)
        ```

        ## Import

        Cloud SSO User Provisioning can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/userProvisioning:UserProvisioning example <directory_id>:<user_provisioning_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserProvisioningArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserProvisioningArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserProvisioningArgs.__new__(UserProvisioningArgs)

            if deletion_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'deletion_strategy'")
            __props__.__dict__["deletion_strategy"] = deletion_strategy
            __props__.__dict__["description"] = description
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            if duplication_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'duplication_strategy'")
            __props__.__dict__["duplication_strategy"] = duplication_strategy
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user_provisioning_id"] = None
            __props__.__dict__["user_provisioning_statistics"] = None
        super(UserProvisioning, __self__).__init__(
            'alicloud:cloudsso/userProvisioning:UserProvisioning',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            duplication_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_type: Optional[pulumi.Input[_builtins.str]] = None,
            user_provisioning_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_provisioning_statistics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserProvisioningUserProvisioningStatisticArgs', 'UserProvisioningUserProvisioningStatisticArgsDict']]]]] = None) -> 'UserProvisioning':
        """
        Get an existing UserProvisioning resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the synchronization
        :param pulumi.Input[_builtins.str] deletion_strategy: The processing policy for users who have been synchronized when deleting synchronization
        :param pulumi.Input[_builtins.str] description: Description of User Synchronization
        :param pulumi.Input[_builtins.str] directory_id: The ID of the directory to which the synchronization belongs
        :param pulumi.Input[_builtins.str] duplication_strategy: Processing Policy for Synchronization Conflicts
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] principal_type: The ID of the CloudSSO user/group associated with the synchronization.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] target_id: The ID of the destination associated with the synchronization.
        :param pulumi.Input[_builtins.str] target_type: The target type associated with the synchronization
        :param pulumi.Input[_builtins.str] user_provisioning_id: The first ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserProvisioningUserProvisioningStatisticArgs', 'UserProvisioningUserProvisioningStatisticArgsDict']]]] user_provisioning_statistics: User Provisioning statistics
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserProvisioningState.__new__(_UserProvisioningState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_strategy"] = deletion_strategy
        __props__.__dict__["description"] = description
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["duplication_strategy"] = duplication_strategy
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["status"] = status
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["user_provisioning_id"] = user_provisioning_id
        __props__.__dict__["user_provisioning_statistics"] = user_provisioning_statistics
        return UserProvisioning(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the synchronization
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionStrategy")
    def deletion_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The processing policy for users who have been synchronized when deleting synchronization
        """
        return pulumi.get(self, "deletion_strategy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of User Synchronization
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the directory to which the synchronization belongs
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="duplicationStrategy")
    def duplication_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Processing Policy for Synchronization Conflicts
        """
        return pulumi.get(self, "duplication_strategy")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CloudSSO user/group associated with the synchronization.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the destination associated with the synchronization.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[_builtins.str]:
        """
        The target type associated with the synchronization
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter(name="userProvisioningId")
    def user_provisioning_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "user_provisioning_id")

    @_builtins.property
    @pulumi.getter(name="userProvisioningStatistics")
    def user_provisioning_statistics(self) -> pulumi.Output[Sequence['outputs.UserProvisioningUserProvisioningStatistic']]:
        """
        User Provisioning statistics
        """
        return pulumi.get(self, "user_provisioning_statistics")

