# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayLoggingArgs', 'GatewayLogging']

@pulumi.input_type
class GatewayLoggingArgs:
    def __init__(__self__, *,
                 gateway_id: pulumi.Input[_builtins.str],
                 sls_logstore: pulumi.Input[_builtins.str],
                 sls_project: pulumi.Input[_builtins.str],
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayLogging resource.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Gateway.
        :param pulumi.Input[_builtins.str] sls_logstore: The name of the Log Store.
        :param pulumi.Input[_builtins.str] sls_project: The name of the Project.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "sls_logstore", sls_logstore)
        pulumi.set(__self__, "sls_project", sls_project)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="slsLogstore")
    def sls_logstore(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_logstore")

    @sls_logstore.setter
    def sls_logstore(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sls_logstore", value)

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Project.
        """
        return pulumi.get(self, "sls_project")

    @sls_project.setter
    def sls_project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sls_project", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _GatewayLoggingState:
    def __init__(__self__, *,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayLogging resources.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Gateway.
        :param pulumi.Input[_builtins.str] sls_logstore: The name of the Log Store.
        :param pulumi.Input[_builtins.str] sls_project: The name of the Project.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if sls_logstore is not None:
            pulumi.set(__self__, "sls_logstore", sls_logstore)
        if sls_project is not None:
            pulumi.set(__self__, "sls_project", sls_project)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="slsLogstore")
    def sls_logstore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_logstore")

    @sls_logstore.setter
    def sls_logstore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_logstore", value)

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Project.
        """
        return pulumi.get(self, "sls_project")

    @sls_project.setter
    def sls_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_project", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging")
class GatewayLogging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway Gateway Logging resource.

        For information about Cloud Storage Gateway Gateway Logging and how to use it, see [What is Gateway Logging](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaylogging).

        > **NOTE:** Available since v1.144.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_uuid = random.index.Uuid("default")
        default_storage_bundle = alicloud.cloudstoragegateway.StorageBundle("default", storage_bundle_name=std.substr(input=f"tf-example-{std.replace(text=default_uuid['result'],
                search='-',
                replace='').result}",
            offset=0,
            length=16).result)
        default_project = alicloud.log.Project("default",
            project_name=std.substr(input=f"tf-example-{std.replace(text=default_uuid['result'],
                    search='-',
                    replace='').result}",
                offset=0,
                length=16).result,
            description="terraform-example")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name=name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_gateway = alicloud.cloudstoragegateway.Gateway("default",
            gateway_name=name,
            description=name,
            gateway_class="Standard",
            type="File",
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            release_after_expiration=False,
            public_network_bandwidth=40,
            storage_bundle_id=default_storage_bundle.id,
            location="Cloud")
        default_gateway_logging = alicloud.cloudstoragegateway.GatewayLogging("default",
            gateway_id=default_gateway.id,
            sls_logstore=default_store.logstore_name,
            sls_project=default_project.project_name)
        ```

        ## Import

        Cloud Storage Gateway Gateway Logging can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging example <gateway_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Gateway.
        :param pulumi.Input[_builtins.str] sls_logstore: The name of the Log Store.
        :param pulumi.Input[_builtins.str] sls_project: The name of the Project.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayLoggingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway Gateway Logging resource.

        For information about Cloud Storage Gateway Gateway Logging and how to use it, see [What is Gateway Logging](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaylogging).

        > **NOTE:** Available since v1.144.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_uuid = random.index.Uuid("default")
        default_storage_bundle = alicloud.cloudstoragegateway.StorageBundle("default", storage_bundle_name=std.substr(input=f"tf-example-{std.replace(text=default_uuid['result'],
                search='-',
                replace='').result}",
            offset=0,
            length=16).result)
        default_project = alicloud.log.Project("default",
            project_name=std.substr(input=f"tf-example-{std.replace(text=default_uuid['result'],
                    search='-',
                    replace='').result}",
                offset=0,
                length=16).result,
            description="terraform-example")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name=name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_gateway = alicloud.cloudstoragegateway.Gateway("default",
            gateway_name=name,
            description=name,
            gateway_class="Standard",
            type="File",
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            release_after_expiration=False,
            public_network_bandwidth=40,
            storage_bundle_id=default_storage_bundle.id,
            location="Cloud")
        default_gateway_logging = alicloud.cloudstoragegateway.GatewayLogging("default",
            gateway_id=default_gateway.id,
            sls_logstore=default_store.logstore_name,
            sls_project=default_project.project_name)
        ```

        ## Import

        Cloud Storage Gateway Gateway Logging can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging example <gateway_id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayLoggingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayLoggingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayLoggingArgs.__new__(GatewayLoggingArgs)

            if gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_id'")
            __props__.__dict__["gateway_id"] = gateway_id
            if sls_logstore is None and not opts.urn:
                raise TypeError("Missing required property 'sls_logstore'")
            __props__.__dict__["sls_logstore"] = sls_logstore
            if sls_project is None and not opts.urn:
                raise TypeError("Missing required property 'sls_project'")
            __props__.__dict__["sls_project"] = sls_project
            __props__.__dict__["status"] = status
        super(GatewayLogging, __self__).__init__(
            'alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            sls_logstore: Optional[pulumi.Input[_builtins.str]] = None,
            sls_project: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayLogging':
        """
        Get an existing GatewayLogging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Gateway.
        :param pulumi.Input[_builtins.str] sls_logstore: The name of the Log Store.
        :param pulumi.Input[_builtins.str] sls_project: The name of the Project.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayLoggingState.__new__(_GatewayLoggingState)

        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["sls_logstore"] = sls_logstore
        __props__.__dict__["sls_project"] = sls_project
        __props__.__dict__["status"] = status
        return GatewayLogging(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="slsLogstore")
    def sls_logstore(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_logstore")

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Project.
        """
        return pulumi.get(self, "sls_project")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `Enabled`, `Disable`.
        """
        return pulumi.get(self, "status")

