# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSiteMonitorsResult',
    'AwaitableGetSiteMonitorsResult',
    'get_site_monitors',
    'get_site_monitors_output',
]

@pulumi.output_type
class GetSiteMonitorsResult:
    """
    A collection of values returned by getSiteMonitors.
    """
    def __init__(__self__, id=None, ids=None, monitors=None, output_file=None, task_id=None, task_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if monitors and not isinstance(monitors, list):
            raise TypeError("Expected argument 'monitors' to be a list")
        pulumi.set(__self__, "monitors", monitors)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if task_id and not isinstance(task_id, str):
            raise TypeError("Expected argument 'task_id' to be a str")
        pulumi.set(__self__, "task_id", task_id)
        if task_type and not isinstance(task_type, str):
            raise TypeError("Expected argument 'task_type' to be a str")
        pulumi.set(__self__, "task_type", task_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Site Monitor IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Sequence['outputs.GetSiteMonitorsMonitorResult']:
        """
        A list of Site Monitor Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[_builtins.str]:
        """
        Task Id.
        """
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[_builtins.str]:
        """
        Task Type.
        """
        return pulumi.get(self, "task_type")


class AwaitableGetSiteMonitorsResult(GetSiteMonitorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSiteMonitorsResult(
            id=self.id,
            ids=self.ids,
            monitors=self.monitors,
            output_file=self.output_file,
            task_id=self.task_id,
            task_type=self.task_type)


def get_site_monitors(ids: Optional[Sequence[_builtins.str]] = None,
                      output_file: Optional[_builtins.str] = None,
                      task_id: Optional[_builtins.str] = None,
                      task_type: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSiteMonitorsResult:
    """
    This data source provides Cloud Monitor Service Site Monitor available to the user.[What is Site Monitor](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor)

    > **NOTE:** Available since v1.224.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf_example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default_site_monitor = alicloud.cms.SiteMonitor("default",
        address="http://www.alibabacloud.com",
        task_name=f"terraform-example-{default_integer['result']}",
        task_type="HTTP",
        interval="5",
        isp_cities=[{
            "city": "546",
            "isp": "465",
        }],
        options_json=\"\"\"{
        \\"http_method\\": \\"get\\",
        \\"waitTime_after_completion\\": null,
        \\"ipv6_task\\": false,
        \\"diagnosis_ping\\": false,
        \\"diagnosis_mtr\\": false,
        \\"assertions\\": [
            {
                \\"operator\\": \\"lessThan\\",
                \\"type\\": \\"response_time\\",
                \\"target\\": 1000
            }
        ],
        \\"time_out\\": 30000
    }
    \"\"\")
    default = alicloud.cms.get_site_monitors_output(ids=[default_site_monitor.id],
        task_type="HTTP")
    pulumi.export("alicloudCmsSiteMonitorExampleId", default.monitors[0].task_id)
    ```


    :param Sequence[_builtins.str] ids: A list of Site Monitor IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str task_id: Task ID.
    :param _builtins.str task_type: Task Type.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['taskId'] = task_id
    __args__['taskType'] = task_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cms/getSiteMonitors:getSiteMonitors', __args__, opts=opts, typ=GetSiteMonitorsResult).value

    return AwaitableGetSiteMonitorsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        monitors=pulumi.get(__ret__, 'monitors'),
        output_file=pulumi.get(__ret__, 'output_file'),
        task_id=pulumi.get(__ret__, 'task_id'),
        task_type=pulumi.get(__ret__, 'task_type'))
def get_site_monitors_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             task_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             task_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSiteMonitorsResult]:
    """
    This data source provides Cloud Monitor Service Site Monitor available to the user.[What is Site Monitor](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor)

    > **NOTE:** Available since v1.224.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf_example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default_site_monitor = alicloud.cms.SiteMonitor("default",
        address="http://www.alibabacloud.com",
        task_name=f"terraform-example-{default_integer['result']}",
        task_type="HTTP",
        interval="5",
        isp_cities=[{
            "city": "546",
            "isp": "465",
        }],
        options_json=\"\"\"{
        \\"http_method\\": \\"get\\",
        \\"waitTime_after_completion\\": null,
        \\"ipv6_task\\": false,
        \\"diagnosis_ping\\": false,
        \\"diagnosis_mtr\\": false,
        \\"assertions\\": [
            {
                \\"operator\\": \\"lessThan\\",
                \\"type\\": \\"response_time\\",
                \\"target\\": 1000
            }
        ],
        \\"time_out\\": 30000
    }
    \"\"\")
    default = alicloud.cms.get_site_monitors_output(ids=[default_site_monitor.id],
        task_type="HTTP")
    pulumi.export("alicloudCmsSiteMonitorExampleId", default.monitors[0].task_id)
    ```


    :param Sequence[_builtins.str] ids: A list of Site Monitor IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str task_id: Task ID.
    :param _builtins.str task_type: Task Type.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['taskId'] = task_id
    __args__['taskType'] = task_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cms/getSiteMonitors:getSiteMonitors', __args__, opts=opts, typ=GetSiteMonitorsResult)
    return __ret__.apply(lambda __response__: GetSiteMonitorsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        monitors=pulumi.get(__response__, 'monitors'),
        output_file=pulumi.get(__response__, 'output_file'),
        task_id=pulumi.get(__response__, 'task_id'),
        task_type=pulumi.get(__response__, 'task_type')))
