# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricRuleBlackListArgs', 'MetricRuleBlackList']

@pulumi.input_type
class MetricRuleBlackListArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 instances: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 metric_rule_black_list_name: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]] = None,
                 scope_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MetricRuleBlackList resource.
        :param pulumi.Input[_builtins.str] category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The list of instances of cloud services specified in the alert blacklist policy.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_name: The name of the alert blacklist policy.
        :param pulumi.Input[_builtins.str] namespace: The data namespace of the cloud service.
        :param pulumi.Input[_builtins.str] effective_time: The effective time range of the alert blacklist policy.
        :param pulumi.Input[_builtins.str] enable_end_time: The start timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] enable_start_time: The end timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.bool] is_enable: The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        :param pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]] metrics: Monitoring metrics in the instance. See `metrics` below.
        :param pulumi.Input[_builtins.str] scope_type: The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_values: Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "metric_rule_black_list_name", metric_rule_black_list_name)
        pulumi.set(__self__, "namespace", namespace)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if enable_end_time is not None:
            pulumi.set(__self__, "enable_end_time", enable_end_time)
        if enable_start_time is not None:
            pulumi.set(__self__, "enable_start_time", enable_start_time)
        if is_enable is not None:
            pulumi.set(__self__, "is_enable", is_enable)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if scope_type is not None:
            pulumi.set(__self__, "scope_type", scope_type)
        if scope_values is not None:
            pulumi.set(__self__, "scope_values", scope_values)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of instances of cloud services specified in the alert blacklist policy.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListName")
    def metric_rule_black_list_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the alert blacklist policy.
        """
        return pulumi.get(self, "metric_rule_black_list_name")

    @metric_rule_black_list_name.setter
    def metric_rule_black_list_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_rule_black_list_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The data namespace of the cloud service.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time range of the alert blacklist policy.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="enableEndTime")
    def enable_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_end_time")

    @enable_end_time.setter
    def enable_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_end_time", value)

    @_builtins.property
    @pulumi.getter(name="enableStartTime")
    def enable_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_start_time")

    @enable_start_time.setter
    def enable_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_start_time", value)

    @_builtins.property
    @pulumi.getter(name="isEnable")
    def is_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        """
        return pulumi.get(self, "is_enable")

    @is_enable.setter
    def is_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enable", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]]:
        """
        Monitoring metrics in the instance. See `metrics` below.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        """
        return pulumi.get(self, "scope_type")

    @scope_type.setter
    def scope_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_type", value)

    @_builtins.property
    @pulumi.getter(name="scopeValues")
    def scope_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        """
        return pulumi.get(self, "scope_values")

    @scope_values.setter
    def scope_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_values", value)


@pulumi.input_type
class _MetricRuleBlackListState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_rule_black_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_rule_black_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricRuleBlackList resources.
        :param pulumi.Input[_builtins.str] category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        :param pulumi.Input[_builtins.str] create_time: The timestamp for creating an alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] effective_time: The effective time range of the alert blacklist policy.
        :param pulumi.Input[_builtins.str] enable_end_time: The start timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] enable_start_time: The end timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The list of instances of cloud services specified in the alert blacklist policy.
        :param pulumi.Input[_builtins.bool] is_enable: The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_id: The ID of the blacklist policy.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_name: The name of the alert blacklist policy.
        :param pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]] metrics: Monitoring metrics in the instance. See `metrics` below.
        :param pulumi.Input[_builtins.str] namespace: The data namespace of the cloud service.
        :param pulumi.Input[_builtins.str] scope_type: The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_values: Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        :param pulumi.Input[_builtins.str] update_time: Modify the timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if enable_end_time is not None:
            pulumi.set(__self__, "enable_end_time", enable_end_time)
        if enable_start_time is not None:
            pulumi.set(__self__, "enable_start_time", enable_start_time)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if is_enable is not None:
            pulumi.set(__self__, "is_enable", is_enable)
        if metric_rule_black_list_id is not None:
            pulumi.set(__self__, "metric_rule_black_list_id", metric_rule_black_list_id)
        if metric_rule_black_list_name is not None:
            pulumi.set(__self__, "metric_rule_black_list_name", metric_rule_black_list_name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope_type is not None:
            pulumi.set(__self__, "scope_type", scope_type)
        if scope_values is not None:
            pulumi.set(__self__, "scope_values", scope_values)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp for creating an alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time range of the alert blacklist policy.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="enableEndTime")
    def enable_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_end_time")

    @enable_end_time.setter
    def enable_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_end_time", value)

    @_builtins.property
    @pulumi.getter(name="enableStartTime")
    def enable_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_start_time")

    @enable_start_time.setter
    def enable_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_start_time", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of instances of cloud services specified in the alert blacklist policy.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="isEnable")
    def is_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        """
        return pulumi.get(self, "is_enable")

    @is_enable.setter
    def is_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enable", value)

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListId")
    def metric_rule_black_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the blacklist policy.
        """
        return pulumi.get(self, "metric_rule_black_list_id")

    @metric_rule_black_list_id.setter
    def metric_rule_black_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_rule_black_list_id", value)

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListName")
    def metric_rule_black_list_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert blacklist policy.
        """
        return pulumi.get(self, "metric_rule_black_list_name")

    @metric_rule_black_list_name.setter
    def metric_rule_black_list_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_rule_black_list_name", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]]:
        """
        Monitoring metrics in the instance. See `metrics` below.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleBlackListMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data namespace of the cloud service.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        """
        return pulumi.get(self, "scope_type")

    @scope_type.setter
    def scope_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_type", value)

    @_builtins.property
    @pulumi.getter(name="scopeValues")
    def scope_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        """
        return pulumi.get(self, "scope_values")

    @scope_values.setter
    def scope_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_values", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modify the timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("alicloud:cms/metricRuleBlackList:MetricRuleBlackList")
class MetricRuleBlackList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_rule_black_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRuleBlackListMetricArgs', 'MetricRuleBlackListMetricArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Cloud Monitor Service Metric Rule Black List resource.

        For information about Cloud Monitor Service Metric Rule Black List and how to use it, see [What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="Instance")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name=name,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_metric_rule_black_list = alicloud.cms.MetricRuleBlackList("default",
            instances=[default_instance.id.apply(lambda id: f"{{\\"instancceId\\":\\"{id}\\"}}")],
            metrics=[{
                "metric_name": "disk_utilization",
            }],
            category="ecs",
            enable_end_time="1799443209000",
            namespace="acs_ecs_dashboard",
            enable_start_time="1689243209000",
            metric_rule_black_list_name=name)
        ```

        ## Import

        Cloud Monitor Service Metric Rule Black List can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/metricRuleBlackList:MetricRuleBlackList example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        :param pulumi.Input[_builtins.str] effective_time: The effective time range of the alert blacklist policy.
        :param pulumi.Input[_builtins.str] enable_end_time: The start timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] enable_start_time: The end timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The list of instances of cloud services specified in the alert blacklist policy.
        :param pulumi.Input[_builtins.bool] is_enable: The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_name: The name of the alert blacklist policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRuleBlackListMetricArgs', 'MetricRuleBlackListMetricArgsDict']]]] metrics: Monitoring metrics in the instance. See `metrics` below.
        :param pulumi.Input[_builtins.str] namespace: The data namespace of the cloud service.
        :param pulumi.Input[_builtins.str] scope_type: The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_values: Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricRuleBlackListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Monitor Service Metric Rule Black List resource.

        For information about Cloud Monitor Service Metric Rule Black List and how to use it, see [What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="Instance")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name=name,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_metric_rule_black_list = alicloud.cms.MetricRuleBlackList("default",
            instances=[default_instance.id.apply(lambda id: f"{{\\"instancceId\\":\\"{id}\\"}}")],
            metrics=[{
                "metric_name": "disk_utilization",
            }],
            category="ecs",
            enable_end_time="1799443209000",
            namespace="acs_ecs_dashboard",
            enable_start_time="1689243209000",
            metric_rule_black_list_name=name)
        ```

        ## Import

        Cloud Monitor Service Metric Rule Black List can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/metricRuleBlackList:MetricRuleBlackList example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MetricRuleBlackListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricRuleBlackListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_rule_black_list_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRuleBlackListMetricArgs', 'MetricRuleBlackListMetricArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricRuleBlackListArgs.__new__(MetricRuleBlackListArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["enable_end_time"] = enable_end_time
            __props__.__dict__["enable_start_time"] = enable_start_time
            if instances is None and not opts.urn:
                raise TypeError("Missing required property 'instances'")
            __props__.__dict__["instances"] = instances
            __props__.__dict__["is_enable"] = is_enable
            if metric_rule_black_list_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_rule_black_list_name'")
            __props__.__dict__["metric_rule_black_list_name"] = metric_rule_black_list_name
            __props__.__dict__["metrics"] = metrics
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["scope_type"] = scope_type
            __props__.__dict__["scope_values"] = scope_values
            __props__.__dict__["create_time"] = None
            __props__.__dict__["metric_rule_black_list_id"] = None
            __props__.__dict__["update_time"] = None
        super(MetricRuleBlackList, __self__).__init__(
            'alicloud:cms/metricRuleBlackList:MetricRuleBlackList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            metric_rule_black_list_id: Optional[pulumi.Input[_builtins.str]] = None,
            metric_rule_black_list_name: Optional[pulumi.Input[_builtins.str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRuleBlackListMetricArgs', 'MetricRuleBlackListMetricArgsDict']]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            scope_type: Optional[pulumi.Input[_builtins.str]] = None,
            scope_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MetricRuleBlackList':
        """
        Get an existing MetricRuleBlackList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        :param pulumi.Input[_builtins.str] create_time: The timestamp for creating an alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] effective_time: The effective time range of the alert blacklist policy.
        :param pulumi.Input[_builtins.str] enable_end_time: The start timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[_builtins.str] enable_start_time: The end timestamp of the alert blacklist policy.Unit: milliseconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The list of instances of cloud services specified in the alert blacklist policy.
        :param pulumi.Input[_builtins.bool] is_enable: The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_id: The ID of the blacklist policy.
        :param pulumi.Input[_builtins.str] metric_rule_black_list_name: The name of the alert blacklist policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRuleBlackListMetricArgs', 'MetricRuleBlackListMetricArgsDict']]]] metrics: Monitoring metrics in the instance. See `metrics` below.
        :param pulumi.Input[_builtins.str] namespace: The data namespace of the cloud service.
        :param pulumi.Input[_builtins.str] scope_type: The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_values: Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        :param pulumi.Input[_builtins.str] update_time: Modify the timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricRuleBlackListState.__new__(_MetricRuleBlackListState)

        __props__.__dict__["category"] = category
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["enable_end_time"] = enable_end_time
        __props__.__dict__["enable_start_time"] = enable_start_time
        __props__.__dict__["instances"] = instances
        __props__.__dict__["is_enable"] = is_enable
        __props__.__dict__["metric_rule_black_list_id"] = metric_rule_black_list_id
        __props__.__dict__["metric_rule_black_list_name"] = metric_rule_black_list_name
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["scope_type"] = scope_type
        __props__.__dict__["scope_values"] = scope_values
        __props__.__dict__["update_time"] = update_time
        return MetricRuleBlackList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp for creating an alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The effective time range of the alert blacklist policy.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="enableEndTime")
    def enable_end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The start timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_end_time")

    @_builtins.property
    @pulumi.getter(name="enableStartTime")
    def enable_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "enable_start_time")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of instances of cloud services specified in the alert blacklist policy.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="isEnable")
    def is_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
        """
        return pulumi.get(self, "is_enable")

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListId")
    def metric_rule_black_list_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the blacklist policy.
        """
        return pulumi.get(self, "metric_rule_black_list_id")

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListName")
    def metric_rule_black_list_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the alert blacklist policy.
        """
        return pulumi.get(self, "metric_rule_black_list_name")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Optional[Sequence['outputs.MetricRuleBlackListMetric']]]:
        """
        Monitoring metrics in the instance. See `metrics` below.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The data namespace of the cloud service.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> pulumi.Output[_builtins.str]:
        """
        The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
        """
        return pulumi.get(self, "scope_type")

    @_builtins.property
    @pulumi.getter(name="scopeValues")
    def scope_values(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
        """
        return pulumi.get(self, "scope_values")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Modify the timestamp of the alert blacklist policy.Unit: milliseconds.
        """
        return pulumi.get(self, "update_time")

