# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ChainChainConfigArgs',
    'ChainChainConfigArgsDict',
    'ChainChainConfigNodeArgs',
    'ChainChainConfigNodeArgsDict',
    'ChainChainConfigNodeNodeConfigArgs',
    'ChainChainConfigNodeNodeConfigArgsDict',
    'ChainChainConfigNodeNodeConfigDenyPolicyArgs',
    'ChainChainConfigNodeNodeConfigDenyPolicyArgsDict',
    'ChainChainConfigRouterArgs',
    'ChainChainConfigRouterArgsDict',
    'ChainChainConfigRouterFromArgs',
    'ChainChainConfigRouterFromArgsDict',
    'ChainChainConfigRouterToArgs',
    'ChainChainConfigRouterToArgsDict',
    'RegistryEnterpriseInstanceInstanceEndpointArgs',
    'RegistryEnterpriseInstanceInstanceEndpointArgsDict',
    'RegistryEnterpriseInstanceInstanceEndpointDomainArgs',
    'RegistryEnterpriseInstanceInstanceEndpointDomainArgsDict',
    'RepoDomainListArgs',
    'RepoDomainListArgsDict',
]

MYPY = False

if not MYPY:
    class ChainChainConfigArgsDict(TypedDict):
        nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeArgsDict']]]]
        """
        Each node in the delivery chain. See `nodes` below.

        > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        """
        routers: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterArgsDict']]]]
        """
        Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
elif False:
    ChainChainConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigArgs:
    def __init__(__self__, *,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeArgs']]]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeArgs']]] nodes: Each node in the delivery chain. See `nodes` below.
               
               > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterArgs']]] routers: Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeArgs']]]]:
        """
        Each node in the delivery chain. See `nodes` below.

        > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterArgs']]]]:
        """
        Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        return pulumi.get(self, "routers")

    @routers.setter
    def routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterArgs']]]]):
        pulumi.set(self, "routers", value)


if not MYPY:
    class ChainChainConfigNodeArgsDict(TypedDict):
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        node_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigArgsDict']]]]
        """
        The configuration of delivery chain node. See `node_config` below.
        """
        node_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of delivery chain node.
        """
elif False:
    ChainChainConfigNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigNodeArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigArgs']]]] = None,
                 node_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable: Whether to enable the delivery chain node. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigArgs']]] node_configs: The configuration of delivery chain node. See `node_config` below.
        :param pulumi.Input[_builtins.str] node_name: The name of delivery chain node.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if node_configs is not None:
            pulumi.set(__self__, "node_configs", node_configs)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigArgs']]]]:
        """
        The configuration of delivery chain node. See `node_config` below.
        """
        return pulumi.get(self, "node_configs")

    @node_configs.setter
    def node_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigArgs']]]]):
        pulumi.set(self, "node_configs", value)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name", value)


if not MYPY:
    class ChainChainConfigNodeNodeConfigArgsDict(TypedDict):
        deny_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigDenyPolicyArgsDict']]]]
        """
        Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
elif False:
    ChainChainConfigNodeNodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigNodeNodeConfigArgs:
    def __init__(__self__, *,
                 deny_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigDenyPolicyArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigDenyPolicyArgs']]] deny_policies: Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        if deny_policies is not None:
            pulumi.set(__self__, "deny_policies", deny_policies)

    @_builtins.property
    @pulumi.getter(name="denyPolicies")
    def deny_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigDenyPolicyArgs']]]]:
        """
        Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        return pulumi.get(self, "deny_policies")

    @deny_policies.setter
    def deny_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigNodeNodeConfigDenyPolicyArgs']]]]):
        pulumi.set(self, "deny_policies", value)


if not MYPY:
    class ChainChainConfigNodeNodeConfigDenyPolicyArgsDict(TypedDict):
        action: NotRequired[pulumi.Input[_builtins.str]]
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        issue_count: NotRequired[pulumi.Input[_builtins.str]]
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        issue_level: NotRequired[pulumi.Input[_builtins.str]]
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        logic: NotRequired[pulumi.Input[_builtins.str]]
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
elif False:
    ChainChainConfigNodeNodeConfigDenyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigNodeNodeConfigDenyPolicyArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_count: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_level: Optional[pulumi.Input[_builtins.str]] = None,
                 logic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        :param pulumi.Input[_builtins.str] issue_count: The count of scanning vulnerabilities that triggers blocking.
        :param pulumi.Input[_builtins.str] issue_level: The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        :param pulumi.Input[_builtins.str] logic: The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if issue_count is not None:
            pulumi.set(__self__, "issue_count", issue_count)
        if issue_level is not None:
            pulumi.set(__self__, "issue_level", issue_level)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="issueCount")
    def issue_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        return pulumi.get(self, "issue_count")

    @issue_count.setter
    def issue_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issue_count", value)

    @_builtins.property
    @pulumi.getter(name="issueLevel")
    def issue_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        return pulumi.get(self, "issue_level")

    @issue_level.setter
    def issue_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issue_level", value)

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        return pulumi.get(self, "logic")

    @logic.setter
    def logic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic", value)


if not MYPY:
    class ChainChainConfigRouterArgsDict(TypedDict):
        froms: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterFromArgsDict']]]]
        """
        Source node. See `from` below.
        """
        tos: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterToArgsDict']]]]
        """
        Destination node. See `to` below.
        """
elif False:
    ChainChainConfigRouterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigRouterArgs:
    def __init__(__self__, *,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterFromArgs']]]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterToArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterFromArgs']]] froms: Source node. See `from` below.
        :param pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterToArgs']]] tos: Destination node. See `to` below.
        """
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterFromArgs']]]]:
        """
        Source node. See `from` below.
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterFromArgs']]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterToArgs']]]]:
        """
        Destination node. See `to` below.
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChainChainConfigRouterToArgs']]]]):
        pulumi.set(self, "tos", value)


if not MYPY:
    class ChainChainConfigRouterFromArgsDict(TypedDict):
        node_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
elif False:
    ChainChainConfigRouterFromArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigRouterFromArgs:
    def __init__(__self__, *,
                 node_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name", value)


if not MYPY:
    class ChainChainConfigRouterToArgsDict(TypedDict):
        node_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
elif False:
    ChainChainConfigRouterToArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChainChainConfigRouterToArgs:
    def __init__(__self__, *,
                 node_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name", value)


if not MYPY:
    class RegistryEnterpriseInstanceInstanceEndpointArgsDict(TypedDict):
        domains: NotRequired[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointDomainArgsDict']]]]
        """
        Domain List
        """
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        enable
        """
        endpoint_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Network Access Endpoint Type
        """
elif False:
    RegistryEnterpriseInstanceInstanceEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryEnterpriseInstanceInstanceEndpointArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointDomainArgs']]]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointDomainArgs']]] domains: Domain List
        :param pulumi.Input[_builtins.bool] enable: enable
        :param pulumi.Input[_builtins.str] endpoint_type: Network Access Endpoint Type
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointDomainArgs']]]]:
        """
        Domain List
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryEnterpriseInstanceInstanceEndpointDomainArgs']]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        enable
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Access Endpoint Type
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)


if not MYPY:
    class RegistryEnterpriseInstanceInstanceEndpointDomainArgsDict(TypedDict):
        domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain Type
        """
elif False:
    RegistryEnterpriseInstanceInstanceEndpointDomainArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryEnterpriseInstanceInstanceEndpointDomainArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] domain: Domain
        :param pulumi.Input[_builtins.str] type: Domain Type
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class RepoDomainListArgsDict(TypedDict):
        internal: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain of internal endpoint, only in some regions.
        """
        public: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain of public endpoint.
        """
        vpc: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain of vpc endpoint.
        """
elif False:
    RepoDomainListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepoDomainListArgs:
    def __init__(__self__, *,
                 internal: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] internal: Domain of internal endpoint, only in some regions.
        :param pulumi.Input[_builtins.str] public: Domain of public endpoint.
        :param pulumi.Input[_builtins.str] vpc: Domain of vpc endpoint.
        """
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of internal endpoint, only in some regions.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of public endpoint.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of vpc endpoint.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc", value)


