# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryEnterpriseSyncRuleArgs', 'RegistryEnterpriseSyncRule']

@pulumi.input_type
class RegistryEnterpriseSyncRuleArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 namespace_name: pulumi.Input[_builtins.str],
                 tag_filter: pulumi.Input[_builtins.str],
                 target_instance_id: pulumi.Input[_builtins.str],
                 target_namespace_name: pulumi.Input[_builtins.str],
                 target_region_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 target_repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryEnterpriseSyncRule resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry source instance.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name of the source instance.
        :param pulumi.Input[_builtins.str] tag_filter: The regular expression used to filter image tags.
        :param pulumi.Input[_builtins.str] target_instance_id: The ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_namespace_name: The namespace name of the destination instance.
        :param pulumi.Input[_builtins.str] target_region_id: The region ID of the destination instance.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        :param pulumi.Input[_builtins.str] repo_name: The image repository name of the source instance.
        :param pulumi.Input[_builtins.str] sync_rule_name: The name of the sync rule.
        :param pulumi.Input[_builtins.str] sync_scope: The synchronization scope. Valid values:
               - `REPO`: Encrypts or decrypts data.
               - `NAMESPACE`: Generates or verifies a digital signature.
               > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        :param pulumi.Input[_builtins.str] sync_trigger: The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
               - `INITIATIVE`: Manually triggers the synchronization rule.
               - `PASSIVE`: Automatically triggers the synchronization rule.
        :param pulumi.Input[_builtins.str] target_repo_name: The image repository name of the destination instance.
        :param pulumi.Input[_builtins.str] target_user_id: The UID of the account to which the target instance belongs.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "tag_filter", tag_filter)
        pulumi.set(__self__, "target_instance_id", target_instance_id)
        pulumi.set(__self__, "target_namespace_name", target_namespace_name)
        pulumi.set(__self__, "target_region_id", target_region_id)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if sync_rule_name is not None:
            pulumi.set(__self__, "sync_rule_name", sync_rule_name)
        if sync_scope is not None:
            pulumi.set(__self__, "sync_scope", sync_scope)
        if sync_trigger is not None:
            pulumi.set(__self__, "sync_trigger", sync_trigger)
        if target_repo_name is not None:
            pulumi.set(__self__, "target_repo_name", target_repo_name)
        if target_user_id is not None:
            pulumi.set(__self__, "target_user_id", target_user_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry source instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace name of the source instance.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> pulumi.Input[_builtins.str]:
        """
        The regular expression used to filter image tags.
        """
        return pulumi.get(self, "tag_filter")

    @tag_filter.setter
    def tag_filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_filter", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the destination instance.
        """
        return pulumi.get(self, "target_instance_id")

    @target_instance_id.setter
    def target_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="targetNamespaceName")
    def target_namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace name of the destination instance.
        """
        return pulumi.get(self, "target_namespace_name")

    @target_namespace_name.setter
    def target_namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="targetRegionId")
    def target_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID of the destination instance.
        """
        return pulumi.get(self, "target_region_id")

    @target_region_id.setter
    def target_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_region_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image repository name of the source instance.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_name", value)

    @_builtins.property
    @pulumi.getter(name="syncRuleName")
    def sync_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the sync rule.
        """
        return pulumi.get(self, "sync_rule_name")

    @sync_rule_name.setter
    def sync_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="syncScope")
    def sync_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization scope. Valid values:
        - `REPO`: Encrypts or decrypts data.
        - `NAMESPACE`: Generates or verifies a digital signature.
        > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        """
        return pulumi.get(self, "sync_scope")

    @sync_scope.setter
    def sync_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_scope", value)

    @_builtins.property
    @pulumi.getter(name="syncTrigger")
    def sync_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
        - `INITIATIVE`: Manually triggers the synchronization rule.
        - `PASSIVE`: Automatically triggers the synchronization rule.
        """
        return pulumi.get(self, "sync_trigger")

    @sync_trigger.setter
    def sync_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_trigger", value)

    @_builtins.property
    @pulumi.getter(name="targetRepoName")
    def target_repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image repository name of the destination instance.
        """
        return pulumi.get(self, "target_repo_name")

    @target_repo_name.setter
    def target_repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_repo_name", value)

    @_builtins.property
    @pulumi.getter(name="targetUserId")
    def target_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the account to which the target instance belongs.
        """
        return pulumi.get(self, "target_user_id")

    @target_user_id.setter
    def target_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_user_id", value)


@pulumi.input_type
class _RegistryEnterpriseSyncRuleState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_sync_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryEnterpriseSyncRule resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.240.0) The time when the synchronization rule was created.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry source instance.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name of the source instance.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.240.0) The region ID of the source instance.
        :param pulumi.Input[_builtins.str] repo_name: The image repository name of the source instance.
        :param pulumi.Input[_builtins.str] repo_sync_rule_id: (Available since v1.240.0) The ID of the synchronization rule.
        :param pulumi.Input[_builtins.str] rule_id: (Deprecated since v1.240.0) Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.
        :param pulumi.Input[_builtins.str] sync_direction: The synchronization direction.
        :param pulumi.Input[_builtins.str] sync_rule_name: The name of the sync rule.
        :param pulumi.Input[_builtins.str] sync_scope: The synchronization scope. Valid values:
               - `REPO`: Encrypts or decrypts data.
               - `NAMESPACE`: Generates or verifies a digital signature.
               > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        :param pulumi.Input[_builtins.str] sync_trigger: The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
               - `INITIATIVE`: Manually triggers the synchronization rule.
               - `PASSIVE`: Automatically triggers the synchronization rule.
        :param pulumi.Input[_builtins.str] tag_filter: The regular expression used to filter image tags.
        :param pulumi.Input[_builtins.str] target_instance_id: The ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_namespace_name: The namespace name of the destination instance.
        :param pulumi.Input[_builtins.str] target_region_id: The region ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_repo_name: The image repository name of the destination instance.
        :param pulumi.Input[_builtins.str] target_user_id: The UID of the account to which the target instance belongs.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if repo_sync_rule_id is not None:
            pulumi.set(__self__, "repo_sync_rule_id", repo_sync_rule_id)
        if rule_id is not None:
            warnings.warn("""Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.""", DeprecationWarning)
            pulumi.log.warn("""rule_id is deprecated: Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.""")
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sync_direction is not None:
            pulumi.set(__self__, "sync_direction", sync_direction)
        if sync_rule_name is not None:
            pulumi.set(__self__, "sync_rule_name", sync_rule_name)
        if sync_scope is not None:
            pulumi.set(__self__, "sync_scope", sync_scope)
        if sync_trigger is not None:
            pulumi.set(__self__, "sync_trigger", sync_trigger)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)
        if target_instance_id is not None:
            pulumi.set(__self__, "target_instance_id", target_instance_id)
        if target_namespace_name is not None:
            pulumi.set(__self__, "target_namespace_name", target_namespace_name)
        if target_region_id is not None:
            pulumi.set(__self__, "target_region_id", target_region_id)
        if target_repo_name is not None:
            pulumi.set(__self__, "target_repo_name", target_repo_name)
        if target_user_id is not None:
            pulumi.set(__self__, "target_user_id", target_user_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.240.0) The time when the synchronization rule was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry source instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the source instance.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.240.0) The region ID of the source instance.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image repository name of the source instance.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_name", value)

    @_builtins.property
    @pulumi.getter(name="repoSyncRuleId")
    def repo_sync_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.240.0) The ID of the synchronization rule.
        """
        return pulumi.get(self, "repo_sync_rule_id")

    @repo_sync_rule_id.setter
    def repo_sync_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_sync_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    @_utilities.deprecated("""Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.""")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated since v1.240.0) Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="syncDirection")
    def sync_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization direction.
        """
        return pulumi.get(self, "sync_direction")

    @sync_direction.setter
    def sync_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_direction", value)

    @_builtins.property
    @pulumi.getter(name="syncRuleName")
    def sync_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the sync rule.
        """
        return pulumi.get(self, "sync_rule_name")

    @sync_rule_name.setter
    def sync_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="syncScope")
    def sync_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization scope. Valid values:
        - `REPO`: Encrypts or decrypts data.
        - `NAMESPACE`: Generates or verifies a digital signature.
        > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        """
        return pulumi.get(self, "sync_scope")

    @sync_scope.setter
    def sync_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_scope", value)

    @_builtins.property
    @pulumi.getter(name="syncTrigger")
    def sync_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
        - `INITIATIVE`: Manually triggers the synchronization rule.
        - `PASSIVE`: Automatically triggers the synchronization rule.
        """
        return pulumi.get(self, "sync_trigger")

    @sync_trigger.setter
    def sync_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_trigger", value)

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The regular expression used to filter image tags.
        """
        return pulumi.get(self, "tag_filter")

    @tag_filter.setter
    def tag_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_filter", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the destination instance.
        """
        return pulumi.get(self, "target_instance_id")

    @target_instance_id.setter
    def target_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="targetNamespaceName")
    def target_namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the destination instance.
        """
        return pulumi.get(self, "target_namespace_name")

    @target_namespace_name.setter
    def target_namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="targetRegionId")
    def target_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the destination instance.
        """
        return pulumi.get(self, "target_region_id")

    @target_region_id.setter
    def target_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_region_id", value)

    @_builtins.property
    @pulumi.getter(name="targetRepoName")
    def target_repo_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image repository name of the destination instance.
        """
        return pulumi.get(self, "target_repo_name")

    @target_repo_name.setter
    def target_repo_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_repo_name", value)

    @_builtins.property
    @pulumi.getter(name="targetUserId")
    def target_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the account to which the target instance belongs.
        """
        return pulumi.get(self, "target_user_id")

    @target_user_id.setter
    def target_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_user_id", value)


@pulumi.type_token("alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule")
class RegistryEnterpriseSyncRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Container Registry Sync Rule resource.

        For information about Container Registry Sync Rule and how to use it, see [What is Sync Rule](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createreposyncrule)

        > **NOTE:** Available since v1.90.0.

        > **NOTE:** You need to set your registry password in Container Registry console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        source = alicloud.cr.RegistryEnterpriseInstance("source",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-source-{default_integer['result']}")
        target = alicloud.cr.RegistryEnterpriseInstance("target",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-target-{default_integer['result']}")
        source_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("source",
            instance_id=source.id,
            name=f"{name}-{default_integer['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        target_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("target",
            instance_id=target.id,
            name=f"{name}-{default_integer['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        source_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("source",
            instance_id=source.id,
            namespace=source_registry_enterprise_namespace.name,
            name=f"{name}-{default_integer['result']}",
            summary="this is summary of my new repo",
            repo_type="PUBLIC")
        target_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("target",
            instance_id=target.id,
            namespace=target_registry_enterprise_namespace.name,
            name=f"{name}-{default_integer['result']}",
            summary="this is summary of my new repo",
            repo_type="PUBLIC")
        default_registry_enterprise_sync_rule = alicloud.cs.RegistryEnterpriseSyncRule("default",
            instance_id=source.id,
            namespace_name=source_registry_enterprise_namespace.name,
            sync_rule_name=f"{name}-{default_integer['result']}",
            target_instance_id=target.id,
            target_namespace_name=target_registry_enterprise_namespace.name,
            target_region_id=default.regions[0].id,
            tag_filter=".*",
            repo_name=source_registry_enterprise_repo.name,
            target_repo_name=target_registry_enterprise_repo.name)
        ```

        ## Import

        Container Registry Sync Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule example <instance_id>:<namespace_name>:<repo_sync_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry source instance.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name of the source instance.
        :param pulumi.Input[_builtins.str] repo_name: The image repository name of the source instance.
        :param pulumi.Input[_builtins.str] sync_rule_name: The name of the sync rule.
        :param pulumi.Input[_builtins.str] sync_scope: The synchronization scope. Valid values:
               - `REPO`: Encrypts or decrypts data.
               - `NAMESPACE`: Generates or verifies a digital signature.
               > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        :param pulumi.Input[_builtins.str] sync_trigger: The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
               - `INITIATIVE`: Manually triggers the synchronization rule.
               - `PASSIVE`: Automatically triggers the synchronization rule.
        :param pulumi.Input[_builtins.str] tag_filter: The regular expression used to filter image tags.
        :param pulumi.Input[_builtins.str] target_instance_id: The ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_namespace_name: The namespace name of the destination instance.
        :param pulumi.Input[_builtins.str] target_region_id: The region ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_repo_name: The image repository name of the destination instance.
        :param pulumi.Input[_builtins.str] target_user_id: The UID of the account to which the target instance belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryEnterpriseSyncRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Container Registry Sync Rule resource.

        For information about Container Registry Sync Rule and how to use it, see [What is Sync Rule](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createreposyncrule)

        > **NOTE:** Available since v1.90.0.

        > **NOTE:** You need to set your registry password in Container Registry console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        source = alicloud.cr.RegistryEnterpriseInstance("source",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-source-{default_integer['result']}")
        target = alicloud.cr.RegistryEnterpriseInstance("target",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-target-{default_integer['result']}")
        source_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("source",
            instance_id=source.id,
            name=f"{name}-{default_integer['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        target_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("target",
            instance_id=target.id,
            name=f"{name}-{default_integer['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        source_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("source",
            instance_id=source.id,
            namespace=source_registry_enterprise_namespace.name,
            name=f"{name}-{default_integer['result']}",
            summary="this is summary of my new repo",
            repo_type="PUBLIC")
        target_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("target",
            instance_id=target.id,
            namespace=target_registry_enterprise_namespace.name,
            name=f"{name}-{default_integer['result']}",
            summary="this is summary of my new repo",
            repo_type="PUBLIC")
        default_registry_enterprise_sync_rule = alicloud.cs.RegistryEnterpriseSyncRule("default",
            instance_id=source.id,
            namespace_name=source_registry_enterprise_namespace.name,
            sync_rule_name=f"{name}-{default_integer['result']}",
            target_instance_id=target.id,
            target_namespace_name=target_registry_enterprise_namespace.name,
            target_region_id=default.regions[0].id,
            tag_filter=".*",
            repo_name=source_registry_enterprise_repo.name,
            target_repo_name=target_registry_enterprise_repo.name)
        ```

        ## Import

        Container Registry Sync Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule example <instance_id>:<namespace_name>:<repo_sync_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param RegistryEnterpriseSyncRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryEnterpriseSyncRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_repo_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryEnterpriseSyncRuleArgs.__new__(RegistryEnterpriseSyncRuleArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["repo_name"] = repo_name
            __props__.__dict__["sync_rule_name"] = sync_rule_name
            __props__.__dict__["sync_scope"] = sync_scope
            __props__.__dict__["sync_trigger"] = sync_trigger
            if tag_filter is None and not opts.urn:
                raise TypeError("Missing required property 'tag_filter'")
            __props__.__dict__["tag_filter"] = tag_filter
            if target_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_instance_id'")
            __props__.__dict__["target_instance_id"] = target_instance_id
            if target_namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_namespace_name'")
            __props__.__dict__["target_namespace_name"] = target_namespace_name
            if target_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_region_id'")
            __props__.__dict__["target_region_id"] = target_region_id
            __props__.__dict__["target_repo_name"] = target_repo_name
            __props__.__dict__["target_user_id"] = target_user_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["repo_sync_rule_id"] = None
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["sync_direction"] = None
        super(RegistryEnterpriseSyncRule, __self__).__init__(
            'alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_name: Optional[pulumi.Input[_builtins.str]] = None,
            repo_sync_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            sync_direction: Optional[pulumi.Input[_builtins.str]] = None,
            sync_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            sync_scope: Optional[pulumi.Input[_builtins.str]] = None,
            sync_trigger: Optional[pulumi.Input[_builtins.str]] = None,
            tag_filter: Optional[pulumi.Input[_builtins.str]] = None,
            target_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_repo_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryEnterpriseSyncRule':
        """
        Get an existing RegistryEnterpriseSyncRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.240.0) The time when the synchronization rule was created.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry source instance.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name of the source instance.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.240.0) The region ID of the source instance.
        :param pulumi.Input[_builtins.str] repo_name: The image repository name of the source instance.
        :param pulumi.Input[_builtins.str] repo_sync_rule_id: (Available since v1.240.0) The ID of the synchronization rule.
        :param pulumi.Input[_builtins.str] rule_id: (Deprecated since v1.240.0) Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.
        :param pulumi.Input[_builtins.str] sync_direction: The synchronization direction.
        :param pulumi.Input[_builtins.str] sync_rule_name: The name of the sync rule.
        :param pulumi.Input[_builtins.str] sync_scope: The synchronization scope. Valid values:
               - `REPO`: Encrypts or decrypts data.
               - `NAMESPACE`: Generates or verifies a digital signature.
               > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        :param pulumi.Input[_builtins.str] sync_trigger: The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
               - `INITIATIVE`: Manually triggers the synchronization rule.
               - `PASSIVE`: Automatically triggers the synchronization rule.
        :param pulumi.Input[_builtins.str] tag_filter: The regular expression used to filter image tags.
        :param pulumi.Input[_builtins.str] target_instance_id: The ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_namespace_name: The namespace name of the destination instance.
        :param pulumi.Input[_builtins.str] target_region_id: The region ID of the destination instance.
        :param pulumi.Input[_builtins.str] target_repo_name: The image repository name of the destination instance.
        :param pulumi.Input[_builtins.str] target_user_id: The UID of the account to which the target instance belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryEnterpriseSyncRuleState.__new__(_RegistryEnterpriseSyncRuleState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["repo_name"] = repo_name
        __props__.__dict__["repo_sync_rule_id"] = repo_sync_rule_id
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["sync_direction"] = sync_direction
        __props__.__dict__["sync_rule_name"] = sync_rule_name
        __props__.__dict__["sync_scope"] = sync_scope
        __props__.__dict__["sync_trigger"] = sync_trigger
        __props__.__dict__["tag_filter"] = tag_filter
        __props__.__dict__["target_instance_id"] = target_instance_id
        __props__.__dict__["target_namespace_name"] = target_namespace_name
        __props__.__dict__["target_region_id"] = target_region_id
        __props__.__dict__["target_repo_name"] = target_repo_name
        __props__.__dict__["target_user_id"] = target_user_id
        return RegistryEnterpriseSyncRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.240.0) The time when the synchronization rule was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry source instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.240.0. New field `sync_rule_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace name of the source instance.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.240.0) The region ID of the source instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image repository name of the source instance.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="repoSyncRuleId")
    def repo_sync_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.240.0) The ID of the synchronization rule.
        """
        return pulumi.get(self, "repo_sync_rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    @_utilities.deprecated("""Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.""")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated since v1.240.0) Field `rule_id` has been deprecated from provider version 1.240.0. New field `repo_sync_rule_id` instead.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="syncDirection")
    def sync_direction(self) -> pulumi.Output[_builtins.str]:
        """
        The synchronization direction.
        """
        return pulumi.get(self, "sync_direction")

    @_builtins.property
    @pulumi.getter(name="syncRuleName")
    def sync_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the sync rule.
        """
        return pulumi.get(self, "sync_rule_name")

    @_builtins.property
    @pulumi.getter(name="syncScope")
    def sync_scope(self) -> pulumi.Output[_builtins.str]:
        """
        The synchronization scope. Valid values:
        - `REPO`: Encrypts or decrypts data.
        - `NAMESPACE`: Generates or verifies a digital signature.
        > **NOTE:** From version 1.240.0, `sync_scope` can be set.
        """
        return pulumi.get(self, "sync_scope")

    @_builtins.property
    @pulumi.getter(name="syncTrigger")
    def sync_trigger(self) -> pulumi.Output[_builtins.str]:
        """
        The policy configured to trigger the synchronization rule. Default value: `PASSIVE`. Valid values:
        - `INITIATIVE`: Manually triggers the synchronization rule.
        - `PASSIVE`: Automatically triggers the synchronization rule.
        """
        return pulumi.get(self, "sync_trigger")

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> pulumi.Output[_builtins.str]:
        """
        The regular expression used to filter image tags.
        """
        return pulumi.get(self, "tag_filter")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the destination instance.
        """
        return pulumi.get(self, "target_instance_id")

    @_builtins.property
    @pulumi.getter(name="targetNamespaceName")
    def target_namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace name of the destination instance.
        """
        return pulumi.get(self, "target_namespace_name")

    @_builtins.property
    @pulumi.getter(name="targetRegionId")
    def target_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the destination instance.
        """
        return pulumi.get(self, "target_region_id")

    @_builtins.property
    @pulumi.getter(name="targetRepoName")
    def target_repo_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image repository name of the destination instance.
        """
        return pulumi.get(self, "target_repo_name")

    @_builtins.property
    @pulumi.getter(name="targetUserId")
    def target_user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UID of the account to which the target instance belongs.
        """
        return pulumi.get(self, "target_user_id")

