# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessKubernetesArgs', 'ServerlessKubernetes']

@pulumi.input_type
class ServerlessKubernetesArgs:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_policy: Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']] = None,
                 private_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 service_discovery_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sls_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServerlessKubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]] addons: You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
               - ack.standard: Standard serverless clusters.
               - ack.pro.small: Professional serverless clusters.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.bool] endpoint_public_access_enabled: Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] logging_type: Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        :param pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        :param pulumi.Input['ServerlessKubernetesOperationPolicyArgs'] operation_policy: The cluster automatic operation policy. See `operation_policy` below.
               
               *Removed params*
        :param pulumi.Input[_builtins.bool] private_zone: Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discovery_types: Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        :param pulumi.Input[_builtins.str] sls_project_name: If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches where new kubernetes cluster will be located.
        :param pulumi.Input[_builtins.str] zone_id: When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if endpoint_public_access_enabled is not None:
            pulumi.set(__self__, "endpoint_public_access_enabled", endpoint_public_access_enabled)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            warnings.warn("""Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""", DeprecationWarning)
            pulumi.log.warn("""load_balancer_spec is deprecated: Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""")
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if logging_type is not None:
            warnings.warn("""Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""", DeprecationWarning)
            pulumi.log.warn("""logging_type is deprecated: Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""")
        if logging_type is not None:
            pulumi.set(__self__, "logging_type", logging_type)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if operation_policy is not None:
            pulumi.set(__self__, "operation_policy", operation_policy)
        if private_zone is not None:
            warnings.warn("""Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""", DeprecationWarning)
            pulumi.log.warn("""private_zone is deprecated: Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""")
        if private_zone is not None:
            pulumi.set(__self__, "private_zone", private_zone)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_discovery_types is not None:
            pulumi.set(__self__, "service_discovery_types", service_discovery_types)
        if sls_project_name is not None:
            warnings.warn("""Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""", DeprecationWarning)
            pulumi.log.warn("""sls_project_name is deprecated: Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""")
        if sls_project_name is not None:
            pulumi.set(__self__, "sls_project_name", sls_project_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]]:
        """
        You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
        - ack.standard: Standard serverless clusters.
        - ack.pro.small: Professional serverless clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_san", value)

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]]):
        pulumi.set(self, "delete_options", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @_builtins.property
    @pulumi.getter(name="endpointPublicAccessEnabled")
    def endpoint_public_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        """
        return pulumi.get(self, "endpoint_public_access_enabled")

    @endpoint_public_access_enabled.setter
    def endpoint_public_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "endpoint_public_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="loggingType")
    @_utilities.deprecated("""Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""")
    def logging_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "logging_type")

    @logging_type.setter
    def logging_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_type", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']]:
        """
        The cluster automatic operation policy. See `operation_policy` below.

        *Removed params*
        """
        return pulumi.get(self, "operation_policy")

    @operation_policy.setter
    def operation_policy(self, value: Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']]):
        pulumi.set(self, "operation_policy", value)

    @_builtins.property
    @pulumi.getter(name="privateZone")
    @_utilities.deprecated("""Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""")
    def private_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        """
        return pulumi.get(self, "private_zone")

    @private_zone.setter
    def private_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_zone", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveryTypes")
    def service_discovery_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        """
        return pulumi.get(self, "service_discovery_types")

    @service_discovery_types.setter
    def service_discovery_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_discovery_types", value)

    @_builtins.property
    @pulumi.getter(name="slsProjectName")
    @_utilities.deprecated("""Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""")
    def sls_project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "sls_project_name")

    @sls_project_name.setter
    def sls_project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_project_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the cluster.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vswitches where new kubernetes cluster will be located.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ServerlessKubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_policy: Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']] = None,
                 private_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rrsa_metadata: Optional[pulumi.Input['ServerlessKubernetesRrsaMetadataArgs']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 service_discovery_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sls_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerlessKubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]] addons: You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
               - ack.standard: Standard serverless clusters.
               - ack.pro.small: Professional serverless clusters.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.bool] endpoint_public_access_enabled: Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] logging_type: Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        :param pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        :param pulumi.Input['ServerlessKubernetesOperationPolicyArgs'] operation_policy: The cluster automatic operation policy. See `operation_policy` below.
               
               *Removed params*
        :param pulumi.Input[_builtins.bool] private_zone: Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['ServerlessKubernetesRrsaMetadataArgs'] rrsa_metadata: Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discovery_types: Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        :param pulumi.Input[_builtins.str] sls_project_name: If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches where new kubernetes cluster will be located.
        :param pulumi.Input[_builtins.str] zone_id: When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if endpoint_public_access_enabled is not None:
            pulumi.set(__self__, "endpoint_public_access_enabled", endpoint_public_access_enabled)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            warnings.warn("""Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""", DeprecationWarning)
            pulumi.log.warn("""load_balancer_spec is deprecated: Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""")
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if logging_type is not None:
            warnings.warn("""Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""", DeprecationWarning)
            pulumi.log.warn("""logging_type is deprecated: Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""")
        if logging_type is not None:
            pulumi.set(__self__, "logging_type", logging_type)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if operation_policy is not None:
            pulumi.set(__self__, "operation_policy", operation_policy)
        if private_zone is not None:
            warnings.warn("""Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""", DeprecationWarning)
            pulumi.log.warn("""private_zone is deprecated: Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""")
        if private_zone is not None:
            pulumi.set(__self__, "private_zone", private_zone)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if rrsa_metadata is not None:
            pulumi.set(__self__, "rrsa_metadata", rrsa_metadata)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_discovery_types is not None:
            pulumi.set(__self__, "service_discovery_types", service_discovery_types)
        if sls_project_name is not None:
            warnings.warn("""Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""", DeprecationWarning)
            pulumi.log.warn("""sls_project_name is deprecated: Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""")
        if sls_project_name is not None:
            pulumi.set(__self__, "sls_project_name", sls_project_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]]:
        """
        You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
        - ack.standard: Standard serverless clusters.
        - ack.pro.small: Professional serverless clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_san", value)

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessKubernetesDeleteOptionArgs']]]]):
        pulumi.set(self, "delete_options", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @_builtins.property
    @pulumi.getter(name="endpointPublicAccessEnabled")
    def endpoint_public_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        """
        return pulumi.get(self, "endpoint_public_access_enabled")

    @endpoint_public_access_enabled.setter
    def endpoint_public_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "endpoint_public_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="loggingType")
    @_utilities.deprecated("""Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""")
    def logging_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "logging_type")

    @logging_type.setter
    def logging_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_type", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ServerlessKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']]:
        """
        The cluster automatic operation policy. See `operation_policy` below.

        *Removed params*
        """
        return pulumi.get(self, "operation_policy")

    @operation_policy.setter
    def operation_policy(self, value: Optional[pulumi.Input['ServerlessKubernetesOperationPolicyArgs']]):
        pulumi.set(self, "operation_policy", value)

    @_builtins.property
    @pulumi.getter(name="privateZone")
    @_utilities.deprecated("""Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""")
    def private_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        """
        return pulumi.get(self, "private_zone")

    @private_zone.setter
    def private_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_zone", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> Optional[pulumi.Input['ServerlessKubernetesRrsaMetadataArgs']]:
        """
        Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @rrsa_metadata.setter
    def rrsa_metadata(self, value: Optional[pulumi.Input['ServerlessKubernetesRrsaMetadataArgs']]):
        pulumi.set(self, "rrsa_metadata", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveryTypes")
    def service_discovery_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        """
        return pulumi.get(self, "service_discovery_types")

    @service_discovery_types.setter
    def service_discovery_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_discovery_types", value)

    @_builtins.property
    @pulumi.getter(name="slsProjectName")
    @_utilities.deprecated("""Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""")
    def sls_project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "sls_project_name")

    @sls_project_name.setter
    def sls_project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_project_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the cluster.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vswitches where new kubernetes cluster will be located.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:cs/serverlessKubernetes:ServerlessKubernetes")
class ServerlessKubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesAddonArgs', 'ServerlessKubernetesAddonArgsDict']]]]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesDeleteOptionArgs', 'ServerlessKubernetesDeleteOptionArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ServerlessKubernetesMaintenanceWindowArgs', 'ServerlessKubernetesMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_policy: Optional[pulumi.Input[Union['ServerlessKubernetesOperationPolicyArgs', 'ServerlessKubernetesOperationPolicyArgsDict']]] = None,
                 private_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 service_discovery_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sls_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource will help you to manager a Serverless Kubernetes Cluster, see [What is serverless kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-a-dedicated-kubernetes-cluster-that-supports-sandboxed-containers). The cluster is same as container service created by web console.

        > **NOTE:** Available since v1.58.0.

        > **NOTE:** Serverless Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating serverless kubernetes cluster need to install several packages and it will cost about 5 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** If you want to manage serverless Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.162.0, support for creating professional serverless cluster.

        > **NOTE:** From version 1.229.1, support to migrate basic serverless cluster to professional serverless cluster.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "ask-example-pro"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.2.0.0/21")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="10.2.1.0/24",
            zone_id=default.zones[0].id)
        serverless = alicloud.cs.ServerlessKubernetes("serverless",
            name_prefix=name,
            cluster_spec="ack.pro.small",
            vpc_id=default_network.id,
            vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            endpoint_public_access_enabled=True,
            deletion_protection=False,
            time_zone="Asia/Shanghai",
            service_cidr="172.21.0.0/20",
            tags={
                "k-aa": "v-aa",
                "k-bb": "v-bb",
            })
        ```

        ## Import

        Serverless Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/serverlessKubernetes:ServerlessKubernetes main ce4273f9156874b46bb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesAddonArgs', 'ServerlessKubernetesAddonArgsDict']]]] addons: You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
               - ack.standard: Standard serverless clusters.
               - ack.pro.small: Professional serverless clusters.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesDeleteOptionArgs', 'ServerlessKubernetesDeleteOptionArgsDict']]]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.bool] endpoint_public_access_enabled: Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] logging_type: Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        :param pulumi.Input[Union['ServerlessKubernetesMaintenanceWindowArgs', 'ServerlessKubernetesMaintenanceWindowArgsDict']] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        :param pulumi.Input[Union['ServerlessKubernetesOperationPolicyArgs', 'ServerlessKubernetesOperationPolicyArgsDict']] operation_policy: The cluster automatic operation policy. See `operation_policy` below.
               
               *Removed params*
        :param pulumi.Input[_builtins.bool] private_zone: Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discovery_types: Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        :param pulumi.Input[_builtins.str] sls_project_name: If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches where new kubernetes cluster will be located.
        :param pulumi.Input[_builtins.str] zone_id: When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerlessKubernetesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manager a Serverless Kubernetes Cluster, see [What is serverless kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-a-dedicated-kubernetes-cluster-that-supports-sandboxed-containers). The cluster is same as container service created by web console.

        > **NOTE:** Available since v1.58.0.

        > **NOTE:** Serverless Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating serverless kubernetes cluster need to install several packages and it will cost about 5 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** If you want to manage serverless Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.162.0, support for creating professional serverless cluster.

        > **NOTE:** From version 1.229.1, support to migrate basic serverless cluster to professional serverless cluster.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "ask-example-pro"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.2.0.0/21")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            vpc_id=default_network.id,
            cidr_block="10.2.1.0/24",
            zone_id=default.zones[0].id)
        serverless = alicloud.cs.ServerlessKubernetes("serverless",
            name_prefix=name,
            cluster_spec="ack.pro.small",
            vpc_id=default_network.id,
            vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            endpoint_public_access_enabled=True,
            deletion_protection=False,
            time_zone="Asia/Shanghai",
            service_cidr="172.21.0.0/20",
            tags={
                "k-aa": "v-aa",
                "k-bb": "v-bb",
            })
        ```

        ## Import

        Serverless Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/serverlessKubernetes:ServerlessKubernetes main ce4273f9156874b46bb
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessKubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessKubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesAddonArgs', 'ServerlessKubernetesAddonArgsDict']]]]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesDeleteOptionArgs', 'ServerlessKubernetesDeleteOptionArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ServerlessKubernetesMaintenanceWindowArgs', 'ServerlessKubernetesMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_policy: Optional[pulumi.Input[Union['ServerlessKubernetesOperationPolicyArgs', 'ServerlessKubernetesOperationPolicyArgsDict']]] = None,
                 private_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 service_discovery_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sls_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessKubernetesArgs.__new__(ServerlessKubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["custom_san"] = custom_san
            __props__.__dict__["delete_options"] = delete_options
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_rrsa"] = enable_rrsa
            __props__.__dict__["endpoint_public_access_enabled"] = endpoint_public_access_enabled
            __props__.__dict__["kube_config"] = kube_config
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["logging_type"] = logging_type
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["operation_policy"] = operation_policy
            __props__.__dict__["private_zone"] = private_zone
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["service_discovery_types"] = service_discovery_types
            __props__.__dict__["sls_project_name"] = sls_project_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["version"] = version
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["rrsa_metadata"] = None
        super(ServerlessKubernetes, __self__).__init__(
            'alicloud:cs/serverlessKubernetes:ServerlessKubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesAddonArgs', 'ServerlessKubernetesAddonArgsDict']]]]] = None,
            client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
            custom_san: Optional[pulumi.Input[_builtins.str]] = None,
            delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesDeleteOptionArgs', 'ServerlessKubernetesDeleteOptionArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
            logging_type: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['ServerlessKubernetesMaintenanceWindowArgs', 'ServerlessKubernetesMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
            operation_policy: Optional[pulumi.Input[Union['ServerlessKubernetesOperationPolicyArgs', 'ServerlessKubernetesOperationPolicyArgsDict']]] = None,
            private_zone: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rrsa_metadata: Optional[pulumi.Input[Union['ServerlessKubernetesRrsaMetadataArgs', 'ServerlessKubernetesRrsaMetadataArgsDict']]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            service_discovery_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sls_project_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerlessKubernetes':
        """
        Get an existing ServerlessKubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesAddonArgs', 'ServerlessKubernetesAddonArgsDict']]]] addons: You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
               - ack.standard: Standard serverless clusters.
               - ack.pro.small: Professional serverless clusters.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessKubernetesDeleteOptionArgs', 'ServerlessKubernetesDeleteOptionArgsDict']]]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.bool] endpoint_public_access_enabled: Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] logging_type: Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        :param pulumi.Input[Union['ServerlessKubernetesMaintenanceWindowArgs', 'ServerlessKubernetesMaintenanceWindowArgsDict']] maintenance_window: The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is the only in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        :param pulumi.Input[Union['ServerlessKubernetesOperationPolicyArgs', 'ServerlessKubernetesOperationPolicyArgsDict']] operation_policy: The cluster automatic operation policy. See `operation_policy` below.
               
               *Removed params*
        :param pulumi.Input[_builtins.bool] private_zone: Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[Union['ServerlessKubernetesRrsaMetadataArgs', 'ServerlessKubernetesRrsaMetadataArgsDict']] rrsa_metadata: Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discovery_types: Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        :param pulumi.Input[_builtins.str] sls_project_name: If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches where new kubernetes cluster will be located.
        :param pulumi.Input[_builtins.str] zone_id: When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessKubernetesState.__new__(_ServerlessKubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["custom_san"] = custom_san
        __props__.__dict__["delete_options"] = delete_options
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_rrsa"] = enable_rrsa
        __props__.__dict__["endpoint_public_access_enabled"] = endpoint_public_access_enabled
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["logging_type"] = logging_type
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["operation_policy"] = operation_policy
        __props__.__dict__["private_zone"] = private_zone
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["rrsa_metadata"] = rrsa_metadata
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["service_discovery_types"] = service_discovery_types
        __props__.__dict__["sls_project_name"] = sls_project_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        __props__.__dict__["zone_id"] = zone_id
        return ServerlessKubernetes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessKubernetesAddon']]]:
        """
        You can specific network plugin, log component, ingress component and so on. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
        """
        return pulumi.get(self, "cluster_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
        - ack.standard: Standard serverless clusters.
        - ack.pro.small: Professional serverless clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessKubernetesDeleteOption']]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable the deletion protection or not.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @_builtins.property
    @pulumi.getter(name="endpointPublicAccessEnabled")
    def endpoint_public_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create internet eip for API Server. Default to false. Only works for **Create** Operation.
        """
        return pulumi.get(self, "endpoint_public_access_enabled")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.229.1. The load balancer has been changed to PayByCLCU so that the spec is no need anymore.""")
    def load_balancer_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation.
        """
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="loggingType")
    @_utilities.deprecated("""Field 'logging_type' has been deprecated from provider version 1.229.1. Please use addons `alibaba-log-controller` to enable logging.""")
    def logging_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable log service, Valid value `SLS`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "logging_type")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.ServerlessKubernetesMaintenanceWindow']:
        """
        The cluster maintenance window，effective only in the professional managed cluster. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The kubernetes cluster's name. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
        """
        return pulumi.get(self, "new_nat_gateway")

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> pulumi.Output['outputs.ServerlessKubernetesOperationPolicy']:
        """
        The cluster automatic operation policy. See `operation_policy` below.

        *Removed params*
        """
        return pulumi.get(self, "operation_policy")

    @_builtins.property
    @pulumi.getter(name="privateZone")
    @_utilities.deprecated("""Field 'private_zone' has been deprecated from provider version 1.123.1. New field 'service_discovery_types' replace it.""")
    def private_zone(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
        """
        return pulumi.get(self, "private_zone")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "retain_resources")

    @_builtins.property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> pulumi.Output['outputs.ServerlessKubernetesRrsaMetadata']:
        """
        Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
        """
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveryTypes")
    def service_discovery_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Service discovery type. Only works for **Create** Operation. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
        """
        return pulumi.get(self, "service_discovery_types")

    @_builtins.property
    @pulumi.getter(name="slsProjectName")
    @_utilities.deprecated("""Field 'sls_project_name' has been deprecated from provider version 1.229.1. Please use the field `config` of addons `alibaba-log-controller` to specify log project name.""")
    def sls_project_name(self) -> pulumi.Output[_builtins.str]:
        """
        If you use an existing SLS project, you must specify `sls_project_name`. Only works for **Create** Operation.
        """
        return pulumi.get(self, "sls_project_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone of the cluster.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.  Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC will be built.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The vswitches where new kubernetes cluster will be located.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located. Only works for **Create** Operation.
        """
        return pulumi.get(self, "zone_id")

