# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DwResourceGroupArgs', 'DwResourceGroup']

@pulumi.input_type
class DwResourceGroupArgs:
    def __init__(__self__, *,
                 default_vpc_id: pulumi.Input[_builtins.str],
                 default_vswitch_id: pulumi.Input[_builtins.str],
                 remark: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DwResourceGroup resource.
        :param pulumi.Input[_builtins.str] default_vpc_id: The VPC ID of the default network resource.
        :param pulumi.Input[_builtins.str] default_vswitch_id: The ID of the vswitch bound to the network resource by default.
        :param pulumi.Input[_builtins.str] remark: Resource Group Comments
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. The default value is false.
        :param pulumi.Input[_builtins.int] payment_duration: When the payment method is Prepaid, the unit is PaymentDurationUnit.
        :param pulumi.Input[_builtins.str] payment_duration_unit: When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] resource_group_name: Resource group name
        :param pulumi.Input[_builtins.int] specification: Package year and package month resource group specifications, unit CU
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        pulumi.set(__self__, "default_vpc_id", default_vpc_id)
        pulumi.set(__self__, "default_vswitch_id", default_vswitch_id)
        pulumi.set(__self__, "remark", remark)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="defaultVpcId")
    def default_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID of the default network resource.
        """
        return pulumi.get(self, "default_vpc_id")

    @default_vpc_id.setter
    def default_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultVswitchId")
    def default_vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vswitch bound to the network resource by default.
        """
        return pulumi.get(self, "default_vswitch_id")

    @default_vswitch_id.setter
    def default_vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_vswitch_id", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Input[_builtins.str]:
        """
        Resource Group Comments
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. The default value is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When the payment method is Prepaid, the unit is PaymentDurationUnit.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Package year and package month resource group specifications, unit CU
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DwResourceGroupState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 default_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DwResourceGroup resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. The default value is false.
        :param pulumi.Input[_builtins.int] create_time: Resource group creation time
        :param pulumi.Input[_builtins.str] default_vpc_id: The VPC ID of the default network resource.
        :param pulumi.Input[_builtins.str] default_vswitch_id: The ID of the vswitch bound to the network resource by default.
        :param pulumi.Input[_builtins.int] payment_duration: When the payment method is Prepaid, the unit is PaymentDurationUnit.
        :param pulumi.Input[_builtins.str] payment_duration_unit: When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        :param pulumi.Input[_builtins.str] remark: Resource Group Comments
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] resource_group_name: Resource group name
        :param pulumi.Input[_builtins.int] specification: Package year and package month resource group specifications, unit CU
        :param pulumi.Input[_builtins.str] status: Resource group status:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_vpc_id is not None:
            pulumi.set(__self__, "default_vpc_id", default_vpc_id)
        if default_vswitch_id is not None:
            pulumi.set(__self__, "default_vswitch_id", default_vswitch_id)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. The default value is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Resource group creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="defaultVpcId")
    def default_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the default network resource.
        """
        return pulumi.get(self, "default_vpc_id")

    @default_vpc_id.setter
    def default_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultVswitchId")
    def default_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vswitch bound to the network resource by default.
        """
        return pulumi.get(self, "default_vswitch_id")

    @default_vswitch_id.setter
    def default_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When the payment method is Prepaid, the unit is PaymentDurationUnit.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group Comments
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Package year and package month resource group specifications, unit CU
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group status:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:dataworks/dwResourceGroup:DwResourceGroup")
class DwResourceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Data Works Dw Resource Group resource.

        For information about Data Works Dw Resource Group and how to use it, see [What is Dw Resource Group](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createresourcegroup).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_z_imu_co = alicloud.dataworks.Project("defaultZImuCO",
            description="default_pj002",
            project_name=name,
            display_name="default_pj002",
            pai_task_enabled=True)
        defaulte4zha_l = alicloud.vpc.Network("defaulte4zhaL",
            description="default_resgv2_vpc001",
            vpc_name=std.format(input="%s1",
                args=[name]).result,
            cidr_block="172.16.0.0/12")
        default675v38 = alicloud.vpc.Switch("default675v38",
            description="default_resg_vsw001",
            vpc_id=defaulte4zha_l.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s2",
                args=[name]).result,
            cidr_block="172.16.0.0/24")
        default = alicloud.dataworks.DwResourceGroup("default",
            payment_type="PostPaid",
            default_vpc_id=defaulte4zha_l.id,
            remark="openapi_example",
            resource_group_name="openapi_pop2_example_resg00002",
            default_vswitch_id=default675v38.id,
            payment_duration_unit="Month",
            specification=500,
            payment_duration=1)
        ```

        ## Import

        Data Works Dw Resource Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dwResourceGroup:DwResourceGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. The default value is false.
        :param pulumi.Input[_builtins.str] default_vpc_id: The VPC ID of the default network resource.
        :param pulumi.Input[_builtins.str] default_vswitch_id: The ID of the vswitch bound to the network resource by default.
        :param pulumi.Input[_builtins.int] payment_duration: When the payment method is Prepaid, the unit is PaymentDurationUnit.
        :param pulumi.Input[_builtins.str] payment_duration_unit: When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        :param pulumi.Input[_builtins.str] remark: Resource Group Comments
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] resource_group_name: Resource group name
        :param pulumi.Input[_builtins.int] specification: Package year and package month resource group specifications, unit CU
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DwResourceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Dw Resource Group resource.

        For information about Data Works Dw Resource Group and how to use it, see [What is Dw Resource Group](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createresourcegroup).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_z_imu_co = alicloud.dataworks.Project("defaultZImuCO",
            description="default_pj002",
            project_name=name,
            display_name="default_pj002",
            pai_task_enabled=True)
        defaulte4zha_l = alicloud.vpc.Network("defaulte4zhaL",
            description="default_resgv2_vpc001",
            vpc_name=std.format(input="%s1",
                args=[name]).result,
            cidr_block="172.16.0.0/12")
        default675v38 = alicloud.vpc.Switch("default675v38",
            description="default_resg_vsw001",
            vpc_id=defaulte4zha_l.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s2",
                args=[name]).result,
            cidr_block="172.16.0.0/24")
        default = alicloud.dataworks.DwResourceGroup("default",
            payment_type="PostPaid",
            default_vpc_id=defaulte4zha_l.id,
            remark="openapi_example",
            resource_group_name="openapi_pop2_example_resg00002",
            default_vswitch_id=default675v38.id,
            payment_duration_unit="Month",
            specification=500,
            payment_duration=1)
        ```

        ## Import

        Data Works Dw Resource Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dwResourceGroup:DwResourceGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DwResourceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DwResourceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DwResourceGroupArgs.__new__(DwResourceGroupArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if default_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'default_vpc_id'")
            __props__.__dict__["default_vpc_id"] = default_vpc_id
            if default_vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'default_vswitch_id'")
            __props__.__dict__["default_vswitch_id"] = default_vswitch_id
            __props__.__dict__["payment_duration"] = payment_duration
            __props__.__dict__["payment_duration_unit"] = payment_duration_unit
            __props__.__dict__["payment_type"] = payment_type
            if remark is None and not opts.urn:
                raise TypeError("Missing required property 'remark'")
            __props__.__dict__["remark"] = remark
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["specification"] = specification
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(DwResourceGroup, __self__).__init__(
            'alicloud:dataworks/dwResourceGroup:DwResourceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            default_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
            payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            remark: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DwResourceGroup':
        """
        Get an existing DwResourceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. The default value is false.
        :param pulumi.Input[_builtins.int] create_time: Resource group creation time
        :param pulumi.Input[_builtins.str] default_vpc_id: The VPC ID of the default network resource.
        :param pulumi.Input[_builtins.str] default_vswitch_id: The ID of the vswitch bound to the network resource by default.
        :param pulumi.Input[_builtins.int] payment_duration: When the payment method is Prepaid, the unit is PaymentDurationUnit.
        :param pulumi.Input[_builtins.str] payment_duration_unit: When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        :param pulumi.Input[_builtins.str] payment_type: The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        :param pulumi.Input[_builtins.str] remark: Resource Group Comments
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] resource_group_name: Resource group name
        :param pulumi.Input[_builtins.int] specification: Package year and package month resource group specifications, unit CU
        :param pulumi.Input[_builtins.str] status: Resource group status:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DwResourceGroupState.__new__(_DwResourceGroupState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_vpc_id"] = default_vpc_id
        __props__.__dict__["default_vswitch_id"] = default_vswitch_id
        __props__.__dict__["payment_duration"] = payment_duration
        __props__.__dict__["payment_duration_unit"] = payment_duration_unit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["remark"] = remark
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["specification"] = specification
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return DwResourceGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically renew. The default value is false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Resource group creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultVpcId")
    def default_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the default network resource.
        """
        return pulumi.get(self, "default_vpc_id")

    @_builtins.property
    @pulumi.getter(name="defaultVswitchId")
    def default_vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vswitch bound to the network resource by default.
        """
        return pulumi.get(self, "default_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        When the payment method is Prepaid, the unit is PaymentDurationUnit.
        """
        return pulumi.get(self, "payment_duration")

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When the payment method is Prepaid, the payment duration unit, Month is Month, Year is Year, and there is no other optional value.
        """
        return pulumi.get(self, "payment_duration_unit")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing type of the resource group. PrePaid is Subscription, and PostPaid is Pay-As-You-Go.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group Comments
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Package year and package month resource group specifications, unit CU
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Resource group status:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

