# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 dw_resource_group_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] dw_resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] vpc_id: Virtual Private Cloud ID of network resources
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID of the network resource.
        """
        pulumi.set(__self__, "dw_resource_group_id", dw_resource_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="dwResourceGroupId")
    def dw_resource_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "dw_resource_group_id")

    @dw_resource_group_id.setter
    def dw_resource_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dw_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Virtual Private Cloud ID of network resources
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vSwitch ID of the network resource.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 dw_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[_builtins.int] create_time: Time when the network resource was created
        :param pulumi.Input[_builtins.str] dw_resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: Network Resource Status
        :param pulumi.Input[_builtins.str] vpc_id: Virtual Private Cloud ID of network resources
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID of the network resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dw_resource_group_id is not None:
            pulumi.set(__self__, "dw_resource_group_id", dw_resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time when the network resource was created
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dwResourceGroupId")
    def dw_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "dw_resource_group_id")

    @dw_resource_group_id.setter
    def dw_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dw_resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Resource Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual Private Cloud ID of network resources
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID of the network resource.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:dataworks/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dw_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Works Network resource.

        Resource Group Network.

        For information about Data Works Network and how to use it, see [What is Network](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createnetwork).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default5_bia4h = alicloud.vpc.Network("default5Bia4h",
            description=name,
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        defaultss7s7_f = alicloud.vpc.Switch("defaultss7s7F",
            description=name,
            vpc_id=default5_bia4h.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s1",
                args=[name]).result,
            cidr_block="10.0.0.0/24")
        default_v_jv_kvl = alicloud.dataworks.DwResourceGroup("defaultVJvKvl",
            payment_duration_unit="Month",
            payment_type="PostPaid",
            specification=500,
            default_vswitch_id=defaultss7s7_f.id,
            remark=name,
            resource_group_name="network_openapi_example01",
            default_vpc_id=default5_bia4h.id)
        defaulte4zha_l = alicloud.vpc.Network("defaulte4zhaL",
            description=name,
            vpc_name=std.format(input="%s3",
                args=[name]).result,
            cidr_block="172.16.0.0/12")
        default675v38 = alicloud.vpc.Switch("default675v38",
            description=name,
            vpc_id=defaulte4zha_l.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s4",
                args=[name]).result,
            cidr_block="172.16.0.0/24")
        default = alicloud.dataworks.Network("default",
            vpc_id=defaulte4zha_l.id,
            vswitch_id=default675v38.id,
            dw_resource_group_id=default_v_jv_kvl.id)
        ```

        ## Import

        Data Works Network can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/network:Network example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dw_resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] vpc_id: Virtual Private Cloud ID of network resources
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID of the network resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Network resource.

        Resource Group Network.

        For information about Data Works Network and how to use it, see [What is Network](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createnetwork).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default5_bia4h = alicloud.vpc.Network("default5Bia4h",
            description=name,
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        defaultss7s7_f = alicloud.vpc.Switch("defaultss7s7F",
            description=name,
            vpc_id=default5_bia4h.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s1",
                args=[name]).result,
            cidr_block="10.0.0.0/24")
        default_v_jv_kvl = alicloud.dataworks.DwResourceGroup("defaultVJvKvl",
            payment_duration_unit="Month",
            payment_type="PostPaid",
            specification=500,
            default_vswitch_id=defaultss7s7_f.id,
            remark=name,
            resource_group_name="network_openapi_example01",
            default_vpc_id=default5_bia4h.id)
        defaulte4zha_l = alicloud.vpc.Network("defaulte4zhaL",
            description=name,
            vpc_name=std.format(input="%s3",
                args=[name]).result,
            cidr_block="172.16.0.0/12")
        default675v38 = alicloud.vpc.Switch("default675v38",
            description=name,
            vpc_id=defaulte4zha_l.id,
            zone_id="cn-beijing-g",
            vswitch_name=std.format(input="%s4",
                args=[name]).result,
            cidr_block="172.16.0.0/24")
        default = alicloud.dataworks.Network("default",
            vpc_id=defaulte4zha_l.id,
            vswitch_id=default675v38.id,
            dw_resource_group_id=default_v_jv_kvl.id)
        ```

        ## Import

        Data Works Network can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/network:Network example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dw_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            if dw_resource_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'dw_resource_group_id'")
            __props__.__dict__["dw_resource_group_id"] = dw_resource_group_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Network, __self__).__init__(
            'alicloud:dataworks/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            dw_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] create_time: Time when the network resource was created
        :param pulumi.Input[_builtins.str] dw_resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: Network Resource Status
        :param pulumi.Input[_builtins.str] vpc_id: Virtual Private Cloud ID of network resources
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID of the network resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dw_resource_group_id"] = dw_resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Time when the network resource was created
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dwResourceGroupId")
    def dw_resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "dw_resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Network Resource Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Virtual Private Cloud ID of network resources
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vSwitch ID of the network resource.
        """
        return pulumi.get(self, "vswitch_id")

