# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWafRulesResult',
    'AwaitableGetWafRulesResult',
    'get_waf_rules',
    'get_waf_rules_output',
]

@pulumi.output_type
class GetWafRulesResult:
    """
    A collection of values returned by getWafRules.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, page_number=None, page_size=None, query_args=None, waf_rules=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if query_args and not isinstance(query_args, str):
            raise TypeError("Expected argument 'query_args' to be a str")
        pulumi.set(__self__, "query_args", query_args)
        if waf_rules and not isinstance(waf_rules, list):
            raise TypeError("Expected argument 'waf_rules' to be a list")
        pulumi.set(__self__, "waf_rules", waf_rules)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="queryArgs")
    def query_args(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "query_args")

    @_builtins.property
    @pulumi.getter(name="wafRules")
    def waf_rules(self) -> Sequence['outputs.GetWafRulesWafRuleResult']:
        """
        A list of Waf Rule Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "waf_rules")


class AwaitableGetWafRulesResult(GetWafRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWafRulesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            query_args=self.query_args,
            waf_rules=self.waf_rules)


def get_waf_rules(ids: Optional[Sequence[_builtins.str]] = None,
                  output_file: Optional[_builtins.str] = None,
                  page_number: Optional[_builtins.int] = None,
                  page_size: Optional[_builtins.int] = None,
                  query_args: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWafRulesResult:
    """
    This data source provides Dcdn Waf Rule available to the user.[What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules)

    > **NOTE:** Available since v1.201.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.dcdn.get_waf_rules(ids=[default_alicloud_dcdn_waf_rule["id"]])
    pulumi.export("alicloudDcdnWafRuleExampleId", default.waf_rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Waf Rule IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str query_args: The query conditions. The value is a string in the JSON format.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['queryArgs'] = query_args
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dcdn/getWafRules:getWafRules', __args__, opts=opts, typ=GetWafRulesResult).value

    return AwaitableGetWafRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        query_args=pulumi.get(__ret__, 'query_args'),
        waf_rules=pulumi.get(__ret__, 'waf_rules'))
def get_waf_rules_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         query_args: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWafRulesResult]:
    """
    This data source provides Dcdn Waf Rule available to the user.[What is Waf Rule](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-batchcreatedcdnwafrules)

    > **NOTE:** Available since v1.201.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.dcdn.get_waf_rules(ids=[default_alicloud_dcdn_waf_rule["id"]])
    pulumi.export("alicloudDcdnWafRuleExampleId", default.waf_rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Waf Rule IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str query_args: The query conditions. The value is a string in the JSON format.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['queryArgs'] = query_args
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:dcdn/getWafRules:getWafRules', __args__, opts=opts, typ=GetWafRulesResult)
    return __ret__.apply(lambda __response__: GetWafRulesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        query_args=pulumi.get(__response__, 'query_args'),
        waf_rules=pulumi.get(__response__, 'waf_rules')))
