# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WafPolicyArgs', 'WafPolicy']

@pulumi.input_type
class WafPolicyArgs:
    def __init__(__self__, *,
                 defense_scene: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 policy_type: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a WafPolicy resource.
        :param pulumi.Input[_builtins.str] defense_scene: The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        :param pulumi.Input[_builtins.str] policy_name: The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        :param pulumi.Input[_builtins.str] policy_type: The type of the protection policy. Valid values: `default`, `custom`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `on`, `off`.
        """
        pulumi.set(__self__, "defense_scene", defense_scene)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> pulumi.Input[_builtins.str]:
        """
        The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        """
        return pulumi.get(self, "defense_scene")

    @defense_scene.setter
    def defense_scene(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "defense_scene", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the protection policy. Valid values: `default`, `custom`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The status of the resource. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _WafPolicyState:
    def __init__(__self__, *,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WafPolicy resources.
        :param pulumi.Input[_builtins.str] defense_scene: The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        :param pulumi.Input[_builtins.str] policy_name: The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        :param pulumi.Input[_builtins.str] policy_type: The type of the protection policy. Valid values: `default`, `custom`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `on`, `off`.
        """
        if defense_scene is not None:
            pulumi.set(__self__, "defense_scene", defense_scene)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        """
        return pulumi.get(self, "defense_scene")

    @defense_scene.setter
    def defense_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defense_scene", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the protection policy. Valid values: `default`, `custom`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:dcdn/wafPolicy:WafPolicy")
class WafPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DCDN Waf Policy resource.

        For information about DCDN Waf Policy and how to use it, see [What is Waf Policy](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-createdcdnwafpolicy).

        > **NOTE:** Available since v1.184.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.dcdn.WafPolicy("example",
            defense_scene="waf_group",
            policy_name=f"{name}_{default['result']}",
            policy_type="custom",
            status="on")
        ```

        ## Import

        DCDN Waf Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/wafPolicy:WafPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defense_scene: The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        :param pulumi.Input[_builtins.str] policy_name: The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        :param pulumi.Input[_builtins.str] policy_type: The type of the protection policy. Valid values: `default`, `custom`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `on`, `off`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WafPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DCDN Waf Policy resource.

        For information about DCDN Waf Policy and how to use it, see [What is Waf Policy](https://www.alibabacloud.com/help/en/dcdn/developer-reference/api-dcdn-2018-01-15-createdcdnwafpolicy).

        > **NOTE:** Available since v1.184.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.dcdn.WafPolicy("example",
            defense_scene="waf_group",
            policy_name=f"{name}_{default['result']}",
            policy_type="custom",
            status="on")
        ```

        ## Import

        DCDN Waf Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/wafPolicy:WafPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WafPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WafPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WafPolicyArgs.__new__(WafPolicyArgs)

            if defense_scene is None and not opts.urn:
                raise TypeError("Missing required property 'defense_scene'")
            __props__.__dict__["defense_scene"] = defense_scene
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            if policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type'")
            __props__.__dict__["policy_type"] = policy_type
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
        super(WafPolicy, __self__).__init__(
            'alicloud:dcdn/wafPolicy:WafPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defense_scene: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'WafPolicy':
        """
        Get an existing WafPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defense_scene: The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        :param pulumi.Input[_builtins.str] policy_name: The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        :param pulumi.Input[_builtins.str] policy_type: The type of the protection policy. Valid values: `default`, `custom`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `on`, `off`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WafPolicyState.__new__(_WafPolicyState)

        __props__.__dict__["defense_scene"] = defense_scene
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["status"] = status
        return WafPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defenseScene")
    def defense_scene(self) -> pulumi.Output[_builtins.str]:
        """
        The type of protection policy. Valid values: `waf_group`, `custom_acl`, `whitelist`, `ip_blacklist`, `region_block`.
        """
        return pulumi.get(self, "defense_scene")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the protection policy. The name must be 1 to 64 characters in length, and can contain letters, digits,and underscores (_).
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the protection policy. Valid values: `default`, `custom`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "status")

