# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VscMountPointArgs', 'VscMountPoint']

@pulumi.input_type
class VscMountPointArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VscMountPoint resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the HDFS file system resource associated with the VSC mount point.
        :param pulumi.Input[_builtins.str] alias_prefix: Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  The length is 0 to 100 characters.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if alias_prefix is not None:
            pulumi.set(__self__, "alias_prefix", alias_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the HDFS file system resource associated with the VSC mount point.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        """
        return pulumi.get(self, "alias_prefix")

    @alias_prefix.setter
    def alias_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias_prefix", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Mount point.  The length is 0 to 100 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _VscMountPointState:
    def __init__(__self__, *,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceArgs']]]] = None,
                 mount_point_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VscMountPoint resources.
        :param pulumi.Input[_builtins.str] alias_prefix: Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  The length is 0 to 100 characters.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the HDFS file system resource associated with the VSC mount point.
        :param pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceArgs']]] instances: The collection of ECS instances on which the HDFS file system is mounted. **The current property is not available**.
        :param pulumi.Input[_builtins.str] mount_point_id: VSC mount point ID, which is the unique identifier of the vsc mount point and is used to access the associated HDFS file system.
        """
        if alias_prefix is not None:
            pulumi.set(__self__, "alias_prefix", alias_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if mount_point_id is not None:
            pulumi.set(__self__, "mount_point_id", mount_point_id)

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        """
        return pulumi.get(self, "alias_prefix")

    @alias_prefix.setter
    def alias_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias_prefix", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Mount point.  The length is 0 to 100 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the HDFS file system resource associated with the VSC mount point.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceArgs']]]]:
        """
        The collection of ECS instances on which the HDFS file system is mounted. **The current property is not available**.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VSC mount point ID, which is the unique identifier of the vsc mount point and is used to access the associated HDFS file system.
        """
        return pulumi.get(self, "mount_point_id")

    @mount_point_id.setter
    def mount_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_point_id", value)


@pulumi.type_token("alicloud:dfs/vscMountPoint:VscMountPoint")
class VscMountPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Apsara File Storage for HDFS (DFS) Vsc Mount Point resource.

        For information about Apsara File Storage for HDFS (DFS) Vsc Mount Point and how to use it, see [What is Vsc Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.218.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_file_system = alicloud.dfs.FileSystem("default",
            space_capacity=1024,
            description="for vsc mountpoint RMC test",
            storage_type="PERFORMANCE",
            zone_id="cn-hangzhou-b",
            protocol_type="PANGU",
            data_redundancy_type="LRS",
            file_system_name=name)
        default_fs_for_rmcvsc_mp = alicloud.dfs.VscMountPoint("DefaultFsForRMCVscMp",
            file_system_id=default_file_system.id,
            alias_prefix=name,
            description=name)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) Vsc Mount Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/vscMountPoint:VscMountPoint example <file_system_id>:<mount_point_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias_prefix: Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  The length is 0 to 100 characters.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the HDFS file system resource associated with the VSC mount point.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VscMountPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Apsara File Storage for HDFS (DFS) Vsc Mount Point resource.

        For information about Apsara File Storage for HDFS (DFS) Vsc Mount Point and how to use it, see [What is Vsc Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.218.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_file_system = alicloud.dfs.FileSystem("default",
            space_capacity=1024,
            description="for vsc mountpoint RMC test",
            storage_type="PERFORMANCE",
            zone_id="cn-hangzhou-b",
            protocol_type="PANGU",
            data_redundancy_type="LRS",
            file_system_name=name)
        default_fs_for_rmcvsc_mp = alicloud.dfs.VscMountPoint("DefaultFsForRMCVscMp",
            file_system_id=default_file_system.id,
            alias_prefix=name,
            description=name)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) Vsc Mount Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/vscMountPoint:VscMountPoint example <file_system_id>:<mount_point_id>
        ```

        :param str resource_name: The name of the resource.
        :param VscMountPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VscMountPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VscMountPointArgs.__new__(VscMountPointArgs)

            __props__.__dict__["alias_prefix"] = alias_prefix
            __props__.__dict__["description"] = description
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["instances"] = None
            __props__.__dict__["mount_point_id"] = None
        super(VscMountPoint, __self__).__init__(
            'alicloud:dfs/vscMountPoint:VscMountPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VscMountPointInstanceArgs', 'VscMountPointInstanceArgsDict']]]]] = None,
            mount_point_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VscMountPoint':
        """
        Get an existing VscMountPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias_prefix: Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        :param pulumi.Input[_builtins.str] description: The description of the Mount point.  The length is 0 to 100 characters.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the HDFS file system resource associated with the VSC mount point.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VscMountPointInstanceArgs', 'VscMountPointInstanceArgsDict']]]] instances: The collection of ECS instances on which the HDFS file system is mounted. **The current property is not available**.
        :param pulumi.Input[_builtins.str] mount_point_id: VSC mount point ID, which is the unique identifier of the vsc mount point and is used to access the associated HDFS file system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VscMountPointState.__new__(_VscMountPointState)

        __props__.__dict__["alias_prefix"] = alias_prefix
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["instances"] = instances
        __props__.__dict__["mount_point_id"] = mount_point_id
        return VscMountPoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aliasPrefix")
    def alias_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
        """
        return pulumi.get(self, "alias_prefix")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Mount point.  The length is 0 to 100 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the HDFS file system resource associated with the VSC mount point.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence['outputs.VscMountPointInstance']]:
        """
        The collection of ECS instances on which the HDFS file system is mounted. **The current property is not available**.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> pulumi.Output[_builtins.str]:
        """
        VSC mount point ID, which is the unique identifier of the vsc mount point and is used to access the associated HDFS file system.
        """
        return pulumi.get(self, "mount_point_id")

