# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnterpriseLogicDatabaseArgs', 'EnterpriseLogicDatabase']

@pulumi.input_type
class EnterpriseLogicDatabaseArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[_builtins.str],
                 database_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 logic_database_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnterpriseLogicDatabase resource.
        :param pulumi.Input[_builtins.str] alias: Logical Library alias.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] database_ids: Sub-Database ID
        :param pulumi.Input[_builtins.str] logic_database_id: The ID of the logical Library.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "database_ids", database_ids)
        if logic_database_id is not None:
            pulumi.set(__self__, "logic_database_id", logic_database_id)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Input[_builtins.str]:
        """
        Logical Library alias.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="databaseIds")
    def database_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Sub-Database ID
        """
        return pulumi.get(self, "database_ids")

    @database_ids.setter
    def database_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "database_ids", value)

    @_builtins.property
    @pulumi.getter(name="logicDatabaseId")
    def logic_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the logical Library.
        """
        return pulumi.get(self, "logic_database_id")

    @logic_database_id.setter
    def logic_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic_database_id", value)


@pulumi.input_type
class _EnterpriseLogicDatabaseState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 db_type: Optional[pulumi.Input[_builtins.str]] = None,
                 env_type: Optional[pulumi.Input[_builtins.str]] = None,
                 logic: Optional[pulumi.Input[_builtins.bool]] = None,
                 logic_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 owner_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 search_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnterpriseLogicDatabase resources.
        :param pulumi.Input[_builtins.str] alias: Logical Library alias.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] database_ids: Sub-Database ID
        :param pulumi.Input[_builtins.str] db_type: Database type.
        :param pulumi.Input[_builtins.str] env_type: Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        :param pulumi.Input[_builtins.bool] logic: Whether it is a logical Library, the return value is true.
        :param pulumi.Input[_builtins.str] logic_database_id: The ID of the logical Library.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owner_id_lists: The user ID list of the logical library Owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owner_name_lists: The nickname list of the logical library Owner.
        :param pulumi.Input[_builtins.str] schema_name: Logical Library name.
        :param pulumi.Input[_builtins.str] search_name: Logical library search name.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if database_ids is not None:
            pulumi.set(__self__, "database_ids", database_ids)
        if db_type is not None:
            pulumi.set(__self__, "db_type", db_type)
        if env_type is not None:
            pulumi.set(__self__, "env_type", env_type)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if logic_database_id is not None:
            pulumi.set(__self__, "logic_database_id", logic_database_id)
        if owner_id_lists is not None:
            pulumi.set(__self__, "owner_id_lists", owner_id_lists)
        if owner_name_lists is not None:
            pulumi.set(__self__, "owner_name_lists", owner_name_lists)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if search_name is not None:
            pulumi.set(__self__, "search_name", search_name)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical Library alias.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="databaseIds")
    def database_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Sub-Database ID
        """
        return pulumi.get(self, "database_ids")

    @database_ids.setter
    def database_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "database_ids", value)

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type.
        """
        return pulumi.get(self, "db_type")

    @db_type.setter
    def db_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_type", value)

    @_builtins.property
    @pulumi.getter(name="envType")
    def env_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        """
        return pulumi.get(self, "env_type")

    @env_type.setter
    def env_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_type", value)

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether it is a logical Library, the return value is true.
        """
        return pulumi.get(self, "logic")

    @logic.setter
    def logic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logic", value)

    @_builtins.property
    @pulumi.getter(name="logicDatabaseId")
    def logic_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the logical Library.
        """
        return pulumi.get(self, "logic_database_id")

    @logic_database_id.setter
    def logic_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic_database_id", value)

    @_builtins.property
    @pulumi.getter(name="ownerIdLists")
    def owner_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The user ID list of the logical library Owner.
        """
        return pulumi.get(self, "owner_id_lists")

    @owner_id_lists.setter
    def owner_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="ownerNameLists")
    def owner_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The nickname list of the logical library Owner.
        """
        return pulumi.get(self, "owner_name_lists")

    @owner_name_lists.setter
    def owner_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_name_lists", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical Library name.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="searchName")
    def search_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical library search name.
        """
        return pulumi.get(self, "search_name")

    @search_name.setter
    def search_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_name", value)


@pulumi.type_token("alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase")
class EnterpriseLogicDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logic_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DMS Enterprise Logic Database resource.

        For information about DMS Enterprise Logic Database and how to use it, see [What is Logic Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createlogicdatabase).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.dms.EnterpriseLogicDatabase("default",
            alias="TF_logic_db_test",
            database_ids=[
                "35617919",
                "35617920",
            ])
        ```

        ## Import

        DMS Enterprise Logic Database can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Logical Library alias.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] database_ids: Sub-Database ID
        :param pulumi.Input[_builtins.str] logic_database_id: The ID of the logical Library.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseLogicDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS Enterprise Logic Database resource.

        For information about DMS Enterprise Logic Database and how to use it, see [What is Logic Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createlogicdatabase).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.dms.EnterpriseLogicDatabase("default",
            alias="TF_logic_db_test",
            database_ids=[
                "35617919",
                "35617920",
            ])
        ```

        ## Import

        DMS Enterprise Logic Database can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseLogicDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseLogicDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 logic_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseLogicDatabaseArgs.__new__(EnterpriseLogicDatabaseArgs)

            if alias is None and not opts.urn:
                raise TypeError("Missing required property 'alias'")
            __props__.__dict__["alias"] = alias
            if database_ids is None and not opts.urn:
                raise TypeError("Missing required property 'database_ids'")
            __props__.__dict__["database_ids"] = database_ids
            __props__.__dict__["logic_database_id"] = logic_database_id
            __props__.__dict__["db_type"] = None
            __props__.__dict__["env_type"] = None
            __props__.__dict__["logic"] = None
            __props__.__dict__["owner_id_lists"] = None
            __props__.__dict__["owner_name_lists"] = None
            __props__.__dict__["schema_name"] = None
            __props__.__dict__["search_name"] = None
        super(EnterpriseLogicDatabase, __self__).__init__(
            'alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            db_type: Optional[pulumi.Input[_builtins.str]] = None,
            env_type: Optional[pulumi.Input[_builtins.str]] = None,
            logic: Optional[pulumi.Input[_builtins.bool]] = None,
            logic_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            owner_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            search_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnterpriseLogicDatabase':
        """
        Get an existing EnterpriseLogicDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Logical Library alias.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] database_ids: Sub-Database ID
        :param pulumi.Input[_builtins.str] db_type: Database type.
        :param pulumi.Input[_builtins.str] env_type: Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        :param pulumi.Input[_builtins.bool] logic: Whether it is a logical Library, the return value is true.
        :param pulumi.Input[_builtins.str] logic_database_id: The ID of the logical Library.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owner_id_lists: The user ID list of the logical library Owner.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owner_name_lists: The nickname list of the logical library Owner.
        :param pulumi.Input[_builtins.str] schema_name: Logical Library name.
        :param pulumi.Input[_builtins.str] search_name: Logical library search name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseLogicDatabaseState.__new__(_EnterpriseLogicDatabaseState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["database_ids"] = database_ids
        __props__.__dict__["db_type"] = db_type
        __props__.__dict__["env_type"] = env_type
        __props__.__dict__["logic"] = logic
        __props__.__dict__["logic_database_id"] = logic_database_id
        __props__.__dict__["owner_id_lists"] = owner_id_lists
        __props__.__dict__["owner_name_lists"] = owner_name_lists
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["search_name"] = search_name
        return EnterpriseLogicDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[_builtins.str]:
        """
        Logical Library alias.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="databaseIds")
    def database_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Sub-Database ID
        """
        return pulumi.get(self, "database_ids")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> pulumi.Output[_builtins.str]:
        """
        Database type.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="envType")
    def env_type(self) -> pulumi.Output[_builtins.str]:
        """
        Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
        """
        return pulumi.get(self, "env_type")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether it is a logical Library, the return value is true.
        """
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="logicDatabaseId")
    def logic_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the logical Library.
        """
        return pulumi.get(self, "logic_database_id")

    @_builtins.property
    @pulumi.getter(name="ownerIdLists")
    def owner_id_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The user ID list of the logical library Owner.
        """
        return pulumi.get(self, "owner_id_lists")

    @_builtins.property
    @pulumi.getter(name="ownerNameLists")
    def owner_name_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The nickname list of the logical library Owner.
        """
        return pulumi.get(self, "owner_name_lists")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        Logical Library name.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="searchName")
    def search_name(self) -> pulumi.Output[_builtins.str]:
        """
        Logical library search name.
        """
        return pulumi.get(self, "search_name")

