# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnterpriseWorkspaceArgs', 'EnterpriseWorkspace']

@pulumi.input_type
class EnterpriseWorkspaceArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 workspace_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EnterpriseWorkspace resource.
        :param pulumi.Input[_builtins.str] description: The description of the Workspace.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] workspace_name: The name of the Workspace.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "workspace_name", workspace_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the Workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_name", value)


@pulumi.input_type
class _EnterpriseWorkspaceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnterpriseWorkspace resources.
        :param pulumi.Input[_builtins.str] description: The description of the Workspace.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] workspace_name: The name of the Workspace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_name", value)


@pulumi.type_token("alicloud:dms/enterpriseWorkspace:EnterpriseWorkspace")
class EnterpriseWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DMS Enterprise Workspace resource.

        For information about DMS Enterprise Workspace and how to use it, see [What is Workspace](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateWorkspace).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        vpc_create = alicloud.vpc.Network("vpc_create",
            is_default=False,
            description="example vpc",
            cidr_block="192.168.0.0/16",
            vpc_name=f"{name}-{default['result']}")
        default_enterprise_workspace = alicloud.dms.EnterpriseWorkspace("default",
            description=name,
            workspace_name=f"{name}-{default['result']}",
            vpc_id=vpc_create.id)
        ```

        ## Import

        DMS Enterprise Workspace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/enterpriseWorkspace:EnterpriseWorkspace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Workspace.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] workspace_name: The name of the Workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS Enterprise Workspace resource.

        For information about DMS Enterprise Workspace and how to use it, see [What is Workspace](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateWorkspace).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        vpc_create = alicloud.vpc.Network("vpc_create",
            is_default=False,
            description="example vpc",
            cidr_block="192.168.0.0/16",
            vpc_name=f"{name}-{default['result']}")
        default_enterprise_workspace = alicloud.dms.EnterpriseWorkspace("default",
            description=name,
            workspace_name=f"{name}-{default['result']}",
            vpc_id=vpc_create.id)
        ```

        ## Import

        DMS Enterprise Workspace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/enterpriseWorkspace:EnterpriseWorkspace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseWorkspaceArgs.__new__(EnterpriseWorkspaceArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["region_id"] = None
        super(EnterpriseWorkspace, __self__).__init__(
            'alicloud:dms/enterpriseWorkspace:EnterpriseWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnterpriseWorkspace':
        """
        Get an existing EnterpriseWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Workspace.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] workspace_name: The name of the Workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseWorkspaceState.__new__(_EnterpriseWorkspaceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["workspace_name"] = workspace_name
        return EnterpriseWorkspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the Workspace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Workspace.
        """
        return pulumi.get(self, "workspace_name")

