# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnterpriseDatabasesResult',
    'AwaitableGetEnterpriseDatabasesResult',
    'get_enterprise_databases',
    'get_enterprise_databases_output',
]

@pulumi.output_type
class GetEnterpriseDatabasesResult:
    """
    A collection of values returned by getEnterpriseDatabases.
    """
    def __init__(__self__, databases=None, id=None, ids=None, instance_id=None, name_regex=None, output_file=None):
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetEnterpriseDatabasesDatabaseResult']:
        """
        A list of Database Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Database IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The instance ID of the target database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetEnterpriseDatabasesResult(GetEnterpriseDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnterpriseDatabasesResult(
            databases=self.databases,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            output_file=self.output_file)


def get_enterprise_databases(ids: Optional[Sequence[_builtins.str]] = None,
                             instance_id: Optional[_builtins.str] = None,
                             name_regex: Optional[_builtins.str] = None,
                             output_file: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnterpriseDatabasesResult:
    """
    This data source provides DMS Enterprise Database available to the user. [What is Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-listdatabases).

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.dms.get_enterprise_databases(name_regex="test2",
        instance_id="2195118")
    pulumi.export("alicloudDmsEnterpriseDatabaseExampleId", default.databases[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Database IDs.
    :param _builtins.str instance_id: The instance ID of the target database.
    :param _builtins.str name_regex: A regex string to filter the results by the database Schema Name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dms/getEnterpriseDatabases:getEnterpriseDatabases', __args__, opts=opts, typ=GetEnterpriseDatabasesResult).value

    return AwaitableGetEnterpriseDatabasesResult(
        databases=pulumi.get(__ret__, 'databases'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_enterprise_databases_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnterpriseDatabasesResult]:
    """
    This data source provides DMS Enterprise Database available to the user. [What is Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-listdatabases).

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.dms.get_enterprise_databases(name_regex="test2",
        instance_id="2195118")
    pulumi.export("alicloudDmsEnterpriseDatabaseExampleId", default.databases[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Database IDs.
    :param _builtins.str instance_id: The instance ID of the target database.
    :param _builtins.str name_regex: A regex string to filter the results by the database Schema Name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:dms/getEnterpriseDatabases:getEnterpriseDatabases', __args__, opts=opts, typ=GetEnterpriseDatabasesResult)
    return __ret__.apply(lambda __response__: GetEnterpriseDatabasesResult(
        databases=pulumi.get(__response__, 'databases'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        output_file=pulumi.get(__response__, 'output_file')))
