# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnterpriseProxyAccessesResult',
    'AwaitableGetEnterpriseProxyAccessesResult',
    'get_enterprise_proxy_accesses',
    'get_enterprise_proxy_accesses_output',
]

@pulumi.output_type
class GetEnterpriseProxyAccessesResult:
    """
    A collection of values returned by getEnterpriseProxyAccesses.
    """
    def __init__(__self__, accesses=None, enable_details=None, id=None, ids=None, output_file=None, proxy_id=None):
        if accesses and not isinstance(accesses, list):
            raise TypeError("Expected argument 'accesses' to be a list")
        pulumi.set(__self__, "accesses", accesses)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if proxy_id and not isinstance(proxy_id, str):
            raise TypeError("Expected argument 'proxy_id' to be a str")
        pulumi.set(__self__, "proxy_id", proxy_id)

    @_builtins.property
    @pulumi.getter
    def accesses(self) -> Sequence['outputs.GetEnterpriseProxyAccessesAccessResult']:
        """
        A list of Proxy Access Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "accesses")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Proxy Access IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        The ID of the security agent.
        """
        return pulumi.get(self, "proxy_id")


class AwaitableGetEnterpriseProxyAccessesResult(GetEnterpriseProxyAccessesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnterpriseProxyAccessesResult(
            accesses=self.accesses,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            proxy_id=self.proxy_id)


def get_enterprise_proxy_accesses(enable_details: Optional[_builtins.bool] = None,
                                  ids: Optional[Sequence[_builtins.str]] = None,
                                  output_file: Optional[_builtins.str] = None,
                                  proxy_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnterpriseProxyAccessesResult:
    """
    This data source provides DMS Enterprise Proxy Access available to the user.[What is Proxy Access](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateProxyAccess)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_enterprise_proxy_access = alicloud.dms.EnterpriseProxyAccess("default",
        indep_password="PASSWORD-DEMO",
        proxy_id="1881",
        indep_account="dmstest",
        user_id="104442")
    default = alicloud.dms.get_enterprise_proxy_accesses_output(ids=[default_enterprise_proxy_access.id],
        proxy_id="1881")
    pulumi.export("alicloudDmsProxyAccesesExampleId", default.accesses[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Proxy Access IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str proxy_id: The ID of the security agent.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['proxyId'] = proxy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:dms/getEnterpriseProxyAccesses:getEnterpriseProxyAccesses', __args__, opts=opts, typ=GetEnterpriseProxyAccessesResult).value

    return AwaitableGetEnterpriseProxyAccessesResult(
        accesses=pulumi.get(__ret__, 'accesses'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        proxy_id=pulumi.get(__ret__, 'proxy_id'))
def get_enterprise_proxy_accesses_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         proxy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnterpriseProxyAccessesResult]:
    """
    This data source provides DMS Enterprise Proxy Access available to the user.[What is Proxy Access](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateProxyAccess)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_enterprise_proxy_access = alicloud.dms.EnterpriseProxyAccess("default",
        indep_password="PASSWORD-DEMO",
        proxy_id="1881",
        indep_account="dmstest",
        user_id="104442")
    default = alicloud.dms.get_enterprise_proxy_accesses_output(ids=[default_enterprise_proxy_access.id],
        proxy_id="1881")
    pulumi.export("alicloudDmsProxyAccesesExampleId", default.accesses[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Proxy Access IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str proxy_id: The ID of the security agent.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['proxyId'] = proxy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:dms/getEnterpriseProxyAccesses:getEnterpriseProxyAccesses', __args__, opts=opts, typ=GetEnterpriseProxyAccessesResult)
    return __ret__.apply(lambda __response__: GetEnterpriseProxyAccessesResult(
        accesses=pulumi.get(__response__, 'accesses'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        proxy_id=pulumi.get(__response__, 'proxy_id')))
