# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerGroupArgs', 'ContainerGroup']

@pulumi.input_type
class ContainerGroupArgs:
    def __init__(__self__, *,
                 container_group_name: pulumi.Input[_builtins.str],
                 containers: pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]],
                 security_group_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 dns_config: Optional[pulumi.Input['ContainerGroupDnsConfigArgs']] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]] = None,
                 insecure_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 plain_http_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context: Optional[pulumi.Input['ContainerGroupSecurityContextArgs']] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ContainerGroup resource.
        :param pulumi.Input[_builtins.str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]] containers: The list of containers. See `containers` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
               **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]] acr_registry_infos: The ACR enterprise edition example properties. See `acr_registry_info` below.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input['ContainerGroupDnsConfigArgs'] dns_config: The structure of dnsConfig. See `dns_config` below.
        :param pulumi.Input[_builtins.str] dns_policy: The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the EIP. Default value: `5`.
        :param pulumi.Input[_builtins.str] eip_instance_id: The ID of the elastic IP address (EIP).
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the temporary storage space to add. Unit: GiB.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential. See `image_registry_credential` below.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below.
        :param pulumi.Input[_builtins.str] insecure_registry: The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ECS instance.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] plain_http_registry: The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        :param pulumi.Input['ContainerGroupSecurityContextArgs'] security_context: The security context of the container group. See `security_context` below.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum hourly price of the ECI spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The buffer time during which the program handles operations before the program stops. Unit: seconds.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]] volumes: The list of volumes. See `volumes` below.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        pulumi.set(__self__, "container_group_name", container_group_name)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if auto_match_image_cache is not None:
            pulumi.set(__self__, "auto_match_image_cache", auto_match_image_cache)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_instance_id is not None:
            pulumi.set(__self__, "eip_instance_id", eip_instance_id)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if insecure_registry is not None:
            pulumi.set(__self__, "insecure_registry", insecure_registry)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if plain_http_registry is not None:
            pulumi.set(__self__, "plain_http_registry", plain_http_registry)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_group_name", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]]:
        """
        The list of containers. See `containers` below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
        **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]]:
        """
        The ACR enterprise edition example properties. See `acr_registry_info` below.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @auto_match_image_cache.setter
    def auto_match_image_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_match_image_cache", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['ContainerGroupDnsConfigArgs']]:
        """
        The structure of dnsConfig. See `dns_config` below.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['ContainerGroupDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the EIP. Default value: `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="eipInstanceId")
    def eip_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the elastic IP address (EIP).
        """
        return pulumi.get(self, "eip_instance_id")

    @eip_instance_id.setter
    def eip_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the temporary storage space to add. Unit: GiB.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]]:
        """
        The image registry credential. See `image_registry_credential` below.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter(name="insecureRegistry")
    def insecure_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        """
        return pulumi.get(self, "insecure_registry")

    @insecure_registry.setter
    def insecure_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insecure_registry", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="plainHttpRegistry")
    def plain_http_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        """
        return pulumi.get(self, "plain_http_registry")

    @plain_http_registry.setter
    def plain_http_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plain_http_registry", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['ContainerGroupSecurityContextArgs']]:
        """
        The security context of the container group. See `security_context` below.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['ContainerGroupSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum hourly price of the ECI spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The buffer time during which the program handles operations before the program stops. Unit: seconds.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ContainerGroupState:
    def __init__(__self__, *,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 dns_config: Optional[pulumi.Input['ContainerGroupDnsConfigArgs']] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]] = None,
                 insecure_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 intranet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 plain_http_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context: Optional[pulumi.Input['ContainerGroupSecurityContextArgs']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]] acr_registry_infos: The ACR enterprise edition example properties. See `acr_registry_info` below.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        :param pulumi.Input[_builtins.str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]] containers: The list of containers. See `containers` below.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input['ContainerGroupDnsConfigArgs'] dns_config: The structure of dnsConfig. See `dns_config` below.
        :param pulumi.Input[_builtins.str] dns_policy: The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the EIP. Default value: `5`.
        :param pulumi.Input[_builtins.str] eip_instance_id: The ID of the elastic IP address (EIP).
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the temporary storage space to add. Unit: GiB.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential. See `image_registry_credential` below.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below.
        :param pulumi.Input[_builtins.str] insecure_registry: The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ECS instance.
        :param pulumi.Input[_builtins.str] internet_ip: (Available since v1.170.0) The Public IP of the container group.
        :param pulumi.Input[_builtins.str] intranet_ip: (Available since v1.170.0) The Private IP of the container group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] plain_http_registry: The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        :param pulumi.Input['ContainerGroupSecurityContextArgs'] security_context: The security context of the container group. See `security_context` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum hourly price of the ECI spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        :param pulumi.Input[_builtins.str] status: The status of container group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The buffer time during which the program handles operations before the program stops. Unit: seconds.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]] volumes: The list of volumes. See `volumes` below.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
               **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if auto_match_image_cache is not None:
            pulumi.set(__self__, "auto_match_image_cache", auto_match_image_cache)
        if container_group_name is not None:
            pulumi.set(__self__, "container_group_name", container_group_name)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_instance_id is not None:
            pulumi.set(__self__, "eip_instance_id", eip_instance_id)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if insecure_registry is not None:
            pulumi.set(__self__, "insecure_registry", insecure_registry)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if intranet_ip is not None:
            pulumi.set(__self__, "intranet_ip", intranet_ip)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if plain_http_registry is not None:
            pulumi.set(__self__, "plain_http_registry", plain_http_registry)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]]:
        """
        The ACR enterprise edition example properties. See `acr_registry_info` below.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @auto_match_image_cache.setter
    def auto_match_image_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_match_image_cache", value)

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_group_name", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]]]:
        """
        The list of containers. See `containers` below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['ContainerGroupDnsConfigArgs']]:
        """
        The structure of dnsConfig. See `dns_config` below.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['ContainerGroupDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the EIP. Default value: `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="eipInstanceId")
    def eip_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the elastic IP address (EIP).
        """
        return pulumi.get(self, "eip_instance_id")

    @eip_instance_id.setter
    def eip_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the temporary storage space to add. Unit: GiB.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]]:
        """
        The image registry credential. See `image_registry_credential` below.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter(name="insecureRegistry")
    def insecure_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        """
        return pulumi.get(self, "insecure_registry")

    @insecure_registry.setter
    def insecure_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insecure_registry", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.170.0) The Public IP of the container group.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_ip", value)

    @_builtins.property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.170.0) The Private IP of the container group.
        """
        return pulumi.get(self, "intranet_ip")

    @intranet_ip.setter
    def intranet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "intranet_ip", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="plainHttpRegistry")
    def plain_http_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        """
        return pulumi.get(self, "plain_http_registry")

    @plain_http_registry.setter
    def plain_http_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plain_http_registry", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['ContainerGroupSecurityContextArgs']]:
        """
        The security context of the container group. See `security_context` below.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['ContainerGroupSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum hourly price of the ECI spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of container group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The buffer time during which the program handles operations before the program stops. Unit: seconds.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerGroupVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
        **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:eci/containerGroup:ContainerGroup")
class ContainerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupAcrRegistryInfoArgs', 'ContainerGroupAcrRegistryInfoArgsDict']]]]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupContainerArgs', 'ContainerGroupContainerArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 dns_config: Optional[pulumi.Input[Union['ContainerGroupDnsConfigArgs', 'ContainerGroupDnsConfigArgsDict']]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupHostAliasArgs', 'ContainerGroupHostAliasArgsDict']]]]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupImageRegistryCredentialArgs', 'ContainerGroupImageRegistryCredentialArgsDict']]]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupInitContainerArgs', 'ContainerGroupInitContainerArgsDict']]]]] = None,
                 insecure_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 plain_http_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context: Optional[pulumi.Input[Union['ContainerGroupSecurityContextArgs', 'ContainerGroupSecurityContextArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupVolumeArgs', 'ContainerGroupVolumeArgsDict']]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides ECI Container Group resource.

        For information about ECI Container Group and how to use it, see [What is Container Group](https://www.alibabacloud.com/help/en/elastic-container-instance/latest/api-eci-2018-08-08-createcontainergroup).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.eci.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default.zones[0].zone_ids[0])
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_container_group = alicloud.eci.ContainerGroup("default",
            container_group_name=name,
            cpu=8,
            memory=16,
            restart_policy="OnFailure",
            security_group_id=default_security_group.id,
            vswitch_id=default_switch.id,
            auto_create_eip=True,
            tags={
                "Created": "TF",
                "For": "example",
            },
            containers=[{
                "image": "registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine",
                "name": "nginx",
                "working_dir": "/tmp/nginx",
                "image_pull_policy": "IfNotPresent",
                "commands": [
                    "/bin/sh",
                    "-c",
                    "sleep 9999",
                ],
                "volume_mounts": [{
                    "mount_path": "/tmp/example",
                    "read_only": False,
                    "name": "empty1",
                }],
                "ports": [{
                    "port": 80,
                    "protocol": "TCP",
                }],
                "environment_vars": [{
                    "key": "name",
                    "value": "nginx",
                }],
                "liveness_probes": [{
                    "period_seconds": 5,
                    "initial_delay_seconds": 5,
                    "success_threshold": 1,
                    "failure_threshold": 3,
                    "timeout_seconds": 1,
                    "execs": [{
                        "commands": ["cat /tmp/healthy"],
                    }],
                }],
                "readiness_probes": [{
                    "period_seconds": 5,
                    "initial_delay_seconds": 5,
                    "success_threshold": 1,
                    "failure_threshold": 3,
                    "timeout_seconds": 1,
                    "execs": [{
                        "commands": ["cat /tmp/healthy"],
                    }],
                }],
            }],
            init_containers=[{
                "name": "init-busybox",
                "image": "registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30",
                "image_pull_policy": "IfNotPresent",
                "commands": ["echo"],
                "args": ["hello initcontainer"],
            }],
            volumes=[
                {
                    "name": "empty1",
                    "type": "EmptyDirVolume",
                },
                {
                    "name": "empty2",
                    "type": "EmptyDirVolume",
                },
            ])
        ```

        ## Import

        ECI Container Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eci/containerGroup:ContainerGroup example <container_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupAcrRegistryInfoArgs', 'ContainerGroupAcrRegistryInfoArgsDict']]]] acr_registry_infos: The ACR enterprise edition example properties. See `acr_registry_info` below.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        :param pulumi.Input[_builtins.str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupContainerArgs', 'ContainerGroupContainerArgsDict']]]] containers: The list of containers. See `containers` below.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[Union['ContainerGroupDnsConfigArgs', 'ContainerGroupDnsConfigArgsDict']] dns_config: The structure of dnsConfig. See `dns_config` below.
        :param pulumi.Input[_builtins.str] dns_policy: The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the EIP. Default value: `5`.
        :param pulumi.Input[_builtins.str] eip_instance_id: The ID of the elastic IP address (EIP).
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the temporary storage space to add. Unit: GiB.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupHostAliasArgs', 'ContainerGroupHostAliasArgsDict']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupImageRegistryCredentialArgs', 'ContainerGroupImageRegistryCredentialArgsDict']]]] image_registry_credentials: The image registry credential. See `image_registry_credential` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupInitContainerArgs', 'ContainerGroupInitContainerArgsDict']]]] init_containers: The list of initContainers. See `init_containers` below.
        :param pulumi.Input[_builtins.str] insecure_registry: The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ECS instance.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] plain_http_registry: The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        :param pulumi.Input[Union['ContainerGroupSecurityContextArgs', 'ContainerGroupSecurityContextArgsDict']] security_context: The security context of the container group. See `security_context` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum hourly price of the ECI spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The buffer time during which the program handles operations before the program stops. Unit: seconds.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupVolumeArgs', 'ContainerGroupVolumeArgsDict']]]] volumes: The list of volumes. See `volumes` below.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
               **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides ECI Container Group resource.

        For information about ECI Container Group and how to use it, see [What is Container Group](https://www.alibabacloud.com/help/en/elastic-container-instance/latest/api-eci-2018-08-08-createcontainergroup).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.eci.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default.zones[0].zone_ids[0])
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_container_group = alicloud.eci.ContainerGroup("default",
            container_group_name=name,
            cpu=8,
            memory=16,
            restart_policy="OnFailure",
            security_group_id=default_security_group.id,
            vswitch_id=default_switch.id,
            auto_create_eip=True,
            tags={
                "Created": "TF",
                "For": "example",
            },
            containers=[{
                "image": "registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine",
                "name": "nginx",
                "working_dir": "/tmp/nginx",
                "image_pull_policy": "IfNotPresent",
                "commands": [
                    "/bin/sh",
                    "-c",
                    "sleep 9999",
                ],
                "volume_mounts": [{
                    "mount_path": "/tmp/example",
                    "read_only": False,
                    "name": "empty1",
                }],
                "ports": [{
                    "port": 80,
                    "protocol": "TCP",
                }],
                "environment_vars": [{
                    "key": "name",
                    "value": "nginx",
                }],
                "liveness_probes": [{
                    "period_seconds": 5,
                    "initial_delay_seconds": 5,
                    "success_threshold": 1,
                    "failure_threshold": 3,
                    "timeout_seconds": 1,
                    "execs": [{
                        "commands": ["cat /tmp/healthy"],
                    }],
                }],
                "readiness_probes": [{
                    "period_seconds": 5,
                    "initial_delay_seconds": 5,
                    "success_threshold": 1,
                    "failure_threshold": 3,
                    "timeout_seconds": 1,
                    "execs": [{
                        "commands": ["cat /tmp/healthy"],
                    }],
                }],
            }],
            init_containers=[{
                "name": "init-busybox",
                "image": "registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30",
                "image_pull_policy": "IfNotPresent",
                "commands": ["echo"],
                "args": ["hello initcontainer"],
            }],
            volumes=[
                {
                    "name": "empty1",
                    "type": "EmptyDirVolume",
                },
                {
                    "name": "empty2",
                    "type": "EmptyDirVolume",
                },
            ])
        ```

        ## Import

        ECI Container Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eci/containerGroup:ContainerGroup example <container_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param ContainerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupAcrRegistryInfoArgs', 'ContainerGroupAcrRegistryInfoArgsDict']]]]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupContainerArgs', 'ContainerGroupContainerArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 dns_config: Optional[pulumi.Input[Union['ContainerGroupDnsConfigArgs', 'ContainerGroupDnsConfigArgsDict']]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupHostAliasArgs', 'ContainerGroupHostAliasArgsDict']]]]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupImageRegistryCredentialArgs', 'ContainerGroupImageRegistryCredentialArgsDict']]]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupInitContainerArgs', 'ContainerGroupInitContainerArgsDict']]]]] = None,
                 insecure_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 plain_http_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context: Optional[pulumi.Input[Union['ContainerGroupSecurityContextArgs', 'ContainerGroupSecurityContextArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupVolumeArgs', 'ContainerGroupVolumeArgsDict']]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerGroupArgs.__new__(ContainerGroupArgs)

            __props__.__dict__["acr_registry_infos"] = acr_registry_infos
            __props__.__dict__["auto_create_eip"] = auto_create_eip
            __props__.__dict__["auto_match_image_cache"] = auto_match_image_cache
            if container_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_group_name'")
            __props__.__dict__["container_group_name"] = container_group_name
            if containers is None and not opts.urn:
                raise TypeError("Missing required property 'containers'")
            __props__.__dict__["containers"] = containers
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["dns_config"] = dns_config
            __props__.__dict__["dns_policy"] = dns_policy
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["eip_instance_id"] = eip_instance_id
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["host_aliases"] = host_aliases
            __props__.__dict__["image_registry_credentials"] = image_registry_credentials
            __props__.__dict__["init_containers"] = init_containers
            __props__.__dict__["insecure_registry"] = insecure_registry
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["memory"] = memory
            __props__.__dict__["plain_http_registry"] = plain_http_registry
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restart_policy"] = restart_policy
            __props__.__dict__["security_context"] = security_context
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
            __props__.__dict__["volumes"] = volumes
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["internet_ip"] = None
            __props__.__dict__["intranet_ip"] = None
            __props__.__dict__["status"] = None
        super(ContainerGroup, __self__).__init__(
            'alicloud:eci/containerGroup:ContainerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupAcrRegistryInfoArgs', 'ContainerGroupAcrRegistryInfoArgsDict']]]]] = None,
            auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
            container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupContainerArgs', 'ContainerGroupContainerArgsDict']]]]] = None,
            cpu: Optional[pulumi.Input[_builtins.float]] = None,
            dns_config: Optional[pulumi.Input[Union['ContainerGroupDnsConfigArgs', 'ContainerGroupDnsConfigArgsDict']]] = None,
            dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
            eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            eip_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
            host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupHostAliasArgs', 'ContainerGroupHostAliasArgsDict']]]]] = None,
            image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupImageRegistryCredentialArgs', 'ContainerGroupImageRegistryCredentialArgsDict']]]]] = None,
            init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupInitContainerArgs', 'ContainerGroupInitContainerArgsDict']]]]] = None,
            insecure_registry: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            intranet_ip: Optional[pulumi.Input[_builtins.str]] = None,
            memory: Optional[pulumi.Input[_builtins.float]] = None,
            plain_http_registry: Optional[pulumi.Input[_builtins.str]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
            security_context: Optional[pulumi.Input[Union['ContainerGroupSecurityContextArgs', 'ContainerGroupSecurityContextArgsDict']]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupVolumeArgs', 'ContainerGroupVolumeArgsDict']]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContainerGroup':
        """
        Get an existing ContainerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupAcrRegistryInfoArgs', 'ContainerGroupAcrRegistryInfoArgsDict']]]] acr_registry_infos: The ACR enterprise edition example properties. See `acr_registry_info` below.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        :param pulumi.Input[_builtins.str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupContainerArgs', 'ContainerGroupContainerArgsDict']]]] containers: The list of containers. See `containers` below.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[Union['ContainerGroupDnsConfigArgs', 'ContainerGroupDnsConfigArgsDict']] dns_config: The structure of dnsConfig. See `dns_config` below.
        :param pulumi.Input[_builtins.str] dns_policy: The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the EIP. Default value: `5`.
        :param pulumi.Input[_builtins.str] eip_instance_id: The ID of the elastic IP address (EIP).
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the temporary storage space to add. Unit: GiB.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupHostAliasArgs', 'ContainerGroupHostAliasArgsDict']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupImageRegistryCredentialArgs', 'ContainerGroupImageRegistryCredentialArgsDict']]]] image_registry_credentials: The image registry credential. See `image_registry_credential` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupInitContainerArgs', 'ContainerGroupInitContainerArgsDict']]]] init_containers: The list of initContainers. See `init_containers` below.
        :param pulumi.Input[_builtins.str] insecure_registry: The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ECS instance.
        :param pulumi.Input[_builtins.str] internet_ip: (Available since v1.170.0) The Public IP of the container group.
        :param pulumi.Input[_builtins.str] intranet_ip: (Available since v1.170.0) The Private IP of the container group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] plain_http_registry: The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        :param pulumi.Input[Union['ContainerGroupSecurityContextArgs', 'ContainerGroupSecurityContextArgsDict']] security_context: The security context of the container group. See `security_context` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum hourly price of the ECI spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        :param pulumi.Input[_builtins.str] status: The status of container group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The buffer time during which the program handles operations before the program stops. Unit: seconds.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerGroupVolumeArgs', 'ContainerGroupVolumeArgsDict']]]] volumes: The list of volumes. See `volumes` below.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
               **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerGroupState.__new__(_ContainerGroupState)

        __props__.__dict__["acr_registry_infos"] = acr_registry_infos
        __props__.__dict__["auto_create_eip"] = auto_create_eip
        __props__.__dict__["auto_match_image_cache"] = auto_match_image_cache
        __props__.__dict__["container_group_name"] = container_group_name
        __props__.__dict__["containers"] = containers
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["dns_config"] = dns_config
        __props__.__dict__["dns_policy"] = dns_policy
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["eip_instance_id"] = eip_instance_id
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["host_aliases"] = host_aliases
        __props__.__dict__["image_registry_credentials"] = image_registry_credentials
        __props__.__dict__["init_containers"] = init_containers
        __props__.__dict__["insecure_registry"] = insecure_registry
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_ip"] = internet_ip
        __props__.__dict__["intranet_ip"] = intranet_ip
        __props__.__dict__["memory"] = memory
        __props__.__dict__["plain_http_registry"] = plain_http_registry
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restart_policy"] = restart_policy
        __props__.__dict__["security_context"] = security_context
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return ContainerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerGroupAcrRegistryInfo']]]:
        """
        The ACR enterprise edition example properties. See `acr_registry_info` below.
        """
        return pulumi.get(self, "acr_registry_infos")

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
        """
        return pulumi.get(self, "auto_create_eip")

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Sequence['outputs.ContainerGroupContainer']]:
        """
        The list of containers. See `containers` below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.float]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> pulumi.Output[Optional['outputs.ContainerGroupDnsConfig']]:
        """
        The structure of dnsConfig. See `dns_config` below.
        """
        return pulumi.get(self, "dns_config")

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The policy of DNS. Default value: `Default`. Valid values: `Default` and `None`.
        """
        return pulumi.get(self, "dns_policy")

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The bandwidth of the EIP. Default value: `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @_builtins.property
    @pulumi.getter(name="eipInstanceId")
    def eip_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the elastic IP address (EIP).
        """
        return pulumi.get(self, "eip_instance_id")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the temporary storage space to add. Unit: GiB.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerGroupHostAlias']]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerGroupImageRegistryCredential']]]:
        """
        The image registry credential. See `image_registry_credential` below.
        """
        return pulumi.get(self, "image_registry_credentials")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerGroupInitContainer']]]:
        """
        The list of initContainers. See `init_containers` below.
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter(name="insecureRegistry")
    def insecure_registry(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
        """
        return pulumi.get(self, "insecure_registry")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.170.0) The Public IP of the container group.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.170.0) The Private IP of the container group.
        """
        return pulumi.get(self, "intranet_ip")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.float]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="plainHttpRegistry")
    def plain_http_registry(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
        """
        return pulumi.get(self, "plain_http_registry")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> pulumi.Output[Optional['outputs.ContainerGroupSecurityContext']]:
        """
        The security context of the container group. See `security_context` below.
        """
        return pulumi.get(self, "security_context")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[_builtins.float]:
        """
        The maximum hourly price of the ECI spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of container group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The buffer time during which the program handles operations before the program stops. Unit: seconds.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerGroupVolume']]]:
        """
        The list of volumes. See `volumes` below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
        **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
        """
        return pulumi.get(self, "zone_id")

