# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 allocate_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input['InstanceImageOptionsArgs']] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_action: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input['InstanceMaintenanceTimeArgs']] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input['InstanceNetworkInterfacesArgs']] = None,
                 operator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_pair_number: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.bool] allocate_public_ip: It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the `PostPaid` instance.
               The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
               Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
               - [1, 2, 3, 6, 12] when `period_unit` in "Month"
               - [1, 2, 3] when `period_unit` in "Week"
        :param pulumi.Input[_builtins.str] availability_zone: The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: The list of data disks created with instance. See `data_disks` below.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        :param pulumi.Input[_builtins.str] description: Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to send a dry-run request. Default to false.
               - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
               - false: A request is sent. If the validation succeeds, the instance is created.
        :param pulumi.Input[_builtins.bool] enable_jumbo_frame: Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] force_delete: If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
               However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        :param pulumi.Input[_builtins.str] host_name: Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
               On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[_builtins.str] http_endpoint: Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        :param pulumi.Input[_builtins.str] http_tokens: Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
               - optional: does not forcefully use the security-enhanced mode (IMDSv2).
               - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        :param pulumi.Input[_builtins.str] image_id: The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        :param pulumi.Input['InstanceImageOptionsArgs'] image_options: The options of images. See `image_options` below.
               
               > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
               
               > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.
               
               > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
               
               > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
               
               > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
               Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
               However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
               
               > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether to change instance disks charge type when changing instance charge type.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
               **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
               However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
               there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] launch_template_id: The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[_builtins.str] launch_template_name: The name of the launch template.
        :param pulumi.Input[_builtins.str] launch_template_version: The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        :param pulumi.Input[_builtins.str] maintenance_action: The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
               * `Stop` : stops the instance.
               * `AutoRecover` : automatically recovers the instance.
               * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        :param pulumi.Input[_builtins.bool] maintenance_notify: Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        :param pulumi.Input['InstanceMaintenanceTimeArgs'] maintenance_time: The time of maintenance. See `maintenance_time` below.
        :param pulumi.Input[_builtins.int] network_card_index: The index of the network card for Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
               - `Standard`: Uses the TCP communication mode.
               - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        :param pulumi.Input['InstanceNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance. See `network_interfaces` below.
        :param pulumi.Input[_builtins.str] operator_type: The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        :param pulumi.Input[_builtins.str] password: Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
               - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
               - [1-3] when `period_unit` in "Week"
               
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        :param pulumi.Input[_builtins.str] private_ip: Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] private_pool_options_id: The ID of the private pool.
        :param pulumi.Input[_builtins.str] private_pool_options_match_criteria: The type of the private pool. Default value: `None`. Valid values:
               - `Open`: Open private pool.
               - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
               - `None`: No private pool. The capacity in private pools is not used.
        :param pulumi.Input[_builtins.int] queue_pair_number: The number of queues supported by the ERI.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the instance belongs.
        :param pulumi.Input[_builtins.str] role_name: The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: The security enhancement strategy.
               - Active: Enable security enhancement strategy, it only works on system images.
               - Deactive: Disable security enhancement strategy, it works on all images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        :param pulumi.Input[_builtins.int] spot_duration: The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
               - NoSpot: A regular Pay-As-You-Go instance.
               - SpotWithPriceLimit: A price threshold for a spot instance
               - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
               
               Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        :param pulumi.Input[_builtins.str] status: The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        :param pulumi.Input[_builtins.str] stopped_mode: The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
               * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
               * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the performance burst feature for the system disk. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_category: Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the Key Management Service (KMS) key to be used for the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        :param pulumi.Input[_builtins.str] system_disk_storage_cluster_id: The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
               It supports to setting a base64-encoded value, and it is the recommended usage.
               From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
               Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: A mapping of tags to assign to the devices created by the instance at launch time.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        if allocate_public_ip is not None:
            warnings.warn("""Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""", DeprecationWarning)
            pulumi.log.warn("""allocate_public_ip is deprecated: Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""")
        if allocate_public_ip is not None:
            pulumi.set(__self__, "allocate_public_ip", allocate_public_ip)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_options is not None:
            pulumi.set(__self__, "image_options", image_options)
        if include_data_disks is not None:
            pulumi.set(__self__, "include_data_disks", include_data_disks)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            warnings.warn("""The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""", DeprecationWarning)
            pulumi.log.warn("""internet_max_bandwidth_in is deprecated: The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""")
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if maintenance_action is not None:
            pulumi.set(__self__, "maintenance_action", maintenance_action)
        if maintenance_notify is not None:
            pulumi.set(__self__, "maintenance_notify", maintenance_notify)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if network_interface_traffic_mode is not None:
            pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if operator_type is not None:
            pulumi.set(__self__, "operator_type", operator_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_pool_options_id is not None:
            pulumi.set(__self__, "private_pool_options_id", private_pool_options_id)
        if private_pool_options_match_criteria is not None:
            pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)
        if queue_pair_number is not None:
            pulumi.set(__self__, "queue_pair_number", queue_pair_number)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stopped_mode is not None:
            pulumi.set(__self__, "stopped_mode", stopped_mode)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_bursting_enabled is not None:
            pulumi.set(__self__, "system_disk_bursting_enabled", system_disk_bursting_enabled)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_storage_cluster_id is not None:
            pulumi.set(__self__, "system_disk_storage_cluster_id", system_disk_storage_cluster_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="allocatePublicIp")
    @_utilities.deprecated("""Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""")
    def allocate_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        """
        return pulumi.get(self, "allocate_public_ip")

    @allocate_public_ip.setter
    def allocate_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allocate_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic release time of the `PostPaid` instance.
        The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
        Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
        - [1, 2, 3, 6, 12] when `period_unit` in "Month"
        - [1, 2, 3] when `period_unit` in "Week"
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        The list of data disks created with instance. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send a dry-run request. Default to false.
        - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
        - false: A request is sent. If the validation succeeds, the instance is created.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
        However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
        On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
        - optional: does not forcefully use the security-enhanced mode (IMDSv2).
        - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> Optional[pulumi.Input['InstanceImageOptionsArgs']]:
        """
        The options of images. See `image_options` below.

        > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.

        > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.

        > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.

        > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.

        > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
        Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
        However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".

        > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "image_options")

    @image_options.setter
    def image_options(self, value: Optional[pulumi.Input['InstanceImageOptionsArgs']]):
        pulumi.set(self, "image_options", value)

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to change instance disks charge type when changing instance charge type.
        """
        return pulumi.get(self, "include_data_disks")

    @include_data_disks.setter
    def include_data_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
        **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
        However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
        there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    @_utilities.deprecated("""The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use outdated instance type.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_outdated", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceAction")
    def maintenance_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
        * `Stop` : stops the instance.
        * `AutoRecover` : automatically recovers the instance.
        * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        """
        return pulumi.get(self, "maintenance_action")

    @maintenance_action.setter
    def maintenance_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_action", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceNotify")
    def maintenance_notify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        """
        return pulumi.get(self, "maintenance_notify")

    @maintenance_notify.setter
    def maintenance_notify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "maintenance_notify", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input['InstanceMaintenanceTimeArgs']]:
        """
        The time of maintenance. See `maintenance_time` below.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input['InstanceMaintenanceTimeArgs']]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The index of the network card for Primary ENI.
        """
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
        - `Standard`: Uses the TCP communication mode.
        - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @network_interface_traffic_mode.setter
    def network_interface_traffic_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_traffic_mode", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['InstanceNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance. See `network_interfaces` below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['InstanceNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator_type", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
        - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
        - [1-3] when `period_unit` in "Week"

        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private pool.
        """
        return pulumi.get(self, "private_pool_options_id")

    @private_pool_options_id.setter
    def private_pool_options_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_pool_options_id", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the private pool. Default value: `None`. Valid values:
        - `Open`: Open private pool.
        - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
        - `None`: No private pool. The capacity in private pools is not used.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @private_pool_options_match_criteria.setter
    def private_pool_options_match_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_pool_options_match_criteria", value)

    @_builtins.property
    @pulumi.getter(name="queuePairNumber")
    def queue_pair_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of queues supported by the ERI.
        """
        return pulumi.get(self, "queue_pair_number")

    @queue_pair_number.setter
    def queue_pair_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_pair_number", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @secondary_private_ip_address_count.setter
    def secondary_private_ip_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_private_ip_address_count", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security enhancement strategy.
        - Active: Enable security enhancement strategy, it only works on system images.
        - Deactive: Disable security enhancement strategy, it works on all images.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        """
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
        - NoSpot: A regular Pay-As-You-Go instance.
        - SpotWithPriceLimit: A price threshold for a spot instance
        - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance

        Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
        * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
        * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        """
        return pulumi.get(self, "stopped_mode")

    @stopped_mode.setter
    def stopped_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stopped_mode", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature for the system disk. Valid values:
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @system_disk_bursting_enabled.setter
    def system_disk_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key to be used for the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskStorageClusterId")
    def system_disk_storage_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        """
        return pulumi.get(self, "system_disk_storage_cluster_id")

    @system_disk_storage_cluster_id.setter
    def system_disk_storage_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_storage_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
        It supports to setting a base64-encoded value, and it is the recommended usage.
        From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
        Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the devices created by the instance at launch time.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 allocate_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deployment_set_group_no: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input['InstanceImageOptionsArgs']] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_action: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input['InstanceMaintenanceTimeArgs']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input['InstanceNetworkInterfacesArgs']] = None,
                 operator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_pair_number: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] allocate_public_ip: It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the `PostPaid` instance.
               The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
               Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
               - [1, 2, 3, 6, 12] when `period_unit` in "Month"
               - [1, 2, 3] when `period_unit` in "Week"
        :param pulumi.Input[_builtins.str] availability_zone: The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        :param pulumi.Input[_builtins.int] cpu: The number of vCPUs.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.232.0) The time when the instance was created.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: The list of data disks created with instance. See `data_disks` below.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        :param pulumi.Input[_builtins.str] deployment_set_group_no: The group number of the instance in a deployment set when the deployment set is use.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        :param pulumi.Input[_builtins.str] description: Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to send a dry-run request. Default to false.
               - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
               - false: A request is sent. If the validation succeeds, the instance is created.
        :param pulumi.Input[_builtins.bool] enable_jumbo_frame: Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] expired_time: (Available since v1.232.0) The expiration time of the instance.
        :param pulumi.Input[_builtins.bool] force_delete: If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
               However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        :param pulumi.Input[_builtins.str] host_name: Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
               On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[_builtins.str] http_endpoint: Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        :param pulumi.Input[_builtins.str] http_tokens: Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
               - optional: does not forcefully use the security-enhanced mode (IMDSv2).
               - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        :param pulumi.Input[_builtins.str] image_id: The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        :param pulumi.Input['InstanceImageOptionsArgs'] image_options: The options of images. See `image_options` below.
               
               > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
               
               > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.
               
               > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
               
               > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
               
               > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
               Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
               However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
               
               > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether to change instance disks charge type when changing instance charge type.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
               **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
               However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
               there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] launch_template_id: The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[_builtins.str] launch_template_name: The name of the launch template.
        :param pulumi.Input[_builtins.str] launch_template_version: The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        :param pulumi.Input[_builtins.str] maintenance_action: The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
               * `Stop` : stops the instance.
               * `AutoRecover` : automatically recovers the instance.
               * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        :param pulumi.Input[_builtins.bool] maintenance_notify: Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        :param pulumi.Input['InstanceMaintenanceTimeArgs'] maintenance_time: The time of maintenance. See `maintenance_time` below.
        :param pulumi.Input[_builtins.int] memory: The memory size of the instance. Unit: MiB.
        :param pulumi.Input[_builtins.int] network_card_index: The index of the network card for Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
               - `Standard`: Uses the TCP communication mode.
               - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        :param pulumi.Input['InstanceNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance. See `network_interfaces` below.
        :param pulumi.Input[_builtins.str] operator_type: The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        :param pulumi.Input[_builtins.str] os_name: The name of the operating system of the instance.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system of the instance.
        :param pulumi.Input[_builtins.str] password: Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
               - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
               - [1-3] when `period_unit` in "Week"
               
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI.
        :param pulumi.Input[_builtins.str] private_ip: Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] private_pool_options_id: The ID of the private pool.
        :param pulumi.Input[_builtins.str] private_pool_options_match_criteria: The type of the private pool. Default value: `None`. Valid values:
               - `Open`: Open private pool.
               - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
               - `None`: No private pool. The capacity in private pools is not used.
        :param pulumi.Input[_builtins.str] public_ip: The instance public ip.
        :param pulumi.Input[_builtins.int] queue_pair_number: The number of queues supported by the ERI.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the instance belongs.
        :param pulumi.Input[_builtins.str] role_name: The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: The security enhancement strategy.
               - Active: Enable security enhancement strategy, it only works on system images.
               - Deactive: Disable security enhancement strategy, it works on all images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        :param pulumi.Input[_builtins.int] spot_duration: The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
               - NoSpot: A regular Pay-As-You-Go instance.
               - SpotWithPriceLimit: A price threshold for a spot instance
               - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
               
               Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        :param pulumi.Input[_builtins.str] start_time: (Available since v1.232.0) The time when the instance was last started.
        :param pulumi.Input[_builtins.str] status: The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        :param pulumi.Input[_builtins.str] stopped_mode: The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
               * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
               * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the performance burst feature for the system disk. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_category: Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        :param pulumi.Input[_builtins.str] system_disk_id: (Available since v1.210.0) The ID of system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the Key Management Service (KMS) key to be used for the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        :param pulumi.Input[_builtins.str] system_disk_storage_cluster_id: The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
               It supports to setting a base64-encoded value, and it is the recommended usage.
               From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
               Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: A mapping of tags to assign to the devices created by the instance at launch time.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        if allocate_public_ip is not None:
            warnings.warn("""Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""", DeprecationWarning)
            pulumi.log.warn("""allocate_public_ip is deprecated: Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""")
        if allocate_public_ip is not None:
            pulumi.set(__self__, "allocate_public_ip", allocate_public_ip)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deployment_set_group_no is not None:
            pulumi.set(__self__, "deployment_set_group_no", deployment_set_group_no)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_options is not None:
            pulumi.set(__self__, "image_options", image_options)
        if include_data_disks is not None:
            pulumi.set(__self__, "include_data_disks", include_data_disks)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            warnings.warn("""The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""", DeprecationWarning)
            pulumi.log.warn("""internet_max_bandwidth_in is deprecated: The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""")
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if maintenance_action is not None:
            pulumi.set(__self__, "maintenance_action", maintenance_action)
        if maintenance_notify is not None:
            pulumi.set(__self__, "maintenance_notify", maintenance_notify)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_interface_traffic_mode is not None:
            pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if operator_type is not None:
            pulumi.set(__self__, "operator_type", operator_type)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_pool_options_id is not None:
            pulumi.set(__self__, "private_pool_options_id", private_pool_options_id)
        if private_pool_options_match_criteria is not None:
            pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if queue_pair_number is not None:
            pulumi.set(__self__, "queue_pair_number", queue_pair_number)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stopped_mode is not None:
            pulumi.set(__self__, "stopped_mode", stopped_mode)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_bursting_enabled is not None:
            pulumi.set(__self__, "system_disk_bursting_enabled", system_disk_bursting_enabled)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_id is not None:
            pulumi.set(__self__, "system_disk_id", system_disk_id)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_storage_cluster_id is not None:
            pulumi.set(__self__, "system_disk_storage_cluster_id", system_disk_storage_cluster_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="allocatePublicIp")
    @_utilities.deprecated("""Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""")
    def allocate_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        """
        return pulumi.get(self, "allocate_public_ip")

    @allocate_public_ip.setter
    def allocate_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allocate_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic release time of the `PostPaid` instance.
        The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
        Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
        - [1, 2, 3, 6, 12] when `period_unit` in "Month"
        - [1, 2, 3] when `period_unit` in "Week"
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.232.0) The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        The list of data disks created with instance. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetGroupNo")
    def deployment_set_group_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group number of the instance in a deployment set when the deployment set is use.
        """
        return pulumi.get(self, "deployment_set_group_no")

    @deployment_set_group_no.setter
    def deployment_set_group_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_group_no", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send a dry-run request. Default to false.
        - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
        - false: A request is sent. If the validation succeeds, the instance is created.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.232.0) The expiration time of the instance.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
        However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
        On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
        - optional: does not forcefully use the security-enhanced mode (IMDSv2).
        - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> Optional[pulumi.Input['InstanceImageOptionsArgs']]:
        """
        The options of images. See `image_options` below.

        > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.

        > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.

        > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.

        > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.

        > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
        Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
        However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".

        > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "image_options")

    @image_options.setter
    def image_options(self, value: Optional[pulumi.Input['InstanceImageOptionsArgs']]):
        pulumi.set(self, "image_options", value)

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to change instance disks charge type when changing instance charge type.
        """
        return pulumi.get(self, "include_data_disks")

    @include_data_disks.setter
    def include_data_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
        **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
        However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
        there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    @_utilities.deprecated("""The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use outdated instance type.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_outdated", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceAction")
    def maintenance_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
        * `Stop` : stops the instance.
        * `AutoRecover` : automatically recovers the instance.
        * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        """
        return pulumi.get(self, "maintenance_action")

    @maintenance_action.setter
    def maintenance_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_action", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceNotify")
    def maintenance_notify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        """
        return pulumi.get(self, "maintenance_notify")

    @maintenance_notify.setter
    def maintenance_notify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "maintenance_notify", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input['InstanceMaintenanceTimeArgs']]:
        """
        The time of maintenance. See `maintenance_time` below.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input['InstanceMaintenanceTimeArgs']]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory size of the instance. Unit: MiB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The index of the network card for Primary ENI.
        """
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Primary ENI.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
        - `Standard`: Uses the TCP communication mode.
        - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @network_interface_traffic_mode.setter
    def network_interface_traffic_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_traffic_mode", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['InstanceNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance. See `network_interfaces` below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['InstanceNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator_type", value)

    @_builtins.property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the operating system of the instance.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the operating system of the instance.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
        - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
        - [1-3] when `period_unit` in "Week"

        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private pool.
        """
        return pulumi.get(self, "private_pool_options_id")

    @private_pool_options_id.setter
    def private_pool_options_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_pool_options_id", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the private pool. Default value: `None`. Valid values:
        - `Open`: Open private pool.
        - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
        - `None`: No private pool. The capacity in private pools is not used.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @private_pool_options_match_criteria.setter
    def private_pool_options_match_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_pool_options_match_criteria", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance public ip.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="queuePairNumber")
    def queue_pair_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of queues supported by the ERI.
        """
        return pulumi.get(self, "queue_pair_number")

    @queue_pair_number.setter
    def queue_pair_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_pair_number", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @secondary_private_ip_address_count.setter
    def secondary_private_ip_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_private_ip_address_count", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security enhancement strategy.
        - Active: Enable security enhancement strategy, it only works on system images.
        - Deactive: Disable security enhancement strategy, it works on all images.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        """
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
        - NoSpot: A regular Pay-As-You-Go instance.
        - SpotWithPriceLimit: A price threshold for a spot instance
        - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance

        Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.232.0) The time when the instance was last started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
        * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
        * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        """
        return pulumi.get(self, "stopped_mode")

    @stopped_mode.setter
    def stopped_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stopped_mode", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature for the system disk. Valid values:
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @system_disk_bursting_enabled.setter
    def system_disk_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.210.0) The ID of system disk.
        """
        return pulumi.get(self, "system_disk_id")

    @system_disk_id.setter
    def system_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key to be used for the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskStorageClusterId")
    def system_disk_storage_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        """
        return pulumi.get(self, "system_disk_storage_cluster_id")

    @system_disk_storage_cluster_id.setter
    def system_disk_storage_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_storage_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
        It supports to setting a base64-encoded value, and it is the recommended usage.
        From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
        Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the devices created by the instance at launch time.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:ecs/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input[Union['InstanceImageOptionsArgs', 'InstanceImageOptionsArgsDict']]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_action: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[Union['InstanceMaintenanceTimeArgs', 'InstanceMaintenanceTimeArgsDict']]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Union['InstanceNetworkInterfacesArgs', 'InstanceNetworkInterfacesArgsDict']]] = None,
                 operator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_pair_number: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS instance resource.

        > **NOTE:** Available since v1.0.0

        > **NOTE:** From version v1.213.0, you can specify `launch_template_id` and `launch_template_version` to use a launch template. This eliminates the need to configure a large number of parameters every time you create instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        instance_type = config.get("instanceType")
        if instance_type is None:
            instance_type = "ecs.n4.large"
        image_id = config.get("imageId")
        if image_id is None:
            image_id = "ubuntu_18_04_64_20G_alibase_20190624.vhd"
        # Create a new ECS instance for VPC
        vpc = alicloud.vpc.Network("vpc",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        # Create a new ECS instance for a VPC
        group = alicloud.ecs.SecurityGroup("group",
            security_group_name=name,
            description="foo",
            vpc_id=vpc.id)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch",
            available_instance_type=instance_type)
        vswitch = alicloud.vpc.Switch("vswitch",
            vpc_id=vpc.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        instance = alicloud.ecs.Instance("instance",
            availability_zone=default.zones[0].id,
            security_groups=[__item.id for __item in [group]],
            instance_type=instance_type,
            system_disk_category="cloud_efficiency",
            system_disk_name=name,
            system_disk_description="test_foo_system_disk_description",
            image_id=image_id,
            instance_name=name,
            vswitch_id=vswitch.id,
            internet_max_bandwidth_out=10,
            data_disks=[{
                "name": "disk2",
                "size": 20,
                "category": "cloud_efficiency",
                "description": "disk2",
                "encrypted": True,
                "kms_key_id": key.id,
            }])
        ```

        ## Module Support

        You can use the existing ecs-instance module
        to create several ECS instances one-click.

        ## Import

        Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/instance:Instance example i-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allocate_public_ip: It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the `PostPaid` instance.
               The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
               Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
               - [1, 2, 3, 6, 12] when `period_unit` in "Month"
               - [1, 2, 3] when `period_unit` in "Week"
        :param pulumi.Input[_builtins.str] availability_zone: The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: The list of data disks created with instance. See `data_disks` below.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        :param pulumi.Input[_builtins.str] description: Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to send a dry-run request. Default to false.
               - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
               - false: A request is sent. If the validation succeeds, the instance is created.
        :param pulumi.Input[_builtins.bool] enable_jumbo_frame: Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] force_delete: If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
               However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        :param pulumi.Input[_builtins.str] host_name: Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
               On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[_builtins.str] http_endpoint: Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        :param pulumi.Input[_builtins.str] http_tokens: Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
               - optional: does not forcefully use the security-enhanced mode (IMDSv2).
               - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        :param pulumi.Input[_builtins.str] image_id: The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        :param pulumi.Input[Union['InstanceImageOptionsArgs', 'InstanceImageOptionsArgsDict']] image_options: The options of images. See `image_options` below.
               
               > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
               
               > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.
               
               > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
               
               > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
               
               > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
               Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
               However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
               
               > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether to change instance disks charge type when changing instance charge type.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
               **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
               However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
               there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] launch_template_id: The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[_builtins.str] launch_template_name: The name of the launch template.
        :param pulumi.Input[_builtins.str] launch_template_version: The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        :param pulumi.Input[_builtins.str] maintenance_action: The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
               * `Stop` : stops the instance.
               * `AutoRecover` : automatically recovers the instance.
               * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        :param pulumi.Input[_builtins.bool] maintenance_notify: Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        :param pulumi.Input[Union['InstanceMaintenanceTimeArgs', 'InstanceMaintenanceTimeArgsDict']] maintenance_time: The time of maintenance. See `maintenance_time` below.
        :param pulumi.Input[_builtins.int] network_card_index: The index of the network card for Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
               - `Standard`: Uses the TCP communication mode.
               - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        :param pulumi.Input[Union['InstanceNetworkInterfacesArgs', 'InstanceNetworkInterfacesArgsDict']] network_interfaces: The list of network interfaces created with instance. See `network_interfaces` below.
        :param pulumi.Input[_builtins.str] operator_type: The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        :param pulumi.Input[_builtins.str] password: Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
               - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
               - [1-3] when `period_unit` in "Week"
               
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        :param pulumi.Input[_builtins.str] private_ip: Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] private_pool_options_id: The ID of the private pool.
        :param pulumi.Input[_builtins.str] private_pool_options_match_criteria: The type of the private pool. Default value: `None`. Valid values:
               - `Open`: Open private pool.
               - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
               - `None`: No private pool. The capacity in private pools is not used.
        :param pulumi.Input[_builtins.int] queue_pair_number: The number of queues supported by the ERI.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the instance belongs.
        :param pulumi.Input[_builtins.str] role_name: The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: The security enhancement strategy.
               - Active: Enable security enhancement strategy, it only works on system images.
               - Deactive: Disable security enhancement strategy, it works on all images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        :param pulumi.Input[_builtins.int] spot_duration: The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
               - NoSpot: A regular Pay-As-You-Go instance.
               - SpotWithPriceLimit: A price threshold for a spot instance
               - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
               
               Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        :param pulumi.Input[_builtins.str] status: The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        :param pulumi.Input[_builtins.str] stopped_mode: The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
               * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
               * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the performance burst feature for the system disk. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_category: Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the Key Management Service (KMS) key to be used for the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        :param pulumi.Input[_builtins.str] system_disk_storage_cluster_id: The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
               It supports to setting a base64-encoded value, and it is the recommended usage.
               From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
               Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: A mapping of tags to assign to the devices created by the instance at launch time.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS instance resource.

        > **NOTE:** Available since v1.0.0

        > **NOTE:** From version v1.213.0, you can specify `launch_template_id` and `launch_template_version` to use a launch template. This eliminates the need to configure a large number of parameters every time you create instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        instance_type = config.get("instanceType")
        if instance_type is None:
            instance_type = "ecs.n4.large"
        image_id = config.get("imageId")
        if image_id is None:
            image_id = "ubuntu_18_04_64_20G_alibase_20190624.vhd"
        # Create a new ECS instance for VPC
        vpc = alicloud.vpc.Network("vpc",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        # Create a new ECS instance for a VPC
        group = alicloud.ecs.SecurityGroup("group",
            security_group_name=name,
            description="foo",
            vpc_id=vpc.id)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch",
            available_instance_type=instance_type)
        vswitch = alicloud.vpc.Switch("vswitch",
            vpc_id=vpc.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        instance = alicloud.ecs.Instance("instance",
            availability_zone=default.zones[0].id,
            security_groups=[__item.id for __item in [group]],
            instance_type=instance_type,
            system_disk_category="cloud_efficiency",
            system_disk_name=name,
            system_disk_description="test_foo_system_disk_description",
            image_id=image_id,
            instance_name=name,
            vswitch_id=vswitch.id,
            internet_max_bandwidth_out=10,
            data_disks=[{
                "name": "disk2",
                "size": 20,
                "category": "cloud_efficiency",
                "description": "disk2",
                "encrypted": True,
                "kms_key_id": key.id,
            }])
        ```

        ## Module Support

        You can use the existing ecs-instance module
        to create several ECS instances one-click.

        ## Import

        Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/instance:Instance example i-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input[Union['InstanceImageOptionsArgs', 'InstanceImageOptionsArgsDict']]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_action: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[Union['InstanceMaintenanceTimeArgs', 'InstanceMaintenanceTimeArgsDict']]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Union['InstanceNetworkInterfacesArgs', 'InstanceNetworkInterfacesArgsDict']]] = None,
                 operator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_pair_number: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["allocate_public_ip"] = allocate_public_ip
            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["dedicated_host_id"] = dedicated_host_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
            __props__.__dict__["http_endpoint"] = http_endpoint
            __props__.__dict__["http_put_response_hop_limit"] = http_put_response_hop_limit
            __props__.__dict__["http_tokens"] = http_tokens
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_options"] = image_options
            __props__.__dict__["include_data_disks"] = include_data_disks
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["is_outdated"] = is_outdated
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["launch_template_id"] = launch_template_id
            __props__.__dict__["launch_template_name"] = launch_template_name
            __props__.__dict__["launch_template_version"] = launch_template_version
            __props__.__dict__["maintenance_action"] = maintenance_action
            __props__.__dict__["maintenance_notify"] = maintenance_notify
            __props__.__dict__["maintenance_time"] = maintenance_time
            __props__.__dict__["network_card_index"] = network_card_index
            __props__.__dict__["network_interface_traffic_mode"] = network_interface_traffic_mode
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["operator_type"] = operator_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["private_pool_options_id"] = private_pool_options_id
            __props__.__dict__["private_pool_options_match_criteria"] = private_pool_options_match_criteria
            __props__.__dict__["queue_pair_number"] = queue_pair_number
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            __props__.__dict__["secondary_private_ips"] = secondary_private_ips
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["spot_duration"] = spot_duration
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["status"] = status
            __props__.__dict__["stopped_mode"] = stopped_mode
            __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
            __props__.__dict__["system_disk_bursting_enabled"] = system_disk_bursting_enabled
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
            __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
            __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_storage_cluster_id"] = system_disk_storage_cluster_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["volume_tags"] = volume_tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["cpu"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["deployment_set_group_no"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["memory"] = None
            __props__.__dict__["network_interface_id"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_type"] = None
            __props__.__dict__["primary_ip_address"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["system_disk_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:ecs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocate_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            cpu: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
            dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            deployment_set_group_no: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            hpc_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
            http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_options: Optional[pulumi.Input[Union['InstanceImageOptionsArgs', 'InstanceImageOptionsArgsDict']]] = None,
            include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
            launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_action: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_notify: Optional[pulumi.Input[_builtins.bool]] = None,
            maintenance_time: Optional[pulumi.Input[Union['InstanceMaintenanceTimeArgs', 'InstanceMaintenanceTimeArgsDict']]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Union['InstanceNetworkInterfacesArgs', 'InstanceNetworkInterfacesArgsDict']]] = None,
            operator_type: Optional[pulumi.Input[_builtins.str]] = None,
            os_name: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            private_pool_options_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_pool_options_match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            queue_pair_number: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
            spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            stopped_mode: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allocate_public_ip: It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the `PostPaid` instance.
               The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
               Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
               - [1, 2, 3, 6, 12] when `period_unit` in "Month"
               - [1, 2, 3] when `period_unit` in "Week"
        :param pulumi.Input[_builtins.str] availability_zone: The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        :param pulumi.Input[_builtins.int] cpu: The number of vCPUs.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.232.0) The time when the instance was created.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: The list of data disks created with instance. See `data_disks` below.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        :param pulumi.Input[_builtins.str] deployment_set_group_no: The group number of the instance in a deployment set when the deployment set is use.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        :param pulumi.Input[_builtins.str] description: Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to send a dry-run request. Default to false.
               - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
               - false: A request is sent. If the validation succeeds, the instance is created.
        :param pulumi.Input[_builtins.bool] enable_jumbo_frame: Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] expired_time: (Available since v1.232.0) The expiration time of the instance.
        :param pulumi.Input[_builtins.bool] force_delete: If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
               However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        :param pulumi.Input[_builtins.str] host_name: Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
               On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[_builtins.str] http_endpoint: Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        :param pulumi.Input[_builtins.str] http_tokens: Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
               - optional: does not forcefully use the security-enhanced mode (IMDSv2).
               - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        :param pulumi.Input[_builtins.str] image_id: The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        :param pulumi.Input[Union['InstanceImageOptionsArgs', 'InstanceImageOptionsArgsDict']] image_options: The options of images. See `image_options` below.
               
               > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
               
               > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.
               
               > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
               
               > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
               
               > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
               Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
               However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
               
               > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether to change instance disks charge type when changing instance charge type.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
               **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
               However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
               there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] launch_template_id: The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[_builtins.str] launch_template_name: The name of the launch template.
        :param pulumi.Input[_builtins.str] launch_template_version: The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        :param pulumi.Input[_builtins.str] maintenance_action: The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
               * `Stop` : stops the instance.
               * `AutoRecover` : automatically recovers the instance.
               * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        :param pulumi.Input[_builtins.bool] maintenance_notify: Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        :param pulumi.Input[Union['InstanceMaintenanceTimeArgs', 'InstanceMaintenanceTimeArgsDict']] maintenance_time: The time of maintenance. See `maintenance_time` below.
        :param pulumi.Input[_builtins.int] memory: The memory size of the instance. Unit: MiB.
        :param pulumi.Input[_builtins.int] network_card_index: The index of the network card for Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the Primary ENI.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
               - `Standard`: Uses the TCP communication mode.
               - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        :param pulumi.Input[Union['InstanceNetworkInterfacesArgs', 'InstanceNetworkInterfacesArgsDict']] network_interfaces: The list of network interfaces created with instance. See `network_interfaces` below.
        :param pulumi.Input[_builtins.str] operator_type: The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        :param pulumi.Input[_builtins.str] os_name: The name of the operating system of the instance.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system of the instance.
        :param pulumi.Input[_builtins.str] password: Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
               - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
               - [1-3] when `period_unit` in "Week"
               
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI.
        :param pulumi.Input[_builtins.str] private_ip: Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] private_pool_options_id: The ID of the private pool.
        :param pulumi.Input[_builtins.str] private_pool_options_match_criteria: The type of the private pool. Default value: `None`. Valid values:
               - `Open`: Open private pool.
               - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
               - `None`: No private pool. The capacity in private pools is not used.
        :param pulumi.Input[_builtins.str] public_ip: The instance public ip.
        :param pulumi.Input[_builtins.int] queue_pair_number: The number of queues supported by the ERI.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
               - `AutoRenewal`: Enable auto renewal.
               - `Normal`: Disable auto renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the instance belongs.
        :param pulumi.Input[_builtins.str] role_name: The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secondary_private_ips: A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: The security enhancement strategy.
               - Active: Enable security enhancement strategy, it only works on system images.
               - Deactive: Disable security enhancement strategy, it works on all images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        :param pulumi.Input[_builtins.int] spot_duration: The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
               - NoSpot: A regular Pay-As-You-Go instance.
               - SpotWithPriceLimit: A price threshold for a spot instance
               - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
               
               Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        :param pulumi.Input[_builtins.str] start_time: (Available since v1.232.0) The time when the instance was last started.
        :param pulumi.Input[_builtins.str] status: The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        :param pulumi.Input[_builtins.str] stopped_mode: The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
               * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
               * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the performance burst feature for the system disk. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_category: Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        :param pulumi.Input[_builtins.str] system_disk_id: (Available since v1.210.0) The ID of system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the Key Management Service (KMS) key to be used for the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        :param pulumi.Input[_builtins.str] system_disk_storage_cluster_id: The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
               It supports to setting a base64-encoded value, and it is the recommended usage.
               From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
               Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] volume_tags: A mapping of tags to assign to the devices created by the instance at launch time.
               - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["allocate_public_ip"] = allocate_public_ip
        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["dedicated_host_id"] = dedicated_host_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["deployment_set_group_no"] = deployment_set_group_no
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
        __props__.__dict__["http_endpoint"] = http_endpoint
        __props__.__dict__["http_put_response_hop_limit"] = http_put_response_hop_limit
        __props__.__dict__["http_tokens"] = http_tokens
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_options"] = image_options
        __props__.__dict__["include_data_disks"] = include_data_disks
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["is_outdated"] = is_outdated
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["launch_template_id"] = launch_template_id
        __props__.__dict__["launch_template_name"] = launch_template_name
        __props__.__dict__["launch_template_version"] = launch_template_version
        __props__.__dict__["maintenance_action"] = maintenance_action
        __props__.__dict__["maintenance_notify"] = maintenance_notify
        __props__.__dict__["maintenance_time"] = maintenance_time
        __props__.__dict__["memory"] = memory
        __props__.__dict__["network_card_index"] = network_card_index
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["network_interface_traffic_mode"] = network_interface_traffic_mode
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["operator_type"] = operator_type
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["primary_ip_address"] = primary_ip_address
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_pool_options_id"] = private_pool_options_id
        __props__.__dict__["private_pool_options_match_criteria"] = private_pool_options_match_criteria
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["queue_pair_number"] = queue_pair_number
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["secondary_private_ip_address_count"] = secondary_private_ip_address_count
        __props__.__dict__["secondary_private_ips"] = secondary_private_ips
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["spot_duration"] = spot_duration
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["stopped_mode"] = stopped_mode
        __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
        __props__.__dict__["system_disk_bursting_enabled"] = system_disk_bursting_enabled
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
        __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
        __props__.__dict__["system_disk_id"] = system_disk_id
        __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_storage_cluster_id"] = system_disk_storage_cluster_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["volume_tags"] = volume_tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocatePublicIp")
    @_utilities.deprecated("""Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting 'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.""")
    def allocate_public_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
        """
        return pulumi.get(self, "allocate_public_ip")

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The automatic release time of the `PostPaid` instance.
        The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
        Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
        """
        return pulumi.get(self, "auto_release_time")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
        - [1, 2, 3, 6, 12] when `period_unit` in "Month"
        - [1, 2, 3] when `period_unit` in "Week"
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.int]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.232.0) The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[_builtins.str]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDataDisk']]]:
        """
        The list of data disks created with instance. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="deploymentSetGroupNo")
    def deployment_set_group_no(self) -> pulumi.Output[_builtins.str]:
        """
        The group number of the instance in a deployment set when the deployment set is use.
        """
        return pulumi.get(self, "deployment_set_group_no")

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
        """
        return pulumi.get(self, "deployment_set_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to send a dry-run request. Default to false.
        - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
        - false: A request is sent. If the validation succeeds, the instance is created.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.232.0) The expiration time of the instance.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If it is true, the `PrePaid` instance will be change to `PostPaid` and then deleted forcibly.
        However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
        On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
        """
        return pulumi.get(self, "http_endpoint")

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> pulumi.Output[_builtins.int]:
        """
        **NOTE:**: This parameter is not available for use yet. The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
        - optional: does not forcefully use the security-enhanced mode (IMDSv2).
        - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
        """
        return pulumi.get(self, "http_tokens")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> pulumi.Output['outputs.InstanceImageOptions']:
        """
        The options of images. See `image_options` below.

        > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.

        > **NOTE:** From version 1.5.0, instance's charge type can be changed to `PrePaid` by specifying `period` and `period_unit`, but it is irreversible.

        > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.

        > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.

        > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
        Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
        However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".

        > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "image_options")

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to change instance disks charge type when changing instance charge type.
        """
        return pulumi.get(self, "include_data_disks")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Valid values are `PrePaid`, `PostPaid`. **NOTE:** From version 1.243.0, the default value `PostPaid` will be removed.
        **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
        However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
        there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with http:// or https://. **NOTE:** From version 1.243.0, the default value `ECS-Instance` will be removed.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic". **NOTE:** From version 1.243.0, the default value `PayByTraffic` will be removed.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    @_utilities.deprecated("""The attribute is invalid and no any affect for the instance. So it has been deprecated since version v1.121.2.""")
    def internet_max_bandwidth_in(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. **NOTE:** From version 1.243.0, the default value `0` will be removed.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10. **NOTE:** From version 1.241.0, `ipv6_addresses` can be modified.
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use outdated instance type.
        """
        return pulumi.get(self, "is_outdated")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
        """
        return pulumi.get(self, "launch_template_version")

    @_builtins.property
    @pulumi.getter(name="maintenanceAction")
    def maintenance_action(self) -> pulumi.Output[_builtins.str]:
        """
        The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
        * `Stop` : stops the instance.
        * `AutoRecover` : automatically recovers the instance.
        * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
        """
        return pulumi.get(self, "maintenance_action")

    @_builtins.property
    @pulumi.getter(name="maintenanceNotify")
    def maintenance_notify(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
        """
        return pulumi.get(self, "maintenance_notify")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> pulumi.Output[Optional['outputs.InstanceMaintenanceTime']]:
        """
        The time of maintenance. See `maintenance_time` below.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        """
        The memory size of the instance. Unit: MiB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The index of the network card for Primary ENI.
        """
        return pulumi.get(self, "network_card_index")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Primary ENI.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
        - `Standard`: Uses the TCP communication mode.
        - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output['outputs.InstanceNetworkInterfaces']:
        """
        The list of network interfaces created with instance. See `network_interfaces` below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
        """
        return pulumi.get(self, "operator_type")

    @_builtins.property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the operating system of the instance.
        """
        return pulumi.get(self, "os_name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the operating system of the instance.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use the password preset in the image. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "password_inherit")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        """
        The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
        - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
        - [1-3] when `period_unit` in "Week"

        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the private pool.
        """
        return pulumi.get(self, "private_pool_options_id")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the private pool. Default value: `None`. Valid values:
        - `Open`: Open private pool.
        - `Target`: Specified private pool. **NOTE:** If `private_pool_options_match_criteria` is set to `Target`, `private_pool_options_id` is required.
        - `None`: No private pool. The capacity in private pools is not used.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The instance public ip.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="queuePairNumber")
    def queue_pair_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of queues supported by the ERI.
        """
        return pulumi.get(self, "queue_pair_number")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
        - `AutoRenewal`: Enable auto renewal.
        - `Normal`: Disable auto renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Access Management (RAM) role. **NOTE:** From version 1.250.0, If you want to use `role_name`, We recommend you to use the resource alicloud_ecs_ram_role_attachment.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
        """
        return pulumi.get(self, "secondary_private_ips")

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The security enhancement strategy.
        - Active: Enable security enhancement strategy, it only works on system images.
        - Deactive: Disable security enhancement strategy, it works on all images.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
        """
        return pulumi.get(self, "spot_duration")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[_builtins.float]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
        - NoSpot: A regular Pay-As-You-Go instance.
        - SpotWithPriceLimit: A price threshold for a spot instance
        - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance

        Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.232.0) The time when the instance was last started.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
        * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
        * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
        """
        return pulumi.get(self, "stopped_mode")

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature for the system disk. Valid values:
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[_builtins.str]:
        """
        Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.210.0) The ID of system disk.
        """
        return pulumi.get(self, "system_disk_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Management Service (KMS) key to be used for the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_name")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[_builtins.str]:
        """
        The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
        """
        return pulumi.get(self, "system_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk to use as the system disk.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter(name="systemDiskStorageClusterId")
    def system_disk_storage_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
        """
        return pulumi.get(self, "system_disk_storage_cluster_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
        It supports to setting a base64-encoded value, and it is the recommended usage.
        From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
        Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the devices created by the instance at launch time.
        - Key: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to `128` characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "volume_tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "vswitch_id")

