# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurityGroupArgs', 'SecurityGroup']

@pulumi.input_type
class SecurityGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 inner_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 inner_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityGroup resource.
        :param pulumi.Input[_builtins.str] description: The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] inner_access: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        :param pulumi.Input[_builtins.str] inner_access_policy: The internal access control policy of the security group. Valid values:
               - `Accept`: The internal interconnectivity policy.
               - `Drop`: The internal isolation policy.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] security_group_name: The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] security_group_type: The type of the security group. Default value: `normal`. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which you want to create the security group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inner_access is not None:
            warnings.warn("""Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""", DeprecationWarning)
            pulumi.log.warn("""inner_access is deprecated: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""")
        if inner_access is not None:
            pulumi.set(__self__, "inner_access", inner_access)
        if inner_access_policy is not None:
            pulumi.set(__self__, "inner_access_policy", inner_access_policy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if security_group_type is not None:
            pulumi.set(__self__, "security_group_type", security_group_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="innerAccess")
    @_utilities.deprecated("""Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""")
    def inner_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        """
        return pulumi.get(self, "inner_access")

    @inner_access.setter
    def inner_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inner_access", value)

    @_builtins.property
    @pulumi.getter(name="innerAccessPolicy")
    def inner_access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal access control policy of the security group. Valid values:
        - `Accept`: The internal interconnectivity policy.
        - `Drop`: The internal isolation policy.
        """
        return pulumi.get(self, "inner_access_policy")

    @inner_access_policy.setter
    def inner_access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inner_access_policy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupType")
    def security_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the security group. Default value: `normal`. Valid values:
        """
        return pulumi.get(self, "security_group_type")

    @security_group_type.setter
    def security_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC in which you want to create the security group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _SecurityGroupState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 inner_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 inner_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityGroup resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.239.0) The time when the security group was created.
        :param pulumi.Input[_builtins.str] description: The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] inner_access: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        :param pulumi.Input[_builtins.str] inner_access_policy: The internal access control policy of the security group. Valid values:
               - `Accept`: The internal interconnectivity policy.
               - `Drop`: The internal isolation policy.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] security_group_name: The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] security_group_type: The type of the security group. Default value: `normal`. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which you want to create the security group.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inner_access is not None:
            warnings.warn("""Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""", DeprecationWarning)
            pulumi.log.warn("""inner_access is deprecated: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""")
        if inner_access is not None:
            pulumi.set(__self__, "inner_access", inner_access)
        if inner_access_policy is not None:
            pulumi.set(__self__, "inner_access_policy", inner_access_policy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if security_group_type is not None:
            pulumi.set(__self__, "security_group_type", security_group_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.239.0) The time when the security group was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="innerAccess")
    @_utilities.deprecated("""Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""")
    def inner_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        """
        return pulumi.get(self, "inner_access")

    @inner_access.setter
    def inner_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inner_access", value)

    @_builtins.property
    @pulumi.getter(name="innerAccessPolicy")
    def inner_access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal access control policy of the security group. Valid values:
        - `Accept`: The internal interconnectivity policy.
        - `Drop`: The internal isolation policy.
        """
        return pulumi.get(self, "inner_access_policy")

    @inner_access_policy.setter
    def inner_access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inner_access_policy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupType")
    def security_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the security group. Default value: `normal`. Valid values:
        """
        return pulumi.get(self, "security_group_type")

    @security_group_type.setter
    def security_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC in which you want to create the security group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:ecs/securityGroup:SecurityGroup")
class SecurityGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 inner_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 inner_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS Security Group resource.

        For information about ECS Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-createsecuritygroup).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** `ecs.SecurityGroup` is used to build and manage a security group, and `ecs.SecurityGroupRule` can define ingress or egress rules for it.

        > **NOTE:** From version 1.7.2, `ecs.SecurityGroup` has supported to segregate different ECS instance in which the same security group.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ecs.SecurityGroup("default", security_group_name="terraform-example")
        ```

        Basic Usage for VPC

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name="terraform-example",
            vpc_id=default.id)
        ```

        ## Module Support

        You can use the existing security-group module
        to create a security group and add several rules one-click.

        ## Import

        ECS Security Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/securityGroup:SecurityGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] inner_access: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        :param pulumi.Input[_builtins.str] inner_access_policy: The internal access control policy of the security group. Valid values:
               - `Accept`: The internal interconnectivity policy.
               - `Drop`: The internal isolation policy.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] security_group_name: The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] security_group_type: The type of the security group. Default value: `normal`. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which you want to create the security group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Security Group resource.

        For information about ECS Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-createsecuritygroup).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** `ecs.SecurityGroup` is used to build and manage a security group, and `ecs.SecurityGroupRule` can define ingress or egress rules for it.

        > **NOTE:** From version 1.7.2, `ecs.SecurityGroup` has supported to segregate different ECS instance in which the same security group.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ecs.SecurityGroup("default", security_group_name="terraform-example")
        ```

        Basic Usage for VPC

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name="terraform-example",
            vpc_id=default.id)
        ```

        ## Module Support

        You can use the existing security-group module
        to create a security group and add several rules one-click.

        ## Import

        ECS Security Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/securityGroup:SecurityGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 inner_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 inner_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupArgs.__new__(SecurityGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["inner_access"] = inner_access
            __props__.__dict__["inner_access_policy"] = inner_access_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_group_name"] = security_group_name
            __props__.__dict__["security_group_type"] = security_group_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
        super(SecurityGroup, __self__).__init__(
            'alicloud:ecs/securityGroup:SecurityGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            inner_access: Optional[pulumi.Input[_builtins.bool]] = None,
            inner_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityGroup':
        """
        Get an existing SecurityGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.239.0) The time when the security group was created.
        :param pulumi.Input[_builtins.str] description: The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] inner_access: Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        :param pulumi.Input[_builtins.str] inner_access_policy: The internal access control policy of the security group. Valid values:
               - `Accept`: The internal interconnectivity policy.
               - `Drop`: The internal isolation policy.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        :param pulumi.Input[_builtins.str] security_group_name: The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] security_group_type: The type of the security group. Default value: `normal`. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC in which you want to create the security group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupState.__new__(_SecurityGroupState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["inner_access"] = inner_access
        __props__.__dict__["inner_access_policy"] = inner_access_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_name"] = security_group_name
        __props__.__dict__["security_group_type"] = security_group_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return SecurityGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.239.0) The time when the security group was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the security group. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="innerAccess")
    @_utilities.deprecated("""Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.""")
    def inner_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
        """
        return pulumi.get(self, "inner_access")

    @_builtins.property
    @pulumi.getter(name="innerAccessPolicy")
    def inner_access_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The internal access control policy of the security group. Valid values:
        - `Accept`: The internal interconnectivity policy.
        - `Drop`: The internal isolation policy.
        """
        return pulumi.get(self, "inner_access_policy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.239.0. New field `security_group_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security group. The name must be `2` to `128` characters in length. The name must start with a letter and cannot start with `http://` or `https://`. The name can contain Unicode characters under the Decimal Number category and the categories whose names contain Letter. The name can also contain colons (:), underscores (\\_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "security_group_name")

    @_builtins.property
    @pulumi.getter(name="securityGroupType")
    def security_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the security group. Default value: `normal`. Valid values:
        """
        return pulumi.get(self, "security_group_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC in which you want to create the security group.
        """
        return pulumi.get(self, "vpc_id")

