# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, clusters=None, id=None, ids=None, logical_region_id=None, name_regex=None, names=None, output_file=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if logical_region_id and not isinstance(logical_region_id, str):
            raise TypeError("Expected argument 'logical_region_id' to be a str")
        pulumi.set(__self__, "logical_region_id", logical_region_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetClustersClusterResult']:
        """
        A list of clusters.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of cluster IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="logicalRegionId")
    def logical_region_id(self) -> _builtins.str:
        return pulumi.get(self, "logical_region_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of cluster names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            clusters=self.clusters,
            id=self.id,
            ids=self.ids,
            logical_region_id=self.logical_region_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_clusters(ids: Optional[Sequence[_builtins.str]] = None,
                 logical_region_id: Optional[_builtins.str] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    This data source provides a list of EDAS clusters in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.82.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    clusters = alicloud.edas.get_clusters(logical_region_id="cn-shenzhen:xxx",
        ids=["addfs-dfsasd"],
        output_file="clusters.txt")
    pulumi.export("firstClusterName", clusters_alicloud_alikafka_consumer_groups["clusters"][0]["clusterName"])
    ```


    :param Sequence[_builtins.str] ids: An ids string to filter results by the cluster id.
    :param _builtins.str logical_region_id: ID of the namespace in EDAS.
    :param _builtins.str name_regex: A regex string to filter results by the cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logicalRegionId'] = logical_region_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:edas/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        logical_region_id=pulumi.get(__ret__, 'logical_region_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_clusters_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        logical_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    This data source provides a list of EDAS clusters in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.82.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    clusters = alicloud.edas.get_clusters(logical_region_id="cn-shenzhen:xxx",
        ids=["addfs-dfsasd"],
        output_file="clusters.txt")
    pulumi.export("firstClusterName", clusters_alicloud_alikafka_consumer_groups["clusters"][0]["clusterName"])
    ```


    :param Sequence[_builtins.str] ids: An ids string to filter results by the cluster id.
    :param _builtins.str logical_region_id: ID of the namespace in EDAS.
    :param _builtins.str name_regex: A regex string to filter results by the cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logicalRegionId'] = logical_region_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:edas/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        logical_region_id=pulumi.get(__response__, 'logical_region_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
