# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExperimentPlanTemplateArgs', 'ExperimentPlanTemplate']

@pulumi.input_type
class ExperimentPlanTemplateArgs:
    def __init__(__self__, *,
                 privacy_level: pulumi.Input[_builtins.str],
                 template_name: pulumi.Input[_builtins.str],
                 template_pipelines: pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]],
                 template_description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExperimentPlanTemplate resource.
        :param pulumi.Input[_builtins.str] privacy_level: Used to indicate the privacy level of the content or information. It can have the following optional parameters:
               - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
               - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        :param pulumi.Input[_builtins.str] template_name: Help users identify and select specific templates.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]] template_pipelines: Representative Template Pipeline. See `template_pipeline` below.
        :param pulumi.Input[_builtins.str] template_description: Describe the purpose of this template.
        """
        pulumi.set(__self__, "privacy_level", privacy_level)
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_pipelines", template_pipelines)
        if template_description is not None:
            pulumi.set(__self__, "template_description", template_description)

    @_builtins.property
    @pulumi.getter(name="privacyLevel")
    def privacy_level(self) -> pulumi.Input[_builtins.str]:
        """
        Used to indicate the privacy level of the content or information. It can have the following optional parameters:
        - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
        - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        """
        return pulumi.get(self, "privacy_level")

    @privacy_level.setter
    def privacy_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "privacy_level", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[_builtins.str]:
        """
        Help users identify and select specific templates.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_name", value)

    @_builtins.property
    @pulumi.getter(name="templatePipelines")
    def template_pipelines(self) -> pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]]:
        """
        Representative Template Pipeline. See `template_pipeline` below.
        """
        return pulumi.get(self, "template_pipelines")

    @template_pipelines.setter
    def template_pipelines(self, value: pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]]):
        pulumi.set(self, "template_pipelines", value)

    @_builtins.property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describe the purpose of this template.
        """
        return pulumi.get(self, "template_description")

    @template_description.setter
    def template_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_description", value)


@pulumi.input_type
class _ExperimentPlanTemplateState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_level: Optional[pulumi.Input[_builtins.str]] = None,
                 template_description: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]]] = None):
        """
        Input properties used for looking up and filtering ExperimentPlanTemplate resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] privacy_level: Used to indicate the privacy level of the content or information. It can have the following optional parameters:
               - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
               - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        :param pulumi.Input[_builtins.str] template_description: Describe the purpose of this template.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_name: Help users identify and select specific templates.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]] template_pipelines: Representative Template Pipeline. See `template_pipeline` below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if privacy_level is not None:
            pulumi.set(__self__, "privacy_level", privacy_level)
        if template_description is not None:
            pulumi.set(__self__, "template_description", template_description)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_pipelines is not None:
            pulumi.set(__self__, "template_pipelines", template_pipelines)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="privacyLevel")
    def privacy_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to indicate the privacy level of the content or information. It can have the following optional parameters:
        - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
        - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        """
        return pulumi.get(self, "privacy_level")

    @privacy_level.setter
    def privacy_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privacy_level", value)

    @_builtins.property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describe the purpose of this template.
        """
        return pulumi.get(self, "template_description")

    @template_description.setter
    def template_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_description", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Help users identify and select specific templates.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)

    @_builtins.property
    @pulumi.getter(name="templatePipelines")
    def template_pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]]]:
        """
        Representative Template Pipeline. See `template_pipeline` below.
        """
        return pulumi.get(self, "template_pipelines")

    @template_pipelines.setter
    def template_pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentPlanTemplateTemplatePipelineArgs']]]]):
        pulumi.set(self, "template_pipelines", value)


@pulumi.type_token("alicloud:eflo/experimentPlanTemplate:ExperimentPlanTemplate")
class ExperimentPlanTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privacy_level: Optional[pulumi.Input[_builtins.str]] = None,
                 template_description: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentPlanTemplateTemplatePipelineArgs', 'ExperimentPlanTemplateTemplatePipelineArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Eflo Experiment Plan Template resource.

        For information about Eflo Experiment Plan Template and how to use it, see [What is Experiment Plan Template](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eflo-cnp-2023-08-28-createexperimentplantemplate).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.eflo.ExperimentPlanTemplate("default",
            template_pipelines=[{
                "workload_id": 2,
                "workload_name": "MatMul",
                "env_params": {
                    "cpu_per_worker": 90,
                    "gpu_per_worker": 8,
                    "memory_per_worker": 500,
                    "share_memory": 500,
                    "worker_num": 1,
                    "py_torch_version": "1",
                    "gpu_driver_version": "1",
                    "cuda_version": "1",
                    "nccl_version": "1",
                },
                "pipeline_order": 1,
                "scene": "baseline",
            }],
            privacy_level="private",
            template_name=name,
            template_description=name)
        ```

        ## Import

        Eflo Experiment Plan Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/experimentPlanTemplate:ExperimentPlanTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] privacy_level: Used to indicate the privacy level of the content or information. It can have the following optional parameters:
               - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
               - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        :param pulumi.Input[_builtins.str] template_description: Describe the purpose of this template.
        :param pulumi.Input[_builtins.str] template_name: Help users identify and select specific templates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentPlanTemplateTemplatePipelineArgs', 'ExperimentPlanTemplateTemplatePipelineArgsDict']]]] template_pipelines: Representative Template Pipeline. See `template_pipeline` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExperimentPlanTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Experiment Plan Template resource.

        For information about Eflo Experiment Plan Template and how to use it, see [What is Experiment Plan Template](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eflo-cnp-2023-08-28-createexperimentplantemplate).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.eflo.ExperimentPlanTemplate("default",
            template_pipelines=[{
                "workload_id": 2,
                "workload_name": "MatMul",
                "env_params": {
                    "cpu_per_worker": 90,
                    "gpu_per_worker": 8,
                    "memory_per_worker": 500,
                    "share_memory": 500,
                    "worker_num": 1,
                    "py_torch_version": "1",
                    "gpu_driver_version": "1",
                    "cuda_version": "1",
                    "nccl_version": "1",
                },
                "pipeline_order": 1,
                "scene": "baseline",
            }],
            privacy_level="private",
            template_name=name,
            template_description=name)
        ```

        ## Import

        Eflo Experiment Plan Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/experimentPlanTemplate:ExperimentPlanTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ExperimentPlanTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExperimentPlanTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privacy_level: Optional[pulumi.Input[_builtins.str]] = None,
                 template_description: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentPlanTemplateTemplatePipelineArgs', 'ExperimentPlanTemplateTemplatePipelineArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExperimentPlanTemplateArgs.__new__(ExperimentPlanTemplateArgs)

            if privacy_level is None and not opts.urn:
                raise TypeError("Missing required property 'privacy_level'")
            __props__.__dict__["privacy_level"] = privacy_level
            __props__.__dict__["template_description"] = template_description
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            if template_pipelines is None and not opts.urn:
                raise TypeError("Missing required property 'template_pipelines'")
            __props__.__dict__["template_pipelines"] = template_pipelines
            __props__.__dict__["create_time"] = None
            __props__.__dict__["template_id"] = None
        super(ExperimentPlanTemplate, __self__).__init__(
            'alicloud:eflo/experimentPlanTemplate:ExperimentPlanTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            privacy_level: Optional[pulumi.Input[_builtins.str]] = None,
            template_description: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None,
            template_name: Optional[pulumi.Input[_builtins.str]] = None,
            template_pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentPlanTemplateTemplatePipelineArgs', 'ExperimentPlanTemplateTemplatePipelineArgsDict']]]]] = None) -> 'ExperimentPlanTemplate':
        """
        Get an existing ExperimentPlanTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] privacy_level: Used to indicate the privacy level of the content or information. It can have the following optional parameters:
               - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
               - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        :param pulumi.Input[_builtins.str] template_description: Describe the purpose of this template.
        :param pulumi.Input[_builtins.str] template_id: The ID of the template.
        :param pulumi.Input[_builtins.str] template_name: Help users identify and select specific templates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentPlanTemplateTemplatePipelineArgs', 'ExperimentPlanTemplateTemplatePipelineArgsDict']]]] template_pipelines: Representative Template Pipeline. See `template_pipeline` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExperimentPlanTemplateState.__new__(_ExperimentPlanTemplateState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["privacy_level"] = privacy_level
        __props__.__dict__["template_description"] = template_description
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["template_pipelines"] = template_pipelines
        return ExperimentPlanTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="privacyLevel")
    def privacy_level(self) -> pulumi.Output[_builtins.str]:
        """
        Used to indicate the privacy level of the content or information. It can have the following optional parameters:
        - private: Indicates that the content is private and restricted to specific users or permission groups. Private content is usually not publicly displayed, and only authorized users can view or edit it.
        - public: Indicates that the content is public and can be accessed by anyone. Public content is usually viewable by all users and is suitable for sharing information or resources
        """
        return pulumi.get(self, "privacy_level")

    @_builtins.property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Describe the purpose of this template.
        """
        return pulumi.get(self, "template_description")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[_builtins.str]:
        """
        Help users identify and select specific templates.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templatePipelines")
    def template_pipelines(self) -> pulumi.Output[Sequence['outputs.ExperimentPlanTemplateTemplatePipeline']]:
        """
        Representative Template Pipeline. See `template_pipeline` below.
        """
        return pulumi.get(self, "template_pipelines")

