# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterApplicationConfigArgs',
    'ClusterApplicationConfigArgsDict',
    'ClusterBootstrapScriptArgs',
    'ClusterBootstrapScriptArgsDict',
    'ClusterBootstrapScriptNodeSelectorArgs',
    'ClusterBootstrapScriptNodeSelectorArgsDict',
    'ClusterNodeAttributeArgs',
    'ClusterNodeAttributeArgsDict',
    'ClusterNodeGroupArgs',
    'ClusterNodeGroupArgsDict',
    'ClusterNodeGroupAckConfigArgs',
    'ClusterNodeGroupAckConfigArgsDict',
    'ClusterNodeGroupAckConfigCustomAnnotationArgs',
    'ClusterNodeGroupAckConfigCustomAnnotationArgsDict',
    'ClusterNodeGroupAckConfigCustomLabelArgs',
    'ClusterNodeGroupAckConfigCustomLabelArgsDict',
    'ClusterNodeGroupAckConfigNodeSelectorArgs',
    'ClusterNodeGroupAckConfigNodeSelectorArgsDict',
    'ClusterNodeGroupAckConfigPvcArgs',
    'ClusterNodeGroupAckConfigPvcArgsDict',
    'ClusterNodeGroupAckConfigTolerationArgs',
    'ClusterNodeGroupAckConfigTolerationArgsDict',
    'ClusterNodeGroupAckConfigVolumeArgs',
    'ClusterNodeGroupAckConfigVolumeArgsDict',
    'ClusterNodeGroupAckConfigVolumeMountArgs',
    'ClusterNodeGroupAckConfigVolumeMountArgsDict',
    'ClusterNodeGroupAutoScalingPolicyArgs',
    'ClusterNodeGroupAutoScalingPolicyArgsDict',
    'ClusterNodeGroupAutoScalingPolicyConstraintsArgs',
    'ClusterNodeGroupAutoScalingPolicyConstraintsArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsDict',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsDict',
    'ClusterNodeGroupCostOptimizedConfigArgs',
    'ClusterNodeGroupCostOptimizedConfigArgsDict',
    'ClusterNodeGroupDataDiskArgs',
    'ClusterNodeGroupDataDiskArgsDict',
    'ClusterNodeGroupPrivatePoolOptionsArgs',
    'ClusterNodeGroupPrivatePoolOptionsArgsDict',
    'ClusterNodeGroupSpotBidPriceArgs',
    'ClusterNodeGroupSpotBidPriceArgsDict',
    'ClusterNodeGroupSubscriptionConfigArgs',
    'ClusterNodeGroupSubscriptionConfigArgsDict',
    'ClusterNodeGroupSystemDiskArgs',
    'ClusterNodeGroupSystemDiskArgsDict',
    'ClusterSubscriptionConfigArgs',
    'ClusterSubscriptionConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterApplicationConfigArgsDict(TypedDict):
        application_name: pulumi.Input[_builtins.str]
        """
        The application name of EMR cluster which has installed.
        """
        config_file_name: pulumi.Input[_builtins.str]
        """
        The configuration file name of application installed.
        """
        config_item_key: pulumi.Input[_builtins.str]
        """
        The configuration item key of application installed.
        """
        config_item_value: pulumi.Input[_builtins.str]
        """
        The configuration item value of application installed.
        """
        config_description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration description of application installed.
        """
        config_scope: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        """
        node_group_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration effected which node group id of emr cluster.
        """
        node_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration effected which node group name of emr cluster.
        """
elif False:
    ClusterApplicationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterApplicationConfigArgs:
    def __init__(__self__, *,
                 application_name: pulumi.Input[_builtins.str],
                 config_file_name: pulumi.Input[_builtins.str],
                 config_item_key: pulumi.Input[_builtins.str],
                 config_item_value: pulumi.Input[_builtins.str],
                 config_description: Optional[pulumi.Input[_builtins.str]] = None,
                 config_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] application_name: The application name of EMR cluster which has installed.
        :param pulumi.Input[_builtins.str] config_file_name: The configuration file name of application installed.
        :param pulumi.Input[_builtins.str] config_item_key: The configuration item key of application installed.
        :param pulumi.Input[_builtins.str] config_item_value: The configuration item value of application installed.
        :param pulumi.Input[_builtins.str] config_description: The configuration description of application installed.
        :param pulumi.Input[_builtins.str] config_scope: The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        :param pulumi.Input[_builtins.str] node_group_id: The configuration effected which node group id of emr cluster.
        :param pulumi.Input[_builtins.str] node_group_name: The configuration effected which node group name of emr cluster.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "config_item_key", config_item_key)
        pulumi.set(__self__, "config_item_value", config_item_value)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_scope is not None:
            pulumi.set(__self__, "config_scope", config_scope)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[_builtins.str]:
        """
        The application name of EMR cluster which has installed.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> pulumi.Input[_builtins.str]:
        """
        The configuration file name of application installed.
        """
        return pulumi.get(self, "config_file_name")

    @config_file_name.setter
    def config_file_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_file_name", value)

    @_builtins.property
    @pulumi.getter(name="configItemKey")
    def config_item_key(self) -> pulumi.Input[_builtins.str]:
        """
        The configuration item key of application installed.
        """
        return pulumi.get(self, "config_item_key")

    @config_item_key.setter
    def config_item_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_item_key", value)

    @_builtins.property
    @pulumi.getter(name="configItemValue")
    def config_item_value(self) -> pulumi.Input[_builtins.str]:
        """
        The configuration item value of application installed.
        """
        return pulumi.get(self, "config_item_value")

    @config_item_value.setter
    def config_item_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_item_value", value)

    @_builtins.property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration description of application installed.
        """
        return pulumi.get(self, "config_description")

    @config_description.setter
    def config_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_description", value)

    @_builtins.property
    @pulumi.getter(name="configScope")
    def config_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        """
        return pulumi.get(self, "config_scope")

    @config_scope.setter
    def config_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_scope", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_name", value)


if not MYPY:
    class ClusterBootstrapScriptArgsDict(TypedDict):
        execution_fail_strategy: pulumi.Input[_builtins.str]
        """
        The bootstrap scripts execution fail strategy, ’FAILED_BLOCK’ or ‘FAILED_CONTINUE’ .
        """
        execution_moment: pulumi.Input[_builtins.str]
        """
        The bootstrap scripts execution moment, ’BEFORE_INSTALL’, ‘AFTER_STARTED’ or ‘BEFORE_START’. The execution moment of BEFORE_START is available since v1.243.0.
        """
        node_selector: pulumi.Input['ClusterBootstrapScriptNodeSelectorArgsDict']
        """
        The bootstrap scripts execution target. See `node_selector` below.
        """
        script_args: pulumi.Input[_builtins.str]
        """
        The bootstrap script args, e.g. "--a=b".
        """
        script_name: pulumi.Input[_builtins.str]
        """
        The bootstrap script name.
        """
        script_path: pulumi.Input[_builtins.str]
        """
        The bootstrap script path, e.g. "oss://bucket/path".
        """
        priority: NotRequired[pulumi.Input[_builtins.int]]
        """
        The bootstrap scripts priority.
        """
elif False:
    ClusterBootstrapScriptArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBootstrapScriptArgs:
    def __init__(__self__, *,
                 execution_fail_strategy: pulumi.Input[_builtins.str],
                 execution_moment: pulumi.Input[_builtins.str],
                 node_selector: pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs'],
                 script_args: pulumi.Input[_builtins.str],
                 script_name: pulumi.Input[_builtins.str],
                 script_path: pulumi.Input[_builtins.str],
                 priority: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] execution_fail_strategy: The bootstrap scripts execution fail strategy, ’FAILED_BLOCK’ or ‘FAILED_CONTINUE’ .
        :param pulumi.Input[_builtins.str] execution_moment: The bootstrap scripts execution moment, ’BEFORE_INSTALL’, ‘AFTER_STARTED’ or ‘BEFORE_START’. The execution moment of BEFORE_START is available since v1.243.0.
        :param pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs'] node_selector: The bootstrap scripts execution target. See `node_selector` below.
        :param pulumi.Input[_builtins.str] script_args: The bootstrap script args, e.g. "--a=b".
        :param pulumi.Input[_builtins.str] script_name: The bootstrap script name.
        :param pulumi.Input[_builtins.str] script_path: The bootstrap script path, e.g. "oss://bucket/path".
        :param pulumi.Input[_builtins.int] priority: The bootstrap scripts priority.
        """
        pulumi.set(__self__, "execution_fail_strategy", execution_fail_strategy)
        pulumi.set(__self__, "execution_moment", execution_moment)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "script_args", script_args)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "script_path", script_path)
        if priority is not None:
            warnings.warn("""Field 'priority' has been deprecated from provider version 1.227.0.""", DeprecationWarning)
            pulumi.log.warn("""priority is deprecated: Field 'priority' has been deprecated from provider version 1.227.0.""")
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="executionFailStrategy")
    def execution_fail_strategy(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap scripts execution fail strategy, ’FAILED_BLOCK’ or ‘FAILED_CONTINUE’ .
        """
        return pulumi.get(self, "execution_fail_strategy")

    @execution_fail_strategy.setter
    def execution_fail_strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_fail_strategy", value)

    @_builtins.property
    @pulumi.getter(name="executionMoment")
    def execution_moment(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap scripts execution moment, ’BEFORE_INSTALL’, ‘AFTER_STARTED’ or ‘BEFORE_START’. The execution moment of BEFORE_START is available since v1.243.0.
        """
        return pulumi.get(self, "execution_moment")

    @execution_moment.setter
    def execution_moment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_moment", value)

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs']:
        """
        The bootstrap scripts execution target. See `node_selector` below.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs']):
        pulumi.set(self, "node_selector", value)

    @_builtins.property
    @pulumi.getter(name="scriptArgs")
    def script_args(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap script args, e.g. "--a=b".
        """
        return pulumi.get(self, "script_args")

    @script_args.setter
    def script_args(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_args", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap script name.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap script path, e.g. "oss://bucket/path".
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_path", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'priority' has been deprecated from provider version 1.227.0.""")
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bootstrap scripts priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)


if not MYPY:
    class ClusterBootstrapScriptNodeSelectorArgsDict(TypedDict):
        node_select_type: pulumi.Input[_builtins.str]
        """
        The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        """
        node_group_id: NotRequired[pulumi.Input[_builtins.str]]
        node_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The bootstrap scripts execution target node group ids.
        """
        node_group_name: NotRequired[pulumi.Input[_builtins.str]]
        node_group_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The bootstrap scripts execution target node group names.
        """
        node_group_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The bootstrap scripts execution target node group types.
        """
        node_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The bootstrap scripts execution target node names.
        """
elif False:
    ClusterBootstrapScriptNodeSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBootstrapScriptNodeSelectorArgs:
    def __init__(__self__, *,
                 node_select_type: pulumi.Input[_builtins.str],
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_group_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] node_select_type: The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_group_ids: The bootstrap scripts execution target node group ids.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_group_names: The bootstrap scripts execution target node group names.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_group_types: The bootstrap scripts execution target node group types.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_names: The bootstrap scripts execution target node names.
        """
        pulumi.set(__self__, "node_select_type", node_select_type)
        if node_group_id is not None:
            warnings.warn("""Field 'node_group_id' has been deprecated from provider version 1.227.0. New field 'node_group_ids' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""node_group_id is deprecated: Field 'node_group_id' has been deprecated from provider version 1.227.0. New field 'node_group_ids' replaces it.""")
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_ids is not None:
            pulumi.set(__self__, "node_group_ids", node_group_ids)
        if node_group_name is not None:
            warnings.warn("""Field 'node_group_name' has been deprecated from provider version 1.227.0. New field 'node_group_names' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""node_group_name is deprecated: Field 'node_group_name' has been deprecated from provider version 1.227.0. New field 'node_group_names' replaces it.""")
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_names is not None:
            pulumi.set(__self__, "node_group_names", node_group_names)
        if node_group_types is not None:
            pulumi.set(__self__, "node_group_types", node_group_types)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)

    @_builtins.property
    @pulumi.getter(name="nodeSelectType")
    def node_select_type(self) -> pulumi.Input[_builtins.str]:
        """
        The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        """
        return pulumi.get(self, "node_select_type")

    @node_select_type.setter
    def node_select_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_select_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    @_utilities.deprecated("""Field 'node_group_id' has been deprecated from provider version 1.227.0. New field 'node_group_ids' replaces it.""")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupIds")
    def node_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The bootstrap scripts execution target node group ids.
        """
        return pulumi.get(self, "node_group_ids")

    @node_group_ids.setter
    def node_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    @_utilities.deprecated("""Field 'node_group_name' has been deprecated from provider version 1.227.0. New field 'node_group_names' replaces it.""")
    def node_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupNames")
    def node_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The bootstrap scripts execution target node group names.
        """
        return pulumi.get(self, "node_group_names")

    @node_group_names.setter
    def node_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_group_names", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupTypes")
    def node_group_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The bootstrap scripts execution target node group types.
        """
        return pulumi.get(self, "node_group_types")

    @node_group_types.setter
    def node_group_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_group_types", value)

    @_builtins.property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The bootstrap scripts execution target node names.
        """
        return pulumi.get(self, "node_names")

    @node_names.setter
    def node_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_names", value)


if not MYPY:
    class ClusterNodeAttributeArgsDict(TypedDict):
        key_pair_name: pulumi.Input[_builtins.str]
        """
        The name of the key pair.
        """
        ram_role: pulumi.Input[_builtins.str]
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        security_group_id: pulumi.Input[_builtins.str]
        """
        Security Group ID for Cluster.
        """
        vpc_id: pulumi.Input[_builtins.str]
        """
        Used to retrieve instances belong to specified VPC.
        """
        zone_id: pulumi.Input[_builtins.str]
        """
        Zone ID, e.g. cn-hangzhou-i
        """
        data_disk_encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable data disk encryption.
        """
        data_disk_kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        system_disk_encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable system disk encryption.
        """
        system_disk_kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
elif False:
    ClusterNodeAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeAttributeArgs:
    def __init__(__self__, *,
                 key_pair_name: pulumi.Input[_builtins.str],
                 ram_role: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 data_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair.
        :param pulumi.Input[_builtins.str] ram_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[_builtins.str] security_group_id: Security Group ID for Cluster.
        :param pulumi.Input[_builtins.str] vpc_id: Used to retrieve instances belong to specified VPC.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID, e.g. cn-hangzhou-i
        :param pulumi.Input[_builtins.bool] data_disk_encrypted: Whether to enable data disk encryption.
        :param pulumi.Input[_builtins.str] data_disk_kms_key_id: The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to enable system disk encryption.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "ram_role", ram_role)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if data_disk_encrypted is not None:
            pulumi.set(__self__, "data_disk_encrypted", data_disk_encrypted)
        if data_disk_kms_key_id is not None:
            pulumi.set(__self__, "data_disk_kms_key_id", data_disk_kms_key_id)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="ramRole")
    def ram_role(self) -> pulumi.Input[_builtins.str]:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "ram_role")

    @ram_role.setter
    def ram_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ram_role", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Security Group ID for Cluster.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone ID, e.g. cn-hangzhou-i
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskEncrypted")
    def data_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable data disk encryption.
        """
        return pulumi.get(self, "data_disk_encrypted")

    @data_disk_encrypted.setter
    def data_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskKmsKeyId")
    def data_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        return pulumi.get(self, "data_disk_kms_key_id")

    @data_disk_kms_key_id.setter
    def data_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable system disk encryption.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)


if not MYPY:
    class ClusterNodeGroupArgsDict(TypedDict):
        data_disks: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgsDict']]]
        """
        Host Ecs data disks information in this node group. See `data_disks` below.
        """
        instance_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Host Ecs instance types. **NOTE:** From version 1.236.0, `instance_types` can be modified.
        """
        node_count: pulumi.Input[_builtins.int]
        """
        Host Ecs number in this node group.
        """
        node_group_name: pulumi.Input[_builtins.str]
        """
        The node group name of emr cluster.
        """
        node_group_type: pulumi.Input[_builtins.str]
        """
        The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0. Node group type of MASTER-EXTEND is available since v1.243.0.
        """
        system_disk: pulumi.Input['ClusterNodeGroupSystemDiskArgsDict']
        """
        Host Ecs system disk information in this node group. See `system_disk` below.
        """
        ack_config: NotRequired[pulumi.Input['ClusterNodeGroupAckConfigArgsDict']]
        """
        The node group of ack configuration for emr cluster to deploying on kubernetes. See `ack_config` below.
        """
        additional_security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Additional security Group IDS for Cluster, you can also specify this key for each node group. **NOTE:** From version 1.236.0, `additional_security_group_ids` can be modified.
        """
        auto_scaling_policy: NotRequired[pulumi.Input['ClusterNodeGroupAutoScalingPolicyArgsDict']]
        """
        The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
        """
        cost_optimized_config: NotRequired[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgsDict']]
        """
        The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below. **NOTE:** From version 1.236.0, `cost_optimized_config` can be modified.
        """
        deployment_set_strategy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP. **NOTE:** From version 1.236.0, `deployment_set_strategy` can be modified.
        """
        graceful_shutdown: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        """
        node_resize_strategy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
        """
        payment_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        private_pool_options: NotRequired[pulumi.Input['ClusterNodeGroupPrivatePoolOptionsArgsDict']]
        """
        The node group specific private pool resources. See `private_pool_options` below.
        """
        spot_bid_prices: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgsDict']]]]
        """
        The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        """
        spot_instance_remedy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        spot_strategy: NotRequired[pulumi.Input[_builtins.str]]
        """
        The spot strategy configuration of emr cluster. Valid values: `NoSpot`, `SpotWithPriceLimit`, `SpotAsPriceGo`.
        """
        subscription_config: NotRequired[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgsDict']]
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        vswitch_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Global vSwitch ids, you can also specify it in node group. **NOTE:** From version 1.236.0, `vswitch_ids` can be modified.
        """
        with_public_ip: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the node has a public IP address enabled. **NOTE:** From version 1.236.0, `with_public_ip` can be modified.
        """
elif False:
    ClusterNodeGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupArgs:
    def __init__(__self__, *,
                 data_disks: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]],
                 instance_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 node_count: pulumi.Input[_builtins.int],
                 node_group_name: pulumi.Input[_builtins.str],
                 node_group_type: pulumi.Input[_builtins.str],
                 system_disk: pulumi.Input['ClusterNodeGroupSystemDiskArgs'],
                 ack_config: Optional[pulumi.Input['ClusterNodeGroupAckConfigArgs']] = None,
                 additional_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_policy: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyArgs']] = None,
                 cost_optimized_config: Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']] = None,
                 deployment_set_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_resize_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options: Optional[pulumi.Input['ClusterNodeGroupPrivatePoolOptionsArgs']] = None,
                 spot_bid_prices: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 with_public_ip: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]] data_disks: Host Ecs data disks information in this node group. See `data_disks` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Host Ecs instance types. **NOTE:** From version 1.236.0, `instance_types` can be modified.
        :param pulumi.Input[_builtins.int] node_count: Host Ecs number in this node group.
        :param pulumi.Input[_builtins.str] node_group_name: The node group name of emr cluster.
        :param pulumi.Input[_builtins.str] node_group_type: The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0. Node group type of MASTER-EXTEND is available since v1.243.0.
        :param pulumi.Input['ClusterNodeGroupSystemDiskArgs'] system_disk: Host Ecs system disk information in this node group. See `system_disk` below.
        :param pulumi.Input['ClusterNodeGroupAckConfigArgs'] ack_config: The node group of ack configuration for emr cluster to deploying on kubernetes. See `ack_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_security_group_ids: Additional security Group IDS for Cluster, you can also specify this key for each node group. **NOTE:** From version 1.236.0, `additional_security_group_ids` can be modified.
        :param pulumi.Input['ClusterNodeGroupAutoScalingPolicyArgs'] auto_scaling_policy: The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
        :param pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs'] cost_optimized_config: The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below. **NOTE:** From version 1.236.0, `cost_optimized_config` can be modified.
        :param pulumi.Input[_builtins.str] deployment_set_strategy: Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP. **NOTE:** From version 1.236.0, `deployment_set_strategy` can be modified.
        :param pulumi.Input[_builtins.bool] graceful_shutdown: Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        :param pulumi.Input[_builtins.str] node_resize_strategy: Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
        :param pulumi.Input[_builtins.str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input['ClusterNodeGroupPrivatePoolOptionsArgs'] private_pool_options: The node group specific private pool resources. See `private_pool_options` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]] spot_bid_prices: The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy configuration of emr cluster. Valid values: `NoSpot`, `SpotWithPriceLimit`, `SpotAsPriceGo`.
        :param pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: Global vSwitch ids, you can also specify it in node group. **NOTE:** From version 1.236.0, `vswitch_ids` can be modified.
        :param pulumi.Input[_builtins.bool] with_public_ip: Whether the node has a public IP address enabled. **NOTE:** From version 1.236.0, `with_public_ip` can be modified.
        """
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_group_name", node_group_name)
        pulumi.set(__self__, "node_group_type", node_group_type)
        pulumi.set(__self__, "system_disk", system_disk)
        if ack_config is not None:
            pulumi.set(__self__, "ack_config", ack_config)
        if additional_security_group_ids is not None:
            pulumi.set(__self__, "additional_security_group_ids", additional_security_group_ids)
        if auto_scaling_policy is not None:
            pulumi.set(__self__, "auto_scaling_policy", auto_scaling_policy)
        if cost_optimized_config is not None:
            pulumi.set(__self__, "cost_optimized_config", cost_optimized_config)
        if deployment_set_strategy is not None:
            pulumi.set(__self__, "deployment_set_strategy", deployment_set_strategy)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if node_resize_strategy is not None:
            pulumi.set(__self__, "node_resize_strategy", node_resize_strategy)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if private_pool_options is not None:
            pulumi.set(__self__, "private_pool_options", private_pool_options)
        if spot_bid_prices is not None:
            pulumi.set(__self__, "spot_bid_prices", spot_bid_prices)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if with_public_ip is not None:
            pulumi.set(__self__, "with_public_ip", with_public_ip)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]]:
        """
        Host Ecs data disks information in this node group. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Host Ecs instance types. **NOTE:** From version 1.236.0, `instance_types` can be modified.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[_builtins.int]:
        """
        Host Ecs number in this node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupType")
    def node_group_type(self) -> pulumi.Input[_builtins.str]:
        """
        The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0. Node group type of MASTER-EXTEND is available since v1.243.0.
        """
        return pulumi.get(self, "node_group_type")

    @node_group_type.setter
    def node_group_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_group_type", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Input['ClusterNodeGroupSystemDiskArgs']:
        """
        Host Ecs system disk information in this node group. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: pulumi.Input['ClusterNodeGroupSystemDiskArgs']):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter(name="ackConfig")
    def ack_config(self) -> Optional[pulumi.Input['ClusterNodeGroupAckConfigArgs']]:
        """
        The node group of ack configuration for emr cluster to deploying on kubernetes. See `ack_config` below.
        """
        return pulumi.get(self, "ack_config")

    @ack_config.setter
    def ack_config(self, value: Optional[pulumi.Input['ClusterNodeGroupAckConfigArgs']]):
        pulumi.set(self, "ack_config", value)

    @_builtins.property
    @pulumi.getter(name="additionalSecurityGroupIds")
    def additional_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional security Group IDS for Cluster, you can also specify this key for each node group. **NOTE:** From version 1.236.0, `additional_security_group_ids` can be modified.
        """
        return pulumi.get(self, "additional_security_group_ids")

    @additional_security_group_ids.setter
    def additional_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingPolicy")
    def auto_scaling_policy(self) -> Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyArgs']]:
        """
        The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
        """
        return pulumi.get(self, "auto_scaling_policy")

    @auto_scaling_policy.setter
    def auto_scaling_policy(self, value: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyArgs']]):
        pulumi.set(self, "auto_scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="costOptimizedConfig")
    def cost_optimized_config(self) -> Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']]:
        """
        The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below. **NOTE:** From version 1.236.0, `cost_optimized_config` can be modified.
        """
        return pulumi.get(self, "cost_optimized_config")

    @cost_optimized_config.setter
    def cost_optimized_config(self, value: Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']]):
        pulumi.set(self, "cost_optimized_config", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetStrategy")
    def deployment_set_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP. **NOTE:** From version 1.236.0, `deployment_set_strategy` can be modified.
        """
        return pulumi.get(self, "deployment_set_strategy")

    @deployment_set_strategy.setter
    def deployment_set_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_strategy", value)

    @_builtins.property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        """
        return pulumi.get(self, "graceful_shutdown")

    @graceful_shutdown.setter
    def graceful_shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "graceful_shutdown", value)

    @_builtins.property
    @pulumi.getter(name="nodeResizeStrategy")
    def node_resize_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
        """
        return pulumi.get(self, "node_resize_strategy")

    @node_resize_strategy.setter
    def node_resize_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_resize_strategy", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> Optional[pulumi.Input['ClusterNodeGroupPrivatePoolOptionsArgs']]:
        """
        The node group specific private pool resources. See `private_pool_options` below.
        """
        return pulumi.get(self, "private_pool_options")

    @private_pool_options.setter
    def private_pool_options(self, value: Optional[pulumi.Input['ClusterNodeGroupPrivatePoolOptionsArgs']]):
        pulumi.set(self, "private_pool_options", value)

    @_builtins.property
    @pulumi.getter(name="spotBidPrices")
    def spot_bid_prices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]]:
        """
        The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        """
        return pulumi.get(self, "spot_bid_prices")

    @spot_bid_prices.setter
    def spot_bid_prices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]]):
        pulumi.set(self, "spot_bid_prices", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy configuration of emr cluster. Valid values: `NoSpot`, `SpotWithPriceLimit`, `SpotAsPriceGo`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Global vSwitch ids, you can also specify it in node group. **NOTE:** From version 1.236.0, `vswitch_ids` can be modified.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="withPublicIp")
    def with_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the node has a public IP address enabled. **NOTE:** From version 1.236.0, `with_public_ip` can be modified.
        """
        return pulumi.get(self, "with_public_ip")

    @with_public_ip.setter
    def with_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "with_public_ip", value)


if not MYPY:
    class ClusterNodeGroupAckConfigArgsDict(TypedDict):
        ack_instance_id: pulumi.Input[_builtins.str]
        """
        The ack cluster instance id.
        """
        limit_cpu: pulumi.Input[_builtins.float]
        """
        The job pod resource of limit cpu.
        """
        limit_memory: pulumi.Input[_builtins.float]
        """
        The job pod resource of limit memory.
        """
        namespace: pulumi.Input[_builtins.str]
        """
        The ack cluster namespace.
        """
        request_cpu: pulumi.Input[_builtins.float]
        """
        The job pod resource of request cpu.
        """
        request_memory: pulumi.Input[_builtins.float]
        """
        The job pod resource of request memory.
        """
        custom_annotations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomAnnotationArgsDict']]]]
        """
        The ack cluster custom annotations. See `custom_annotations` below.
        """
        custom_labels: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomLabelArgsDict']]]]
        """
        The ack cluster custom labels. See `custom_labels` below.
        """
        node_affinity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ack cluster node affinity.
        """
        node_selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigNodeSelectorArgsDict']]]]
        """
        The ack cluster node selectors for job pods scheduling. See `node_selectors` below.
        """
        pod_affinity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The job pod affinity.
        """
        pod_anti_affinity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The job pod anti-affinity.
        """
        pre_start_commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The job pod pre start command.
        """
        pvcs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigPvcArgsDict']]]]
        """
        The ack cluster persistent volume claim. See `pvcs` below.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigTolerationArgsDict']]]]
        """
        The ack cluster tolerations. See `tolerations` below.
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeMountArgsDict']]]]
        """
        The ack cluster volume mounts. See `volume_mounts` below.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeArgsDict']]]]
        """
        The ack cluster volumes. See `volumes` below.
        """
elif False:
    ClusterNodeGroupAckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigArgs:
    def __init__(__self__, *,
                 ack_instance_id: pulumi.Input[_builtins.str],
                 limit_cpu: pulumi.Input[_builtins.float],
                 limit_memory: pulumi.Input[_builtins.float],
                 namespace: pulumi.Input[_builtins.str],
                 request_cpu: pulumi.Input[_builtins.float],
                 request_memory: pulumi.Input[_builtins.float],
                 custom_annotations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomAnnotationArgs']]]] = None,
                 custom_labels: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomLabelArgs']]]] = None,
                 node_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 node_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigNodeSelectorArgs']]]] = None,
                 pod_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_anti_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_start_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pvcs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigPvcArgs']]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigTolerationArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeMountArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] ack_instance_id: The ack cluster instance id.
        :param pulumi.Input[_builtins.float] limit_cpu: The job pod resource of limit cpu.
        :param pulumi.Input[_builtins.float] limit_memory: The job pod resource of limit memory.
        :param pulumi.Input[_builtins.str] namespace: The ack cluster namespace.
        :param pulumi.Input[_builtins.float] request_cpu: The job pod resource of request cpu.
        :param pulumi.Input[_builtins.float] request_memory: The job pod resource of request memory.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomAnnotationArgs']]] custom_annotations: The ack cluster custom annotations. See `custom_annotations` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomLabelArgs']]] custom_labels: The ack cluster custom labels. See `custom_labels` below.
        :param pulumi.Input[_builtins.str] node_affinity: The ack cluster node affinity.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigNodeSelectorArgs']]] node_selectors: The ack cluster node selectors for job pods scheduling. See `node_selectors` below.
        :param pulumi.Input[_builtins.str] pod_affinity: The job pod affinity.
        :param pulumi.Input[_builtins.str] pod_anti_affinity: The job pod anti-affinity.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pre_start_commands: The job pod pre start command.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigPvcArgs']]] pvcs: The ack cluster persistent volume claim. See `pvcs` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigTolerationArgs']]] tolerations: The ack cluster tolerations. See `tolerations` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeMountArgs']]] volume_mounts: The ack cluster volume mounts. See `volume_mounts` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeArgs']]] volumes: The ack cluster volumes. See `volumes` below.
        """
        pulumi.set(__self__, "ack_instance_id", ack_instance_id)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)
        if custom_annotations is not None:
            pulumi.set(__self__, "custom_annotations", custom_annotations)
        if custom_labels is not None:
            pulumi.set(__self__, "custom_labels", custom_labels)
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if node_selectors is not None:
            pulumi.set(__self__, "node_selectors", node_selectors)
        if pod_affinity is not None:
            pulumi.set(__self__, "pod_affinity", pod_affinity)
        if pod_anti_affinity is not None:
            pulumi.set(__self__, "pod_anti_affinity", pod_anti_affinity)
        if pre_start_commands is not None:
            pulumi.set(__self__, "pre_start_commands", pre_start_commands)
        if pvcs is not None:
            pulumi.set(__self__, "pvcs", pvcs)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="ackInstanceId")
    def ack_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ack cluster instance id.
        """
        return pulumi.get(self, "ack_instance_id")

    @ack_instance_id.setter
    def ack_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ack_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> pulumi.Input[_builtins.float]:
        """
        The job pod resource of limit cpu.
        """
        return pulumi.get(self, "limit_cpu")

    @limit_cpu.setter
    def limit_cpu(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "limit_cpu", value)

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> pulumi.Input[_builtins.float]:
        """
        The job pod resource of limit memory.
        """
        return pulumi.get(self, "limit_memory")

    @limit_memory.setter
    def limit_memory(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "limit_memory", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The ack cluster namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> pulumi.Input[_builtins.float]:
        """
        The job pod resource of request cpu.
        """
        return pulumi.get(self, "request_cpu")

    @request_cpu.setter
    def request_cpu(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "request_cpu", value)

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> pulumi.Input[_builtins.float]:
        """
        The job pod resource of request memory.
        """
        return pulumi.get(self, "request_memory")

    @request_memory.setter
    def request_memory(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "request_memory", value)

    @_builtins.property
    @pulumi.getter(name="customAnnotations")
    def custom_annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomAnnotationArgs']]]]:
        """
        The ack cluster custom annotations. See `custom_annotations` below.
        """
        return pulumi.get(self, "custom_annotations")

    @custom_annotations.setter
    def custom_annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomAnnotationArgs']]]]):
        pulumi.set(self, "custom_annotations", value)

    @_builtins.property
    @pulumi.getter(name="customLabels")
    def custom_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomLabelArgs']]]]:
        """
        The ack cluster custom labels. See `custom_labels` below.
        """
        return pulumi.get(self, "custom_labels")

    @custom_labels.setter
    def custom_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigCustomLabelArgs']]]]):
        pulumi.set(self, "custom_labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ack cluster node affinity.
        """
        return pulumi.get(self, "node_affinity")

    @node_affinity.setter
    def node_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_affinity", value)

    @_builtins.property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigNodeSelectorArgs']]]]:
        """
        The ack cluster node selectors for job pods scheduling. See `node_selectors` below.
        """
        return pulumi.get(self, "node_selectors")

    @node_selectors.setter
    def node_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigNodeSelectorArgs']]]]):
        pulumi.set(self, "node_selectors", value)

    @_builtins.property
    @pulumi.getter(name="podAffinity")
    def pod_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job pod affinity.
        """
        return pulumi.get(self, "pod_affinity")

    @pod_affinity.setter
    def pod_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_affinity", value)

    @_builtins.property
    @pulumi.getter(name="podAntiAffinity")
    def pod_anti_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job pod anti-affinity.
        """
        return pulumi.get(self, "pod_anti_affinity")

    @pod_anti_affinity.setter
    def pod_anti_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_anti_affinity", value)

    @_builtins.property
    @pulumi.getter(name="preStartCommands")
    def pre_start_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The job pod pre start command.
        """
        return pulumi.get(self, "pre_start_commands")

    @pre_start_commands.setter
    def pre_start_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pre_start_commands", value)

    @_builtins.property
    @pulumi.getter
    def pvcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigPvcArgs']]]]:
        """
        The ack cluster persistent volume claim. See `pvcs` below.
        """
        return pulumi.get(self, "pvcs")

    @pvcs.setter
    def pvcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigPvcArgs']]]]):
        pulumi.set(self, "pvcs", value)

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigTolerationArgs']]]]:
        """
        The ack cluster tolerations. See `tolerations` below.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigTolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeMountArgs']]]]:
        """
        The ack cluster volume mounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeArgs']]]]:
        """
        The ack cluster volumes. See `volumes` below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAckConfigVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class ClusterNodeGroupAckConfigCustomAnnotationArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag value for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAckConfigCustomAnnotationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigCustomAnnotationArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The tag key for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterNodeGroupAckConfigCustomLabelArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag value for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAckConfigCustomLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigCustomLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The tag key for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterNodeGroupAckConfigNodeSelectorArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag value for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAckConfigNodeSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigNodeSelectorArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The tag key for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterNodeGroupAckConfigPvcArgsDict(TypedDict):
        data_disk_size: pulumi.Input[_builtins.int]
        """
        The ack cluster job pod data disk size of persistent volume claim.
        """
        data_disk_storage_class: pulumi.Input[_builtins.str]
        """
        The ack cluster job pod data disk storage class of persistent volume claim.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of ack cluster job pod volume mounts.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path of ack cluster job pod volume mounts.
        """
elif False:
    ClusterNodeGroupAckConfigPvcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigPvcArgs:
    def __init__(__self__, *,
                 data_disk_size: pulumi.Input[_builtins.int],
                 data_disk_storage_class: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] data_disk_size: The ack cluster job pod data disk size of persistent volume claim.
        :param pulumi.Input[_builtins.str] data_disk_storage_class: The ack cluster job pod data disk storage class of persistent volume claim.
        :param pulumi.Input[_builtins.str] name: The name of ack cluster job pod volume mounts.
        :param pulumi.Input[_builtins.str] path: The path of ack cluster job pod volume mounts.
        """
        pulumi.set(__self__, "data_disk_size", data_disk_size)
        pulumi.set(__self__, "data_disk_storage_class", data_disk_storage_class)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> pulumi.Input[_builtins.int]:
        """
        The ack cluster job pod data disk size of persistent volume claim.
        """
        return pulumi.get(self, "data_disk_size")

    @data_disk_size.setter
    def data_disk_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskStorageClass")
    def data_disk_storage_class(self) -> pulumi.Input[_builtins.str]:
        """
        The ack cluster job pod data disk storage class of persistent volume claim.
        """
        return pulumi.get(self, "data_disk_storage_class")

    @data_disk_storage_class.setter
    def data_disk_storage_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_disk_storage_class", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class ClusterNodeGroupAckConfigTolerationArgsDict(TypedDict):
        effect: NotRequired[pulumi.Input[_builtins.str]]
        """
        The effect of ack cluster tolerations.
        """
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        operator: NotRequired[pulumi.Input[_builtins.str]]
        """
        The operator of ack cluster tolerations.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag value for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAckConfigTolerationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigTolerationArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 operator: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] effect: The effect of ack cluster tolerations.
        :param pulumi.Input[_builtins.str] key: The tag key for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] operator: The operator of ack cluster tolerations.
        :param pulumi.Input[_builtins.str] value: The tag value for this scaling rule specific metrics trigger.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effect of ack cluster tolerations.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operator of ack cluster tolerations.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterNodeGroupAckConfigVolumeArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of ack cluster job pod volume mounts.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path of ack cluster job pod volume mounts.
        """
        type: pulumi.Input[_builtins.str]
        """
        The ack cluster job pod volumes type.
        """
elif False:
    ClusterNodeGroupAckConfigVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of ack cluster job pod volume mounts.
        :param pulumi.Input[_builtins.str] path: The path of ack cluster job pod volume mounts.
        :param pulumi.Input[_builtins.str] type: The ack cluster job pod volumes type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The ack cluster job pod volumes type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ClusterNodeGroupAckConfigVolumeMountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of ack cluster job pod volume mounts.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path of ack cluster job pod volume mounts.
        """
elif False:
    ClusterNodeGroupAckConfigVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAckConfigVolumeMountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of ack cluster job pod volume mounts.
        :param pulumi.Input[_builtins.str] path: The path of ack cluster job pod volume mounts.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyArgsDict(TypedDict):
        constraints: NotRequired[pulumi.Input['ClusterNodeGroupAutoScalingPolicyConstraintsArgsDict']]
        """
        The constraints of auto scaling policy. See `constraints` below.
        """
        scaling_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleArgsDict']]]]
        """
        The scaling rules of auto scaling policy. See `scaling_rules` below.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyArgs:
    def __init__(__self__, *,
                 constraints: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyConstraintsArgs']] = None,
                 scaling_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleArgs']]]] = None):
        """
        :param pulumi.Input['ClusterNodeGroupAutoScalingPolicyConstraintsArgs'] constraints: The constraints of auto scaling policy. See `constraints` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleArgs']]] scaling_rules: The scaling rules of auto scaling policy. See `scaling_rules` below.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if scaling_rules is not None:
            pulumi.set(__self__, "scaling_rules", scaling_rules)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyConstraintsArgs']]:
        """
        The constraints of auto scaling policy. See `constraints` below.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyConstraintsArgs']]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter(name="scalingRules")
    def scaling_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleArgs']]]]:
        """
        The scaling rules of auto scaling policy. See `scaling_rules` below.
        """
        return pulumi.get(self, "scaling_rules")

    @scaling_rules.setter
    def scaling_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleArgs']]]]):
        pulumi.set(self, "scaling_rules", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyConstraintsArgsDict(TypedDict):
        max_capacity: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum capacity of constraints for emr node group auto scaling policy.
        """
        min_capacity: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum capacity of constraints for emr node group auto scaling policy.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyConstraintsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyConstraintsArgs:
    def __init__(__self__, *,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] max_capacity: The maximum capacity of constraints for emr node group auto scaling policy.
        :param pulumi.Input[_builtins.int] min_capacity: The minimum capacity of constraints for emr node group auto scaling policy.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum capacity of constraints for emr node group auto scaling policy.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum capacity of constraints for emr node group auto scaling policy.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_capacity", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleArgsDict(TypedDict):
        activity_type: pulumi.Input[_builtins.str]
        """
        The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
        """
        adjustment_value: pulumi.Input[_builtins.int]
        """
        The adjustment value of auto scaling policy. The value should between 1 and 5000.
        """
        rule_name: pulumi.Input[_builtins.str]
        """
        The rule name of auto scaling policy.
        """
        trigger_type: pulumi.Input[_builtins.str]
        """
        The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
        """
        adjustment_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
        """
        metrics_trigger: NotRequired[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsDict']]
        """
        The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
        """
        min_adjustment_value: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum adjustment value of auto scaling policy.
        """
        time_trigger: NotRequired[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsDict']]
        """
        The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleArgs:
    def __init__(__self__, *,
                 activity_type: pulumi.Input[_builtins.str],
                 adjustment_value: pulumi.Input[_builtins.int],
                 rule_name: pulumi.Input[_builtins.str],
                 trigger_type: pulumi.Input[_builtins.str],
                 adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_trigger: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs']] = None,
                 min_adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
                 time_trigger: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] activity_type: The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
        :param pulumi.Input[_builtins.int] adjustment_value: The adjustment value of auto scaling policy. The value should between 1 and 5000.
        :param pulumi.Input[_builtins.str] rule_name: The rule name of auto scaling policy.
        :param pulumi.Input[_builtins.str] trigger_type: The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
        :param pulumi.Input[_builtins.str] adjustment_type: The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
        :param pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs'] metrics_trigger: The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
        :param pulumi.Input[_builtins.int] min_adjustment_value: The minimum adjustment value of auto scaling policy.
        :param pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs'] time_trigger: The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
        """
        pulumi.set(__self__, "activity_type", activity_type)
        pulumi.set(__self__, "adjustment_value", adjustment_value)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "trigger_type", trigger_type)
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if metrics_trigger is not None:
            pulumi.set(__self__, "metrics_trigger", metrics_trigger)
        if min_adjustment_value is not None:
            pulumi.set(__self__, "min_adjustment_value", min_adjustment_value)
        if time_trigger is not None:
            pulumi.set(__self__, "time_trigger", time_trigger)

    @_builtins.property
    @pulumi.getter(name="activityType")
    def activity_type(self) -> pulumi.Input[_builtins.str]:
        """
        The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
        """
        return pulumi.get(self, "activity_type")

    @activity_type.setter
    def activity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "activity_type", value)

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> pulumi.Input[_builtins.int]:
        """
        The adjustment value of auto scaling policy. The value should between 1 and 5000.
        """
        return pulumi.get(self, "adjustment_value")

    @adjustment_value.setter
    def adjustment_value(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "adjustment_value", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The rule name of auto scaling policy.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_type", value)

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adjustment_type", value)

    @_builtins.property
    @pulumi.getter(name="metricsTrigger")
    def metrics_trigger(self) -> Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs']]:
        """
        The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
        """
        return pulumi.get(self, "metrics_trigger")

    @metrics_trigger.setter
    def metrics_trigger(self, value: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs']]):
        pulumi.set(self, "metrics_trigger", value)

    @_builtins.property
    @pulumi.getter(name="minAdjustmentValue")
    def min_adjustment_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum adjustment value of auto scaling policy.
        """
        return pulumi.get(self, "min_adjustment_value")

    @min_adjustment_value.setter
    def min_adjustment_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_adjustment_value", value)

    @_builtins.property
    @pulumi.getter(name="timeTrigger")
    def time_trigger(self) -> Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs']]:
        """
        The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
        """
        return pulumi.get(self, "time_trigger")

    @time_trigger.setter
    def time_trigger(self, value: Optional[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs']]):
        pulumi.set(self, "time_trigger", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsDict(TypedDict):
        evaluation_count: pulumi.Input[_builtins.int]
        """
        The evaluation count for this scaling rule specific metrics trigger.
        """
        time_window: pulumi.Input[_builtins.int]
        """
        The time window for this scaling rule specific metrics trigger.
        """
        condition_logic_operator: NotRequired[pulumi.Input[_builtins.str]]
        """
        The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsDict']]]]
        """
        The conditions for this scaling rule specific metrics trigger. See `conditions` below.
        """
        cool_down_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time of cool down interval for this scaling rule specific metrics trigger.
        """
        time_constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsDict']]]]
        """
        The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs:
    def __init__(__self__, *,
                 evaluation_count: pulumi.Input[_builtins.int],
                 time_window: pulumi.Input[_builtins.int],
                 condition_logic_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs']]]] = None,
                 cool_down_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.int] evaluation_count: The evaluation count for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.int] time_window: The time window for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] condition_logic_operator: The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs']]] conditions: The conditions for this scaling rule specific metrics trigger. See `conditions` below.
        :param pulumi.Input[_builtins.int] cool_down_interval: The time of cool down interval for this scaling rule specific metrics trigger.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs']]] time_constraints: The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
        """
        pulumi.set(__self__, "evaluation_count", evaluation_count)
        pulumi.set(__self__, "time_window", time_window)
        if condition_logic_operator is not None:
            pulumi.set(__self__, "condition_logic_operator", condition_logic_operator)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if cool_down_interval is not None:
            pulumi.set(__self__, "cool_down_interval", cool_down_interval)
        if time_constraints is not None:
            pulumi.set(__self__, "time_constraints", time_constraints)

    @_builtins.property
    @pulumi.getter(name="evaluationCount")
    def evaluation_count(self) -> pulumi.Input[_builtins.int]:
        """
        The evaluation count for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "evaluation_count")

    @evaluation_count.setter
    def evaluation_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "evaluation_count", value)

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input[_builtins.int]:
        """
        The time window for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "time_window", value)

    @_builtins.property
    @pulumi.getter(name="conditionLogicOperator")
    def condition_logic_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
        """
        return pulumi.get(self, "condition_logic_operator")

    @condition_logic_operator.setter
    def condition_logic_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_logic_operator", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs']]]]:
        """
        The conditions for this scaling rule specific metrics trigger. See `conditions` below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="coolDownInterval")
    def cool_down_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time of cool down interval for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "cool_down_interval")

    @cool_down_interval.setter
    def cool_down_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cool_down_interval", value)

    @_builtins.property
    @pulumi.getter(name="timeConstraints")
    def time_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs']]]]:
        """
        The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
        """
        return pulumi.get(self, "time_constraints")

    @time_constraints.setter
    def time_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs']]]]):
        pulumi.set(self, "time_constraints", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsDict(TypedDict):
        comparison_operator: pulumi.Input[_builtins.str]
        """
        The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
        """
        metric_name: pulumi.Input[_builtins.str]
        """
        The metric name for this scaling rule specific metrics trigger.
        """
        statistics: pulumi.Input[_builtins.str]
        """
        The statistics for this scaling rule specific metrics trigger.
        """
        threshold: pulumi.Input[_builtins.float]
        """
        The threshold for this scaling rule specific metrics trigger.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsDict']]]]
        """
        A mapping of tags to assign to the resource.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[_builtins.str],
                 metric_name: pulumi.Input[_builtins.str],
                 statistics: pulumi.Input[_builtins.str],
                 threshold: pulumi.Input[_builtins.float],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] comparison_operator: The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
        :param pulumi.Input[_builtins.str] metric_name: The metric name for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] statistics: The statistics for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.float] threshold: The threshold for this scaling rule specific metrics trigger.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs']]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "threshold", threshold)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[_builtins.str]:
        """
        The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "comparison_operator", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        The metric name for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> pulumi.Input[_builtins.str]:
        """
        The statistics for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "statistics", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[_builtins.float]:
        """
        The threshold for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs']]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag value for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The tag key for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The end time for this scaling rule specific metrics trigger.
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The start time for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] end_time: The end time for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.str] start_time: The start time for this scaling rule specific metrics trigger.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsDict(TypedDict):
        launch_time: pulumi.Input[_builtins.str]
        """
        The launch time for this scaling rule specific time trigger.
        """
        end_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The end time for this scaling rule specific metrics trigger.
        """
        launch_expiration_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
        """
        recurrence_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
        """
        recurrence_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The recurrence value for this scaling rule specific time trigger.
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The start time for this scaling rule specific metrics trigger.
        """
elif False:
    ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs:
    def __init__(__self__, *,
                 launch_time: pulumi.Input[_builtins.str],
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
                 recurrence_type: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence_value: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] launch_time: The launch time for this scaling rule specific time trigger.
        :param pulumi.Input[_builtins.str] end_time: The end time for this scaling rule specific metrics trigger.
        :param pulumi.Input[_builtins.int] launch_expiration_time: The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
        :param pulumi.Input[_builtins.str] recurrence_type: The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
        :param pulumi.Input[_builtins.str] recurrence_value: The recurrence value for this scaling rule specific time trigger.
        :param pulumi.Input[_builtins.str] start_time: The start time for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if launch_expiration_time is not None:
            pulumi.set(__self__, "launch_expiration_time", launch_expiration_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> pulumi.Input[_builtins.str]:
        """
        The launch time for this scaling rule specific time trigger.
        """
        return pulumi.get(self, "launch_time")

    @launch_time.setter
    def launch_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "launch_time", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="launchExpirationTime")
    def launch_expiration_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
        """
        return pulumi.get(self, "launch_expiration_time")

    @launch_expiration_time.setter
    def launch_expiration_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "launch_expiration_time", value)

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recurrence_type", value)

    @_builtins.property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurrence value for this scaling rule specific time trigger.
        """
        return pulumi.get(self, "recurrence_value")

    @recurrence_value.setter
    def recurrence_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recurrence_value", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterNodeGroupCostOptimizedConfigArgsDict(TypedDict):
        on_demand_base_capacity: pulumi.Input[_builtins.int]
        """
        The cost optimized configuration which on demand based capacity.
        """
        on_demand_percentage_above_base_capacity: pulumi.Input[_builtins.int]
        """
        The cost optimized configuration which on demand percentage above based capacity.
        """
        spot_instance_pools: pulumi.Input[_builtins.int]
        """
        The cost optimized configuration with spot instance pools.
        """
elif False:
    ClusterNodeGroupCostOptimizedConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupCostOptimizedConfigArgs:
    def __init__(__self__, *,
                 on_demand_base_capacity: pulumi.Input[_builtins.int],
                 on_demand_percentage_above_base_capacity: pulumi.Input[_builtins.int],
                 spot_instance_pools: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] on_demand_base_capacity: The cost optimized configuration which on demand based capacity.
        :param pulumi.Input[_builtins.int] on_demand_percentage_above_base_capacity: The cost optimized configuration which on demand percentage above based capacity.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The cost optimized configuration with spot instance pools.
        """
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The cost optimized configuration which on demand based capacity.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The cost optimized configuration which on demand percentage above based capacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> pulumi.Input[_builtins.int]:
        """
        The cost optimized configuration with spot instance pools.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "spot_instance_pools", value)


if not MYPY:
    class ClusterNodeGroupDataDiskArgsDict(TypedDict):
        category: pulumi.Input[_builtins.str]
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        size: pulumi.Input[_builtins.int]
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The count of a data disk.
        """
        performance_level: NotRequired[pulumi.Input[_builtins.str]]
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
elif False:
    ClusterNodeGroupDataDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupDataDiskArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 count: Optional[pulumi.Input[_builtins.int]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] category: The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        :param pulumi.Input[_builtins.int] size: The size of a data disk, at least 40. Unit: GiB.
        :param pulumi.Input[_builtins.int] count: The count of a data disk.
        :param pulumi.Input[_builtins.str] performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)


if not MYPY:
    class ClusterNodeGroupPrivatePoolOptionsArgsDict(TypedDict):
        match_criteria: NotRequired[pulumi.Input[_builtins.str]]
        """
        The node group specific private pool resource match criteria. Valid values: `Open`, `Target`, `None`.
        """
        private_pool_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The node group specific private pool resource ids.
        """
elif False:
    ClusterNodeGroupPrivatePoolOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupPrivatePoolOptionsArgs:
    def __init__(__self__, *,
                 match_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] match_criteria: The node group specific private pool resource match criteria. Valid values: `Open`, `Target`, `None`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_pool_ids: The node group specific private pool resource ids.
        """
        if match_criteria is not None:
            pulumi.set(__self__, "match_criteria", match_criteria)
        if private_pool_ids is not None:
            pulumi.set(__self__, "private_pool_ids", private_pool_ids)

    @_builtins.property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node group specific private pool resource match criteria. Valid values: `Open`, `Target`, `None`.
        """
        return pulumi.get(self, "match_criteria")

    @match_criteria.setter
    def match_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_criteria", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolIds")
    def private_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The node group specific private pool resource ids.
        """
        return pulumi.get(self, "private_pool_ids")

    @private_pool_ids.setter
    def private_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_pool_ids", value)


if not MYPY:
    class ClusterNodeGroupSpotBidPriceArgsDict(TypedDict):
        bid_price: pulumi.Input[_builtins.int]
        """
        The spot bid price of a PayAsYouGo instance.
        """
        instance_type: pulumi.Input[_builtins.str]
        """
        Host Ecs instance type.
        """
elif False:
    ClusterNodeGroupSpotBidPriceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupSpotBidPriceArgs:
    def __init__(__self__, *,
                 bid_price: pulumi.Input[_builtins.int],
                 instance_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] bid_price: The spot bid price of a PayAsYouGo instance.
        :param pulumi.Input[_builtins.str] instance_type: Host Ecs instance type.
        """
        pulumi.set(__self__, "bid_price", bid_price)
        pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> pulumi.Input[_builtins.int]:
        """
        The spot bid price of a PayAsYouGo instance.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bid_price", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Host Ecs instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)


if not MYPY:
    class ClusterNodeGroupSubscriptionConfigArgsDict(TypedDict):
        payment_duration: pulumi.Input[_builtins.int]
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        payment_duration_unit: pulumi.Input[_builtins.str]
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        auto_pay_order: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        auto_renew_duration: NotRequired[pulumi.Input[_builtins.int]]
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        auto_renew_duration_unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
elif False:
    ClusterNodeGroupSubscriptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupSubscriptionConfigArgs:
    def __init__(__self__, *,
                 payment_duration: pulumi.Input[_builtins.int],
                 payment_duration_unit: pulumi.Input[_builtins.str],
                 auto_pay_order: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_duration_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[_builtins.str] payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param pulumi.Input[_builtins.bool] auto_pay_order: Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param pulumi.Input[_builtins.int] auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[_builtins.str] auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_pay_order is not None:
            pulumi.set(__self__, "auto_pay_order", auto_pay_order)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Input[_builtins.int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Input[_builtins.str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="autoPayOrder")
    def auto_pay_order(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        return pulumi.get(self, "auto_pay_order")

    @auto_pay_order.setter
    def auto_pay_order(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay_order", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")

    @auto_renew_duration_unit.setter
    def auto_renew_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_duration_unit", value)


if not MYPY:
    class ClusterNodeGroupSystemDiskArgsDict(TypedDict):
        category: pulumi.Input[_builtins.str]
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        size: pulumi.Input[_builtins.int]
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The count of a data disk.
        """
        performance_level: NotRequired[pulumi.Input[_builtins.str]]
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
elif False:
    ClusterNodeGroupSystemDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupSystemDiskArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 count: Optional[pulumi.Input[_builtins.int]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] category: The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        :param pulumi.Input[_builtins.int] size: The size of a data disk, at least 40. Unit: GiB.
        :param pulumi.Input[_builtins.int] count: The count of a data disk.
        :param pulumi.Input[_builtins.str] performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)


if not MYPY:
    class ClusterSubscriptionConfigArgsDict(TypedDict):
        payment_duration: pulumi.Input[_builtins.int]
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        payment_duration_unit: pulumi.Input[_builtins.str]
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        auto_pay_order: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        auto_renew: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        auto_renew_duration: NotRequired[pulumi.Input[_builtins.int]]
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        auto_renew_duration_unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
elif False:
    ClusterSubscriptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSubscriptionConfigArgs:
    def __init__(__self__, *,
                 payment_duration: pulumi.Input[_builtins.int],
                 payment_duration_unit: pulumi.Input[_builtins.str],
                 auto_pay_order: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew_duration_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[_builtins.str] payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param pulumi.Input[_builtins.bool] auto_pay_order: Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param pulumi.Input[_builtins.int] auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[_builtins.str] auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_pay_order is not None:
            pulumi.set(__self__, "auto_pay_order", auto_pay_order)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Input[_builtins.int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Input[_builtins.str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="autoPayOrder")
    def auto_pay_order(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        return pulumi.get(self, "auto_pay_order")

    @auto_pay_order.setter
    def auto_pay_order(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay_order", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")

    @auto_renew_duration_unit.setter
    def auto_renew_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_duration_unit", value)


