# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterApplicationConfig',
    'ClusterBootstrapScript',
    'ClusterBootstrapScriptNodeSelector',
    'ClusterNodeAttribute',
    'ClusterNodeGroup',
    'ClusterNodeGroupAckConfig',
    'ClusterNodeGroupAckConfigCustomAnnotation',
    'ClusterNodeGroupAckConfigCustomLabel',
    'ClusterNodeGroupAckConfigNodeSelector',
    'ClusterNodeGroupAckConfigPvc',
    'ClusterNodeGroupAckConfigToleration',
    'ClusterNodeGroupAckConfigVolume',
    'ClusterNodeGroupAckConfigVolumeMount',
    'ClusterNodeGroupAutoScalingPolicy',
    'ClusterNodeGroupAutoScalingPolicyConstraints',
    'ClusterNodeGroupAutoScalingPolicyScalingRule',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint',
    'ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger',
    'ClusterNodeGroupCostOptimizedConfig',
    'ClusterNodeGroupDataDisk',
    'ClusterNodeGroupPrivatePoolOptions',
    'ClusterNodeGroupSpotBidPrice',
    'ClusterNodeGroupSubscriptionConfig',
    'ClusterNodeGroupSystemDisk',
    'ClusterSubscriptionConfig',
    'GetClusterInstancesInstanceResult',
    'GetClustersClusterResult',
    'GetClustersClusterTagResult',
]

@pulumi.output_type
class ClusterApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationName":
            suggest = "application_name"
        elif key == "configFileName":
            suggest = "config_file_name"
        elif key == "configItemKey":
            suggest = "config_item_key"
        elif key == "configItemValue":
            suggest = "config_item_value"
        elif key == "configDescription":
            suggest = "config_description"
        elif key == "configScope":
            suggest = "config_scope"
        elif key == "nodeGroupId":
            suggest = "node_group_id"
        elif key == "nodeGroupName":
            suggest = "node_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_name: _builtins.str,
                 config_file_name: _builtins.str,
                 config_item_key: _builtins.str,
                 config_item_value: _builtins.str,
                 config_description: Optional[_builtins.str] = None,
                 config_scope: Optional[_builtins.str] = None,
                 node_group_id: Optional[_builtins.str] = None,
                 node_group_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str application_name: The application name of EMR cluster which has installed.
        :param _builtins.str config_file_name: The configuration file name of application installed.
        :param _builtins.str config_item_key: The configuration item key of application installed.
        :param _builtins.str config_item_value: The configuration item value of application installed.
        :param _builtins.str config_description: The configuration description of application installed.
        :param _builtins.str config_scope: The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        :param _builtins.str node_group_id: The configuration effected which node group id of emr cluster.
        :param _builtins.str node_group_name: The configuration effected which node group name of emr cluster.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "config_item_key", config_item_key)
        pulumi.set(__self__, "config_item_value", config_item_value)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_scope is not None:
            pulumi.set(__self__, "config_scope", config_scope)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        The application name of EMR cluster which has installed.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> _builtins.str:
        """
        The configuration file name of application installed.
        """
        return pulumi.get(self, "config_file_name")

    @_builtins.property
    @pulumi.getter(name="configItemKey")
    def config_item_key(self) -> _builtins.str:
        """
        The configuration item key of application installed.
        """
        return pulumi.get(self, "config_item_key")

    @_builtins.property
    @pulumi.getter(name="configItemValue")
    def config_item_value(self) -> _builtins.str:
        """
        The configuration item value of application installed.
        """
        return pulumi.get(self, "config_item_value")

    @_builtins.property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[_builtins.str]:
        """
        The configuration description of application installed.
        """
        return pulumi.get(self, "config_description")

    @_builtins.property
    @pulumi.getter(name="configScope")
    def config_scope(self) -> Optional[_builtins.str]:
        """
        The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        """
        return pulumi.get(self, "config_scope")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[_builtins.str]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[_builtins.str]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")


@pulumi.output_type
class ClusterBootstrapScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionFailStrategy":
            suggest = "execution_fail_strategy"
        elif key == "executionMoment":
            suggest = "execution_moment"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "scriptArgs":
            suggest = "script_args"
        elif key == "scriptName":
            suggest = "script_name"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_fail_strategy: _builtins.str,
                 execution_moment: _builtins.str,
                 node_selector: 'outputs.ClusterBootstrapScriptNodeSelector',
                 script_args: _builtins.str,
                 script_name: _builtins.str,
                 script_path: _builtins.str,
                 priority: Optional[_builtins.int] = None):
        """
        :param _builtins.str execution_fail_strategy: The bootstrap scripts execution fail strategy, ’FAILED_BLOCK’ or ‘FAILED_CONTINUE’ .
        :param _builtins.str execution_moment: The bootstrap scripts execution moment, ’BEFORE_INSTALL’, ‘AFTER_STARTED’ or ‘BEFORE_START’. The execution moment of BEFORE_START is available since v1.243.0.
        :param 'ClusterBootstrapScriptNodeSelectorArgs' node_selector: The bootstrap scripts execution target. See `node_selector` below.
        :param _builtins.str script_args: The bootstrap script args, e.g. "--a=b".
        :param _builtins.str script_name: The bootstrap script name.
        :param _builtins.str script_path: The bootstrap script path, e.g. "oss://bucket/path".
        :param _builtins.int priority: The bootstrap scripts priority.
        """
        pulumi.set(__self__, "execution_fail_strategy", execution_fail_strategy)
        pulumi.set(__self__, "execution_moment", execution_moment)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "script_args", script_args)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "script_path", script_path)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="executionFailStrategy")
    def execution_fail_strategy(self) -> _builtins.str:
        """
        The bootstrap scripts execution fail strategy, ’FAILED_BLOCK’ or ‘FAILED_CONTINUE’ .
        """
        return pulumi.get(self, "execution_fail_strategy")

    @_builtins.property
    @pulumi.getter(name="executionMoment")
    def execution_moment(self) -> _builtins.str:
        """
        The bootstrap scripts execution moment, ’BEFORE_INSTALL’, ‘AFTER_STARTED’ or ‘BEFORE_START’. The execution moment of BEFORE_START is available since v1.243.0.
        """
        return pulumi.get(self, "execution_moment")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> 'outputs.ClusterBootstrapScriptNodeSelector':
        """
        The bootstrap scripts execution target. See `node_selector` below.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="scriptArgs")
    def script_args(self) -> _builtins.str:
        """
        The bootstrap script args, e.g. "--a=b".
        """
        return pulumi.get(self, "script_args")

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> _builtins.str:
        """
        The bootstrap script name.
        """
        return pulumi.get(self, "script_name")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> _builtins.str:
        """
        The bootstrap script path, e.g. "oss://bucket/path".
        """
        return pulumi.get(self, "script_path")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'priority' has been deprecated from provider version 1.227.0.""")
    def priority(self) -> Optional[_builtins.int]:
        """
        The bootstrap scripts priority.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ClusterBootstrapScriptNodeSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelectType":
            suggest = "node_select_type"
        elif key == "nodeGroupId":
            suggest = "node_group_id"
        elif key == "nodeGroupIds":
            suggest = "node_group_ids"
        elif key == "nodeGroupName":
            suggest = "node_group_name"
        elif key == "nodeGroupNames":
            suggest = "node_group_names"
        elif key == "nodeGroupTypes":
            suggest = "node_group_types"
        elif key == "nodeNames":
            suggest = "node_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapScriptNodeSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapScriptNodeSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapScriptNodeSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_select_type: _builtins.str,
                 node_group_id: Optional[_builtins.str] = None,
                 node_group_ids: Optional[Sequence[_builtins.str]] = None,
                 node_group_name: Optional[_builtins.str] = None,
                 node_group_names: Optional[Sequence[_builtins.str]] = None,
                 node_group_types: Optional[Sequence[_builtins.str]] = None,
                 node_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str node_select_type: The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        :param Sequence[_builtins.str] node_group_ids: The bootstrap scripts execution target node group ids.
        :param Sequence[_builtins.str] node_group_names: The bootstrap scripts execution target node group names.
        :param Sequence[_builtins.str] node_group_types: The bootstrap scripts execution target node group types.
        :param Sequence[_builtins.str] node_names: The bootstrap scripts execution target node names.
        """
        pulumi.set(__self__, "node_select_type", node_select_type)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_ids is not None:
            pulumi.set(__self__, "node_group_ids", node_group_ids)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_names is not None:
            pulumi.set(__self__, "node_group_names", node_group_names)
        if node_group_types is not None:
            pulumi.set(__self__, "node_group_types", node_group_types)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)

    @_builtins.property
    @pulumi.getter(name="nodeSelectType")
    def node_select_type(self) -> _builtins.str:
        """
        The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        """
        return pulumi.get(self, "node_select_type")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    @_utilities.deprecated("""Field 'node_group_id' has been deprecated from provider version 1.227.0. New field 'node_group_ids' replaces it.""")
    def node_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeGroupIds")
    def node_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The bootstrap scripts execution target node group ids.
        """
        return pulumi.get(self, "node_group_ids")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    @_utilities.deprecated("""Field 'node_group_name' has been deprecated from provider version 1.227.0. New field 'node_group_names' replaces it.""")
    def node_group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_group_name")

    @_builtins.property
    @pulumi.getter(name="nodeGroupNames")
    def node_group_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The bootstrap scripts execution target node group names.
        """
        return pulumi.get(self, "node_group_names")

    @_builtins.property
    @pulumi.getter(name="nodeGroupTypes")
    def node_group_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The bootstrap scripts execution target node group types.
        """
        return pulumi.get(self, "node_group_types")

    @_builtins.property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The bootstrap scripts execution target node names.
        """
        return pulumi.get(self, "node_names")


@pulumi.output_type
class ClusterNodeAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPairName":
            suggest = "key_pair_name"
        elif key == "ramRole":
            suggest = "ram_role"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "dataDiskEncrypted":
            suggest = "data_disk_encrypted"
        elif key == "dataDiskKmsKeyId":
            suggest = "data_disk_kms_key_id"
        elif key == "systemDiskEncrypted":
            suggest = "system_disk_encrypted"
        elif key == "systemDiskKmsKeyId":
            suggest = "system_disk_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_pair_name: _builtins.str,
                 ram_role: _builtins.str,
                 security_group_id: _builtins.str,
                 vpc_id: _builtins.str,
                 zone_id: _builtins.str,
                 data_disk_encrypted: Optional[_builtins.bool] = None,
                 data_disk_kms_key_id: Optional[_builtins.str] = None,
                 system_disk_encrypted: Optional[_builtins.bool] = None,
                 system_disk_kms_key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_pair_name: The name of the key pair.
        :param _builtins.str ram_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param _builtins.str security_group_id: Security Group ID for Cluster.
        :param _builtins.str vpc_id: Used to retrieve instances belong to specified VPC.
        :param _builtins.str zone_id: Zone ID, e.g. cn-hangzhou-i
        :param _builtins.bool data_disk_encrypted: Whether to enable data disk encryption.
        :param _builtins.str data_disk_kms_key_id: The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        :param _builtins.bool system_disk_encrypted: Whether to enable system disk encryption.
        :param _builtins.str system_disk_kms_key_id: The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "ram_role", ram_role)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if data_disk_encrypted is not None:
            pulumi.set(__self__, "data_disk_encrypted", data_disk_encrypted)
        if data_disk_kms_key_id is not None:
            pulumi.set(__self__, "data_disk_kms_key_id", data_disk_kms_key_id)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> _builtins.str:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="ramRole")
    def ram_role(self) -> _builtins.str:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "ram_role")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        Security Group ID for Cluster.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Zone ID, e.g. cn-hangzhou-i
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="dataDiskEncrypted")
    def data_disk_encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether to enable data disk encryption.
        """
        return pulumi.get(self, "data_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="dataDiskKmsKeyId")
    def data_disk_kms_key_id(self) -> Optional[_builtins.str]:
        """
        The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        return pulumi.get(self, "data_disk_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether to enable system disk encryption.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[_builtins.str]:
        """
        The kms key id used to encrypt the system disk. It takes effect when system_disk_encrypted is true.
        """
        return pulumi.get(self, "system_disk_kms_key_id")


@pulumi.output_type
class ClusterNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "instanceTypes":
            suggest = "instance_types"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeGroupName":
            suggest = "node_group_name"
        elif key == "nodeGroupType":
            suggest = "node_group_type"
        elif key == "systemDisk":
            suggest = "system_disk"
        elif key == "ackConfig":
            suggest = "ack_config"
        elif key == "additionalSecurityGroupIds":
            suggest = "additional_security_group_ids"
        elif key == "autoScalingPolicy":
            suggest = "auto_scaling_policy"
        elif key == "costOptimizedConfig":
            suggest = "cost_optimized_config"
        elif key == "deploymentSetStrategy":
            suggest = "deployment_set_strategy"
        elif key == "gracefulShutdown":
            suggest = "graceful_shutdown"
        elif key == "nodeResizeStrategy":
            suggest = "node_resize_strategy"
        elif key == "paymentType":
            suggest = "payment_type"
        elif key == "privatePoolOptions":
            suggest = "private_pool_options"
        elif key == "spotBidPrices":
            suggest = "spot_bid_prices"
        elif key == "spotInstanceRemedy":
            suggest = "spot_instance_remedy"
        elif key == "spotStrategy":
            suggest = "spot_strategy"
        elif key == "subscriptionConfig":
            suggest = "subscription_config"
        elif key == "vswitchIds":
            suggest = "vswitch_ids"
        elif key == "withPublicIp":
            suggest = "with_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Sequence['outputs.ClusterNodeGroupDataDisk'],
                 instance_types: Sequence[_builtins.str],
                 node_count: _builtins.int,
                 node_group_name: _builtins.str,
                 node_group_type: _builtins.str,
                 system_disk: 'outputs.ClusterNodeGroupSystemDisk',
                 ack_config: Optional['outputs.ClusterNodeGroupAckConfig'] = None,
                 additional_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 auto_scaling_policy: Optional['outputs.ClusterNodeGroupAutoScalingPolicy'] = None,
                 cost_optimized_config: Optional['outputs.ClusterNodeGroupCostOptimizedConfig'] = None,
                 deployment_set_strategy: Optional[_builtins.str] = None,
                 graceful_shutdown: Optional[_builtins.bool] = None,
                 node_resize_strategy: Optional[_builtins.str] = None,
                 payment_type: Optional[_builtins.str] = None,
                 private_pool_options: Optional['outputs.ClusterNodeGroupPrivatePoolOptions'] = None,
                 spot_bid_prices: Optional[Sequence['outputs.ClusterNodeGroupSpotBidPrice']] = None,
                 spot_instance_remedy: Optional[_builtins.bool] = None,
                 spot_strategy: Optional[_builtins.str] = None,
                 subscription_config: Optional['outputs.ClusterNodeGroupSubscriptionConfig'] = None,
                 vswitch_ids: Optional[Sequence[_builtins.str]] = None,
                 with_public_ip: Optional[_builtins.bool] = None):
        """
        :param Sequence['ClusterNodeGroupDataDiskArgs'] data_disks: Host Ecs data disks information in this node group. See `data_disks` below.
        :param Sequence[_builtins.str] instance_types: Host Ecs instance types. **NOTE:** From version 1.236.0, `instance_types` can be modified.
        :param _builtins.int node_count: Host Ecs number in this node group.
        :param _builtins.str node_group_name: The node group name of emr cluster.
        :param _builtins.str node_group_type: The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0. Node group type of MASTER-EXTEND is available since v1.243.0.
        :param 'ClusterNodeGroupSystemDiskArgs' system_disk: Host Ecs system disk information in this node group. See `system_disk` below.
        :param 'ClusterNodeGroupAckConfigArgs' ack_config: The node group of ack configuration for emr cluster to deploying on kubernetes. See `ack_config` below.
        :param Sequence[_builtins.str] additional_security_group_ids: Additional security Group IDS for Cluster, you can also specify this key for each node group. **NOTE:** From version 1.236.0, `additional_security_group_ids` can be modified.
        :param 'ClusterNodeGroupAutoScalingPolicyArgs' auto_scaling_policy: The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
        :param 'ClusterNodeGroupCostOptimizedConfigArgs' cost_optimized_config: The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below. **NOTE:** From version 1.236.0, `cost_optimized_config` can be modified.
        :param _builtins.str deployment_set_strategy: Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP. **NOTE:** From version 1.236.0, `deployment_set_strategy` can be modified.
        :param _builtins.bool graceful_shutdown: Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        :param _builtins.str node_resize_strategy: Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
        :param _builtins.str payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param 'ClusterNodeGroupPrivatePoolOptionsArgs' private_pool_options: The node group specific private pool resources. See `private_pool_options` below.
        :param Sequence['ClusterNodeGroupSpotBidPriceArgs'] spot_bid_prices: The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        :param _builtins.bool spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param _builtins.str spot_strategy: The spot strategy configuration of emr cluster. Valid values: `NoSpot`, `SpotWithPriceLimit`, `SpotAsPriceGo`.
        :param 'ClusterNodeGroupSubscriptionConfigArgs' subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param Sequence[_builtins.str] vswitch_ids: Global vSwitch ids, you can also specify it in node group. **NOTE:** From version 1.236.0, `vswitch_ids` can be modified.
        :param _builtins.bool with_public_ip: Whether the node has a public IP address enabled. **NOTE:** From version 1.236.0, `with_public_ip` can be modified.
        """
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_group_name", node_group_name)
        pulumi.set(__self__, "node_group_type", node_group_type)
        pulumi.set(__self__, "system_disk", system_disk)
        if ack_config is not None:
            pulumi.set(__self__, "ack_config", ack_config)
        if additional_security_group_ids is not None:
            pulumi.set(__self__, "additional_security_group_ids", additional_security_group_ids)
        if auto_scaling_policy is not None:
            pulumi.set(__self__, "auto_scaling_policy", auto_scaling_policy)
        if cost_optimized_config is not None:
            pulumi.set(__self__, "cost_optimized_config", cost_optimized_config)
        if deployment_set_strategy is not None:
            pulumi.set(__self__, "deployment_set_strategy", deployment_set_strategy)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if node_resize_strategy is not None:
            pulumi.set(__self__, "node_resize_strategy", node_resize_strategy)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if private_pool_options is not None:
            pulumi.set(__self__, "private_pool_options", private_pool_options)
        if spot_bid_prices is not None:
            pulumi.set(__self__, "spot_bid_prices", spot_bid_prices)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if with_public_ip is not None:
            pulumi.set(__self__, "with_public_ip", with_public_ip)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.ClusterNodeGroupDataDisk']:
        """
        Host Ecs data disks information in this node group. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[_builtins.str]:
        """
        Host Ecs instance types. **NOTE:** From version 1.236.0, `instance_types` can be modified.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        Host Ecs number in this node group.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> _builtins.str:
        """
        The node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @_builtins.property
    @pulumi.getter(name="nodeGroupType")
    def node_group_type(self) -> _builtins.str:
        """
        The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0. Node group type of MASTER-EXTEND is available since v1.243.0.
        """
        return pulumi.get(self, "node_group_type")

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> 'outputs.ClusterNodeGroupSystemDisk':
        """
        Host Ecs system disk information in this node group. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @_builtins.property
    @pulumi.getter(name="ackConfig")
    def ack_config(self) -> Optional['outputs.ClusterNodeGroupAckConfig']:
        """
        The node group of ack configuration for emr cluster to deploying on kubernetes. See `ack_config` below.
        """
        return pulumi.get(self, "ack_config")

    @_builtins.property
    @pulumi.getter(name="additionalSecurityGroupIds")
    def additional_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Additional security Group IDS for Cluster, you can also specify this key for each node group. **NOTE:** From version 1.236.0, `additional_security_group_ids` can be modified.
        """
        return pulumi.get(self, "additional_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="autoScalingPolicy")
    def auto_scaling_policy(self) -> Optional['outputs.ClusterNodeGroupAutoScalingPolicy']:
        """
        The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
        """
        return pulumi.get(self, "auto_scaling_policy")

    @_builtins.property
    @pulumi.getter(name="costOptimizedConfig")
    def cost_optimized_config(self) -> Optional['outputs.ClusterNodeGroupCostOptimizedConfig']:
        """
        The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below. **NOTE:** From version 1.236.0, `cost_optimized_config` can be modified.
        """
        return pulumi.get(self, "cost_optimized_config")

    @_builtins.property
    @pulumi.getter(name="deploymentSetStrategy")
    def deployment_set_strategy(self) -> Optional[_builtins.str]:
        """
        Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP. **NOTE:** From version 1.236.0, `deployment_set_strategy` can be modified.
        """
        return pulumi.get(self, "deployment_set_strategy")

    @_builtins.property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[_builtins.bool]:
        """
        Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        """
        return pulumi.get(self, "graceful_shutdown")

    @_builtins.property
    @pulumi.getter(name="nodeResizeStrategy")
    def node_resize_strategy(self) -> Optional[_builtins.str]:
        """
        Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
        """
        return pulumi.get(self, "node_resize_strategy")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[_builtins.str]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> Optional['outputs.ClusterNodeGroupPrivatePoolOptions']:
        """
        The node group specific private pool resources. See `private_pool_options` below.
        """
        return pulumi.get(self, "private_pool_options")

    @_builtins.property
    @pulumi.getter(name="spotBidPrices")
    def spot_bid_prices(self) -> Optional[Sequence['outputs.ClusterNodeGroupSpotBidPrice']]:
        """
        The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        """
        return pulumi.get(self, "spot_bid_prices")

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[_builtins.bool]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[_builtins.str]:
        """
        The spot strategy configuration of emr cluster. Valid values: `NoSpot`, `SpotWithPriceLimit`, `SpotAsPriceGo`.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional['outputs.ClusterNodeGroupSubscriptionConfig']:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Global vSwitch ids, you can also specify it in node group. **NOTE:** From version 1.236.0, `vswitch_ids` can be modified.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="withPublicIp")
    def with_public_ip(self) -> Optional[_builtins.bool]:
        """
        Whether the node has a public IP address enabled. **NOTE:** From version 1.236.0, `with_public_ip` can be modified.
        """
        return pulumi.get(self, "with_public_ip")


@pulumi.output_type
class ClusterNodeGroupAckConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ackInstanceId":
            suggest = "ack_instance_id"
        elif key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"
        elif key == "customAnnotations":
            suggest = "custom_annotations"
        elif key == "customLabels":
            suggest = "custom_labels"
        elif key == "nodeAffinity":
            suggest = "node_affinity"
        elif key == "nodeSelectors":
            suggest = "node_selectors"
        elif key == "podAffinity":
            suggest = "pod_affinity"
        elif key == "podAntiAffinity":
            suggest = "pod_anti_affinity"
        elif key == "preStartCommands":
            suggest = "pre_start_commands"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ack_instance_id: _builtins.str,
                 limit_cpu: _builtins.float,
                 limit_memory: _builtins.float,
                 namespace: _builtins.str,
                 request_cpu: _builtins.float,
                 request_memory: _builtins.float,
                 custom_annotations: Optional[Sequence['outputs.ClusterNodeGroupAckConfigCustomAnnotation']] = None,
                 custom_labels: Optional[Sequence['outputs.ClusterNodeGroupAckConfigCustomLabel']] = None,
                 node_affinity: Optional[_builtins.str] = None,
                 node_selectors: Optional[Sequence['outputs.ClusterNodeGroupAckConfigNodeSelector']] = None,
                 pod_affinity: Optional[_builtins.str] = None,
                 pod_anti_affinity: Optional[_builtins.str] = None,
                 pre_start_commands: Optional[Sequence[_builtins.str]] = None,
                 pvcs: Optional[Sequence['outputs.ClusterNodeGroupAckConfigPvc']] = None,
                 tolerations: Optional[Sequence['outputs.ClusterNodeGroupAckConfigToleration']] = None,
                 volume_mounts: Optional[Sequence['outputs.ClusterNodeGroupAckConfigVolumeMount']] = None,
                 volumes: Optional[Sequence['outputs.ClusterNodeGroupAckConfigVolume']] = None):
        """
        :param _builtins.str ack_instance_id: The ack cluster instance id.
        :param _builtins.float limit_cpu: The job pod resource of limit cpu.
        :param _builtins.float limit_memory: The job pod resource of limit memory.
        :param _builtins.str namespace: The ack cluster namespace.
        :param _builtins.float request_cpu: The job pod resource of request cpu.
        :param _builtins.float request_memory: The job pod resource of request memory.
        :param Sequence['ClusterNodeGroupAckConfigCustomAnnotationArgs'] custom_annotations: The ack cluster custom annotations. See `custom_annotations` below.
        :param Sequence['ClusterNodeGroupAckConfigCustomLabelArgs'] custom_labels: The ack cluster custom labels. See `custom_labels` below.
        :param _builtins.str node_affinity: The ack cluster node affinity.
        :param Sequence['ClusterNodeGroupAckConfigNodeSelectorArgs'] node_selectors: The ack cluster node selectors for job pods scheduling. See `node_selectors` below.
        :param _builtins.str pod_affinity: The job pod affinity.
        :param _builtins.str pod_anti_affinity: The job pod anti-affinity.
        :param Sequence[_builtins.str] pre_start_commands: The job pod pre start command.
        :param Sequence['ClusterNodeGroupAckConfigPvcArgs'] pvcs: The ack cluster persistent volume claim. See `pvcs` below.
        :param Sequence['ClusterNodeGroupAckConfigTolerationArgs'] tolerations: The ack cluster tolerations. See `tolerations` below.
        :param Sequence['ClusterNodeGroupAckConfigVolumeMountArgs'] volume_mounts: The ack cluster volume mounts. See `volume_mounts` below.
        :param Sequence['ClusterNodeGroupAckConfigVolumeArgs'] volumes: The ack cluster volumes. See `volumes` below.
        """
        pulumi.set(__self__, "ack_instance_id", ack_instance_id)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)
        if custom_annotations is not None:
            pulumi.set(__self__, "custom_annotations", custom_annotations)
        if custom_labels is not None:
            pulumi.set(__self__, "custom_labels", custom_labels)
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if node_selectors is not None:
            pulumi.set(__self__, "node_selectors", node_selectors)
        if pod_affinity is not None:
            pulumi.set(__self__, "pod_affinity", pod_affinity)
        if pod_anti_affinity is not None:
            pulumi.set(__self__, "pod_anti_affinity", pod_anti_affinity)
        if pre_start_commands is not None:
            pulumi.set(__self__, "pre_start_commands", pre_start_commands)
        if pvcs is not None:
            pulumi.set(__self__, "pvcs", pvcs)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="ackInstanceId")
    def ack_instance_id(self) -> _builtins.str:
        """
        The ack cluster instance id.
        """
        return pulumi.get(self, "ack_instance_id")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> _builtins.float:
        """
        The job pod resource of limit cpu.
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> _builtins.float:
        """
        The job pod resource of limit memory.
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The ack cluster namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> _builtins.float:
        """
        The job pod resource of request cpu.
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> _builtins.float:
        """
        The job pod resource of request memory.
        """
        return pulumi.get(self, "request_memory")

    @_builtins.property
    @pulumi.getter(name="customAnnotations")
    def custom_annotations(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigCustomAnnotation']]:
        """
        The ack cluster custom annotations. See `custom_annotations` below.
        """
        return pulumi.get(self, "custom_annotations")

    @_builtins.property
    @pulumi.getter(name="customLabels")
    def custom_labels(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigCustomLabel']]:
        """
        The ack cluster custom labels. See `custom_labels` below.
        """
        return pulumi.get(self, "custom_labels")

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional[_builtins.str]:
        """
        The ack cluster node affinity.
        """
        return pulumi.get(self, "node_affinity")

    @_builtins.property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigNodeSelector']]:
        """
        The ack cluster node selectors for job pods scheduling. See `node_selectors` below.
        """
        return pulumi.get(self, "node_selectors")

    @_builtins.property
    @pulumi.getter(name="podAffinity")
    def pod_affinity(self) -> Optional[_builtins.str]:
        """
        The job pod affinity.
        """
        return pulumi.get(self, "pod_affinity")

    @_builtins.property
    @pulumi.getter(name="podAntiAffinity")
    def pod_anti_affinity(self) -> Optional[_builtins.str]:
        """
        The job pod anti-affinity.
        """
        return pulumi.get(self, "pod_anti_affinity")

    @_builtins.property
    @pulumi.getter(name="preStartCommands")
    def pre_start_commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The job pod pre start command.
        """
        return pulumi.get(self, "pre_start_commands")

    @_builtins.property
    @pulumi.getter
    def pvcs(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigPvc']]:
        """
        The ack cluster persistent volume claim. See `pvcs` below.
        """
        return pulumi.get(self, "pvcs")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigToleration']]:
        """
        The ack cluster tolerations. See `tolerations` below.
        """
        return pulumi.get(self, "tolerations")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigVolumeMount']]:
        """
        The ack cluster volume mounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ClusterNodeGroupAckConfigVolume']]:
        """
        The ack cluster volumes. See `volumes` below.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ClusterNodeGroupAckConfigCustomAnnotation(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The tag key for this scaling rule specific metrics trigger.
        :param _builtins.str value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterNodeGroupAckConfigCustomLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The tag key for this scaling rule specific metrics trigger.
        :param _builtins.str value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterNodeGroupAckConfigNodeSelector(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The tag key for this scaling rule specific metrics trigger.
        :param _builtins.str value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterNodeGroupAckConfigPvc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDiskSize":
            suggest = "data_disk_size"
        elif key == "dataDiskStorageClass":
            suggest = "data_disk_storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAckConfigPvc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAckConfigPvc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAckConfigPvc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk_size: _builtins.int,
                 data_disk_storage_class: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.int data_disk_size: The ack cluster job pod data disk size of persistent volume claim.
        :param _builtins.str data_disk_storage_class: The ack cluster job pod data disk storage class of persistent volume claim.
        :param _builtins.str name: The name of ack cluster job pod volume mounts.
        :param _builtins.str path: The path of ack cluster job pod volume mounts.
        """
        pulumi.set(__self__, "data_disk_size", data_disk_size)
        pulumi.set(__self__, "data_disk_storage_class", data_disk_storage_class)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> _builtins.int:
        """
        The ack cluster job pod data disk size of persistent volume claim.
        """
        return pulumi.get(self, "data_disk_size")

    @_builtins.property
    @pulumi.getter(name="dataDiskStorageClass")
    def data_disk_storage_class(self) -> _builtins.str:
        """
        The ack cluster job pod data disk storage class of persistent volume claim.
        """
        return pulumi.get(self, "data_disk_storage_class")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ClusterNodeGroupAckConfigToleration(dict):
    def __init__(__self__, *,
                 effect: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 operator: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: The effect of ack cluster tolerations.
        :param _builtins.str key: The tag key for this scaling rule specific metrics trigger.
        :param _builtins.str operator: The operator of ack cluster tolerations.
        :param _builtins.str value: The tag value for this scaling rule specific metrics trigger.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> Optional[_builtins.str]:
        """
        The effect of ack cluster tolerations.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator of ack cluster tolerations.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterNodeGroupAckConfigVolume(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: The name of ack cluster job pod volume mounts.
        :param _builtins.str path: The path of ack cluster job pod volume mounts.
        :param _builtins.str type: The ack cluster job pod volumes type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The ack cluster job pod volumes type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterNodeGroupAckConfigVolumeMount(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str name: The name of ack cluster job pod volume mounts.
        :param _builtins.str path: The path of ack cluster job pod volume mounts.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of ack cluster job pod volume mounts.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalingRules":
            suggest = "scaling_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 constraints: Optional['outputs.ClusterNodeGroupAutoScalingPolicyConstraints'] = None,
                 scaling_rules: Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRule']] = None):
        """
        :param 'ClusterNodeGroupAutoScalingPolicyConstraintsArgs' constraints: The constraints of auto scaling policy. See `constraints` below.
        :param Sequence['ClusterNodeGroupAutoScalingPolicyScalingRuleArgs'] scaling_rules: The scaling rules of auto scaling policy. See `scaling_rules` below.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if scaling_rules is not None:
            pulumi.set(__self__, "scaling_rules", scaling_rules)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ClusterNodeGroupAutoScalingPolicyConstraints']:
        """
        The constraints of auto scaling policy. See `constraints` below.
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="scalingRules")
    def scaling_rules(self) -> Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRule']]:
        """
        The scaling rules of auto scaling policy. See `scaling_rules` below.
        """
        return pulumi.get(self, "scaling_rules")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[_builtins.int] = None,
                 min_capacity: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_capacity: The maximum capacity of constraints for emr node group auto scaling policy.
        :param _builtins.int min_capacity: The minimum capacity of constraints for emr node group auto scaling policy.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[_builtins.int]:
        """
        The maximum capacity of constraints for emr node group auto scaling policy.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[_builtins.int]:
        """
        The minimum capacity of constraints for emr node group auto scaling policy.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activityType":
            suggest = "activity_type"
        elif key == "adjustmentValue":
            suggest = "adjustment_value"
        elif key == "ruleName":
            suggest = "rule_name"
        elif key == "triggerType":
            suggest = "trigger_type"
        elif key == "adjustmentType":
            suggest = "adjustment_type"
        elif key == "metricsTrigger":
            suggest = "metrics_trigger"
        elif key == "minAdjustmentValue":
            suggest = "min_adjustment_value"
        elif key == "timeTrigger":
            suggest = "time_trigger"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyScalingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity_type: _builtins.str,
                 adjustment_value: _builtins.int,
                 rule_name: _builtins.str,
                 trigger_type: _builtins.str,
                 adjustment_type: Optional[_builtins.str] = None,
                 metrics_trigger: Optional['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger'] = None,
                 min_adjustment_value: Optional[_builtins.int] = None,
                 time_trigger: Optional['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger'] = None):
        """
        :param _builtins.str activity_type: The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
        :param _builtins.int adjustment_value: The adjustment value of auto scaling policy. The value should between 1 and 5000.
        :param _builtins.str rule_name: The rule name of auto scaling policy.
        :param _builtins.str trigger_type: The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
        :param _builtins.str adjustment_type: The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
        :param 'ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs' metrics_trigger: The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
        :param _builtins.int min_adjustment_value: The minimum adjustment value of auto scaling policy.
        :param 'ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs' time_trigger: The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
        """
        pulumi.set(__self__, "activity_type", activity_type)
        pulumi.set(__self__, "adjustment_value", adjustment_value)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "trigger_type", trigger_type)
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if metrics_trigger is not None:
            pulumi.set(__self__, "metrics_trigger", metrics_trigger)
        if min_adjustment_value is not None:
            pulumi.set(__self__, "min_adjustment_value", min_adjustment_value)
        if time_trigger is not None:
            pulumi.set(__self__, "time_trigger", time_trigger)

    @_builtins.property
    @pulumi.getter(name="activityType")
    def activity_type(self) -> _builtins.str:
        """
        The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
        """
        return pulumi.get(self, "activity_type")

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> _builtins.int:
        """
        The adjustment value of auto scaling policy. The value should between 1 and 5000.
        """
        return pulumi.get(self, "adjustment_value")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        The rule name of auto scaling policy.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> _builtins.str:
        """
        The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
        """
        return pulumi.get(self, "trigger_type")

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[_builtins.str]:
        """
        The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
        """
        return pulumi.get(self, "adjustment_type")

    @_builtins.property
    @pulumi.getter(name="metricsTrigger")
    def metrics_trigger(self) -> Optional['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger']:
        """
        The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
        """
        return pulumi.get(self, "metrics_trigger")

    @_builtins.property
    @pulumi.getter(name="minAdjustmentValue")
    def min_adjustment_value(self) -> Optional[_builtins.int]:
        """
        The minimum adjustment value of auto scaling policy.
        """
        return pulumi.get(self, "min_adjustment_value")

    @_builtins.property
    @pulumi.getter(name="timeTrigger")
    def time_trigger(self) -> Optional['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger']:
        """
        The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
        """
        return pulumi.get(self, "time_trigger")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationCount":
            suggest = "evaluation_count"
        elif key == "timeWindow":
            suggest = "time_window"
        elif key == "conditionLogicOperator":
            suggest = "condition_logic_operator"
        elif key == "coolDownInterval":
            suggest = "cool_down_interval"
        elif key == "timeConstraints":
            suggest = "time_constraints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_count: _builtins.int,
                 time_window: _builtins.int,
                 condition_logic_operator: Optional[_builtins.str] = None,
                 conditions: Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition']] = None,
                 cool_down_interval: Optional[_builtins.int] = None,
                 time_constraints: Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint']] = None):
        """
        :param _builtins.int evaluation_count: The evaluation count for this scaling rule specific metrics trigger.
        :param _builtins.int time_window: The time window for this scaling rule specific metrics trigger.
        :param _builtins.str condition_logic_operator: The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
        :param Sequence['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs'] conditions: The conditions for this scaling rule specific metrics trigger. See `conditions` below.
        :param _builtins.int cool_down_interval: The time of cool down interval for this scaling rule specific metrics trigger.
        :param Sequence['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs'] time_constraints: The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
        """
        pulumi.set(__self__, "evaluation_count", evaluation_count)
        pulumi.set(__self__, "time_window", time_window)
        if condition_logic_operator is not None:
            pulumi.set(__self__, "condition_logic_operator", condition_logic_operator)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if cool_down_interval is not None:
            pulumi.set(__self__, "cool_down_interval", cool_down_interval)
        if time_constraints is not None:
            pulumi.set(__self__, "time_constraints", time_constraints)

    @_builtins.property
    @pulumi.getter(name="evaluationCount")
    def evaluation_count(self) -> _builtins.int:
        """
        The evaluation count for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "evaluation_count")

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> _builtins.int:
        """
        The time window for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "time_window")

    @_builtins.property
    @pulumi.getter(name="conditionLogicOperator")
    def condition_logic_operator(self) -> Optional[_builtins.str]:
        """
        The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
        """
        return pulumi.get(self, "condition_logic_operator")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition']]:
        """
        The conditions for this scaling rule specific metrics trigger. See `conditions` below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="coolDownInterval")
    def cool_down_interval(self) -> Optional[_builtins.int]:
        """
        The time of cool down interval for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "cool_down_interval")

    @_builtins.property
    @pulumi.getter(name="timeConstraints")
    def time_constraints(self) -> Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint']]:
        """
        The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
        """
        return pulumi.get(self, "time_constraints")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: _builtins.str,
                 metric_name: _builtins.str,
                 statistics: _builtins.str,
                 threshold: _builtins.float,
                 tags: Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag']] = None):
        """
        :param _builtins.str comparison_operator: The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
        :param _builtins.str metric_name: The metric name for this scaling rule specific metrics trigger.
        :param _builtins.str statistics: The statistics for this scaling rule specific metrics trigger.
        :param _builtins.float threshold: The threshold for this scaling rule specific metrics trigger.
        :param Sequence['ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs'] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "threshold", threshold)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> _builtins.str:
        """
        The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
        """
        return pulumi.get(self, "comparison_operator")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        The metric name for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> _builtins.str:
        """
        The statistics for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "statistics")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag']]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The tag key for this scaling rule specific metrics trigger.
        :param _builtins.str value: The tag value for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The tag value for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: The end time for this scaling rule specific metrics trigger.
        :param _builtins.str start_time: The start time for this scaling rule specific metrics trigger.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        The end time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        The start time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTime":
            suggest = "launch_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "launchExpirationTime":
            suggest = "launch_expiration_time"
        elif key == "recurrenceType":
            suggest = "recurrence_type"
        elif key == "recurrenceValue":
            suggest = "recurrence_value"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_time: _builtins.str,
                 end_time: Optional[_builtins.str] = None,
                 launch_expiration_time: Optional[_builtins.int] = None,
                 recurrence_type: Optional[_builtins.str] = None,
                 recurrence_value: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str launch_time: The launch time for this scaling rule specific time trigger.
        :param _builtins.str end_time: The end time for this scaling rule specific metrics trigger.
        :param _builtins.int launch_expiration_time: The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
        :param _builtins.str recurrence_type: The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
        :param _builtins.str recurrence_value: The recurrence value for this scaling rule specific time trigger.
        :param _builtins.str start_time: The start time for this scaling rule specific metrics trigger.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if launch_expiration_time is not None:
            pulumi.set(__self__, "launch_expiration_time", launch_expiration_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> _builtins.str:
        """
        The launch time for this scaling rule specific time trigger.
        """
        return pulumi.get(self, "launch_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        The end time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="launchExpirationTime")
    def launch_expiration_time(self) -> Optional[_builtins.int]:
        """
        The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
        """
        return pulumi.get(self, "launch_expiration_time")

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[_builtins.str]:
        """
        The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
        """
        return pulumi.get(self, "recurrence_type")

    @_builtins.property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[_builtins.str]:
        """
        The recurrence value for this scaling rule specific time trigger.
        """
        return pulumi.get(self, "recurrence_value")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        The start time for this scaling rule specific metrics trigger.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterNodeGroupCostOptimizedConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "spotInstancePools":
            suggest = "spot_instance_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupCostOptimizedConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupCostOptimizedConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupCostOptimizedConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_base_capacity: _builtins.int,
                 on_demand_percentage_above_base_capacity: _builtins.int,
                 spot_instance_pools: _builtins.int):
        """
        :param _builtins.int on_demand_base_capacity: The cost optimized configuration which on demand based capacity.
        :param _builtins.int on_demand_percentage_above_base_capacity: The cost optimized configuration which on demand percentage above based capacity.
        :param _builtins.int spot_instance_pools: The cost optimized configuration with spot instance pools.
        """
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> _builtins.int:
        """
        The cost optimized configuration which on demand based capacity.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> _builtins.int:
        """
        The cost optimized configuration which on demand percentage above based capacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> _builtins.int:
        """
        The cost optimized configuration with spot instance pools.
        """
        return pulumi.get(self, "spot_instance_pools")


@pulumi.output_type
class ClusterNodeGroupDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: _builtins.str,
                 size: _builtins.int,
                 count: Optional[_builtins.int] = None,
                 performance_level: Optional[_builtins.str] = None):
        """
        :param _builtins.str category: The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        :param _builtins.int size: The size of a data disk, at least 40. Unit: GiB.
        :param _builtins.int count: The count of a data disk.
        :param _builtins.str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")


@pulumi.output_type
class ClusterNodeGroupPrivatePoolOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchCriteria":
            suggest = "match_criteria"
        elif key == "privatePoolIds":
            suggest = "private_pool_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupPrivatePoolOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupPrivatePoolOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupPrivatePoolOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_criteria: Optional[_builtins.str] = None,
                 private_pool_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str match_criteria: The node group specific private pool resource match criteria. Valid values: `Open`, `Target`, `None`.
        :param Sequence[_builtins.str] private_pool_ids: The node group specific private pool resource ids.
        """
        if match_criteria is not None:
            pulumi.set(__self__, "match_criteria", match_criteria)
        if private_pool_ids is not None:
            pulumi.set(__self__, "private_pool_ids", private_pool_ids)

    @_builtins.property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> Optional[_builtins.str]:
        """
        The node group specific private pool resource match criteria. Valid values: `Open`, `Target`, `None`.
        """
        return pulumi.get(self, "match_criteria")

    @_builtins.property
    @pulumi.getter(name="privatePoolIds")
    def private_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The node group specific private pool resource ids.
        """
        return pulumi.get(self, "private_pool_ids")


@pulumi.output_type
class ClusterNodeGroupSpotBidPrice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bidPrice":
            suggest = "bid_price"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSpotBidPrice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSpotBidPrice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSpotBidPrice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bid_price: _builtins.int,
                 instance_type: _builtins.str):
        """
        :param _builtins.int bid_price: The spot bid price of a PayAsYouGo instance.
        :param _builtins.str instance_type: Host Ecs instance type.
        """
        pulumi.set(__self__, "bid_price", bid_price)
        pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> _builtins.int:
        """
        The spot bid price of a PayAsYouGo instance.
        """
        return pulumi.get(self, "bid_price")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Host Ecs instance type.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class ClusterNodeGroupSubscriptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paymentDuration":
            suggest = "payment_duration"
        elif key == "paymentDurationUnit":
            suggest = "payment_duration_unit"
        elif key == "autoPayOrder":
            suggest = "auto_pay_order"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "autoRenewDuration":
            suggest = "auto_renew_duration"
        elif key == "autoRenewDurationUnit":
            suggest = "auto_renew_duration_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payment_duration: _builtins.int,
                 payment_duration_unit: _builtins.str,
                 auto_pay_order: Optional[_builtins.bool] = None,
                 auto_renew: Optional[_builtins.bool] = None,
                 auto_renew_duration: Optional[_builtins.int] = None,
                 auto_renew_duration_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param _builtins.str payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param _builtins.bool auto_pay_order: Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        :param _builtins.bool auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param _builtins.int auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param _builtins.str auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_pay_order is not None:
            pulumi.set(__self__, "auto_pay_order", auto_pay_order)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> _builtins.int:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> _builtins.str:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @_builtins.property
    @pulumi.getter(name="autoPayOrder")
    def auto_pay_order(self) -> Optional[_builtins.bool]:
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        return pulumi.get(self, "auto_pay_order")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.bool]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[_builtins.int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[_builtins.str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")


@pulumi.output_type
class ClusterNodeGroupSystemDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSystemDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSystemDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSystemDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: _builtins.str,
                 size: _builtins.int,
                 count: Optional[_builtins.int] = None,
                 performance_level: Optional[_builtins.str] = None):
        """
        :param _builtins.str category: The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        :param _builtins.int size: The size of a data disk, at least 40. Unit: GiB.
        :param _builtins.int count: The count of a data disk.
        :param _builtins.str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The type of the data disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro`. **NOTE:** Since version v1.230.0, the categories `cloud`, `local_hdd_pro`, `local_disk`, `local_ssd_pro` are available.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")


@pulumi.output_type
class ClusterSubscriptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paymentDuration":
            suggest = "payment_duration"
        elif key == "paymentDurationUnit":
            suggest = "payment_duration_unit"
        elif key == "autoPayOrder":
            suggest = "auto_pay_order"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "autoRenewDuration":
            suggest = "auto_renew_duration"
        elif key == "autoRenewDurationUnit":
            suggest = "auto_renew_duration_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payment_duration: _builtins.int,
                 payment_duration_unit: _builtins.str,
                 auto_pay_order: Optional[_builtins.bool] = None,
                 auto_renew: Optional[_builtins.bool] = None,
                 auto_renew_duration: Optional[_builtins.int] = None,
                 auto_renew_duration_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param _builtins.str payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param _builtins.bool auto_pay_order: Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        :param _builtins.bool auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param _builtins.int auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param _builtins.str auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_pay_order is not None:
            pulumi.set(__self__, "auto_pay_order", auto_pay_order)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> _builtins.int:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> _builtins.str:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @_builtins.property
    @pulumi.getter(name="autoPayOrder")
    def auto_pay_order(self) -> Optional[_builtins.bool]:
        """
        Auto pay order for payment type of subscription, ’true’ or ‘false’ .  Default value is ’true’.
        """
        return pulumi.get(self, "auto_pay_order")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.bool]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[_builtins.int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[_builtins.str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")


@pulumi.output_type
class GetClusterInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 auto_renew: _builtins.bool,
                 auto_renew_duration: _builtins.int,
                 auto_renew_duration_unit: _builtins.str,
                 create_time: _builtins.str,
                 expire_time: _builtins.str,
                 instance_id: _builtins.str,
                 instance_name: _builtins.str,
                 instance_state: _builtins.str,
                 instance_type: _builtins.str,
                 node_group_id: _builtins.str,
                 node_group_type: _builtins.str,
                 private_ip: _builtins.str,
                 public_ip: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.bool auto_renew: The emr cluster node group whether auto renew when payment type is 'Subscription'.
        :param _builtins.int auto_renew_duration: The emr cluster node group auto renew duration when payment type is 'Subscription'.
        :param _builtins.str auto_renew_duration_unit: The emr cluster node group auto renew duration unit when payment type is 'Subscription'.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str expire_time: The expire time of the resource.
        :param _builtins.str instance_id: The emr cluster ecs instance ID.
        :param _builtins.str instance_name: The emr cluster ecs instance name.
        :param _builtins.str instance_state: The emr cluster ecs instance state.
        :param _builtins.str instance_type: The emr cluster ecs instance type.
        :param _builtins.str node_group_id: The emr cluster node group ID.
        :param _builtins.str node_group_type: The emr cluster node group type.
        :param _builtins.str private_ip: The emr cluster ecs instance private ip.
        :param _builtins.str public_ip: The emr cluster ecs instance public ip.
        :param _builtins.str zone_id: The emr cluster node group zone ID.
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_state", instance_state)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "node_group_id", node_group_id)
        pulumi.set(__self__, "node_group_type", node_group_type)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> _builtins.bool:
        """
        The emr cluster node group whether auto renew when payment type is 'Subscription'.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> _builtins.int:
        """
        The emr cluster node group auto renew duration when payment type is 'Subscription'.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> _builtins.str:
        """
        The emr cluster node group auto renew duration unit when payment type is 'Subscription'.
        """
        return pulumi.get(self, "auto_renew_duration_unit")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expire time of the resource.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The emr cluster ecs instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The emr cluster ecs instance name.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> _builtins.str:
        """
        The emr cluster ecs instance state.
        """
        return pulumi.get(self, "instance_state")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The emr cluster ecs instance type.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> _builtins.str:
        """
        The emr cluster node group ID.
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeGroupType")
    def node_group_type(self) -> _builtins.str:
        """
        The emr cluster node group type.
        """
        return pulumi.get(self, "node_group_type")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The emr cluster ecs instance private ip.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The emr cluster ecs instance public ip.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The emr cluster node group zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 cluster_state: _builtins.str,
                 cluster_type: _builtins.str,
                 create_time: _builtins.str,
                 emr_default_role: _builtins.str,
                 end_time: _builtins.str,
                 expire_time: _builtins.str,
                 payment_type: _builtins.str,
                 ready_time: _builtins.str,
                 release_version: _builtins.str,
                 resource_group_id: _builtins.str,
                 state_change_reason: Mapping[str, _builtins.str],
                 tags: Sequence['outputs.GetClustersClusterTagResult']):
        """
        :param _builtins.str cluster_id: The first ID of the resource.
        :param _builtins.str cluster_name: The cluster name.
        :param _builtins.str cluster_state: The state of the emr cluster.
        :param _builtins.str cluster_type: The type of the emr cluster.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str emr_default_role: The ecs default role belongs to this emr cluster.
        :param _builtins.str end_time: The end time of the resource.
        :param _builtins.str expire_time: The expire time of the resource.
        :param _builtins.str payment_type: The payment type of the emr cluster.
        :param _builtins.str ready_time: The ready time of the resource.
        :param _builtins.str release_version: The release version of the resource.
        :param _builtins.str resource_group_id: The Resource Group ID.
        :param Mapping[str, _builtins.str] state_change_reason: The cluster state change reason.
        :param Sequence['GetClustersClusterTagArgs'] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_state", cluster_state)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "emr_default_role", emr_default_role)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "ready_time", ready_time)
        pulumi.set(__self__, "release_version", release_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "state_change_reason", state_change_reason)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> _builtins.str:
        """
        The state of the emr cluster.
        """
        return pulumi.get(self, "cluster_state")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        The type of the emr cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="emrDefaultRole")
    def emr_default_role(self) -> _builtins.str:
        """
        The ecs default role belongs to this emr cluster.
        """
        return pulumi.get(self, "emr_default_role")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The end time of the resource.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expire time of the resource.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the emr cluster.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="readyTime")
    def ready_time(self) -> _builtins.str:
        """
        The ready time of the resource.
        """
        return pulumi.get(self, "ready_time")

    @_builtins.property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> _builtins.str:
        """
        The release version of the resource.
        """
        return pulumi.get(self, "release_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="stateChangeReason")
    def state_change_reason(self) -> Mapping[str, _builtins.str]:
        """
        The cluster state change reason.
        """
        return pulumi.get(self, "state_change_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetClustersClusterTagResult']:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetClustersClusterTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


