# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NatGatewayArgs', 'NatGateway']

@pulumi.input_type
class NatGatewayArgs:
    def __init__(__self__, *,
                 ens_region_id: pulumi.Input[_builtins.str],
                 network_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NatGateway resource.
        :param pulumi.Input[_builtins.str] ens_region_id: The ID of the ENS node.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        :param pulumi.Input[_builtins.str] instance_type: NAT specifications. Value: `enat.default`.
        :param pulumi.Input[_builtins.str] nat_name: The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        """
        pulumi.set(__self__, "ens_region_id", ens_region_id)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if nat_name is not None:
            pulumi.set(__self__, "nat_name", nat_name)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ENS node.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT specifications. Value: `enat.default`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="natName")
    def nat_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "nat_name")

    @nat_name.setter
    def nat_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_name", value)


@pulumi.input_type
class _NatGatewayState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NatGateway resources.
        :param pulumi.Input[_builtins.str] create_time: Creation time. UTC time, in the format of YYYY-MM-DDThh:mm:ssZ.
        :param pulumi.Input[_builtins.str] ens_region_id: The ID of the ENS node.
        :param pulumi.Input[_builtins.str] instance_type: NAT specifications. Value: `enat.default`.
        :param pulumi.Input[_builtins.str] nat_name: The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if nat_name is not None:
            pulumi.set(__self__, "nat_name", nat_name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time. UTC time, in the format of YYYY-MM-DDThh:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ENS node.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT specifications. Value: `enat.default`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="natName")
    def nat_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "nat_name")

    @nat_name.setter
    def nat_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:ens/natGateway:NatGateway")
class NatGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ENS Nat Gateway resource.

        Nat gateway of ENS.

        For information about ENS Nat Gateway and how to use it, see [What is Nat Gateway](https://next.api.alibabacloud.com/document/Ens/2017-11-10/CreateNatGateway).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        ens_region_id = config.get("ensRegionId")
        if ens_region_id is None:
            ens_region_id = "cn-chenzhou-telecom_unicom_cmcc"
        default_obbr_l7 = alicloud.ens.Network("defaultObbrL7",
            network_name=name,
            description=name,
            cidr_block="10.0.0.0/8",
            ens_region_id=ens_region_id)
        defaulte_fw783 = alicloud.ens.Vswitch("defaulteFw783",
            cidr_block="10.0.8.0/24",
            vswitch_name=name,
            ens_region_id=default_obbr_l7.ens_region_id,
            network_id=default_obbr_l7.id)
        default = alicloud.ens.NatGateway("default",
            vswitch_id=defaulte_fw783.id,
            ens_region_id=defaulte_fw783.ens_region_id,
            network_id=defaulte_fw783.network_id,
            instance_type="enat.default",
            nat_name=name)
        ```

        ## Import

        ENS Nat Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/natGateway:NatGateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ens_region_id: The ID of the ENS node.
        :param pulumi.Input[_builtins.str] instance_type: NAT specifications. Value: `enat.default`.
        :param pulumi.Input[_builtins.str] nat_name: The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Nat Gateway resource.

        Nat gateway of ENS.

        For information about ENS Nat Gateway and how to use it, see [What is Nat Gateway](https://next.api.alibabacloud.com/document/Ens/2017-11-10/CreateNatGateway).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        ens_region_id = config.get("ensRegionId")
        if ens_region_id is None:
            ens_region_id = "cn-chenzhou-telecom_unicom_cmcc"
        default_obbr_l7 = alicloud.ens.Network("defaultObbrL7",
            network_name=name,
            description=name,
            cidr_block="10.0.0.0/8",
            ens_region_id=ens_region_id)
        defaulte_fw783 = alicloud.ens.Vswitch("defaulteFw783",
            cidr_block="10.0.8.0/24",
            vswitch_name=name,
            ens_region_id=default_obbr_l7.ens_region_id,
            network_id=default_obbr_l7.id)
        default = alicloud.ens.NatGateway("default",
            vswitch_id=defaulte_fw783.id,
            ens_region_id=defaulte_fw783.ens_region_id,
            network_id=defaulte_fw783.network_id,
            instance_type="enat.default",
            nat_name=name)
        ```

        ## Import

        ENS Nat Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/natGateway:NatGateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NatGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatGatewayArgs.__new__(NatGatewayArgs)

            if ens_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'ens_region_id'")
            __props__.__dict__["ens_region_id"] = ens_region_id
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["nat_name"] = nat_name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
        super(NatGateway, __self__).__init__(
            'alicloud:ens/natGateway:NatGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            nat_name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NatGateway':
        """
        Get an existing NatGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Creation time. UTC time, in the format of YYYY-MM-DDThh:mm:ssZ.
        :param pulumi.Input[_builtins.str] ens_region_id: The ID of the ENS node.
        :param pulumi.Input[_builtins.str] instance_type: NAT specifications. Value: `enat.default`.
        :param pulumi.Input[_builtins.str] nat_name: The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatGatewayState.__new__(_NatGatewayState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["nat_name"] = nat_name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return NatGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time. UTC time, in the format of YYYY-MM-DDThh:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ENS node.
        """
        return pulumi.get(self, "ens_region_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        NAT specifications. Value: `enat.default`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="natName")
    def nat_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the NAT gateway. The length is 1 to 128 characters, but it cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "nat_name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

