# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 created_type: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 cas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites interface.
        :param pulumi.Input[_builtins.str] cas_id: Cloud certificate ID.
        :param pulumi.Input[_builtins.str] cert_id: The certificate Id.
        :param pulumi.Input[_builtins.str] cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] domains: A list of domain names. Multiple domain names are separated by commas.
        :param pulumi.Input[_builtins.str] region: Region. This parameter is required if the type is CAS.
               For accounts on the Chinese site, this parameter value is: cn-hangzhou
               For accounts on the international site, this parameter value is: ap-southeast-1
        :param pulumi.Input[_builtins.str] type: Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        pulumi.set(__self__, "created_type", created_type)
        pulumi.set(__self__, "site_id", site_id)
        if cas_id is not None:
            pulumi.set(__self__, "cas_id", cas_id)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="createdType")
    def created_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "created_type")

    @created_type.setter
    def created_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "created_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="casId")
    def cas_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud certificate ID.
        """
        return pulumi.get(self, "cas_id")

    @cas_id.setter
    def cas_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cas_id", value)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate Id.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of domain names. Multiple domain names are separated by commas.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region. This parameter is required if the type is CAS.
        For accounts on the Chinese site, this parameter value is: cn-hangzhou
        For accounts on the international site, this parameter value is: ap-southeast-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 cas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] cas_id: Cloud certificate ID.
        :param pulumi.Input[_builtins.str] cert_id: The certificate Id.
        :param pulumi.Input[_builtins.str] cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] domains: A list of domain names. Multiple domain names are separated by commas.
        :param pulumi.Input[_builtins.str] region: Region. This parameter is required if the type is CAS.
               For accounts on the Chinese site, this parameter value is: cn-hangzhou
               For accounts on the international site, this parameter value is: ap-southeast-1
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites interface.
        :param pulumi.Input[_builtins.str] status: Certificate status.(within 30 days).- issued.- applying.- application failed.- canceled.
        :param pulumi.Input[_builtins.str] type: Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        if cas_id is not None:
            pulumi.set(__self__, "cas_id", cas_id)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_type is not None:
            pulumi.set(__self__, "created_type", created_type)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="casId")
    def cas_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud certificate ID.
        """
        return pulumi.get(self, "cas_id")

    @cas_id.setter
    def cas_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cas_id", value)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate Id.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createdType")
    def created_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_type")

    @created_type.setter
    def created_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_type", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of domain names. Multiple domain names are separated by commas.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region. This parameter is required if the type is CAS.
        For accounts on the Chinese site, this parameter value is: cn-hangzhou
        For accounts on the international site, this parameter value is: ap-southeast-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate status.(within 30 days).- issued.- applying.- application failed.- canceled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:esa/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 created_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Certificate resource.

        For information about ESA Certificate and how to use it, see [What is Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/SetCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_certificate = alicloud.esa.Certificate("default",
            created_type="free",
            domains="101.gositecdn.cn",
            site_id=default.sites[0].id,
            type="lets_encrypt")
        ```

        ## Import

        ESA Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/certificate:Certificate example <site_id>:<cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cas_id: Cloud certificate ID.
        :param pulumi.Input[_builtins.str] cert_id: The certificate Id.
        :param pulumi.Input[_builtins.str] cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] domains: A list of domain names. Multiple domain names are separated by commas.
        :param pulumi.Input[_builtins.str] region: Region. This parameter is required if the type is CAS.
               For accounts on the Chinese site, this parameter value is: cn-hangzhou
               For accounts on the international site, this parameter value is: ap-southeast-1
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites interface.
        :param pulumi.Input[_builtins.str] type: Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Certificate resource.

        For information about ESA Certificate and how to use it, see [What is Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/SetCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_certificate = alicloud.esa.Certificate("default",
            created_type="free",
            domains="101.gositecdn.cn",
            site_id=default.sites[0].id,
            type="lets_encrypt")
        ```

        ## Import

        ESA Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/certificate:Certificate example <site_id>:<cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 created_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["cas_id"] = cas_id
            __props__.__dict__["cert_id"] = cert_id
            __props__.__dict__["cert_name"] = cert_name
            __props__.__dict__["certificate"] = certificate
            if created_type is None and not opts.urn:
                raise TypeError("Missing required property 'created_type'")
            __props__.__dict__["created_type"] = created_type
            __props__.__dict__["domains"] = domains
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["region"] = region
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Certificate, __self__).__init__(
            'alicloud:esa/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cas_id: Optional[pulumi.Input[_builtins.str]] = None,
            cert_id: Optional[pulumi.Input[_builtins.str]] = None,
            cert_name: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_type: Optional[pulumi.Input[_builtins.str]] = None,
            domains: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cas_id: Cloud certificate ID.
        :param pulumi.Input[_builtins.str] cert_id: The certificate Id.
        :param pulumi.Input[_builtins.str] cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] domains: A list of domain names. Multiple domain names are separated by commas.
        :param pulumi.Input[_builtins.str] region: Region. This parameter is required if the type is CAS.
               For accounts on the Chinese site, this parameter value is: cn-hangzhou
               For accounts on the international site, this parameter value is: ap-southeast-1
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites interface.
        :param pulumi.Input[_builtins.str] status: Certificate status.(within 30 days).- issued.- applying.- application failed.- canceled.
        :param pulumi.Input[_builtins.str] type: Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["cas_id"] = cas_id
        __props__.__dict__["cert_id"] = cert_id
        __props__.__dict__["cert_name"] = cert_name
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_type"] = created_type
        __props__.__dict__["domains"] = domains
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["region"] = region
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="casId")
    def cas_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cloud certificate ID.
        """
        return pulumi.get(self, "cas_id")

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate Id.
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdType")
    def created_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_type")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A list of domain names. Multiple domain names are separated by commas.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region. This parameter is required if the type is CAS.
        For accounts on the Chinese site, this parameter value is: cn-hangzhou
        For accounts on the international site, this parameter value is: ap-southeast-1
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites interface.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate status.(within 30 days).- issued.- applying.- application failed.- canceled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate type. Possible values: lets_encrypt: Let's Encrypt certificate;
        """
        return pulumi.get(self, "type")

